/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.util;

import com.jgoodies.forms.util.AbstractUnitConverter;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.UIManager;

public final class DefaultUnitConverter
extends AbstractUnitConverter {
    private static DefaultUnitConverter instance;
    private String averageCharWidthTestString = "X";
    private Font defaultDialogFont;
    private PropertyChangeSupport changeSupport;
    private DialogBaseUnits cachedGlobalDialogBaseUnits = this.computeGlobalDialogBaseUnits();
    private Map cachedDialogBaseUnits = new HashMap();

    private DefaultUnitConverter() {
        UIManager.addPropertyChangeListener(new LAFChangeHandler(this, null));
    }

    public static DefaultUnitConverter getInstance() {
        if (instance == null) {
            instance = new DefaultUnitConverter();
        }
        return instance;
    }

    public String getAverageCharacterWidthTestString() {
        return this.averageCharWidthTestString;
    }

    public void setAverageCharacterWidthTestString(String string) {
        if (string == null) {
            throw new NullPointerException("The test string must not be null.");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("The test string must not be empty.");
        }
        String string2 = this.averageCharWidthTestString;
        this.averageCharWidthTestString = string;
        this.changeSupport.firePropertyChange("averageCharacterWidthTestString", string2, string);
    }

    public Font getDefaultDialogFont() {
        if (this.defaultDialogFont == null) {
            this.defaultDialogFont = this.lookupDefaultDialogFont();
        }
        return this.defaultDialogFont;
    }

    public void setDefaultDialogFont(Font font) {
        Font font2 = this.defaultDialogFont;
        this.defaultDialogFont = font;
        this.changeSupport.firePropertyChange("defaultDialogFont", font2, font);
    }

    public double getDialogBaseUnitsX(Component component) {
        return this.getDialogBaseUnits((Component)component).b;
    }

    public double getDialogBaseUnitsY(Component component) {
        return this.getDialogBaseUnits((Component)component).a;
    }

    private DialogBaseUnits getGlobalDialogBaseUnits() {
        if (this.cachedGlobalDialogBaseUnits == null) {
            this.cachedGlobalDialogBaseUnits = this.computeGlobalDialogBaseUnits();
        }
        return this.cachedGlobalDialogBaseUnits;
    }

    private DialogBaseUnits getDialogBaseUnits(Component component) {
        if (component == null) {
            this.logInfo("Missing font metrics: " + component);
            return this.getGlobalDialogBaseUnits();
        }
        FontMetrics fontMetrics = component.getFontMetrics(this.getDefaultDialogFont());
        DialogBaseUnits dialogBaseUnits = (DialogBaseUnits)this.cachedDialogBaseUnits.get(fontMetrics);
        if (dialogBaseUnits == null) {
            dialogBaseUnits = this.computeDialogBaseUnits(fontMetrics);
            this.cachedDialogBaseUnits.put(fontMetrics, dialogBaseUnits);
        }
        return dialogBaseUnits;
    }

    private DialogBaseUnits computeDialogBaseUnits(FontMetrics fontMetrics) {
        double d2 = this.computeAverageCharWidth(fontMetrics, this.averageCharWidthTestString);
        int n2 = fontMetrics.getAscent();
        double d3 = n2 > 14 ? (double)n2 : (double)(n2 + (15 - n2) / 3);
        DialogBaseUnits dialogBaseUnits = new DialogBaseUnits(d2, d3);
        this.logInfo("Computed dialog base units " + dialogBaseUnits + " for: " + fontMetrics.getFont());
        return dialogBaseUnits;
    }

    private DialogBaseUnits computeGlobalDialogBaseUnits() {
        this.logInfo("Computing global dialog base units...");
        Font font = this.getDefaultDialogFont();
        FontMetrics fontMetrics = this.createDefaultGlobalComponent().getFontMetrics(font);
        DialogBaseUnits dialogBaseUnits = this.computeDialogBaseUnits(fontMetrics);
        return dialogBaseUnits;
    }

    private Font lookupDefaultDialogFont() {
        Font font = UIManager.getFont("Button.font");
        return font != null ? font : new JButton().getFont();
    }

    private Component createDefaultGlobalComponent() {
        return new JPanel();
    }

    private void invalidateCaches() {
        this.cachedGlobalDialogBaseUnits = null;
        this.cachedDialogBaseUnits.clear();
    }

    public final synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public final synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public final synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public final synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    private void logInfo(String string) {
    }

    public static void a(DefaultUnitConverter defaultUnitConverter) {
        defaultUnitConverter.invalidateCaches();
    }

    public static class 1 {
    }

    private class LAFChangeHandler
    implements PropertyChangeListener {
        private final DefaultUnitConverter this$0;

        private LAFChangeHandler(DefaultUnitConverter defaultUnitConverter) {
            this.this$0 = defaultUnitConverter;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            DefaultUnitConverter.a(this.this$0);
        }

        public LAFChangeHandler(DefaultUnitConverter defaultUnitConverter, 1 var2_2) {
            this(defaultUnitConverter);
        }
    }

    private static class DialogBaseUnits {
        public final double b;
        public final double a;

        public DialogBaseUnits(double d2, double d3) {
            this.b = d2;
            this.a = d3;
        }

        public String toString() {
            return "DBU(x=" + this.b + "; y=" + this.a + ")";
        }
    }
}

