/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.factories;

import com.jgoodies.forms.factories.ComponentFactory;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public class DefaultComponentFactory
implements ComponentFactory {
    private static final DefaultComponentFactory INSTANCE = new DefaultComponentFactory();
    private static final char MNEMONIC_MARKER = '&';
    private static final ColumnSpec PREF_GROWING_COL_SPEC = new ColumnSpec(ColumnSpec.FILL, Sizes.PREFERRED, 1.0);
    private static Boolean cachedIsLafAqua;
    private static boolean changeHandlerRegistered;

    private DefaultComponentFactory() {
    }

    public static DefaultComponentFactory getInstance() {
        return INSTANCE;
    }

    public JLabel createLabel(String string) {
        JLabel jLabel = new JLabel();
        DefaultComponentFactory.setTextAndMnemonic(jLabel, string);
        return jLabel;
    }

    public JLabel createTitle(String string) {
        TitleLabel titleLabel = new TitleLabel(null);
        DefaultComponentFactory.setTextAndMnemonic(titleLabel, string);
        titleLabel.setVerticalAlignment(0);
        return titleLabel;
    }

    public JComponent createSeparator(String string) {
        return this.createSeparator(string, 2);
    }

    public JComponent createSeparator(String string, int n2) {
        if (string == null || string.length() == 0) {
            return new JSeparator();
        }
        JLabel jLabel = this.createTitle(string);
        JPanel jPanel = new JPanel();
        ColumnSpec columnSpec = new ColumnSpec(DefaultComponentFactory.isLafAqua() ? Sizes.DLUX1 : Sizes.DLUX3);
        CellConstraints cellConstraints = new CellConstraints();
        if (n2 == 2) {
            FormLayout formLayout = new FormLayout(new ColumnSpec[]{FormFactory.PREF_COLSPEC, columnSpec, PREF_GROWING_COL_SPEC}, new RowSpec[]{FormFactory.PREF_ROWSPEC});
            jPanel.setLayout(formLayout);
            jPanel.add((Component)jLabel, cellConstraints.xy(1, 1));
            jPanel.add((Component)new JSeparator(), cellConstraints.xy(3, 1));
        } else if (n2 == 4) {
            FormLayout formLayout = new FormLayout(new ColumnSpec[]{PREF_GROWING_COL_SPEC, columnSpec, FormFactory.PREF_COLSPEC}, new RowSpec[]{FormFactory.PREF_ROWSPEC});
            jPanel.setLayout(formLayout);
            jPanel.add((Component)new JSeparator(), cellConstraints.xy(1, 1));
            jPanel.add((Component)jLabel, cellConstraints.xy(3, 1));
        } else if (n2 == 0) {
            FormLayout formLayout = new FormLayout(new ColumnSpec[]{PREF_GROWING_COL_SPEC, columnSpec, FormFactory.PREF_COLSPEC, columnSpec, PREF_GROWING_COL_SPEC}, new RowSpec[]{FormFactory.PREF_ROWSPEC});
            jPanel.setLayout(formLayout);
            jPanel.add((Component)new JSeparator(), cellConstraints.xy(1, 1));
            jPanel.add((Component)jLabel, cellConstraints.xy(3, 1));
            jPanel.add((Component)new JSeparator(), cellConstraints.xy(5, 1));
        }
        return jPanel;
    }

    private static void setTextAndMnemonic(JLabel jLabel, String string) {
        int n2;
        int n3 = string.indexOf(38);
        if (n3 == -1) {
            jLabel.setText(string);
            return;
        }
        int n4 = -1;
        int n5 = 0;
        int n6 = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        do {
            if (n3 + 1 < n6 && string.charAt(n3 + 1) == '&') {
                n2 = n3 + 1;
            } else {
                n2 = n3;
                if (n4 == -1) {
                    n4 = n3;
                }
            }
            stringBuffer.append(string.substring(n5, n2));
        } while ((n3 = (n5 = n2 + 1) < n6 ? string.indexOf(38, n5) : -1) != -1);
        stringBuffer.append(string.substring(n5));
        jLabel.setText(stringBuffer.toString());
        if (n4 != -1 && n4 + 1 < n6) {
            jLabel.setDisplayedMnemonic(string.charAt(n4 + 1));
            jLabel.setDisplayedMnemonicIndex(n4);
        }
    }

    private static synchronized void ensureLookAndFeelChangeHandlerRegistered() {
        if (!changeHandlerRegistered) {
            UIManager.addPropertyChangeListener(new LookAndFeelChangeHandler(null));
        }
    }

    private static boolean isLafAqua() {
        if (cachedIsLafAqua == null) {
            cachedIsLafAqua = DefaultComponentFactory.computeIsLafAqua();
            DefaultComponentFactory.ensureLookAndFeelChangeHandlerRegistered();
        }
        return cachedIsLafAqua;
    }

    private static boolean computeIsLafAqua() {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        return lookAndFeel.getName().startsWith("Mac OS X Aqua");
    }

    public static boolean a() {
        return DefaultComponentFactory.isLafAqua();
    }

    public static Boolean a(Boolean bl2) {
        cachedIsLafAqua = bl2;
        return cachedIsLafAqua;
    }

    static {
        changeHandlerRegistered = false;
    }

    public static class 1 {
    }

    private static class LookAndFeelChangeHandler
    implements PropertyChangeListener {
        private LookAndFeelChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            DefaultComponentFactory.a(null);
        }

        public LookAndFeelChangeHandler(1 var1_1) {
            this();
        }
    }

    private static class TitleLabel
    extends JLabel {
        private TitleLabel() {
        }

        private TitleLabel(String string) {
            super(string);
        }

        public void updateUI() {
            super.updateUI();
            Color color = UIManager.getColor("TitledBorder.titleColor");
            if (color != null) {
                this.setForeground(color);
            }
            this.setFont(this.getTitleFont());
        }

        private Font getTitleFont() {
            return DefaultComponentFactory.a() ? UIManager.getFont("Label.font").deriveFont(1) : UIManager.getFont("TitledBorder.font");
        }

        public TitleLabel(1 var1_1) {
            this();
        }
    }
}

