/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.debug;

import com.jgoodies.forms.debug.FormDebugUtils;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JPanel;

public class FormDebugPanel
extends JPanel {
    private static final Color DEFAULT_GRID_COLOR = Color.red;
    private boolean paintInBackground;
    private boolean paintDiagonals;
    private Color gridColor = DEFAULT_GRID_COLOR;

    public FormDebugPanel() {
        this(null);
    }

    public FormDebugPanel(FormLayout formLayout) {
        this(formLayout, false, false);
    }

    public FormDebugPanel(boolean bl2, boolean bl3) {
        this(null, bl2, bl3);
    }

    public FormDebugPanel(FormLayout formLayout, boolean bl2, boolean bl3) {
        super(formLayout);
        this.setPaintInBackground(bl2);
        this.setPaintDiagonals(bl3);
        this.setGridColor(DEFAULT_GRID_COLOR);
    }

    public void setPaintInBackground(boolean bl2) {
        this.paintInBackground = bl2;
    }

    public void setPaintDiagonals(boolean bl2) {
        this.paintDiagonals = bl2;
    }

    public void setGridColor(Color color) {
        this.gridColor = color;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.paintInBackground) {
            this.paintGrid(graphics);
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (!this.paintInBackground) {
            this.paintGrid(graphics);
        }
    }

    private void paintGrid(Graphics graphics) {
        int n2;
        if (!(this.getLayout() instanceof FormLayout)) {
            return;
        }
        FormLayout.LayoutInfo layoutInfo = FormDebugUtils.getLayoutInfo(this);
        int n3 = layoutInfo.getX();
        int n4 = layoutInfo.getY();
        int n5 = layoutInfo.getWidth();
        int n6 = layoutInfo.getHeight();
        graphics.setColor(this.gridColor);
        for (n2 = 0; n2 < layoutInfo.columnOrigins.length; ++n2) {
            graphics.fillRect(layoutInfo.columnOrigins[n2], n4, 1, n6);
        }
        for (n2 = 0; n2 < layoutInfo.rowOrigins.length; ++n2) {
            graphics.fillRect(n3, layoutInfo.rowOrigins[n2], n5, 1);
        }
        if (this.paintDiagonals) {
            graphics.drawLine(n3, n4, n3 + n5, n4 + n6);
            graphics.drawLine(n3, n4 + n6, n3 + n5, n4);
        }
    }
}

