/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.builder;

import com.jgoodies.forms.builder.I15dPanelBuilder;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ConstantSize;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public final class DefaultFormBuilder
extends I15dPanelBuilder {
    private RowSpec lineGapSpec = FormFactory.LINE_GAP_ROWSPEC;
    private RowSpec paragraphGapSpec = FormFactory.PARAGRAPH_GAP_ROWSPEC;
    private int leadingColumnOffset = 0;
    private boolean rowGroupingEnabled = false;

    public DefaultFormBuilder(FormLayout formLayout) {
        this(new JPanel(), formLayout);
    }

    public DefaultFormBuilder(JPanel jPanel, FormLayout formLayout) {
        this(jPanel, formLayout, null);
    }

    public DefaultFormBuilder(FormLayout formLayout, ResourceBundle resourceBundle) {
        this(new JPanel(), formLayout, resourceBundle);
    }

    public DefaultFormBuilder(JPanel jPanel, FormLayout formLayout, ResourceBundle resourceBundle) {
        super(jPanel, formLayout, resourceBundle);
    }

    public void setLineGapSize(ConstantSize constantSize) {
        RowSpec rowSpec = FormFactory.createGapRowSpec(constantSize);
        this.lineGapSpec = rowSpec.asUnmodifyable();
    }

    public RowSpec getLineGapSpec() {
        return this.lineGapSpec;
    }

    public void setParagraphGapSize(ConstantSize constantSize) {
        RowSpec rowSpec = FormFactory.createGapRowSpec(constantSize);
        this.paragraphGapSpec = rowSpec.asUnmodifyable();
    }

    public int getLeadingColumnOffset() {
        return this.leadingColumnOffset;
    }

    public void setLeadingColumnOffset(int n2) {
        this.leadingColumnOffset = n2;
    }

    public boolean isRowGroupingEnabled() {
        return this.rowGroupingEnabled;
    }

    public void setRowGroupingEnabled(boolean bl2) {
        this.rowGroupingEnabled = bl2;
    }

    public void append(Component component) {
        this.append(component, 1);
    }

    public void append(Component component, int n2) {
        this.ensureCursorColumnInGrid();
        this.ensureHasGapRow(this.lineGapSpec);
        this.ensureHasComponentLine();
        this.add(component, this.createLeftAdjustedConstraints(n2));
        this.nextColumn(n2 + 1);
    }

    public void append(Component component, Component component2) {
        this.append(component);
        this.append(component2);
    }

    public void append(Component component, Component component2, Component component3) {
        this.append(component);
        this.append(component2);
        this.append(component3);
    }

    public JLabel append(String string) {
        JLabel jLabel = this.getComponentFactory().createLabel(string);
        this.append(jLabel);
        return jLabel;
    }

    public JLabel append(String string, Component component) {
        return this.append(string, component, 1);
    }

    public JLabel append(String string, Component component, int n2) {
        JLabel jLabel = this.append(string);
        jLabel.setLabelFor(component);
        this.append(component, n2);
        return jLabel;
    }

    public JLabel append(String string, Component component, Component component2) {
        JLabel jLabel = this.append(string, component);
        this.append(component2);
        return jLabel;
    }

    public void append(String string, Component component, Component component2, int n2) {
        this.append(string, component);
        this.append(component2, n2);
    }

    public JLabel append(String string, Component component, Component component2, Component component3) {
        JLabel jLabel = this.append(string, component, component2);
        this.append(component3);
        return jLabel;
    }

    public JLabel append(String string, Component component, Component component2, Component component3, Component component4) {
        JLabel jLabel = this.append(string, component, component2, component3);
        this.append(component4);
        return jLabel;
    }

    public JLabel appendI15d(String string) {
        return this.append(this.getI15dString(string));
    }

    public JLabel appendI15d(String string, Component component, int n2) {
        JLabel jLabel = this.appendI15d(string);
        this.append(component, n2);
        return jLabel;
    }

    public JLabel appendI15d(String string, Component component) {
        return this.appendI15d(string, component, 1);
    }

    public JLabel appendI15d(String string, Component component, boolean bl2) {
        JLabel jLabel = this.appendI15d(string, component, 1);
        if (bl2) {
            this.nextLine();
        }
        return jLabel;
    }

    public JLabel appendI15d(String string, Component component, Component component2) {
        JLabel jLabel = this.appendI15d(string, component);
        this.append(component2);
        return jLabel;
    }

    public JLabel appendI15d(String string, Component component, Component component2, int n2) {
        JLabel jLabel = this.appendI15d(string, component);
        this.append(component2, n2);
        return jLabel;
    }

    public JLabel appendI15d(String string, Component component, Component component2, Component component3) {
        JLabel jLabel = this.appendI15d(string, component, component2);
        this.append(component3);
        return jLabel;
    }

    public JLabel appendI15d(String string, Component component, Component component2, Component component3, Component component4) {
        JLabel jLabel = this.appendI15d(string, component, component2, component3);
        this.append(component4);
        return jLabel;
    }

    public JLabel appendTitle(String string) {
        JLabel jLabel = this.getComponentFactory().createTitle(string);
        this.append(jLabel);
        return jLabel;
    }

    public JLabel appendI15dTitle(String string) {
        return this.appendTitle(this.getI15dString(string));
    }

    public JComponent appendSeparator() {
        return this.appendSeparator("");
    }

    public JComponent appendSeparator(String string) {
        this.ensureCursorColumnInGrid();
        this.ensureHasGapRow(this.paragraphGapSpec);
        this.ensureHasComponentLine();
        this.setColumn(super.getLeadingColumn());
        int n2 = this.getColumnCount();
        this.setColumnSpan(this.getColumnCount());
        JComponent jComponent = this.addSeparator(string);
        this.setColumnSpan(1);
        this.nextColumn(n2);
        return jComponent;
    }

    public void appendI15dSeparator(String string) {
        this.appendSeparator(this.getI15dString(string));
    }

    public int getLeadingColumn() {
        int n2 = super.getLeadingColumn();
        return n2 + this.getLeadingColumnOffset() * this.getColumnIncrementSign();
    }

    private void ensureCursorColumnInGrid() {
        if (this.isLeftToRight() && this.getColumn() > this.getColumnCount() || !this.isLeftToRight() && this.getColumn() < 1) {
            this.nextLine();
        }
    }

    private void ensureHasGapRow(RowSpec rowSpec) {
        RowSpec rowSpec2;
        if (this.getRow() == 1 || this.getRow() <= this.getRowCount()) {
            return;
        }
        if (this.getRow() <= this.getRowCount() && (rowSpec2 = this.getCursorRowSpec()) == rowSpec) {
            return;
        }
        this.appendRow(rowSpec);
        this.nextLine();
    }

    private void ensureHasComponentLine() {
        if (this.getRow() <= this.getRowCount()) {
            return;
        }
        this.appendRow(FormFactory.PREF_ROWSPEC);
        if (this.isRowGroupingEnabled()) {
            this.getLayout().addGroupedRow(this.getRow());
        }
    }

    private RowSpec getCursorRowSpec() {
        return this.getLayout().getRowSpec(this.getRow());
    }
}

