/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.builder;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;

public abstract class AbstractFormBuilder {
    private final Container container;
    private final FormLayout layout;
    private CellConstraints currentCellConstraints;
    private boolean leftToRight;

    public AbstractFormBuilder(Container container, FormLayout formLayout) {
        this.container = container;
        this.layout = formLayout;
        container.setLayout(formLayout);
        this.currentCellConstraints = new CellConstraints();
        ComponentOrientation componentOrientation = container.getComponentOrientation();
        this.leftToRight = componentOrientation.isLeftToRight() || !componentOrientation.isHorizontal();
    }

    public final Container getContainer() {
        return this.container;
    }

    public final FormLayout getLayout() {
        return this.layout;
    }

    public final int getColumnCount() {
        return this.getLayout().getColumnCount();
    }

    public final int getRowCount() {
        return this.getLayout().getRowCount();
    }

    public final boolean isLeftToRight() {
        return this.leftToRight;
    }

    public final void setLeftToRight(boolean bl2) {
        this.leftToRight = bl2;
    }

    public final int getColumn() {
        return this.currentCellConstraints.gridX;
    }

    public final void setColumn(int n2) {
        this.currentCellConstraints.gridX = n2;
    }

    public final int getRow() {
        return this.currentCellConstraints.gridY;
    }

    public final void setRow(int n2) {
        this.currentCellConstraints.gridY = n2;
    }

    public final void setColumnSpan(int n2) {
        this.currentCellConstraints.gridWidth = n2;
    }

    public final void setRowSpan(int n2) {
        this.currentCellConstraints.gridHeight = n2;
    }

    public final void setOrigin(int n2, int n3) {
        this.setColumn(n2);
        this.setRow(n3);
    }

    public final void setExtent(int n2, int n3) {
        this.setColumnSpan(n2);
        this.setRowSpan(n3);
    }

    public final void setBounds(int n2, int n3, int n4, int n5) {
        this.setColumn(n2);
        this.setRow(n3);
        this.setColumnSpan(n4);
        this.setRowSpan(n5);
    }

    public final void nextColumn() {
        this.nextColumn(1);
    }

    public final void nextColumn(int n2) {
        this.currentCellConstraints.gridX += n2 * this.getColumnIncrementSign();
    }

    public final void nextRow() {
        this.nextRow(1);
    }

    public final void nextRow(int n2) {
        this.currentCellConstraints.gridY += n2;
    }

    public final void nextLine() {
        this.nextLine(1);
    }

    public final void nextLine(int n2) {
        this.nextRow(n2);
        this.setColumn(this.getLeadingColumn());
    }

    public final void setHAlignment(CellConstraints.Alignment alignment) {
        this.currentCellConstraints.hAlign = alignment;
    }

    public final void setVAlignment(CellConstraints.Alignment alignment) {
        this.currentCellConstraints.vAlign = alignment;
    }

    public final void setAlignment(CellConstraints.Alignment alignment, CellConstraints.Alignment alignment2) {
        this.setHAlignment(alignment);
        this.setVAlignment(alignment2);
    }

    public final void appendColumn(ColumnSpec columnSpec) {
        this.getLayout().appendColumn(columnSpec);
    }

    public final void appendColumn(String string) {
        this.appendColumn(new ColumnSpec(string));
    }

    public final void appendGlueColumn() {
        this.appendColumn(FormFactory.GLUE_COLSPEC);
    }

    public final void appendLabelComponentsGapColumn() {
        this.appendColumn(FormFactory.LABEL_COMPONENT_GAP_COLSPEC);
    }

    public final void appendRelatedComponentsGapColumn() {
        this.appendColumn(FormFactory.RELATED_GAP_COLSPEC);
    }

    public final void appendUnrelatedComponentsGapColumn() {
        this.appendColumn(FormFactory.UNRELATED_GAP_COLSPEC);
    }

    public final void appendRow(RowSpec rowSpec) {
        this.getLayout().appendRow(rowSpec);
    }

    public final void appendRow(String string) {
        this.appendRow(new RowSpec(string));
    }

    public final void appendGlueRow() {
        this.appendRow(FormFactory.GLUE_ROWSPEC);
    }

    public final void appendRelatedComponentsGapRow() {
        this.appendRow(FormFactory.RELATED_GAP_ROWSPEC);
    }

    public final void appendUnrelatedComponentsGapRow() {
        this.appendRow(FormFactory.UNRELATED_GAP_ROWSPEC);
    }

    public final void appendParagraphGapRow() {
        this.appendRow(FormFactory.PARAGRAPH_GAP_ROWSPEC);
    }

    public final Component add(Component component, CellConstraints cellConstraints) {
        this.container.add(component, cellConstraints);
        return component;
    }

    public final Component add(Component component, String string) {
        this.container.add(component, new CellConstraints(string));
        return component;
    }

    public final Component add(Component component) {
        this.add(component, this.currentCellConstraints);
        return component;
    }

    public final CellConstraints cellConstraints() {
        return this.currentCellConstraints;
    }

    public int getLeadingColumn() {
        return this.isLeftToRight() ? 1 : this.getColumnCount();
    }

    public final int getColumnIncrementSign() {
        return this.isLeftToRight() ? 1 : -1;
    }

    public final CellConstraints createLeftAdjustedConstraints(int n2) {
        int n3 = this.isLeftToRight() ? this.getColumn() : this.getColumn() + 1 - n2;
        return new CellConstraints(n3, this.getRow(), n2, 1);
    }
}

