/*
 * Decompiled with CFR 0.152.
 */
package com.apple.eawt;

import apple.awt.CoreGraphicsAPI;
import com.apple.eawt.ApplicationEvent;
import com.apple.eawt.ApplicationListener;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Toolkit;
import java.beans.Beans;
import java.util.Enumeration;
import java.util.Vector;

public class Application {
    private static long sApplicationDelegate = 0L;
    private static Application sApplication = null;
    private static Vector sApplicationListenersLockable;
    private static Object sApplicationListenersLock;
    private PopupMenu fDockMenu = null;

    private static void checkSecurity() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("canProcessApplicationEvents"));
        }
    }

    public Application() {
        Application.checkSecurity();
    }

    public static Application getApplication() {
        Application.checkSecurity();
        return sApplication;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addApplicationListener(ApplicationListener applicationListener) {
        Object object = sApplicationListenersLock;
        synchronized (object) {
            if (sApplicationListenersLockable == null) {
                sApplicationListenersLockable = new Vector();
            }
            sApplicationListenersLockable.addElement(applicationListener);
            Application._notifyListenerAdded(sApplicationDelegate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeApplicationListener(ApplicationListener applicationListener) {
        Object object = sApplicationListenersLock;
        synchronized (object) {
            if (sApplicationListenersLockable == null) {
                return;
            }
            sApplicationListenersLockable.removeElement(applicationListener);
        }
    }

    public void setEnabledPreferencesMenu(boolean bl2) {
        Application._setEnabledPreferencesMenu(sApplicationDelegate, bl2);
    }

    public void setEnabledAboutMenu(boolean bl2) {
        Application._setEnabledAboutMenu(sApplicationDelegate, bl2);
    }

    public boolean getEnabledPreferencesMenu() {
        return Application._getEnabledPreferencesMenu(sApplicationDelegate);
    }

    public boolean getEnabledAboutMenu() {
        return Application._getEnabledAboutMenu(sApplicationDelegate);
    }

    public boolean isAboutMenuItemPresent() {
        return Application._isAboutMenuItemPresent(sApplicationDelegate);
    }

    public void addAboutMenuItem() {
        Application._setAboutMenuItemPresent(sApplicationDelegate, true);
    }

    public void removeAboutMenuItem() {
        Application._setAboutMenuItemPresent(sApplicationDelegate, false);
    }

    public boolean isPreferencesMenuItemPresent() {
        return Application._isPreferencesMenuItemPresent(sApplicationDelegate);
    }

    public void addPreferencesMenuItem() {
        Application._setPreferencesMenuItemPresent(sApplicationDelegate, true);
    }

    public void removePreferencesMenuItem() {
        Application._setPreferencesMenuItemPresent(sApplicationDelegate, false);
    }

    public static Point getMouseLocationOnScreen() {
        int[] nArray = new int[2];
        CoreGraphicsAPI.CGGetGlobalInputPointerPosition(nArray);
        return new Point(nArray[0], nArray[1]);
    }

    private static native long initializeApplicationDelegate();

    private static native void _notifyListenerAdded(long var0);

    private static native boolean _getEnabledPreferencesMenu(long var0);

    private static native boolean _getEnabledAboutMenu(long var0);

    private static native void _setEnabledPreferencesMenu(long var0, boolean var2);

    private static native void _setEnabledAboutMenu(long var0, boolean var2);

    private static native boolean _isAboutMenuItemPresent(long var0);

    private static native void _setAboutMenuItemPresent(long var0, boolean var2);

    private static native boolean _isPreferencesMenuItemPresent(long var0);

    private static native void _setPreferencesMenuItemPresent(long var0, boolean var2);

    private static native void _setTermination(boolean var0);

    private static native void _setDockMenu(long var0, long var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleAbout() {
        Object object = sApplicationListenersLock;
        synchronized (object) {
            if (sApplicationListenersLockable == null) {
                Application._reportAboutHandled(false);
                return;
            }
        }
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ApplicationEvent applicationEvent = new ApplicationEvent(Toolkit.getDefaultToolkit());
                Object object = Application.a();
                synchronized (object) {
                    if (Application.b() == null) {
                        Application.b(false);
                        return;
                    }
                    Enumeration enumeration = Application.b().elements();
                    if (!enumeration.hasMoreElements()) {
                        Application.b(false);
                    }
                    while (enumeration.hasMoreElements() && !applicationEvent.isHandled()) {
                        ApplicationListener applicationListener = (ApplicationListener)enumeration.nextElement();
                        applicationListener.handleAbout(applicationEvent);
                    }
                }
                Application.b(applicationEvent.isHandled());
            }
        });
    }

    private static native void _reportAboutHandled(boolean var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean handleOpenApplication() {
        Object object = sApplicationListenersLock;
        synchronized (object) {
            if (sApplicationListenersLockable == null) {
                return false;
            }
        }
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ApplicationEvent applicationEvent = new ApplicationEvent(Toolkit.getDefaultToolkit());
                Object object = Application.a();
                synchronized (object) {
                    if (Application.b() == null) {
                        return;
                    }
                    Enumeration enumeration = Application.b().elements();
                    while (enumeration.hasMoreElements() && !applicationEvent.isHandled()) {
                        ApplicationListener applicationListener = (ApplicationListener)enumeration.nextElement();
                        applicationListener.handleOpenApplication(applicationEvent);
                    }
                }
            }
        });
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean handlePrintFile(String string) {
        Object object = sApplicationListenersLock;
        synchronized (object) {
            if (sApplicationListenersLockable == null) {
                return false;
            }
        }
        EventQueue.invokeLater(new Runnable(string){
            private final String val$filename;
            {
                this.val$filename = string;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ApplicationEvent applicationEvent = new ApplicationEvent(Toolkit.getDefaultToolkit(), this.val$filename);
                Object object = Application.a();
                synchronized (object) {
                    if (Application.b() == null) {
                        return;
                    }
                    Enumeration enumeration = Application.b().elements();
                    while (enumeration.hasMoreElements() && !applicationEvent.isHandled()) {
                        ApplicationListener applicationListener = (ApplicationListener)enumeration.nextElement();
                        applicationListener.handlePrintFile(applicationEvent);
                    }
                }
            }
        });
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean handleOpenFile(String string) {
        Object object = sApplicationListenersLock;
        synchronized (object) {
            if (sApplicationListenersLockable == null) {
                return false;
            }
        }
        EventQueue.invokeLater(new Runnable(string){
            private final String val$filename;
            {
                this.val$filename = string;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ApplicationEvent applicationEvent = new ApplicationEvent(Toolkit.getDefaultToolkit(), this.val$filename);
                Object object = Application.a();
                synchronized (object) {
                    if (Application.b() == null) {
                        return;
                    }
                    Enumeration enumeration = Application.b().elements();
                    while (enumeration.hasMoreElements() && !applicationEvent.isHandled()) {
                        ApplicationListener applicationListener = (ApplicationListener)enumeration.nextElement();
                        applicationListener.handleOpenFile(applicationEvent);
                    }
                }
            }
        });
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handlePreferences() {
        Object object = sApplicationListenersLock;
        synchronized (object) {
            if (sApplicationListenersLockable == null) {
                return;
            }
        }
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ApplicationEvent applicationEvent = new ApplicationEvent(Toolkit.getDefaultToolkit());
                Object object = Application.a();
                synchronized (object) {
                    if (Application.b() == null) {
                        return;
                    }
                    Enumeration enumeration = Application.b().elements();
                    while (enumeration.hasMoreElements() && !applicationEvent.isHandled()) {
                        ApplicationListener applicationListener = (ApplicationListener)enumeration.nextElement();
                        applicationListener.handlePreferences(applicationEvent);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleQuit() {
        Object object = sApplicationListenersLock;
        synchronized (object) {
            if (sApplicationListenersLockable == null) {
                System.exit(0);
            }
        }
        object = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ApplicationEvent applicationEvent = new ApplicationEvent(Toolkit.getDefaultToolkit());
                Object object = Application.a();
                synchronized (object) {
                    Enumeration enumeration;
                    if (Application.b() == null) {
                        System.exit(0);
                    }
                    if (!(enumeration = Application.b().elements()).hasMoreElements()) {
                        System.exit(0);
                    }
                    while (enumeration.hasMoreElements() && !applicationEvent.isHandled()) {
                        ApplicationListener applicationListener = (ApplicationListener)enumeration.nextElement();
                        applicationListener.handleQuit(applicationEvent);
                    }
                }
                Application.a(applicationEvent.isHandled());
            }
        };
        EventQueue.invokeLater((Runnable)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean handleReOpenApplication() {
        Object object = sApplicationListenersLock;
        synchronized (object) {
            if (sApplicationListenersLockable == null) {
                return false;
            }
        }
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ApplicationEvent applicationEvent = new ApplicationEvent(Toolkit.getDefaultToolkit());
                Object object = Application.a();
                synchronized (object) {
                    if (Application.b() == null) {
                        return;
                    }
                    Enumeration enumeration = Application.b().elements();
                    while (enumeration.hasMoreElements() && !applicationEvent.isHandled()) {
                        ApplicationListener applicationListener = (ApplicationListener)enumeration.nextElement();
                        applicationListener.handleReOpenApplication(applicationEvent);
                    }
                }
            }
        });
        return true;
    }

    public static Object a() {
        return sApplicationListenersLock;
    }

    public static Vector b() {
        return sApplicationListenersLockable;
    }

    public static void b(boolean bl2) {
        Application._reportAboutHandled(bl2);
    }

    public static void a(boolean bl2) {
        Application._setTermination(bl2);
    }

    static {
        Application.checkSecurity();
        Toolkit.getDefaultToolkit();
        if (!Beans.isDesignTime()) {
            sApplicationDelegate = Application.initializeApplicationDelegate();
        }
        sApplication = new Application();
        sApplicationListenersLockable = null;
        sApplicationListenersLock = new Object();
    }
}

