/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CGraphicsConfig;
import apple.awt.CGraphicsEnvironment;
import apple.awt.OSXOffScreenSurfaceData;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.ImageCapabilities;
import java.awt.image.ColorModel;
import java.security.AccessController;
import sun.awt.DisplayChangedListener;
import sun.awt.image.SunVolatileImage;
import sun.java2d.InvalidPipeException;
import sun.java2d.SurfaceData;
import sun.security.action.GetPropertyAction;

public class OSXVolatileImage
extends SunVolatileImage
implements DisplayChangedListener {
    private void initialize() {
        ((CGraphicsEnvironment)GraphicsEnvironment.getLocalGraphicsEnvironment()).addDisplayChangedListener(this);
    }

    public OSXVolatileImage(Component component, int n2, int n3) {
        super(component, n2, n3);
        this.initialize();
    }

    public OSXVolatileImage(Component component, int n2, int n3, Object object) {
        super(component, n2, n3, object);
        this.initialize();
    }

    public OSXVolatileImage(GraphicsConfiguration graphicsConfiguration, int n2, int n3) {
        super(graphicsConfiguration, n2, n3);
        this.initialize();
    }

    public OSXOffScreenSurfaceData createHWData() {
        ColorModel colorModel = this.getDeviceColorModel();
        return OSXOffScreenSurfaceData.createData(this.getWidth(), this.getHeight(), colorModel, this.graphicsConfig, this, false);
    }

    public void initAcceleratedBackground() {
        try {
            this.surfaceDataHw = this.createHWData();
            if (this.surfaceDataHw != null) {
                this.surfaceData = this.surfaceDataHw;
                this.initContents();
                return;
            }
        }
        catch (InvalidPipeException invalidPipeException) {
            this.surfaceDataHw = null;
        }
        this.surfaceData = this.getSurfaceDataSw();
    }

    public SurfaceData restoreContents() {
        if (accelerationEnabled) {
            this.surfaceLossHw = true;
            this.surfaceLoss = true;
        }
        return super.restoreContents();
    }

    public ColorModel getDeviceColorModel() {
        if (this.comp != null) {
            CGraphicsConfig cGraphicsConfig = (CGraphicsConfig)this.comp.getGraphicsConfiguration();
            return cGraphicsConfig.getColorModel();
        }
        return ((CGraphicsConfig)this.graphicsConfig).getColorModel();
    }

    public void restoreSurfaceDataHw() {
        ((OSXOffScreenSurfaceData)this.surfaceDataHw).restoreSurface();
    }

    public void displayChanged() {
        if (!accelerationEnabled) {
            return;
        }
        this.surfaceLoss = true;
        this.surfaceLossHw = true;
        if (this.surfaceDataHw != null) {
            this.surfaceDataSw = null;
            this.surfaceData = this.getSurfaceDataSw();
            SurfaceData surfaceData = this.surfaceDataHw;
            this.surfaceDataHw = null;
            surfaceData.invalidate();
            if (this.comp != null) {
                this.graphicsConfig = this.comp.getGraphicsConfiguration();
            }
        }
    }

    public void paletteChanged() {
        this.surfaceLoss = true;
    }

    public ImageCapabilities getCapabilities() {
        if (accelerationEnabled && !(this.imageCaps instanceof HWACImageCaps)) {
            this.imageCaps = new HWACImageCaps(this, null);
        }
        return super.getCapabilities();
    }

    public void flush() {
        this.surfaceLoss = true;
        OSXOffScreenSurfaceData oSXOffScreenSurfaceData = (OSXOffScreenSurfaceData)this.surfaceDataHw;
        this.surfaceDataHw = null;
        if (oSXOffScreenSurfaceData != null) {
            oSXOffScreenSurfaceData.flush();
        }
    }

    public String toString() {
        return super.toString() + " surfaceDataHw=" + this.surfaceDataHw + " surfaceData=" + this.surfaceData;
    }

    static {
        boolean bl2;
        String string = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.noddraw"));
        String string2 = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.ddoffscreen"));
        boolean bl3 = bl2 = string2 != null && (string2.equals("false") || string2.equals("f"));
        if (string != null || bl2) {
            accelerationEnabled = false;
        }
    }

    public static class 1 {
    }

    private class HWACImageCaps
    extends SunVolatileImage.DefaultImageCapabilities {
        private final OSXVolatileImage this$0;

        private HWACImageCaps(OSXVolatileImage oSXVolatileImage) {
            this.this$0 = oSXVolatileImage;
            super((SunVolatileImage)oSXVolatileImage);
        }

        public boolean isTrueVolatile() {
            return this.isAccelerated();
        }

        public HWACImageCaps(OSXVolatileImage oSXVolatileImage, 1 var2_2) {
            this(oSXVolatileImage);
        }
    }
}

