/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CAppletFrame;
import apple.awt.CButton;
import apple.awt.CCanvas;
import apple.awt.CCheckbox;
import apple.awt.CCheckboxMenuItem;
import apple.awt.CChoice;
import apple.awt.CClipboard;
import apple.awt.CComponent;
import apple.awt.CCustomCursor;
import apple.awt.CDragSourceContextPeer;
import apple.awt.CFileDialog;
import apple.awt.CFrame;
import apple.awt.CGraphicsDevice;
import apple.awt.CInputMethod;
import apple.awt.CInputMethodDescriptor;
import apple.awt.CLabel;
import apple.awt.CList;
import apple.awt.CMenu;
import apple.awt.CMenuBar;
import apple.awt.CMenuItem;
import apple.awt.CMouseDragGestureRecognizer;
import apple.awt.CPanel;
import apple.awt.CPopupMenu;
import apple.awt.CPrintJob2D;
import apple.awt.CPrinterDialog;
import apple.awt.CPrinterDialogPeer;
import apple.awt.CRobot;
import apple.awt.CScrollPane;
import apple.awt.CScrollbar;
import apple.awt.CSurfaceData;
import apple.awt.CTextArea;
import apple.awt.CTextField;
import apple.awt.CWindow;
import apple.awt.CocoaEvent;
import apple.awt.EmbeddableAppletFrame;
import apple.awt.NSViewAPI;
import apple.awt.OSXImage;
import apple.awt.RuntimeOptions;
import com.apple.eawt.CocoaComponent;
import com.sun.imageio.plugins.tiff.TIFFImageReaderSpi;
import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.JobAttributes;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.PageAttributes;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.im.InputMethodHighlight;
import java.awt.im.spi.InputMethodDescriptor;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.peer.ButtonPeer;
import java.awt.peer.CanvasPeer;
import java.awt.peer.CheckboxMenuItemPeer;
import java.awt.peer.CheckboxPeer;
import java.awt.peer.ChoicePeer;
import java.awt.peer.DialogPeer;
import java.awt.peer.FileDialogPeer;
import java.awt.peer.FontPeer;
import java.awt.peer.FramePeer;
import java.awt.peer.LabelPeer;
import java.awt.peer.ListPeer;
import java.awt.peer.MenuBarPeer;
import java.awt.peer.MenuItemPeer;
import java.awt.peer.MenuPeer;
import java.awt.peer.PanelPeer;
import java.awt.peer.PopupMenuPeer;
import java.awt.peer.RobotPeer;
import java.awt.peer.ScrollPanePeer;
import java.awt.peer.ScrollbarPeer;
import java.awt.peer.TextAreaPeer;
import java.awt.peer.TextFieldPeer;
import java.awt.peer.WindowPeer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.imageio.spi.IIORegistry;
import sun.applet.AppletPanel;
import sun.applet.AppletViewer;
import sun.awt.AppContext;
import sun.awt.SunToolkit;
import sun.awt.font.FontDesignMetrics;
import sun.awt.image.ImageRepresentation;

public class CToolkit
extends SunToolkit {
    private static LookAndFeelChangeListener sLAFListener;
    public static FontMetrics[] lastMetrics;
    public static FontRenderContext b;
    public static CToolkit sToolkit;
    public static CInputMethodDescriptor sInputMethodDescriptor;
    private static Object sInitLock;
    private static boolean sWatchForAppletViewerAppContextIssue;
    public static final String DATA_TRANSFERER_CLASS_NAME = "apple.awt.CDataTransferer";
    private static long sMessageNumber;
    public static Clipboard g;
    public static Class d;
    public static Class a;
    public static final boolean h;
    public static Class c;
    public static Class e;
    public static Class f;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CToolkit() {
        Object object = sInitLock;
        synchronized (object) {
            if (sToolkit == null) {
                sToolkit = this;
            }
            if (CToolkit.a("sun.awt.exception.handler", null) == null) {
                CToolkit.b("sun.awt.exception.handler", (a == null ? (a = CToolkit.a("apple.awt.CToolkit$EventQueueExceptionHandler")) : a).getName());
            }
            CToolkit.b("awt.nativeDoubleBuffering", "true");
            SunToolkit.setDataTransfererClassName((String)DATA_TRANSFERER_CLASS_NAME);
            this.init();
        }
        this.a();
    }

    public static void notImplemented() {
        Thread.dumpStack();
    }

    private native void init();

    public native void loadSystemColors(int[] var1);

    public static final Object targetToPeer(Object object) {
        return SunToolkit.targetToPeer(object);
    }

    public static final void targetDisposedPeer(Object object, Object object2) {
        SunToolkit.targetDisposedPeer(object, object2);
    }

    public static boolean allowKeyboardNavigation() {
        return true;
    }

    public static native int getCFPreferencesNumber(String var0, int var1, int var2);

    public static String a(String string, String string2) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(string, string2){
            private final String val$name;
            private final String val$deflt;
            {
                this.val$name = string;
                this.val$deflt = string2;
            }

            public Object run() {
                return System.getProperty(this.val$name, this.val$deflt);
            }
        });
    }

    public static String b(String string, String string2) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(string, string2){
            private final String val$name;
            private final String val$value;
            {
                this.val$name = string;
                this.val$value = string2;
            }

            public Object run() {
                return System.setProperty(this.val$name, this.val$value);
            }
        });
    }

    public Object lazilyLoadDesktopProperty(String string) {
        if (string.equals("awt.dynamicLayoutSupported")) {
            return new Boolean(true);
        }
        return super.lazilyLoadDesktopProperty(string);
    }

    public int getMenuShortcutKeyMask() {
        return 4;
    }

    public Dimension getBestCursorSize(int n2, int n3) throws HeadlessException {
        return CCustomCursor.getBestCursorSize(n2, n3);
    }

    public int getMaximumCursorColors() throws HeadlessException {
        return Integer.MAX_VALUE;
    }

    public Cursor createCustomCursor(Image image, Point point, String string) throws IndexOutOfBoundsException, HeadlessException {
        return new CCustomCursor(image, point, string);
    }

    public ScrollbarPeer createScrollbar(Scrollbar scrollbar) {
        if (!h && !CToolkit.b("CToolkit.createScrollbar")) {
            throw new AssertionError();
        }
        CScrollbar cScrollbar = new CScrollbar(scrollbar);
        CToolkit.targetCreatedPeer(scrollbar, cScrollbar);
        return cScrollbar;
    }

    public TextAreaPeer createTextArea(TextArea textArea) {
        if (!h && !CToolkit.b("CToolkit.createTextArea")) {
            throw new AssertionError();
        }
        CTextArea cTextArea = new CTextArea(textArea);
        CToolkit.targetCreatedPeer(textArea, cTextArea);
        return cTextArea;
    }

    public ButtonPeer createButton(Button button) {
        if (!h && !CToolkit.b("CToolkit.createButton")) {
            throw new AssertionError();
        }
        CButton cButton = new CButton(button);
        CToolkit.targetCreatedPeer(button, cButton);
        return cButton;
    }

    public ChoicePeer createChoice(Choice choice) {
        if (!h && !CToolkit.b("CToolkit.createChoice")) {
            throw new AssertionError();
        }
        CChoice cChoice = new CChoice(choice);
        CToolkit.targetCreatedPeer(choice, cChoice);
        return cChoice;
    }

    public PanelPeer createPanel(Panel panel) {
        Object object;
        if (!h && !CToolkit.b("CToolkit.createPanel")) {
            throw new AssertionError();
        }
        if (sWatchForAppletViewerAppContextIssue && panel instanceof Applet) {
            AppContext appContext = CToolkit.targetToAppContext(panel);
            for (object = panel.getParent(); object != null; object = ((Component)object).getParent()) {
                Object object2 = object;
                SunToolkit.insertTargetMapping(object, appContext);
                SunToolkit.insertTargetMapping(object.getPeer(), appContext);
                AccessController.doPrivileged(new PrivilegedAction(this, (Component)object2, appContext){
                    private final Component val$tempParent;
                    private final AppContext val$appContext;
                    private final CToolkit this$0;
                    {
                        this.this$0 = cToolkit;
                        this.val$tempParent = component;
                        this.val$appContext = appContext;
                    }

                    public Object run() {
                        try {
                            Field field = (c == null ? (c = CToolkit.a("java.awt.KeyboardFocusManager")) : c).getDeclaredField("appContext");
                            field.setAccessible(true);
                            field.set(this.val$tempParent, this.val$appContext);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        return null;
                    }
                });
            }
            panel.getParent().validate();
        }
        object = new CPanel((Component)panel);
        CToolkit.targetCreatedPeer(panel, object);
        return object;
    }

    public CanvasPeer createCanvas(Canvas canvas) {
        if (!h && !CToolkit.b("CToolkit.createCanvas")) {
            throw new AssertionError();
        }
        long l2 = canvas instanceof CocoaComponent ? ((CocoaComponent)canvas).createNSView() : 0;
        CCanvas cCanvas = new CCanvas(canvas, l2);
        CToolkit.targetCreatedPeer(canvas, cCanvas);
        return cCanvas;
    }

    public static void sendMessage(CocoaComponent cocoaComponent, int n2, Object object) {
        CToolkit.a(((CCanvas)cocoaComponent.getPeer()).q, n2, object);
    }

    public static native void a(long var0, int var2, Object var3);

    public ScrollPanePeer createScrollPane(ScrollPane scrollPane) {
        if (!h && !CToolkit.b("CToolkit.createScrollPane")) {
            throw new AssertionError();
        }
        CScrollPane cScrollPane = new CScrollPane(scrollPane);
        CToolkit.targetCreatedPeer(scrollPane, cScrollPane);
        return cScrollPane;
    }

    public TextFieldPeer createTextField(TextField textField) {
        if (!h && !CToolkit.b("CToolkit.createTextField")) {
            throw new AssertionError();
        }
        CTextField cTextField = new CTextField(textField);
        CToolkit.targetCreatedPeer(textField, cTextField);
        return cTextField;
    }

    public LabelPeer createLabel(Label label) {
        if (!h && !CToolkit.b("CToolkit.createLabel")) {
            throw new AssertionError();
        }
        CLabel cLabel = new CLabel(label);
        CToolkit.targetCreatedPeer(label, cLabel);
        return cLabel;
    }

    public ListPeer createList(List list) {
        if (!h && !CToolkit.b("CToolkit.createList")) {
            throw new AssertionError();
        }
        CList cList = new CList(list);
        CToolkit.targetCreatedPeer(list, cList);
        return cList;
    }

    public CheckboxPeer createCheckbox(Checkbox checkbox) {
        if (!h && !CToolkit.b("CToolkit.createCheckbox")) {
            throw new AssertionError();
        }
        CCheckbox cCheckbox = new CCheckbox(checkbox);
        CToolkit.targetCreatedPeer(checkbox, cCheckbox);
        return cCheckbox;
    }

    public FramePeer createFrame(Frame frame) {
        if (!h && !CToolkit.b("CToolkit.createFrame")) {
            throw new AssertionError();
        }
        CWindow cWindow = frame instanceof EmbeddableAppletFrame ? new CAppletFrame((Component)frame) : new CFrame((Component)frame);
        CToolkit.targetCreatedPeer(frame, cWindow);
        return cWindow;
    }

    public WindowPeer createWindow(Window window) {
        if (!h && !CToolkit.b("CToolkit.createWindow")) {
            throw new AssertionError();
        }
        CWindow cWindow = new CWindow((Component)window);
        CToolkit.targetCreatedPeer(window, cWindow);
        return cWindow;
    }

    public DialogPeer createDialog(Dialog dialog) {
        if (!h && !CToolkit.b("CToolkit.createDialog")) {
            throw new AssertionError();
        }
        if (dialog instanceof CPrinterDialog) {
            return this.a((CPrinterDialog)dialog);
        }
        CFrame cFrame = new CFrame((Component)dialog);
        CToolkit.targetCreatedPeer(dialog, cFrame);
        return cFrame;
    }

    public FileDialogPeer createFileDialog(FileDialog fileDialog) {
        if (!h && !CToolkit.b("CToolkit.createFileDialog")) {
            throw new AssertionError();
        }
        CFileDialog cFileDialog = new CFileDialog(fileDialog);
        CToolkit.targetCreatedPeer(fileDialog, cFileDialog);
        return cFileDialog;
    }

    public MenuBarPeer createMenuBar(MenuBar menuBar) {
        if (!h && !CToolkit.b("CToolkit.createMenuBar")) {
            throw new AssertionError();
        }
        CMenuBar cMenuBar = new CMenuBar(menuBar);
        CToolkit.targetCreatedPeer(menuBar, cMenuBar);
        return cMenuBar;
    }

    public MenuPeer createMenu(Menu menu) {
        if (!h && !CToolkit.b("CToolkit.createMenu")) {
            throw new AssertionError();
        }
        CMenu cMenu = new CMenu(menu);
        CToolkit.targetCreatedPeer(menu, cMenu);
        return cMenu;
    }

    public PopupMenuPeer createPopupMenu(PopupMenu popupMenu) {
        if (!h && !CToolkit.b("CToolkit.createPopupMenu")) {
            throw new AssertionError();
        }
        CPopupMenu cPopupMenu = new CPopupMenu(popupMenu);
        CToolkit.targetCreatedPeer(popupMenu, cPopupMenu);
        return cPopupMenu;
    }

    public MenuItemPeer createMenuItem(MenuItem menuItem) {
        if (!h && !CToolkit.b("CToolkit.createMenuItem")) {
            throw new AssertionError();
        }
        CMenuItem cMenuItem = new CMenuItem(menuItem);
        CToolkit.targetCreatedPeer(menuItem, cMenuItem);
        return cMenuItem;
    }

    public CheckboxMenuItemPeer createCheckboxMenuItem(CheckboxMenuItem checkboxMenuItem) {
        if (!h && !CToolkit.b("CToolkit.createCheckboxMenuItem")) {
            throw new AssertionError();
        }
        CCheckboxMenuItem cCheckboxMenuItem = new CCheckboxMenuItem(checkboxMenuItem);
        CToolkit.targetCreatedPeer(checkboxMenuItem, cCheckboxMenuItem);
        return cCheckboxMenuItem;
    }

    public FontPeer getFontPeer(String string, int n2) {
        CToolkit.notImplemented();
        return null;
    }

    public CPrinterDialogPeer a(CPrinterDialog cPrinterDialog) {
        CPrinterDialogPeer cPrinterDialogPeer = new CPrinterDialogPeer(cPrinterDialog);
        CToolkit.targetCreatedPeer(cPrinterDialog, cPrinterDialogPeer);
        return cPrinterDialogPeer;
    }

    public void initializeDesktopProperties() {
        this.desktopProperties.put("DnD.Autoscroll.initialDelay", new Integer(50));
        this.desktopProperties.put("DnD.Autoscroll.interval", new Integer(50));
        this.desktopProperties.put("DnD.Autoscroll.cursorHysteresis", new Integer(5));
        this.desktopProperties.put("DnD.isDragImageSupported", new Boolean(true));
        this.desktopProperties.put("DnD.Cursor.CopyDrop", new NamedCursor("DnD.Cursor.CopyDrop"));
        this.desktopProperties.put("DnD.Cursor.MoveDrop", new NamedCursor("DnD.Cursor.MoveDrop"));
        this.desktopProperties.put("DnD.Cursor.LinkDrop", new NamedCursor("DnD.Cursor.LinkDrop"));
        this.desktopProperties.put("DnD.Cursor.CopyNoDrop", new NamedCursor("DnD.Cursor.CopyNoDrop"));
        this.desktopProperties.put("DnD.Cursor.MoveNoDrop", new NamedCursor("DnD.Cursor.MoveNoDrop"));
        this.desktopProperties.put("DnD.Cursor.LinkNoDrop", new NamedCursor("DnD.Cursor.LinkNoDrop"));
    }

    public RobotPeer createRobot(Robot robot, GraphicsDevice graphicsDevice) {
        return new CRobot(robot, (CGraphicsDevice)graphicsDevice);
    }

    public int getScreenWidth() {
        Rectangle rectangle = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds();
        return rectangle.width;
    }

    public int getScreenHeight() {
        Rectangle rectangle = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds();
        return rectangle.height;
    }

    public int getScreenResolution() {
        return ((CGraphicsDevice)GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice()).b();
    }

    public Insets getScreenInsets(GraphicsConfiguration graphicsConfiguration) throws HeadlessException {
        return ((CGraphicsDevice)graphicsConfiguration.getDevice()).c();
    }

    public DragSourceContextPeer createDragSourceContextPeer(DragGestureEvent dragGestureEvent) throws InvalidDnDOperationException {
        CDragSourceContextPeer cDragSourceContextPeer = CDragSourceContextPeer.a(dragGestureEvent);
        return cDragSourceContextPeer;
    }

    public DragGestureRecognizer createDragGestureRecognizer(Class clazz, DragSource dragSource, Component component, int n2, DragGestureListener dragGestureListener) {
        CMouseDragGestureRecognizer cMouseDragGestureRecognizer = null;
        if ((e == null ? (e = CToolkit.a("java.awt.dnd.MouseDragGestureRecognizer")) : e).equals(clazz)) {
            cMouseDragGestureRecognizer = new CMouseDragGestureRecognizer(dragSource, component, n2, dragGestureListener);
        }
        return cMouseDragGestureRecognizer;
    }

    public ColorModel getColorModel() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getColorModel();
    }

    public void sync() {
        CSurfaceData.flushAll();
    }

    public boolean prepareImage(Image image, int n2, int n3, ImageObserver imageObserver) {
        if (image instanceof OSXImage) {
            OSXImage oSXImage = (OSXImage)((Object)image);
            if (n2 == 0 || n3 == 0) {
                return true;
            }
            if (oSXImage.hasError()) {
                if (imageObserver != null) {
                    imageObserver.imageUpdate(image, 192, -1, -1, -1, -1);
                }
                return false;
            }
            ImageRepresentation imageRepresentation = oSXImage.getImageRep();
            return imageRepresentation.prepare(imageObserver);
        }
        return true;
    }

    public int checkImage(Image image, int n2, int n3, ImageObserver imageObserver) {
        if (image instanceof OSXImage) {
            OSXImage oSXImage = (OSXImage)((Object)image);
            int n4 = n2 == 0 || n3 == 0 ? 32 : oSXImage.getImageRep().check(imageObserver);
            return oSXImage.check(imageObserver) | n4;
        }
        return 32;
    }

    public Image createImage(ImageProducer imageProducer) {
        return new OSXImage(imageProducer);
    }

    public native void beep();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Clipboard getSystemClipboard() {
        if (!h && !CToolkit.b("CToolkit.getSystemClipboard")) {
            throw new AssertionError();
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSystemClipboardAccess();
        }
        Object object = sInitLock;
        synchronized (object) {
            if (g == null) {
                g = new CClipboard();
            }
        }
        return g;
    }

    public PrintJob getPrintJob(Frame frame, String string, Properties properties) {
        return this.getPrintJob(frame, string, null, null);
    }

    public PrintJob getPrintJob(Frame frame, String string, JobAttributes jobAttributes, PageAttributes pageAttributes) {
        if (GraphicsEnvironment.isHeadless()) {
            throw new IllegalArgumentException();
        }
        CPrintJob2D cPrintJob2D = new CPrintJob2D(frame, string, jobAttributes, pageAttributes);
        if (!cPrintJob2D.printDialog()) {
            cPrintJob2D = null;
        }
        return cPrintJob2D;
    }

    public Locale getDefaultKeyboardLocale() {
        Locale locale = CInputMethod.a();
        if (locale == null) {
            return super.getDefaultKeyboardLocale();
        }
        return locale;
    }

    public InputMethodDescriptor getInputMethodAdapterDescriptor() {
        if (sInputMethodDescriptor == null) {
            sInputMethodDescriptor = new CInputMethodDescriptor();
        }
        return sInputMethodDescriptor;
    }

    public Map mapInputMethodHighlight(InputMethodHighlight inputMethodHighlight) {
        return CInputMethod.mapInputMethodHighlight(inputMethodHighlight);
    }

    public boolean isFrameStateSupported(int n2) {
        switch (n2) {
            case 0: 
            case 1: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public static void postEvent(CComponent cComponent, AWTEvent aWTEvent) {
        CToolkit.postEvent(CToolkit.targetToAppContext(aWTEvent.getSource()), aWTEvent);
    }

    public static void postEvent(AWTEvent aWTEvent) {
        CToolkit.postEvent(CToolkit.targetToAppContext(aWTEvent.getSource()), aWTEvent);
    }

    public static boolean flushEvents() {
        boolean bl2 = false;
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public synchronized void run() {
                }
            });
        }
        catch (InterruptedException interruptedException) {
            bl2 = true;
        }
        catch (Exception exception) {
            System.err.println("Exception caught: " + exception);
            Thread.dumpStack();
        }
        return !bl2;
    }

    public static AppContext finalTargetToAppContext(Object object) {
        AppContext appContext = null;
        if (sWatchForAppletViewerAppContextIssue) {
            if (object instanceof AppletViewer) {
                Enumeration enumeration = ((AppletViewer)object).getApplets();
                object = enumeration.nextElement();
            }
            if (object instanceof AppletPanel) {
                object = ((AppletPanel)object).getApplet();
            }
        }
        appContext = CToolkit.targetToAppContext(object);
        return appContext;
    }

    public static Component resolveBestTarget(Component component) {
        if (sWatchForAppletViewerAppContextIssue) {
            if (component instanceof AppletViewer) {
                Enumeration enumeration = ((AppletViewer)component).getApplets();
                component = (Component)enumeration.nextElement();
            }
            if (component instanceof AppletPanel) {
                component = ((AppletPanel)component).getApplet();
            }
        }
        return component;
    }

    private static void dumpObject(Object object) {
        if (object != null) {
            System.err.println("Printing object of type : " + object.getClass());
            System.err.println(object.toString());
        } else {
            System.err.println("Printing object of type : <null>");
        }
    }

    public String[] getFontList() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FontRenderContext createDefaultFrcUsingRuntimeOptions() {
        LookAndFeelChangeListener lookAndFeelChangeListener = sLAFListener;
        synchronized (lookAndFeelChangeListener) {
            if (b == null) {
                AffineTransform affineTransform = GraphicsEnvironment.isHeadless() ? new AffineTransform() : GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getDefaultTransform();
                b = new FontRenderContext(affineTransform, RuntimeOptions.TextAntialiasing == 2, RuntimeOptions.FractionalMetrics == 2);
            }
            return b;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FontMetrics getFontMetrics(Font font) {
        LookAndFeelChangeListener lookAndFeelChangeListener = sLAFListener;
        synchronized (lookAndFeelChangeListener) {
            FontMetrics fontMetrics;
            for (int i2 = 0; i2 < lastMetrics.length && (fontMetrics = lastMetrics[i2]) != null; ++i2) {
                if (fontMetrics.getFont() != font) continue;
                return fontMetrics;
            }
            FontDesignMetrics fontDesignMetrics = new FontDesignMetrics(font, CToolkit.createDefaultFrcUsingRuntimeOptions());
            System.arraycopy(lastMetrics, 0, lastMetrics, 1, lastMetrics.length - 1);
            CToolkit.lastMetrics[0] = fontDesignMetrics;
            return fontDesignMetrics;
        }
    }

    public void a() {
        IIORegistry iIORegistry = IIORegistry.getDefaultInstance();
        iIORegistry.registerServiceProvider(new TIFFImageReaderSpi(), f == null ? (f = CToolkit.a("javax.imageio.spi.ImageReaderSpi")) : f);
    }

    public static boolean b(String string) {
        System.out.println("[AWT-" + sMessageNumber++ + "]:" + string);
        return true;
    }

    public static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        h = !(d == null ? (d = CToolkit.a("apple.awt.CToolkit")) : d).desiredAssertionStatus();
        sLAFListener = new LookAndFeelChangeListener();
        lastMetrics = new FontMetrics[5];
        b = null;
        sInitLock = new Object();
        sWatchForAppletViewerAppContextIssue = RuntimeOptions.AttemptAppContextFixup;
        sMessageNumber = 0L;
        g = null;
    }

    public static class EventQueueExceptionHandler {
        public static final boolean a = !(d == null ? (d = CToolkit.a("apple.awt.CToolkit")) : d).desiredAssertionStatus();

        public void handle(Throwable throwable) {
            if (!a) {
                throw new AssertionError();
            }
            CocoaEvent.c();
            NSViewAPI.repaintAllWindows();
            System.err.println("apple.awt.EventQueueExceptionHandler Caught Throwable : ");
            throwable.printStackTrace();
        }
    }

    public static class NamedCursor
    extends Cursor {
        public NamedCursor(String string) {
            super(string);
        }
    }

    public static class LookAndFeelChangeListener
    implements PropertyChangeListener {
        public LookAndFeelChangeListener() {
            RuntimeOptions.addPropertyChangeListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("apple.awt.RuntimeOptions")) {
                LookAndFeelChangeListener lookAndFeelChangeListener = this;
                synchronized (lookAndFeelChangeListener) {
                    b = null;
                    lastMetrics = new FontMetrics[5];
                }
            }
        }
    }
}

