/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.MouseDragGestureRecognizer;
import java.awt.event.MouseEvent;
import sun.awt.dnd.SunDragSourceContextPeer;

public class CMouseDragGestureRecognizer
extends MouseDragGestureRecognizer {
    private static final int fMotionThreshold = CMouseDragGestureRecognizer.getMotionThreshold();
    private static final int kDefaultMotionThreshold = 3;
    public static final int ButtonMask = 7168;

    private static int getMotionThreshold() {
        try {
            return (Integer)Toolkit.getDefaultToolkit().getDesktopProperty("DnD.gestureMotionThreshold");
        }
        catch (Exception exception) {
            return 3;
        }
    }

    public CMouseDragGestureRecognizer(DragSource dragSource, Component component, int n2, DragGestureListener dragGestureListener) {
        super(dragSource, component, n2, dragGestureListener);
    }

    public CMouseDragGestureRecognizer(DragSource dragSource, Component component, int n2) {
        this(dragSource, component, n2, null);
    }

    public CMouseDragGestureRecognizer(DragSource dragSource, Component component) {
        this(dragSource, component, 0);
    }

    public CMouseDragGestureRecognizer(DragSource dragSource) {
        this(dragSource, null);
    }

    public int mapDragOperationFromModifiers(MouseEvent mouseEvent) {
        int n2 = mouseEvent.getModifiersEx();
        int n3 = n2 & 0x1C00;
        return SunDragSourceContextPeer.convertModifiersToDropAction(n2, this.getSourceActions());
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.events.clear();
        if (this.mapDragOperationFromModifiers(mouseEvent) != 0) {
            this.appendEvent(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.events.clear();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.events.clear();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        int n2;
        if (!this.events.isEmpty() && (n2 = this.mapDragOperationFromModifiers(mouseEvent)) == 0) {
            this.events.clear();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.events.isEmpty()) {
            int n2 = this.mapDragOperationFromModifiers(mouseEvent);
            if (n2 == 0) {
                return;
            }
            MouseEvent mouseEvent2 = (MouseEvent)this.events.get(0);
            Point point = mouseEvent2.getPoint();
            Point point2 = mouseEvent.getPoint();
            int n3 = Math.abs(point.x - point2.x);
            int n4 = Math.abs(point.y - point2.y);
            if (n3 >= fMotionThreshold || n4 >= fMotionThreshold) {
                this.fireDragGestureRecognized(n2, ((MouseEvent)this.getTriggerEvent()).getPoint());
            } else {
                this.appendEvent(mouseEvent);
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

