/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CDropTarget;
import apple.awt.CGraphicsDevice;
import apple.awt.CToolkit;
import apple.awt.CWindow;
import apple.awt.FullscreenRaster;
import apple.awt.OSXBackBuffer;
import apple.awt.PeerImpl;
import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.dnd.peer.DropTargetPeer;
import java.awt.event.PaintEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.WritableRaster;
import java.awt.peer.ComponentPeer;
import sun.awt.AppContext;
import sun.awt.DisplayChangedListener;
import sun.awt.RepaintArea;
import sun.java2d.InvalidPipeException;

public abstract class CComponent
extends PeerImpl
implements ComponentPeer,
DropTargetPeer,
DisplayChangedListener {
    public AppContext d;
    public boolean f = false;
    public boolean h = false;
    public int a = -1;
    public int e = -1;
    private int numBackBuffers = 0;
    private OSXBackBuffer backBuffer = null;
    private OSXBackBuffer frontBuffer = null;
    public CWindow b = null;
    public RepaintArea paintArea;
    private int fNumDropTargets = 0;
    private CDropTarget fDropTarget = null;

    public CComponent() {
        this.init();
    }

    public void init() {
        this.d = AppContext.getAppContext();
        this.paintArea = new RepaintArea();
    }

    public void b() {
    }

    public void replaceSurfaceData() {
    }

    public void syncTo(Component component) {
        super.syncTo(component);
    }

    public void syncFrom(Component component) {
        super.syncFrom(component);
        this.fTarget = component;
    }

    public CWindow a() {
        if (this.b == null) {
            Container container;
            for (container = this.fTarget.getParent(); container != null && !(container instanceof Window); container = container.getParent()) {
            }
            this.b = (CWindow)container.getPeer();
        }
        return this.b;
    }

    public final boolean isObscured() {
        return false;
    }

    public final boolean canDetermineObscurity() {
        return false;
    }

    public final native boolean requestFocus(Component var1, boolean var2, boolean var3, long var4);

    public abstract boolean isFocusable();

    public abstract boolean handlesWheelScrolling();

    public void paint(Graphics graphics) {
    }

    public void repaint(long l2, int n2, int n3, int n4, int n5) {
    }

    public void print(Graphics graphics) {
        this.fTarget.paint(graphics);
    }

    public void handleEvent(AWTEvent aWTEvent) {
        int n2 = aWTEvent.getID();
        switch (n2) {
            case 800: {
                this.h = false;
            }
            case 801: {
                if (!this.f && !this.h) {
                    this.paintArea.paint(this.fTarget, this.shouldClearRectBeforePaint());
                }
                return;
            }
        }
    }

    public boolean shouldClearRectBeforePaint() {
        return false;
    }

    public final void coalescePaintEvent(PaintEvent paintEvent) {
        Rectangle rectangle = paintEvent.getUpdateRect();
        this.paintArea.add(rectangle, paintEvent.getID());
    }

    public Rectangle getBounds() {
        return this.fTarget.getBounds();
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        return this.fTarget.getSize();
    }

    public final ColorModel getColorModel() {
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        if (graphicsConfiguration != null) {
            return graphicsConfiguration.getColorModel();
        }
        return null;
    }

    public final Toolkit getToolkit() {
        return CToolkit.sToolkit;
    }

    public Graphics getGraphics() {
        CToolkit.notImplemented();
        return null;
    }

    public final FontMetrics getFontMetrics(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    public abstract void setForeground(Color var1);

    public abstract void setBackground(Color var1);

    public abstract void setFont(Font var1);

    public final Image createImage(ImageProducer imageProducer) {
        return this.getToolkit().createImage(imageProducer);
    }

    public final Image createImage(int n2, int n3) {
        return new BufferedImage(n2, n3, 3);
    }

    public final boolean prepareImage(Image image, int n2, int n3, ImageObserver imageObserver) {
        return this.getToolkit().prepareImage(image, n2, n3, imageObserver);
    }

    public final int checkImage(Image image, int n2, int n3, ImageObserver imageObserver) {
        return this.getToolkit().checkImage(image, n2, n3, imageObserver);
    }

    public final Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public final Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public final void show() {
        this.setVisible(true);
    }

    public final void hide() {
        this.setVisible(false);
    }

    public final void enable() {
        this.setEnabled(true);
    }

    public final void disable() {
        this.setEnabled(false);
    }

    public final void reshape(int n2, int n3, int n4, int n5) {
        this.setBounds(n2, n3, n4, n5);
    }

    public final void a(AWTEvent aWTEvent) {
        CToolkit.postEvent(CToolkit.targetToAppContext(this.fTarget), aWTEvent);
    }

    public void addDropTarget(DropTarget dropTarget) {
        if (++this.fNumDropTargets == 1) {
            if (this.fDropTarget != null) {
                System.err.println("CComponent.addDropTarget(): current drop target is non-null.");
            }
            this.fDropTarget = CDropTarget.a(dropTarget, this.fTarget, this);
        }
    }

    public void removeDropTarget(DropTarget dropTarget) {
        if (--this.fNumDropTargets == 0) {
            if (this.fDropTarget != null) {
                this.fDropTarget.dispose();
                this.fDropTarget = null;
            } else {
                System.err.println("CComponent.removeDropTarget(): current drop target is null.");
            }
        }
    }

    public boolean isFullScreen() {
        CGraphicsDevice cGraphicsDevice = (CGraphicsDevice)this.getGraphicsConfiguration().getDevice();
        return cGraphicsDevice.isFullScreen();
    }

    private void assertFullScreen() throws AWTException {
        if (!this.isFullScreen()) {
            throw new AWTException("The operation requested is only supported on a full-screen exclusive window");
        }
    }

    public synchronized void createBuffers(int n2, BufferCapabilities bufferCapabilities) throws AWTException {
        this.assertFullScreen();
        if (bufferCapabilities.getFlipContents() != null || bufferCapabilities.getFrontBufferCapabilities().isAccelerated()) {
            throw new AWTException("Unsupported BufferCapabilities");
        }
        this.numBackBuffers = n2 - 1;
        try {
            this.replaceSurfaceData();
        }
        catch (InvalidPipeException invalidPipeException) {
            throw new AWTException(invalidPipeException.getMessage());
        }
    }

    public synchronized void destroyBuffers() {
        this.disposeBackBuffer();
        this.numBackBuffers = 0;
    }

    private synchronized void disposeFrontBuffer() {
        if (this.frontBuffer == null) {
            return;
        }
        this.frontBuffer = null;
    }

    private synchronized void disposeBackBuffer() {
        if (this.backBuffer == null) {
            return;
        }
        this.backBuffer = null;
    }

    public synchronized void createFrontBuffer() {
        DirectColorModel directColorModel = (DirectColorModel)this.getColorModel();
        WritableRaster writableRaster = FullscreenRaster.createFullscreenRaster(this.fTarget.getWidth(), this.fTarget.getHeight(), directColorModel.getMasks(), null);
        if (writableRaster != null) {
            this.frontBuffer = new OSXBackBuffer(this.fTarget, directColorModel, writableRaster);
        }
    }

    public synchronized void createBackBuffer() {
        if (this.numBackBuffers > 0) {
            DirectColorModel directColorModel = (DirectColorModel)this.getColorModel();
            WritableRaster writableRaster = FullscreenRaster.createFullscreenRaster(this.fTarget.getWidth(), this.fTarget.getHeight(), directColorModel.getMasks(), null);
            if (writableRaster != null) {
                this.backBuffer = new OSXBackBuffer(this.fTarget, directColorModel, writableRaster);
            }
        } else {
            this.backBuffer = null;
        }
    }

    public synchronized void flip(BufferCapabilities.FlipContents flipContents) {
        if (this.backBuffer == null) {
            throw new IllegalStateException("Back Buffers have not been created");
        }
    }

    public Image getFrontBuffer() {
        if (this.frontBuffer == null) {
            this.createFrontBuffer();
        }
        if (this.frontBuffer == null) {
            throw new IllegalStateException("Front Buffer could not be created");
        }
        return this.frontBuffer;
    }

    public Image getBackBuffer() {
        if (this.backBuffer == null) {
            this.createBackBuffer();
        }
        if (this.backBuffer == null) {
            throw new IllegalStateException("Back Buffers could not be created");
        }
        return this.backBuffer;
    }

    public void displayChanged() {
        try {
            this.replaceSurfaceData();
        }
        catch (InvalidPipeException invalidPipeException) {
            // empty catch block
        }
    }

    public void paletteChanged() {
    }
}

