#include "irit_sm.h"
#include "iritprsr.h"
#include "allocate.h"
#include "geom_lib.h"
#include "cagd_lib.h"

void main(int argc, char **argv)
{
    int Handler;

    if (argc == 2) {
	if ((Handler = IPOpenDataFile(argv[1], TRUE, TRUE)) >= 0) {
	    IPObjectStruct
		*PObj = IPGetObjects(Handler);

	    /* Done with file - close it. */
	    IPCloseStream(Handler, TRUE);

	    if (IP_IS_SRF_OBJ(PObj)) {
	        STATIC_DATA CagdRType
		    *Polyline[CAGD_MAX_PT_SIZE] = { NULL };
		int i, j,
		    n = 100;
		CagdRType *RefKV;
	        CagdSrfStruct *Srfs,
		    *Srf = PObj -> U.Srfs;
		BspKnotAlphaCoeffStruct *A1, *A2;

		if (Polyline[0] == NULL) {
		    CagdRType UMin, UMax, VMin, VMax;
		    int Len;

		    CagdSrfDomain(Srf, &UMin, &UMax, &VMin, &VMax);

		    RefKV = BspKnotPrepEquallySpaced(n, UMin, UMax);
		    Len = CAGD_SRF_UPT_LST_LEN(Srf);
		    for (j = 10; j >= 0; j--) {
		        A1 = BspKnotEvalAlphaCoefMerge(Srf -> UOrder,
					  Srf -> UKnotVector,
					  Len, RefKV, n, FALSE);
			if (j > 0)
			    BspKnotFreeAlphaCoef(A1);
		    }
		    IritFree(RefKV);

		    RefKV = BspKnotPrepEquallySpaced(n, VMin, VMax);
		    Len = CAGD_SRF_VPT_LST_LEN(Srf);
		    for (j = 10; j >= 0; j--) {
		        A2 = BspKnotEvalAlphaCoefMerge(Srf -> VOrder,
					  Srf -> VKnotVector,
					  Len, RefKV, n, FALSE);
			if (j > 0)
			    BspKnotFreeAlphaCoef(A2);
		    }
		    IritFree(RefKV);

		    for (i = 0; i < CAGD_MAX_PT_SIZE; i++)
		        Polyline[i] = (CagdRType *)
			    IritMalloc(sizeof(CagdRType) * n);
		}

		for (i = 0; i < 10; i++) {
		    int NumOfIsocurves[2] = { 10, 10 };
		    CagdPolylineStruct
		        *Pl = CagdSrf2Polylines(Srf, NumOfIsocurves, n);

		    CagdPolylineFreeList(Pl);
		}

		for (i = 0; i < 30; i++) {
		    Srfs = CagdSrfSubdivAtParam(Srf, 0.5, CAGD_CONST_U_DIR);
		    CagdSrfFreeList(Srfs);
		    Srfs = CagdSrfSubdivAtParam(Srf, 0.5, CAGD_CONST_V_DIR);
		    CagdSrfFreeList(Srfs);
		}
	    }
	    else {
	        fprintf(stderr, "Expected a surface \"%s\"\n", argv[1]);
		exit(1);
	    }
	}
	else {
	    fprintf(stderr, "Failed to open file \"%s\"\n", argv[1]);
	    exit(1);
	}
    }
    else {
	fprintf(stderr, "Usage: test srf.itd\n");
	exit(2);
    }

    exit(0);
}
