/******************************************************************************
* TrivCoer.c - Handle point coercions/conversions.			      *
*******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                 *
*******************************************************************************
* Written by Gershon Elber, Sep. 94.					      *
******************************************************************************/

#include "triv_loc.h"

/*****************************************************************************
* DESCRIPTION:                                                               M
* Coerces a trivariate to point type PType.				     M
*                                                                            *
* PARAMETERS:                                                                M
*   TV:       To coerce to a new point type PType.                           M
*   PType:    New point type for TV.                                         M
*                                                                            *
* RETURN VALUE:                                                              M
*   TrivTVStruct *:   A new trivariate with PType as its point type.         M
*                                                                            *
* KEYWORDS:                                                                  M
*   TrivCoerceTVTo, coercion                                                 M
*****************************************************************************/
TrivTVStruct *TrivCoerceTVTo(TrivTVStruct *TV, CagdPointType PType)
{
    TV = TrivTVCopy(TV);

    CagdCoercePointsTo(TV -> Points,
		       TV -> ULength * TV -> VLength * TV -> WLength,
		       TV -> PType, PType);

    TV -> PType = PType;
    return TV;
}
