/******************************************************************************
* bsp3injc.c - Injectivitiy testing for uniform cubic Bspline surfaces	      *
*******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                 *
*******************************************************************************
* Written by Gershon Elber, June. 2000.					      *
******************************************************************************/

#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include "symb_loc.h"

STATIC_DATA CagdRType
    x00 = 0.0,
    x01 = 0.0,
    x02 = 0.0,
    x03 = 0.0,
    x10 = 0.0,
    x11 = 0.0,
    x12 = 0.0,
    x13 = 0.0,
    x20 = 0.0,
    x21 = 0.0,
    x22 = 0.0,
    x23 = 0.0,
    x30 = 0.0,
    x31 = 0.0,
    x32 = 0.0,
    x33 = 0.0,
    y00 = 0.0,
    y01 = 0.0,
    y02 = 0.0,
    y03 = 0.0,
    y10 = 0.0,
    y11 = 0.0,
    y12 = 0.0,
    y13 = 0.0,
    y20 = 0.0,
    y21 = 0.0,
    y22 = 0.0,
    y23 = 0.0,
    y30 = 0.0,
    y31 = 0.0,
    y32 = 0.0,
    y33 = 0.0;

static CagdRType SolFunc1(void);
static CagdRType SolFunc2(void);
static CagdRType SolFunc3(void);
static CagdRType SolFunc4(void);
static CagdRType SolFunc5(void);
static CagdRType SolFunc6(void);
static CagdRType SolFunc7(void);
static CagdRType SolFunc8(void);
static CagdRType SolFunc9(void);
static CagdRType SolFunc10(void);
static CagdRType SolFunc11(void);
static CagdRType SolFunc12(void);
static CagdRType SolFunc13(void);
static CagdRType SolFunc14(void);
static CagdRType SolFunc15(void);
static CagdRType SolFunc16(void);
static CagdRType SolFunc17(void);
static CagdRType SolFunc18(void);
static CagdRType SolFunc19(void);
static CagdRType SolFunc20(void);
static CagdRType SolFunc21(void);
static CagdRType SolFunc22(void);
static CagdRType SolFunc23(void);
static CagdRType SolFunc24(void);
static CagdRType SolFunc25(void);
static CagdRType SolFunc26(void);
static CagdRType SolFunc27(void);
static CagdRType SolFunc28(void);
static CagdRType SolFunc29(void);
static CagdRType SolFunc30(void);
static CagdRType SolFunc31(void);
static CagdRType SolFunc32(void);
static CagdRType SolFunc33(void);
static CagdRType SolFunc34(void);
static CagdRType SolFunc35(void);
static CagdRType SolFunc36(void);

typedef CagdRType (*SymbBsp3InjctiveSolFuncType)(void);

STATIC_DATA SymbBsp3InjctiveSolFuncType SymbBsp3InjctiveSolFuncs[] = {
    SolFunc1,
    SolFunc2,
    SolFunc3,
    SolFunc4,
    SolFunc5,
    SolFunc6,
    SolFunc7,
    SolFunc8,
    SolFunc9,
    SolFunc10,
    SolFunc11,
    SolFunc12,
    SolFunc13,
    SolFunc14,
    SolFunc15,
    SolFunc16,
    SolFunc17,
    SolFunc18,
    SolFunc19,
    SolFunc20,
    SolFunc21,
    SolFunc22,
    SolFunc23,
    SolFunc24,
    SolFunc25,
    SolFunc26,
    SolFunc27,
    SolFunc28,
    SolFunc29,
    SolFunc30,
    SolFunc31,
    SolFunc32,
    SolFunc33,
    SolFunc34,
    SolFunc35,
    SolFunc36
};

/*****************************************************************************
* DESCRIPTION:                                                               M
*   Examine if the given uniform cubic patch in injective.  The patch is     M
* assumed to be a mapping from R2 to R2.				     M
*                                                                            *
* PARAMETERS:                                                                M
*   x:         The 4 by 4 array of X coefficients of the cubic patch.        M
*   y:         The 4 by 4 array of Y coefficients of the cubic patch.        M
*                                                                            *
* RETURN VALUE:                                                              M
*   CagdBType:    TRUE if injective, FALSE otherwise.                        M
*                                                                            *
* KEYWORDS:                                                                  M
*   SymbCubicBspInjective                                                    M
*****************************************************************************/
CagdBType SymbCubicBspInjective(CagdRType x[4][4], CagdRType y[4][4])
{
    int i;
    CagdRType V;

    x00 = x[0][0]; x01 = x[0][1]; x02 = x[0][2]; x03 = x[0][3];
    x10 = x[1][0]; x11 = x[1][1]; x12 = x[1][2]; x13 = x[1][3];
    x20 = x[2][0]; x21 = x[2][1]; x22 = x[2][2]; x23 = x[2][3];
    x30 = x[3][0]; x31 = x[3][1]; x32 = x[3][2]; x33 = x[3][3];

    y00 = y[0][0]; y01 = y[0][1]; y02 = y[0][2]; y03 = y[0][3];
    y10 = y[1][0]; y11 = y[1][1]; y12 = y[1][2]; y13 = y[1][3];
    y20 = y[2][0]; y21 = y[2][1]; y22 = y[2][2]; y23 = y[2][3];
    y30 = y[3][0]; y31 = y[3][1]; y32 = y[3][2]; y33 = y[3][3];

    V = SymbBsp3InjctiveSolFuncs[0]();
    for (i = 1; i < 36; i++) {
	if (V * SymbBsp3InjctiveSolFuncs[i]() < 0.0)
	    return FALSE;
    }

    return TRUE;
}

/*****************************************************************************
* DESCRIPTION:                                                               *
*   36 function of the bi-quinitic Bezier function representing the uniform  *
* cubic Bspline's normal field.  All 36 functions must return the same       *
* sign for the uniform cubic Bspline to be injective.			     *
*   These 36 functions were computed using Maple.			     *
*                                                                            *
* PARAMETERS:                                                                *
*   None                                                                     *
*                                                                            *
* RETURN VALUE:                                                              *
*   CagdRType:     The value of the coefficient.                                *
*****************************************************************************/

/* z02 */
static CagdRType SolFunc1(void)
{
    return(x00*y22/120.0-x01*y23/360.0+13.0/90.0*x01*y11+7.0/1440.0*x00*y21-x00
*y01/288.0+x22*y12/10.0+x22*y02/20.0-x22*y20/120.0-x22*y10/30.0-x22*y00/120.0-
x02*y22/20.0+x02*y10/30.0+x02*y00/120.0+79.0/1440.0*x21*y22+3.0/20.0*x21*y12-
x21*y20/288.0-x21*y10/60.0-3.0/20.0*x01*y12-x00*y02/120.0-x10*y01/60.0+x10*y21/
60.0+x01*y00/288.0+x20*y22/120.0-x20*y02/120.0-79.0/1440.0*x01*y02+7.0/1440.0*
x01*y20+x10*y22/30.0+x01*y10/60.0-29.0/1440.0*x01*y22-7.0/1440.0*x21*y00+29.0/
1440.0*x21*y02-13.0/180.0*x21*y01-13.0/90.0*x21*y11+x21*y03/360.0+x21*y13/90.0+
x21*y23/360.0-13.0/90.0*x11*y01+13.0/180.0*x01*y21-x01*y03/360.0-x01*y13/90.0+
13.0/90.0*x11*y21-5.0/72.0*x11*y02-x02*y12/10.0+3.0/20.0*x12*y01-3.0/20.0*x12*
y21+x12*y02/10.0+x02*y20/120.0+x23*y01/360.0-x23*y21/360.0-29.0/1440.0*x02*y21+
x13*y01/90.0-x13*y21/90.0+x03*y01/360.0-5.0/72.0*x22*y11+x22*y03/1440.0+x22*y13
/360.0+x22*y23/1440.0+x20*y21/288.0+5.0/72.0*x02*y11-x02*y03/1440.0-x02*y13/
360.0-x02*y23/1440.0-x10*y02/30.0-x11*y00/360.0+x00*y11/360.0-x00*y03/1440.0-
x00*y13/360.0-x00*y23/1440.0+x20*y03/1440.0+x20*y13/360.0+x20*y23/1440.0+x13*
y00/360.0-x13*y20/360.0+x23*y00/1440.0-x23*y20/1440.0+5.0/72.0*x11*y22+x11*y20/
360.0-x20*y11/360.0+x03*y00/1440.0-x03*y20/1440.0-7.0/1440.0*x20*y01+x03*y02/
1440.0-x03*y22/1440.0-x12*y22/10.0+29.0/1440.0*x22*y01-79.0/1440.0*x22*y21+x13*
y02/360.0-x13*y22/360.0+x23*y02/1440.0-x23*y22/1440.0-x03*y21/360.0+79.0/1440.0
*x02*y01);
}

/* z01 */
static CagdRType SolFunc2(void)
{
    return(x00*y22/360.0+4.0/45.0*x01*y11+x00*y21/45.0-x00*y01/90.0+x22*y12/
18.0+x22*y02/36.0-x22*y20/72.0-x22*y10/30.0-x22*y00/360.0-x02*y22/36.0+x02*y10/
30.0+x02*y00/72.0+2.0/45.0*x21*y22+7.0/45.0*x21*y12-x21*y20/90.0-x21*y10/15.0
-7.0/45.0*x01*y12-x00*y12/45.0-x00*y02/72.0-x10*y01/15.0+x10*y21/15.0+x01*y00/
90.0+x20*y22/72.0+x20*y12/45.0-x20*y02/360.0-2.0/45.0*x01*y02+x01*y20/45.0+x10*
y22/30.0+x01*y10/15.0-x01*y22/30.0-x21*y00/45.0+x21*y02/30.0-2.0/45.0*x21*y01
-4.0/45.0*x21*y11-4.0/45.0*x11*y01+2.0/45.0*x01*y21+4.0/45.0*x11*y21-x11*y02/
45.0-x02*y12/18.0-x12*y20/45.0+7.0/45.0*x12*y01-7.0/45.0*x12*y21+x12*y02/18.0+
x02*y20/360.0-x02*y21/30.0+x12*y00/45.0-x22*y11/45.0+x20*y21/90.0+x02*y11/45.0-
x10*y02/30.0-x11*y00/45.0+x00*y11/45.0+x11*y22/45.0+x11*y20/45.0-x20*y11/45.0-
x20*y01/45.0-x12*y22/18.0+x22*y01/30.0-2.0/45.0*x22*y21+2.0/45.0*x02*y01);
}

/* z40 */
static CagdRType SolFunc3(void)
{
    return(-2.0/45.0*x20*y10+2.0/45.0*x10*y20+2.0/45.0*x22*y12-2.0/45.0*x22*y20
+x22*y10/30.0+4.0/45.0*x21*y22+x21*y12/45.0-4.0/45.0*x21*y20-x21*y10/45.0+x10*
y21/45.0+2.0/45.0*x20*y22-x20*y12/30.0-x10*y22/30.0+x12*y20/30.0-x12*y21/45.0+
x32*y11/45.0-x32*y21/45.0+7.0/45.0*x22*y11-x22*y31/15.0+x12*y11/18.0-x12*y31/
30.0+4.0/45.0*x20*y21-x21*y30/45.0+x30*y21/45.0-x11*y12/18.0-7.0/45.0*x11*y22-
x11*y32/45.0+x10*y30/72.0-x10*y12/36.0+x10*y32/360.0-x30*y10/72.0-x30*y20/90.0+
x30*y12/360.0+x30*y22/45.0+x11*y10/18.0+7.0/45.0*x11*y20+x11*y30/45.0-x31*y10/
30.0-x31*y20/15.0+x12*y10/36.0-x12*y30/360.0-x12*y32/72.0-x32*y10/360.0-x32*y20
/45.0+x32*y12/72.0+x32*y22/90.0-x10*y11/18.0+x10*y31/30.0+x20*y30/90.0-7.0/45.0
*x20*y11+x20*y31/15.0+x20*y32/45.0-x30*y11/45.0-x22*y30/45.0-x22*y32/90.0+x21*
y32/45.0+x31*y12/30.0+x31*y22/15.0-2.0/45.0*x12*y22-4.0/45.0*x22*y21);
}

/* z52 */
static CagdRType SolFunc4(void)
{
    return(x22*y12/10.0-5.0/72.0*x21*y12-x21*y10/360.0+x10*y21/360.0-x20*y12/
30.0+13.0/180.0*x11*y31-x11*y13/360.0-x11*y23/90.0-x11*y33/360.0-13.0/90.0*x21*
y11+13.0/90.0*x21*y31+x33*y12/1440.0-x33*y32/1440.0+13.0/90.0*x11*y21+x12*y20/
30.0+5.0/72.0*x12*y21+x33*y11/360.0-x33*y31/360.0+x23*y11/90.0-x23*y31/90.0+x13
*y11/360.0-x13*y31/360.0+29.0/1440.0*x32*y11-5.0/72.0*x32*y21-79.0/1440.0*x32*
y31+x32*y13/1440.0+x32*y23/360.0+x32*y33/1440.0+3.0/20.0*x22*y11-3.0/20.0*x22*
y31+79.0/1440.0*x12*y11-29.0/1440.0*x12*y31-x12*y13/1440.0-x12*y23/360.0-x12*
y33/1440.0+x31*y23/90.0-13.0/180.0*x31*y11-13.0/90.0*x31*y21+x31*y13/360.0+x31*
y33/360.0+x21*y30/360.0-x30*y21/360.0-x10*y13/1440.0-x10*y23/360.0-x10*y33/
1440.0+x30*y13/1440.0+x30*y23/360.0+x30*y33/1440.0+x13*y10/1440.0-x13*y30/
1440.0+x23*y10/360.0-x23*y30/360.0+x33*y10/1440.0-x33*y30/1440.0-79.0/1440.0*
x11*y12-3.0/20.0*x11*y22-29.0/1440.0*x11*y32-x10*y12/120.0+x10*y32/120.0-x30*
y12/120.0+x30*y32/120.0+x11*y10/288.0+x11*y20/60.0+7.0/1440.0*x11*y30-7.0/
1440.0*x31*y10-x31*y20/60.0-x31*y30/288.0+x12*y10/120.0+x12*y30/120.0-x12*y32/
20.0-x32*y10/120.0-x32*y20/30.0-x32*y30/120.0+x32*y12/20.0+x32*y22/10.0-x10*y11
/288.0+7.0/1440.0*x10*y31-x20*y11/60.0+x20*y31/60.0+x20*y32/30.0-7.0/1440.0*x30
*y11+x30*y31/288.0-x22*y32/10.0+5.0/72.0*x21*y32+29.0/1440.0*x31*y12+3.0/20.0*
x31*y22+79.0/1440.0*x31*y32-x12*y22/10.0+x13*y12/1440.0-x13*y32/1440.0+x23*y12/
360.0-x23*y32/360.0);
}

/* z15 */
static CagdRType SolFunc5(void)
{
    return(-x01*y23/360.0+x01*y11/90.0+x21*y22/18.0-x21*y12/45.0-x01*y12/45.0+
x01*y22/45.0-x21*y02/30.0-x11*y03/45.0-2.0/45.0*x11*y13+x11*y23/30.0-x21*y01/
72.0-2.0/45.0*x21*y11-x21*y03/360.0+x21*y13/30.0+x21*y23/36.0-x11*y01/90.0+x01*
y21/72.0-x01*y13/45.0+2.0/45.0*x11*y21-x11*y02/15.0+x12*y01/45.0+x12*y21/45.0+
x23*y01/360.0-x23*y11/30.0-x23*y21/36.0+x23*y03/72.0+2.0/45.0*x23*y13+x02*y21/
30.0+x13*y01/45.0+2.0/45.0*x13*y11-x13*y21/30.0+x13*y03/90.0-2.0/45.0*x13*y23
-7.0/45.0*x22*y11+x22*y03/45.0+7.0/45.0*x22*y13+x22*y23/18.0+4.0/45.0*x12*y11-
x12*y03/45.0-4.0/45.0*x12*y13-x12*y23/45.0+x02*y11/15.0-x02*y13/15.0-x02*y23/
30.0-4.0/45.0*x11*y12+7.0/45.0*x11*y22+x03*y12/45.0-x03*y22/45.0-x22*y01/45.0-
x22*y21/18.0+x13*y02/15.0+4.0/45.0*x13*y12-7.0/45.0*x13*y22+x23*y02/30.0+x23*
y12/45.0-x23*y22/18.0+x03*y11/45.0+x03*y21/360.0-x03*y13/90.0-x03*y23/72.0);
}

/* z55 */
static CagdRType SolFunc6(void)
{
    return(-x21*y12/9.0+x11*y31/72.0-x11*y13/72.0-x11*y23/36.0-x21*y11/36.0+x21
*y31/36.0-x21*y13/36.0+x33*y12/36.0-x33*y32/36.0+x11*y21/36.0+x12*y21/9.0+x33*
y23/36.0-x33*y21/36.0-x33*y31/72.0+x33*y13/72.0+x23*y11/36.0-x23*y31/36.0+x23*
y13/36.0-x23*y33/36.0-x13*y33/72.0+x13*y11/72.0+x13*y21/36.0-x13*y23/36.0-x32*
y11/36.0-x32*y21/9.0-x32*y31/36.0+x32*y13/36.0+x32*y23/9.0+x32*y33/36.0+x12*y11
/36.0+x12*y31/36.0-x12*y13/36.0-x12*y23/9.0-x12*y33/36.0+x31*y23/36.0+x21*y33/
36.0-x31*y11/72.0-x31*y21/36.0+x31*y33/72.0-x11*y12/36.0+x11*y32/36.0+x21*y32/
9.0-x31*y12/36.0+x31*y32/36.0+x13*y12/36.0-x13*y32/36.0+x23*y12/9.0-x23*y32/9.0
);
}

/* z05 */
static CagdRType SolFunc7(void)
{
    return(x01*y11/36.0+x21*y22/36.0-x01*y02/36.0+x01*y22/36.0-x21*y02/36.0-x11
*y03/36.0+x11*y23/36.0-x21*y01/72.0-x21*y11/36.0+x21*y13/36.0+x21*y23/72.0-x11*
y01/36.0+x01*y21/72.0-x01*y03/72.0-x01*y13/36.0+x11*y21/36.0-x11*y02/9.0-x23*
y11/36.0-x23*y21/72.0+x23*y03/72.0+x23*y13/36.0+x02*y21/36.0+x13*y01/36.0-x13*
y21/36.0+x13*y03/36.0-x13*y23/36.0+x03*y01/72.0-x22*y11/9.0+x22*y03/36.0+x22*
y13/9.0+x22*y23/36.0+x02*y11/9.0-x02*y03/36.0-x02*y13/9.0-x02*y23/36.0+x11*y22/
9.0+x03*y02/36.0-x03*y22/36.0-x22*y01/36.0-x22*y21/36.0+x13*y02/9.0-x13*y22/9.0
+x23*y02/36.0-x23*y22/36.0+x03*y11/36.0-x03*y13/36.0-x03*y23/72.0+x02*y01/36.0
);
}

/* z50 */
static CagdRType SolFunc8(void)
{
    return(-x20*y10/36.0+x10*y20/36.0+x22*y12/36.0+x22*y10/36.0-x20*y12/36.0-
x10*y22/36.0+x12*y20/36.0+x32*y11/36.0-x32*y31/36.0+x22*y11/9.0-x22*y31/9.0+x12
*y11/36.0-x12*y31/36.0-x11*y12/36.0-x11*y22/9.0-x11*y32/36.0+x10*y30/72.0-x10*
y12/72.0-x30*y10/72.0-x30*y20/36.0+x30*y22/36.0+x30*y32/72.0+x11*y10/36.0+x11*
y20/9.0+x11*y30/36.0-x31*y10/36.0-x31*y20/9.0-x31*y30/36.0+x12*y10/72.0-x12*y32
/72.0-x32*y20/36.0-x32*y30/72.0+x32*y12/72.0+x32*y22/36.0-x10*y11/36.0+x10*y31/
36.0+x20*y30/36.0-x20*y11/9.0+x20*y31/9.0+x20*y32/36.0-x30*y11/36.0+x30*y31/
36.0-x22*y30/36.0-x22*y32/36.0+x31*y12/36.0+x31*y22/9.0+x31*y32/36.0-x12*y22/
36.0);
}

/* z30 */
static CagdRType SolFunc9(void)
{
    return(-79.0/1440.0*x20*y10-x20*y00/360.0-x00*y22/360.0+79.0/1440.0*x10*y20
-x10*y00/1440.0+79.0/1440.0*x22*y12+x22*y02/360.0-13.0/180.0*x22*y20+29.0/
1440.0*x22*y10+x22*y00/360.0-x02*y22/360.0+x02*y10/1440.0+13.0/90.0*x21*y22+5.0
/72.0*x21*y12-13.0/90.0*x21*y20-5.0/72.0*x21*y10-x01*y12/360.0-x00*y12/1440.0+
x00*y20/360.0+x00*y10/1440.0-x10*y01/360.0+5.0/72.0*x10*y21+13.0/180.0*x20*y22
-29.0/1440.0*x20*y12-x20*y02/360.0+x01*y20/90.0-29.0/1440.0*x10*y22+x01*y10/
360.0-x01*y22/90.0-x02*y12/1440.0-x01*y32/360.0+29.0/1440.0*x12*y20+x12*y01/
360.0-5.0/72.0*x12*y21+x12*y02/1440.0+x02*y20/360.0+x12*y00/1440.0-x32*y21/
360.0+3.0/20.0*x22*y11-x22*y31/60.0+x32*y01/360.0+x12*y11/10.0-x12*y31/30.0+
13.0/90.0*x20*y21-x10*y02/1440.0+x01*y30/360.0-x21*y30/360.0+x02*y30/1440.0-x02
*y32/1440.0+x32*y00/1440.0+x32*y02/1440.0-x30*y01/360.0+x30*y21/360.0-x11*y12/
10.0-3.0/20.0*x11*y22+x10*y30/120.0-x10*y12/20.0+x10*y32/120.0-x30*y10/120.0-
x30*y20/288.0+x30*y12/120.0+7.0/1440.0*x30*y22+x11*y10/10.0+3.0/20.0*x11*y20-
x31*y10/30.0-x31*y20/60.0+x12*y10/20.0-x12*y30/120.0-x12*y32/120.0-x32*y10/
120.0-7.0/1440.0*x32*y20+x32*y12/120.0+x32*y22/288.0-x10*y11/10.0+x10*y31/30.0+
x20*y30/288.0-3.0/20.0*x20*y11+x20*y31/60.0+7.0/1440.0*x20*y32-7.0/1440.0*x22*
y30-x22*y32/288.0+x21*y32/360.0+x00*y30/1440.0-x00*y32/1440.0-x30*y00/1440.0-
x30*y02/1440.0+x31*y12/30.0+x31*y22/60.0-x20*y01/90.0-79.0/1440.0*x12*y22+x22*
y01/90.0-13.0/90.0*x22*y21);
}

/* z03 */
static CagdRType SolFunc10(void)
{
    return(x00*y22/360.0-x01*y23/120.0+x01*y11/10.0+x00*y21/1440.0-x00*y01/
1440.0+13.0/90.0*x22*y12+13.0/180.0*x22*y02-x22*y20/360.0-x22*y10/90.0-x22*y00/
360.0-13.0/180.0*x02*y22+x02*y10/90.0+x02*y00/360.0+79.0/1440.0*x21*y22+5.0/
72.0*x21*y12-x21*y20/1440.0-x21*y10/360.0-5.0/72.0*x01*y12-x00*y02/360.0-x10*
y01/360.0+x10*y21/360.0+x01*y00/1440.0+x20*y22/360.0-x20*y02/360.0-79.0/1440.0*
x01*y02+x01*y20/1440.0+x10*y22/90.0+x01*y10/360.0+29.0/1440.0*x01*y22-x21*y00/
1440.0-29.0/1440.0*x21*y02-x21*y01/20.0-x21*y11/10.0+x21*y03/120.0+x21*y13/30.0
+x21*y23/120.0-x11*y01/10.0+x01*y21/20.0-x01*y03/120.0-x01*y13/30.0+x11*y21/
10.0-3.0/20.0*x11*y02-13.0/90.0*x02*y12+5.0/72.0*x12*y01-5.0/72.0*x12*y21+13.0/
90.0*x12*y02+x02*y20/360.0+x23*y01/120.0-x23*y21/120.0+29.0/1440.0*x02*y21+x13*
y01/30.0-x13*y21/30.0+x03*y01/120.0-3.0/20.0*x22*y11+7.0/1440.0*x22*y03+x22*y13
/60.0+x22*y23/288.0+x12*y03/360.0-x12*y23/360.0+x20*y21/1440.0+3.0/20.0*x02*y11
-x02*y03/288.0-x02*y13/60.0-7.0/1440.0*x02*y23-x10*y02/90.0-x00*y03/1440.0+x00*
y23/1440.0-x10*y03/360.0+x10*y23/360.0-x20*y03/1440.0+x20*y23/1440.0-x23*y00/
1440.0-x23*y10/360.0-x23*y20/1440.0+3.0/20.0*x11*y22+x03*y00/1440.0+x03*y10/
360.0+x03*y20/1440.0-x20*y01/1440.0+x03*y02/288.0-x03*y12/360.0-7.0/1440.0*x03*
y22-13.0/90.0*x12*y22-29.0/1440.0*x22*y01-79.0/1440.0*x22*y21+x13*y02/60.0-x13*
y22/60.0+7.0/1440.0*x23*y02+x23*y12/360.0-x23*y22/288.0-x03*y21/120.0+79.0/
1440.0*x02*y01);
}

/* z54 */
static CagdRType SolFunc11(void)
{
    return(4.0/45.0*x22*y12-7.0/45.0*x21*y12+x11*y31/36.0-x11*y13/72.0-x11*y23/
30.0-x11*y33/360.0-x21*y11/18.0+x21*y31/18.0-x21*y13/45.0+x33*y12/45.0+x33*y22/
45.0-x33*y32/90.0+x11*y21/18.0+7.0/45.0*x12*y21+x33*y11/360.0-x33*y21/45.0-x33*
y31/72.0+x23*y11/30.0-x23*y31/30.0+x13*y11/72.0+x13*y21/45.0-x13*y31/360.0-x32*
y11/30.0-7.0/45.0*x32*y21-2.0/45.0*x32*y31+x32*y13/45.0+x32*y23/15.0+x32*y33/
90.0+x22*y11/45.0-x22*y31/45.0+x22*y13/45.0-x22*y33/45.0+2.0/45.0*x12*y11+x12*
y31/30.0-x12*y13/90.0-x12*y23/15.0-x12*y33/45.0+x31*y23/30.0+x21*y33/45.0-x31*
y11/36.0-x31*y21/18.0+x31*y13/360.0+x31*y33/72.0-2.0/45.0*x11*y12-x11*y22/45.0+
x11*y32/30.0-2.0/45.0*x12*y32+2.0/45.0*x32*y12+4.0/45.0*x32*y22-4.0/45.0*x22*
y32+7.0/45.0*x21*y32-x31*y12/30.0+x31*y22/45.0+2.0/45.0*x31*y32-4.0/45.0*x12*
y22+x13*y12/90.0-x13*y22/45.0-x13*y32/45.0+x23*y12/15.0-x23*y32/15.0);
}

/* z51 */
static CagdRType SolFunc12(void)
{
    return(x22*y12/18.0+x22*y10/45.0-x21*y12/45.0-x21*y10/45.0+x10*y21/45.0-x20
*y12/30.0-x10*y22/45.0+2.0/45.0*x11*y31-4.0/45.0*x21*y11+4.0/45.0*x21*y31+4.0/
45.0*x11*y21+x12*y20/30.0+x12*y21/45.0+x32*y11/30.0-x32*y21/45.0-2.0/45.0*x32*
y31+7.0/45.0*x22*y11-7.0/45.0*x22*y31+2.0/45.0*x12*y11-x12*y31/30.0-2.0/45.0*
x31*y11-4.0/45.0*x31*y21+x21*y30/45.0-x30*y21/45.0-2.0/45.0*x11*y12-7.0/45.0*
x11*y22-x11*y32/30.0-x10*y12/72.0+x10*y32/360.0-x30*y12/360.0+x30*y22/45.0+x30*
y32/72.0+x11*y10/90.0+x11*y20/15.0+x11*y30/45.0-x31*y10/45.0-x31*y20/15.0-x31*
y30/90.0+x12*y10/72.0+x12*y30/360.0-x12*y32/36.0-x32*y10/360.0-x32*y20/30.0-x32
*y30/72.0+x32*y12/36.0+x32*y22/18.0-x10*y11/90.0+x10*y31/45.0-x20*y11/15.0+x20*
y31/15.0+x20*y32/30.0-x30*y11/45.0+x30*y31/90.0-x22*y30/45.0-x22*y32/18.0+x21*
y32/45.0+x31*y12/30.0+7.0/45.0*x31*y22+2.0/45.0*x31*y32-x12*y22/18.0);
}

/* z00 */
static CagdRType SolFunc13(void)
{
    return(-x20*y10/36.0-x20*y00/72.0+x10*y20/36.0-x10*y00/36.0+x00*y21/36.0-
x00*y01/36.0+x22*y12/36.0+x22*y02/72.0-x22*y20/72.0-x22*y10/36.0-x02*y22/72.0+
x02*y10/36.0+x02*y00/72.0+x21*y22/36.0+x21*y12/9.0-x21*y20/36.0-x21*y10/9.0-x01
*y12/9.0-x00*y12/36.0-x00*y02/72.0+x00*y20/72.0+x00*y10/36.0-x10*y01/9.0+x10*
y21/9.0+x01*y00/36.0+x20*y22/72.0+x20*y12/36.0-x01*y02/36.0+x01*y20/36.0+x10*
y22/36.0+x01*y10/9.0-x01*y22/36.0-x21*y00/36.0+x21*y02/36.0-x02*y12/36.0-x12*
y20/36.0+x12*y01/9.0-x12*y21/9.0+x12*y02/36.0-x02*y21/36.0+x12*y00/36.0+x20*y21
/36.0-x10*y02/36.0-x20*y01/36.0-x12*y22/36.0+x22*y01/36.0-x22*y21/36.0+x02*y01/
36.0);
}

/* z04 */
static CagdRType SolFunc14(void)
{
    return(-x01*y23/360.0+x01*y11/18.0+4.0/45.0*x22*y12+2.0/45.0*x22*y02-2.0/
45.0*x02*y22+2.0/45.0*x21*y22+x21*y12/45.0-x01*y12/45.0-2.0/45.0*x01*y02+x01*
y22/30.0-x21*y02/30.0-x11*y03/45.0+x11*y23/45.0-x21*y01/36.0-x21*y11/18.0+x21*
y03/360.0+x21*y13/30.0+x21*y23/72.0-x11*y01/18.0+x01*y21/36.0-x01*y03/72.0-x01*
y13/30.0+x11*y21/18.0-7.0/45.0*x11*y02-4.0/45.0*x02*y12+x12*y01/45.0-x12*y21/
45.0+4.0/45.0*x12*y02+x23*y01/360.0-x23*y11/45.0-x23*y21/72.0+x02*y21/30.0+x13*
y01/30.0-x13*y21/30.0+x03*y01/72.0-7.0/45.0*x22*y11+x22*y03/45.0+x22*y13/15.0+
x22*y23/90.0+x12*y03/45.0-x12*y23/45.0+7.0/45.0*x02*y11-x02*y03/90.0-x02*y13/
15.0-x02*y23/45.0+7.0/45.0*x11*y22+x03*y02/90.0-x03*y12/45.0-x03*y22/45.0-4.0/
45.0*x12*y22-x22*y01/30.0-2.0/45.0*x22*y21+x13*y02/15.0-x13*y22/15.0+x23*y02/
45.0+x23*y12/45.0-x23*y22/90.0+x03*y11/45.0-x03*y21/360.0+2.0/45.0*x02*y01);
}

/* z35 */
static CagdRType SolFunc15(void)
{
    return(-x01*y23/360.0+x01*y11/1440.0+13.0/90.0*x21*y22-3.0/20.0*x21*y12-x21
*y02/90.0+x11*y31/120.0-x11*y03/1440.0-x11*y13/20.0-29.0/1440.0*x11*y23+x11*y33
/120.0-x21*y01/360.0-79.0/1440.0*x21*y11+x21*y31/288.0-x21*y03/360.0-29.0/
1440.0*x21*y13+13.0/180.0*x21*y23-x11*y01/1440.0+x33*y02/360.0-x33*y22/360.0+
x01*y21/360.0+x01*y31/1440.0-x01*y13/1440.0-x01*y33/1440.0+79.0/1440.0*x11*y21-
x11*y02/360.0+3.0/20.0*x12*y21+x33*y23/288.0+x33*y01/1440.0-x33*y11/120.0-7.0/
1440.0*x33*y21+x33*y03/1440.0+x33*y13/120.0+x23*y01/360.0+29.0/1440.0*x23*y11
-13.0/180.0*x23*y21-7.0/1440.0*x23*y31+x23*y03/360.0+79.0/1440.0*x23*y13-x23*
y33/288.0-x13*y33/120.0+x02*y21/90.0-x03*y33/1440.0+x13*y01/1440.0+x13*y11/20.0
+29.0/1440.0*x13*y21-x13*y31/120.0+x13*y03/1440.0-79.0/1440.0*x13*y23-x32*y11/
30.0-x32*y21/60.0+x32*y13/30.0+x32*y23/60.0-5.0/72.0*x22*y11-x22*y31/360.0+5.0/
72.0*x22*y13+13.0/90.0*x22*y23+x22*y33/360.0+x12*y11/10.0-x12*y13/10.0-3.0/20.0
*x12*y23+x02*y11/360.0+x02*y31/360.0-x02*y13/360.0-x02*y23/90.0-x02*y33/360.0+
7.0/1440.0*x31*y23+7.0/1440.0*x21*y33-x31*y01/1440.0-x31*y11/120.0-x31*y21/
288.0-x31*y03/1440.0+x31*y13/120.0-x11*y12/10.0+5.0/72.0*x11*y22+x11*y32/30.0+
x21*y32/60.0-x31*y02/360.0+x31*y22/360.0-13.0/90.0*x22*y21+x13*y02/360.0+x13*
y12/10.0-5.0/72.0*x13*y22-x13*y32/30.0+x23*y02/90.0+3.0/20.0*x23*y12-13.0/90.0*
x23*y22-x23*y32/60.0+x03*y11/1440.0+x03*y21/360.0+x03*y31/1440.0-x03*y13/1440.0
-x03*y23/360.0);
}

/* z45 */
static CagdRType SolFunc16(void)
{
    return(4.0/45.0*x21*y22-7.0/45.0*x21*y12+x11*y31/72.0-x11*y13/36.0-x11*y23/
30.0+x11*y33/360.0-2.0/45.0*x21*y11+x21*y31/90.0-x21*y13/30.0+2.0/45.0*x21*y23+
x33*y12/45.0-x33*y22/45.0+2.0/45.0*x11*y21+7.0/45.0*x12*y21+x33*y23/90.0-x33*
y11/360.0-x33*y21/45.0+x33*y13/72.0+x23*y11/30.0-2.0/45.0*x23*y21-x23*y31/45.0+
2.0/45.0*x23*y13-x23*y33/90.0-x13*y33/72.0+x13*y11/36.0+x13*y21/30.0-x13*y31/
360.0-2.0/45.0*x13*y23-x32*y11/30.0-x32*y21/15.0+x32*y13/30.0+x32*y23/15.0-x22*
y11/45.0-x22*y31/45.0+x22*y13/45.0+4.0/45.0*x22*y23+x22*y33/45.0+x12*y11/18.0+
x12*y31/45.0-x12*y13/18.0-7.0/45.0*x12*y23-x12*y33/45.0+x31*y23/45.0+x21*y33/
45.0-x31*y11/72.0-x31*y21/90.0+x31*y13/360.0-x11*y12/18.0+x11*y22/45.0+x11*y32/
30.0+x21*y32/15.0-x31*y12/45.0+x31*y22/45.0-4.0/45.0*x22*y21+x13*y12/18.0-x13*
y22/45.0-x13*y32/30.0+7.0/45.0*x23*y12-4.0/45.0*x23*y22-x23*y32/15.0);
}

/* z20 */
static CagdRType SolFunc17(void)
{
    return(-79.0/1440.0*x20*y10-x20*y00/120.0-x00*y22/120.0+79.0/1440.0*x10*y20
-x10*y00/288.0+79.0/1440.0*x22*y12+x22*y02/120.0-x22*y20/20.0-29.0/1440.0*x22*
y10+x22*y00/120.0-x02*y22/120.0+7.0/1440.0*x02*y10+x21*y22/10.0+3.0/20.0*x21*
y12-x21*y20/10.0-3.0/20.0*x21*y10-x01*y12/60.0-7.0/1440.0*x00*y12+x00*y20/120.0
+x00*y10/288.0-x10*y01/60.0+3.0/20.0*x10*y21+x20*y22/20.0+29.0/1440.0*x20*y12-
x20*y02/120.0+x01*y20/30.0+29.0/1440.0*x10*y22+x01*y10/60.0-x01*y22/30.0-x11*
y02/360.0-x02*y12/288.0-29.0/1440.0*x12*y20+x12*y01/60.0-3.0/20.0*x12*y21+x12*
y02/288.0+x02*y20/120.0+7.0/1440.0*x12*y00+5.0/72.0*x22*y11-x22*y31/360.0+13.0/
90.0*x12*y11-x12*y31/90.0+x20*y21/10.0+x02*y11/360.0-x02*y31/360.0-7.0/1440.0*
x10*y02+x11*y00/360.0-x31*y00/360.0-x02*y30/1440.0-x02*y32/1440.0-x32*y00/
1440.0+x32*y02/1440.0-x00*y11/360.0+x00*y31/360.0-13.0/90.0*x11*y12-5.0/72.0*
x11*y22+x10*y30/360.0-13.0/180.0*x10*y12+x10*y32/360.0-x30*y10/360.0-x30*y20/
1440.0+x30*y12/360.0+x30*y22/1440.0+13.0/90.0*x11*y10+5.0/72.0*x11*y20-x31*y10/
90.0-x31*y20/360.0+13.0/180.0*x12*y10-x12*y30/360.0-x12*y32/360.0-x32*y10/360.0
-x32*y20/1440.0+x32*y12/360.0+x32*y22/1440.0-13.0/90.0*x10*y11+x10*y31/90.0+x20
*y30/1440.0-5.0/72.0*x20*y11+x20*y31/360.0+x20*y32/1440.0-x22*y30/1440.0-x22*
y32/1440.0+x00*y30/1440.0+x00*y32/1440.0-x30*y00/1440.0+x30*y02/1440.0+x31*y02/
360.0+x31*y12/90.0+x31*y22/360.0-x20*y01/30.0-79.0/1440.0*x12*y22+x22*y01/30.0-
x22*y21/10.0);
}

/* z32 */
static CagdRType SolFunc18(void)
{
    return(-x01*y23/900.0+13.0/3600.0*x01*y11+x00*y21/3600.0+79.0/400.0*x22*y12
+x22*y02/100.0-13.0/300.0*x22*y20-x22*y10/48.0-x02*y22/100.0+x02*y10/1200.0+
1027.0/3600.0*x21*y22-13.0/720.0*x21*y20-17.0/1200.0*x21*y10-3.0/800.0*x01*y12-
x10*y01/2400.0+17.0/1200.0*x10*y21+13.0/300.0*x20*y22-9.0/200.0*x20*y12-x20*y02
/300.0+x01*y20/600.0+x10*y22/48.0+x01*y10/2400.0-3.0/200.0*x01*y22-x21*y00/
3600.0-x21*y02/144.0+13.0/300.0*x11*y31-x11*y13/100.0-3.0/200.0*x11*y23-13.0/
900.0*x21*y01-1027.0/3600.0*x21*y11+13.0/720.0*x21*y31+x21*y13/144.0+13.0/900.0
*x21*y23-13.0/3600.0*x11*y01+x33*y02/14400.0-x33*y22/14400.0+13.0/900.0*x01*y21
+13.0/3600.0*x01*y31-x01*y13/3600.0-x01*y33/3600.0+1027.0/3600.0*x11*y21-x11*
y02/576.0-x02*y12/400.0-3.0/800.0*x01*y32+9.0/200.0*x12*y20+3.0/800.0*x12*y01+
x12*y02/400.0+x33*y01/3600.0-x33*y21/3600.0+x02*y20/300.0+x23*y01/900.0+3.0/
200.0*x23*y11-13.0/900.0*x23*y21-x23*y31/600.0+x02*y21/144.0+x13*y01/3600.0+x13
*y11/100.0-x13*y21/144.0-x13*y31/300.0-x32*y11/48.0-17.0/1200.0*x32*y21+x32*y13
/1200.0+x32*y23/2400.0+2291.0/14400.0*x22*y11-349.0/14400.0*x22*y31+x22*y13/
576.0+13.0/3600.0*x22*y23+x22*y33/14400.0+3.0/800.0*x32*y01+79.0/400.0*x12*y11
-9.0/200.0*x12*y31-x12*y13/400.0-3.0/800.0*x12*y23+13.0/720.0*x20*y21+x02*y11/
576.0+x02*y31/576.0-x02*y13/14400.0-x02*y23/3600.0-x02*y33/14400.0+x31*y23/
600.0-x10*y02/1200.0+x21*y33/3600.0-13.0/3600.0*x31*y01-13.0/300.0*x31*y11-13.0
/720.0*x31*y21+x31*y13/300.0+x01*y30/2400.0-x11*y00/14400.0-x31*y00/14400.0+x02
*y30/1200.0-x02*y32/400.0+x32*y02/400.0+x00*y11/14400.0+x00*y31/14400.0-x30*y01
/2400.0-x00*y13/14400.0-x00*y23/3600.0-x00*y33/14400.0-x10*y13/400.0-3.0/800.0*
x10*y23+x20*y13/576.0+13.0/3600.0*x20*y23+x20*y33/14400.0+x30*y13/1200.0+x30*
y23/2400.0+x13*y00/14400.0+x13*y10/400.0-x13*y20/576.0-x13*y30/1200.0+x23*y00/
3600.0+3.0/800.0*x23*y10-13.0/3600.0*x23*y20-x23*y30/2400.0+x33*y00/14400.0-x33
*y20/14400.0-79.0/400.0*x11*y12-2291.0/14400.0*x11*y22+x11*y32/48.0-3.0/100.0*
x10*y12+x10*y32/100.0+x30*y22/1200.0+x11*y10/80.0+349.0/14400.0*x11*y20+x11*y30
/1200.0-x31*y10/200.0-7.0/2880.0*x31*y20+3.0/100.0*x12*y10-3.0/100.0*x12*y32-
x32*y10/100.0-x32*y20/200.0+3.0/100.0*x32*y12+x32*y22/80.0-x10*y11/80.0+x10*y31
/200.0-349.0/14400.0*x20*y11+7.0/2880.0*x20*y31+x20*y32/200.0-x30*y11/1200.0-
x22*y30/1200.0-x22*y32/80.0+17.0/1200.0*x21*y32-x30*y02/1200.0-x31*y02/576.0+
9.0/200.0*x31*y12+349.0/14400.0*x31*y22-x20*y01/600.0-79.0/400.0*x12*y22+3.0/
200.0*x22*y01-1027.0/3600.0*x22*y21+x13*y02/14400.0+x13*y12/400.0-x13*y22/576.0
-x13*y32/1200.0+x23*y02/3600.0+3.0/800.0*x23*y12-13.0/3600.0*x23*y22-x23*y32/
2400.0);
}

/* z31 */
static CagdRType SolFunc19(void)
{
    return(-x00*y22/450.0+x01*y11/450.0+x00*y21/450.0+79.0/720.0*x22*y12+x22*
y02/180.0-13.0/180.0*x22*y20+11.0/1200.0*x22*y10+x22*y00/450.0-x02*y22/180.0+
x02*y10/1200.0+52.0/225.0*x21*y22+121.0/1800.0*x21*y12-13.0/225.0*x21*y20-43.0/
600.0*x21*y10-7.0/1800.0*x01*y12-x00*y12/1800.0-x10*y01/600.0+43.0/600.0*x10*
y21+13.0/180.0*x20*y22-7.0/225.0*x20*y12-x20*y02/300.0+x01*y20/150.0-11.0/
1200.0*x10*y22+x01*y10/600.0-7.0/450.0*x01*y22-x21*y00/450.0-x21*y02/450.0+2.0/
75.0*x11*y31-2.0/225.0*x21*y01-79.0/450.0*x21*y11+x21*y31/90.0-x11*y01/450.0+
2.0/225.0*x01*y21+x01*y31/450.0+79.0/450.0*x11*y21-x11*y02/1800.0-x02*y12/720.0
-7.0/1800.0*x01*y32+7.0/225.0*x12*y20+7.0/1800.0*x12*y01-121.0/1800.0*x12*y21+
x12*y02/720.0+x02*y20/300.0+x02*y21/450.0+x12*y00/1800.0-x32*y11/150.0-13.0/
1800.0*x32*y21+353.0/1800.0*x22*y11-43.0/1800.0*x22*y31+7.0/1800.0*x32*y01+4.0/
25.0*x12*y11-7.0/150.0*x12*y31+13.0/225.0*x20*y21+x02*y11/1800.0+x02*y31/1800.0
-x10*y02/1200.0-x31*y01/450.0-2.0/75.0*x31*y11-x31*y21/90.0+x01*y30/600.0-x11*
y00/1800.0+x21*y30/600.0-x31*y00/1800.0+x02*y30/1200.0-x02*y32/720.0+x32*y00/
1800.0+x32*y02/720.0+x00*y11/1800.0+x00*y31/1800.0-x30*y01/600.0-x30*y21/600.0
-4.0/25.0*x11*y12-353.0/1800.0*x11*y22+x11*y32/150.0-x10*y12/20.0+x10*y32/100.0
+x30*y12/150.0+x30*y22/240.0+x11*y10/25.0+187.0/1800.0*x11*y20+x11*y30/150.0-
x31*y10/50.0-17.0/1800.0*x31*y20+x12*y10/20.0-x12*y30/150.0-x12*y32/60.0-x32*
y10/100.0-x32*y20/180.0+x32*y12/60.0+x32*y22/144.0-x10*y11/25.0+x10*y31/50.0
-187.0/1800.0*x20*y11+17.0/1800.0*x20*y31+x20*y32/180.0-x30*y11/150.0-x22*y30/
240.0-x22*y32/144.0+13.0/1800.0*x21*y32-x00*y32/1800.0-x30*y02/1200.0-x31*y02/
1800.0+7.0/150.0*x31*y12+43.0/1800.0*x31*y22-x20*y01/150.0-79.0/720.0*x12*y22+
7.0/450.0*x22*y01-52.0/225.0*x22*y21);
}

/* z10 */
static CagdRType SolFunc20(void)
{
    return(-2.0/45.0*x20*y10-x20*y00/72.0-x00*y22/360.0+2.0/45.0*x10*y20-x10*
y00/90.0+x00*y21/45.0+2.0/45.0*x22*y12+x22*y02/72.0-x22*y20/36.0-x22*y10/30.0+
x22*y00/360.0-x02*y22/72.0+x02*y10/45.0+x21*y22/18.0+7.0/45.0*x21*y12-x21*y20/
18.0-7.0/45.0*x21*y10-x01*y12/15.0-x00*y12/45.0+x00*y20/72.0+x00*y10/90.0-x10*
y01/15.0+7.0/45.0*x10*y21+x20*y22/36.0+x20*y12/30.0-x20*y02/360.0+x01*y20/30.0+
x10*y22/30.0+x01*y10/15.0-x01*y22/30.0-x21*y00/45.0+x21*y02/45.0-x11*y02/45.0-
x02*y12/90.0-x12*y20/30.0+x12*y01/15.0-7.0/45.0*x12*y21+x12*y02/90.0+x02*y20/
360.0-x02*y21/45.0+x12*y00/45.0+x22*y11/45.0+4.0/45.0*x12*y11+x20*y21/18.0+x02*
y11/45.0-x10*y02/45.0+x11*y00/45.0-x00*y11/45.0-4.0/45.0*x11*y12-x11*y22/45.0
-2.0/45.0*x10*y12+4.0/45.0*x11*y10+x11*y20/45.0+2.0/45.0*x12*y10-4.0/45.0*x10*
y11-x20*y11/45.0-x20*y01/30.0-2.0/45.0*x12*y22+x22*y01/30.0-x22*y21/18.0);
}

/* z41 */
static CagdRType SolFunc21(void)
{
    return(4.0/45.0*x22*y12-2.0/45.0*x22*y20+11.0/450.0*x22*y10+32.0/225.0*x21*
y22-8.0/225.0*x21*y20-2.0/45.0*x21*y10+2.0/45.0*x10*y21+2.0/45.0*x20*y22-19.0/
450.0*x20*y12-11.0/450.0*x10*y22+2.0/45.0*x11*y31-32.0/225.0*x21*y11+8.0/225.0*
x21*y31+32.0/225.0*x11*y21+19.0/450.0*x12*y20+11.0/450.0*x32*y11-2.0/45.0*x32*
y21+16.0/75.0*x22*y11-22.0/225.0*x22*y31+4.0/45.0*x12*y11-19.0/450.0*x12*y31+
8.0/225.0*x20*y21-2.0/45.0*x31*y11-8.0/225.0*x31*y21-4.0/45.0*x11*y12-16.0/75.0
*x11*y22-11.0/450.0*x11*y32-x10*y12/36.0+x10*y32/180.0+x30*y22/50.0+x11*y10/
45.0+22.0/225.0*x11*y20+x11*y30/50.0-11.0/450.0*x31*y10-8.0/225.0*x31*y20+x12*
y10/36.0-x12*y32/36.0-x32*y10/180.0-11.0/450.0*x32*y20+x32*y12/36.0+x32*y22/
45.0-x10*y11/45.0+11.0/450.0*x10*y31-22.0/225.0*x20*y11+8.0/225.0*x20*y31+11.0/
450.0*x20*y32-x30*y11/50.0-x22*y30/50.0-x22*y32/45.0+2.0/45.0*x21*y32+19.0/
450.0*x31*y12+22.0/225.0*x31*y22-4.0/45.0*x12*y22-32.0/225.0*x22*y21);
}

/* z43 */
static CagdRType SolFunc22(void)
{
    return(52.0/225.0*x22*y12-2.0/225.0*x22*y20-x22*y10/450.0+79.0/450.0*x21*
y22-353.0/1800.0*x21*y12-x21*y20/450.0-x21*y10/1800.0+x10*y21/1800.0+2.0/225.0*
x20*y22-7.0/450.0*x20*y12+x10*y22/450.0+x11*y31/20.0-x11*y13/60.0-7.0/150.0*x11
*y23-x11*y33/150.0-4.0/25.0*x21*y11+x21*y31/25.0+x21*y13/150.0+2.0/75.0*x21*y23
+x33*y12/240.0-x33*y22/600.0+4.0/25.0*x11*y21+7.0/450.0*x12*y20+353.0/1800.0*
x12*y21+x33*y11/150.0-x33*y21/150.0+7.0/150.0*x23*y11-2.0/75.0*x23*y21-x23*y31/
50.0+x13*y11/60.0-x13*y21/150.0-x13*y31/100.0-7.0/225.0*x32*y11-187.0/1800.0*
x32*y21+x32*y13/180.0+17.0/1800.0*x32*y23+121.0/1800.0*x22*y11-43.0/600.0*x22*
y31+13.0/1800.0*x22*y13+x22*y23/90.0+x22*y33/600.0+79.0/720.0*x12*y11+11.0/
1200.0*x12*y31-x12*y13/144.0-43.0/1800.0*x12*y23-x12*y33/240.0+x20*y21/450.0+
x31*y23/50.0+x21*y33/150.0-x31*y11/20.0-x31*y21/25.0+x31*y13/100.0-x21*y30/
1800.0+x30*y21/1800.0-x10*y13/720.0+x10*y23/1800.0+x10*y33/1200.0-7.0/1800.0*
x20*y13+x20*y23/450.0+x20*y33/600.0-x30*y13/1800.0+x30*y23/1800.0+x13*y10/720.0
+7.0/1800.0*x13*y20+x13*y30/1800.0-x23*y10/1800.0-x23*y20/450.0-x23*y30/1800.0-
x33*y10/1200.0-x33*y20/600.0-79.0/720.0*x11*y12-121.0/1800.0*x11*y22+7.0/225.0*
x11*y32-x10*y12/180.0+x10*y32/300.0-x30*y12/450.0+x30*y22/450.0+x11*y10/720.0+
7.0/1800.0*x11*y20+x11*y30/1800.0-x31*y10/1200.0-x31*y20/600.0+x12*y10/180.0+
x12*y30/450.0-13.0/180.0*x12*y32-x32*y10/300.0-x32*y20/150.0+13.0/180.0*x32*y12
+13.0/225.0*x32*y22-x10*y11/720.0+x10*y31/1200.0-7.0/1800.0*x20*y11+x20*y31/
600.0+x20*y32/150.0-x30*y11/1800.0-x22*y30/450.0-13.0/225.0*x22*y32+187.0/
1800.0*x21*y32-11.0/1200.0*x31*y12+43.0/600.0*x31*y22-52.0/225.0*x12*y22-79.0/
450.0*x22*y21+x13*y12/144.0-13.0/1800.0*x13*y22-x13*y32/180.0+43.0/1800.0*x23*
y12-x23*y22/90.0-17.0/1800.0*x23*y32);
}

/* z53 */
static CagdRType SolFunc23(void)
{
    return(13.0/90.0*x22*y12-3.0/20.0*x21*y12-x20*y12/90.0+x11*y31/20.0-x11*y13
/120.0-x11*y23/30.0-x11*y33/120.0-x21*y11/10.0+x21*y31/10.0+7.0/1440.0*x33*y12+
x33*y22/360.0-x33*y32/288.0+x11*y21/10.0+x12*y20/90.0+3.0/20.0*x12*y21+x33*y11/
120.0-x33*y31/120.0+x23*y11/30.0-x23*y31/30.0+x13*y11/120.0-x13*y31/120.0-29.0/
1440.0*x32*y11-3.0/20.0*x32*y21-79.0/1440.0*x32*y31+7.0/1440.0*x32*y13+x32*y23/
60.0+x32*y33/288.0+5.0/72.0*x22*y11-5.0/72.0*x22*y31+x22*y13/360.0-x22*y33/
360.0+79.0/1440.0*x12*y11+29.0/1440.0*x12*y31-x12*y13/288.0-x12*y23/60.0-7.0/
1440.0*x12*y33+x31*y23/30.0-x31*y11/20.0-x31*y21/10.0+x31*y13/120.0+x31*y33/
120.0-x10*y13/1440.0+x10*y33/1440.0-x20*y13/360.0+x20*y33/360.0-x30*y13/1440.0+
x30*y33/1440.0+x13*y10/1440.0+x13*y20/360.0+x13*y30/1440.0-x33*y10/1440.0-x33*
y20/360.0-x33*y30/1440.0-79.0/1440.0*x11*y12-5.0/72.0*x11*y22+29.0/1440.0*x11*
y32-x10*y12/360.0+x10*y32/360.0-x30*y12/360.0+x30*y32/360.0+x11*y10/1440.0+x11*
y20/360.0+x11*y30/1440.0-x31*y10/1440.0-x31*y20/360.0-x31*y30/1440.0+x12*y10/
360.0+x12*y30/360.0-13.0/180.0*x12*y32-x32*y10/360.0-x32*y20/90.0-x32*y30/360.0
+13.0/180.0*x32*y12+13.0/90.0*x32*y22-x10*y11/1440.0+x10*y31/1440.0-x20*y11/
360.0+x20*y31/360.0+x20*y32/90.0-x30*y11/1440.0+x30*y31/1440.0-13.0/90.0*x22*
y32+3.0/20.0*x21*y32-29.0/1440.0*x31*y12+5.0/72.0*x31*y22+79.0/1440.0*x31*y32
-13.0/90.0*x12*y22+x13*y12/288.0-x13*y22/360.0-7.0/1440.0*x13*y32+x23*y12/60.0-
x23*y32/60.0);
}

/* z25 */
static CagdRType SolFunc24(void)
{
    return(-x01*y23/120.0+x01*y11/288.0+x21*y22/10.0-5.0/72.0*x21*y12-x01*y12/
360.0-x21*y02/30.0+x11*y31/360.0-7.0/1440.0*x11*y03-13.0/180.0*x11*y13+29.0/
1440.0*x11*y23+x11*y33/360.0-x21*y01/120.0-79.0/1440.0*x21*y11+x21*y31/1440.0-
x21*y03/120.0+29.0/1440.0*x21*y13+x21*y23/20.0-x11*y01/288.0+x01*y21/120.0+x01*
y31/1440.0-7.0/1440.0*x01*y13+x01*y33/1440.0+79.0/1440.0*x11*y21-x11*y02/60.0+
x01*y32/360.0+x12*y01/360.0+5.0/72.0*x12*y21+x33*y23/1440.0-x33*y01/1440.0-x33*
y11/360.0-x33*y21/1440.0+x33*y03/1440.0+x33*y13/360.0+x23*y01/120.0-29.0/1440.0
*x23*y11-x23*y21/20.0-x23*y31/1440.0+x23*y03/120.0+79.0/1440.0*x23*y13-x23*y33/
1440.0-x13*y33/360.0+x02*y21/30.0-x03*y33/1440.0+7.0/1440.0*x13*y01+13.0/180.0*
x13*y11-29.0/1440.0*x13*y21-x13*y31/360.0+x13*y03/288.0-79.0/1440.0*x13*y23-x32
*y11/90.0-x32*y21/360.0+x32*y03/360.0+x32*y13/90.0+x32*y23/360.0-3.0/20.0*x22*
y11+3.0/20.0*x22*y13+x22*y23/10.0-x32*y01/360.0+13.0/90.0*x12*y11-x12*y03/360.0
-13.0/90.0*x12*y13-5.0/72.0*x12*y23+x02*y11/60.0-x02*y13/60.0-x02*y23/30.0+x31*
y23/1440.0+x21*y33/1440.0-x31*y01/1440.0-x31*y11/360.0-x31*y21/1440.0+x31*y03/
1440.0+x31*y13/360.0-13.0/90.0*x11*y12+3.0/20.0*x11*y22+x11*y32/90.0+x21*y32/
360.0+x03*y12/360.0-x03*y32/360.0-x22*y21/10.0+x13*y02/60.0+13.0/90.0*x13*y12
-3.0/20.0*x13*y22-x13*y32/90.0+x23*y02/30.0+5.0/72.0*x23*y12-x23*y22/10.0-x23*
y32/360.0+7.0/1440.0*x03*y11+x03*y21/120.0-x03*y31/1440.0-x03*y13/288.0-x03*y23
/120.0);
}

/* z11 */
static CagdRType SolFunc25(void)
{
    return(8.0/225.0*x01*y11+x00*y21/50.0+4.0/45.0*x22*y12+x22*y02/36.0-x22*y20
/36.0-19.0/450.0*x22*y10-x02*y22/36.0+11.0/450.0*x02*y10+4.0/45.0*x21*y22+16.0/
75.0*x21*y12-x21*y20/45.0-22.0/225.0*x21*y10-22.0/225.0*x01*y12-x00*y12/50.0
-8.0/225.0*x10*y01+22.0/225.0*x10*y21+x20*y22/36.0+11.0/450.0*x20*y12-x20*y02/
180.0+11.0/450.0*x01*y20+19.0/450.0*x10*y22+8.0/225.0*x01*y10-19.0/450.0*x01*
y22-x21*y00/50.0+11.0/450.0*x21*y02-2.0/45.0*x21*y01-32.0/225.0*x21*y11-8.0/
225.0*x11*y01+2.0/45.0*x01*y21+32.0/225.0*x11*y21-2.0/45.0*x11*y02-x02*y12/45.0
-11.0/450.0*x12*y20+22.0/225.0*x12*y01-16.0/75.0*x12*y21+x12*y02/45.0+x02*y20/
180.0-11.0/450.0*x02*y21+x12*y00/50.0+32.0/225.0*x12*y11+x20*y21/45.0+2.0/45.0*
x02*y11-11.0/450.0*x10*y02-32.0/225.0*x11*y12-2.0/45.0*x10*y12+8.0/225.0*x11*
y10+2.0/45.0*x11*y20+2.0/45.0*x12*y10-8.0/225.0*x10*y11-2.0/45.0*x20*y11-11.0/
450.0*x20*y01-4.0/45.0*x12*y22+19.0/450.0*x22*y01-4.0/45.0*x22*y21);
}

/* z21 */
static CagdRType SolFunc26(void)
{
    return(-x00*y22/150.0+x01*y11/90.0+x00*y21/150.0+79.0/720.0*x22*y12+x22*y02
/60.0-x22*y20/20.0-7.0/225.0*x22*y10+x22*y00/150.0-x02*y22/60.0+x02*y10/180.0+
4.0/25.0*x21*y22+353.0/1800.0*x21*y12-x21*y20/25.0-187.0/1800.0*x21*y10-43.0/
1800.0*x01*y12-x00*y12/240.0-17.0/1800.0*x10*y01+187.0/1800.0*x10*y21+x20*y22/
20.0+11.0/1200.0*x20*y12-x20*y02/100.0+x01*y20/50.0+7.0/225.0*x10*y22+17.0/
1800.0*x01*y10-7.0/150.0*x01*y22-x21*y00/150.0-x21*y02/150.0+2.0/225.0*x11*y31
-2.0/75.0*x21*y01-79.0/450.0*x21*y11+x21*y31/450.0-x11*y01/90.0+2.0/75.0*x01*
y21+x01*y31/450.0+79.0/450.0*x11*y21-13.0/1800.0*x11*y02-x02*y12/144.0+x01*y32/
1800.0-11.0/1200.0*x12*y20+43.0/1800.0*x12*y01-353.0/1800.0*x12*y21+x12*y02/
144.0+x02*y20/100.0+x02*y21/150.0+x12*y00/240.0-x32*y11/450.0-x32*y21/1800.0+
121.0/1800.0*x22*y11-7.0/1800.0*x22*y31-x32*y01/1800.0+52.0/225.0*x12*y11-7.0/
450.0*x12*y31+x20*y21/25.0+13.0/1800.0*x02*y11-7.0/1800.0*x02*y31-x10*y02/180.0
-x31*y01/450.0-2.0/225.0*x31*y11-x31*y21/450.0+x01*y30/1800.0-x11*y00/600.0+x21
*y30/1800.0-x31*y00/600.0-x02*y30/1800.0-x02*y32/720.0-x32*y00/1200.0+x32*y02/
720.0+x00*y11/600.0+x00*y31/600.0-x30*y01/1800.0-x30*y21/1800.0-52.0/225.0*x11*
y12-121.0/1800.0*x11*y22+x11*y32/450.0-13.0/180.0*x10*y12+x10*y32/300.0+x30*y12
/450.0+x30*y22/1800.0+13.0/225.0*x11*y10+43.0/600.0*x11*y20+x11*y30/450.0-x31*
y10/150.0-x31*y20/600.0+13.0/180.0*x12*y10-x12*y30/450.0-x12*y32/180.0-x32*y10/
300.0-x32*y20/1200.0+x32*y12/180.0+x32*y22/720.0-13.0/225.0*x10*y11+x10*y31/
150.0-43.0/600.0*x20*y11+x20*y31/600.0+x20*y32/1200.0-x30*y11/450.0-x22*y30/
1800.0-x22*y32/720.0+x21*y32/1800.0+x00*y32/1200.0+x30*y02/1800.0+7.0/1800.0*
x31*y02+7.0/450.0*x31*y12+7.0/1800.0*x31*y22-x20*y01/50.0-79.0/720.0*x12*y22+
7.0/150.0*x22*y01-4.0/25.0*x22*y21);
}

/* z24 */
static CagdRType SolFunc27(void)
{
    return(-x01*y23/100.0+x01*y11/144.0+79.0/450.0*x22*y12+2.0/75.0*x22*y02-2.0
/75.0*x02*y22+4.0/25.0*x21*y22-121.0/1800.0*x21*y12-13.0/1800.0*x01*y12-x01*y22
/150.0-7.0/150.0*x21*y02+x11*y31/180.0-x11*y03/240.0-13.0/180.0*x11*y13+11.0/
1200.0*x11*y23+x11*y33/450.0-x21*y01/60.0-79.0/720.0*x21*y11+x21*y31/720.0-x21*
y03/150.0+7.0/225.0*x21*y13+x21*y23/20.0-x11*y01/144.0+x33*y02/1800.0+x33*y12/
450.0+x33*y22/1800.0+x01*y21/60.0+x01*y31/720.0-x01*y13/180.0+x01*y33/1800.0+
79.0/720.0*x11*y21-43.0/1800.0*x11*y02-x02*y12/90.0+7.0/1800.0*x01*y32+13.0/
1800.0*x12*y01+121.0/1800.0*x12*y21+x12*y02/90.0-x33*y01/1800.0-x33*y11/450.0-
x33*y21/1800.0+x23*y01/100.0-11.0/1200.0*x23*y11-x23*y21/20.0-x23*y31/1200.0+
7.0/150.0*x02*y21+x13*y01/180.0+13.0/180.0*x13*y11-7.0/225.0*x13*y21-x13*y31/
300.0-7.0/450.0*x32*y11-7.0/1800.0*x32*y21+x32*y03/600.0+x32*y13/150.0+x32*y23/
600.0-353.0/1800.0*x22*y11-x22*y31/1800.0+x22*y03/150.0+187.0/1800.0*x22*y13+
x22*y23/25.0-x22*y33/1800.0-7.0/1800.0*x32*y01+52.0/225.0*x12*y11-x12*y31/450.0
+x12*y03/600.0-13.0/225.0*x12*y13-43.0/600.0*x12*y23-x12*y33/450.0+43.0/1800.0*
x02*y11-x02*y31/1800.0-17.0/1800.0*x02*y13-x02*y23/50.0-x02*y33/1800.0+x31*y23/
1200.0+x21*y33/1800.0-x31*y01/720.0-x31*y11/180.0-x31*y21/720.0+x31*y03/1200.0+
x31*y13/300.0-x02*y32/450.0+x32*y02/450.0-52.0/225.0*x11*y12+353.0/1800.0*x11*
y22+7.0/450.0*x11*y32-2.0/225.0*x12*y32+2.0/225.0*x32*y12+x32*y22/450.0-x22*y32
/450.0+7.0/1800.0*x21*y32+x31*y02/1800.0+x31*y12/450.0+x31*y22/1800.0-x03*y12/
600.0-x03*y22/150.0-x03*y32/600.0-79.0/450.0*x12*y22+x22*y01/150.0-4.0/25.0*x22
*y21+17.0/1800.0*x13*y02+13.0/225.0*x13*y12-187.0/1800.0*x13*y22-x13*y32/150.0+
x23*y02/50.0+43.0/600.0*x23*y12-x23*y22/25.0-x23*y32/600.0+x03*y11/240.0+x03*
y21/150.0-x03*y31/1200.0);
}

/* z14 */
static CagdRType SolFunc28(void)
{
    return(-x01*y23/180.0+x01*y11/45.0+32.0/225.0*x22*y12+2.0/45.0*x22*y02-2.0/
45.0*x02*y22+4.0/45.0*x21*y22-2.0/45.0*x01*y12+11.0/450.0*x01*y22-19.0/450.0*
x21*y02-x11*y03/50.0-2.0/45.0*x11*y13+11.0/450.0*x11*y23-x21*y01/36.0-4.0/45.0*
x21*y11+19.0/450.0*x21*y13+x21*y23/36.0-x11*y01/45.0+x01*y21/36.0-11.0/450.0*
x01*y13+4.0/45.0*x11*y21-22.0/225.0*x11*y02-8.0/225.0*x02*y12+2.0/45.0*x12*y01+
8.0/225.0*x12*y02+x23*y01/180.0-11.0/450.0*x23*y11-x23*y21/36.0+19.0/450.0*x02*
y21+11.0/450.0*x13*y01+2.0/45.0*x13*y11-19.0/450.0*x13*y21-16.0/75.0*x22*y11+
x22*y03/50.0+22.0/225.0*x22*y13+x22*y23/45.0+32.0/225.0*x12*y11-8.0/225.0*x12*
y13-2.0/45.0*x12*y23+22.0/225.0*x02*y11-8.0/225.0*x02*y13-11.0/450.0*x02*y23
-32.0/225.0*x11*y12+16.0/75.0*x11*y22-x03*y22/50.0-32.0/225.0*x12*y22-11.0/
450.0*x22*y01-4.0/45.0*x22*y21+8.0/225.0*x13*y02+8.0/225.0*x13*y12-22.0/225.0*
x13*y22+11.0/450.0*x23*y02+2.0/45.0*x23*y12-x23*y22/45.0+x03*y11/50.0);
}

/* z44 */
static CagdRType SolFunc29(void)
{
    return(32.0/225.0*x22*y12+32.0/225.0*x21*y22-16.0/75.0*x21*y12+x11*y31/36.0
-x11*y13/36.0-19.0/450.0*x11*y23-4.0/45.0*x21*y11+x21*y31/45.0-11.0/450.0*x21*
y13+2.0/45.0*x21*y23+x33*y12/50.0+4.0/45.0*x11*y21+16.0/75.0*x12*y21-x33*y21/
50.0+19.0/450.0*x23*y11-2.0/45.0*x23*y21-11.0/450.0*x23*y31+x13*y11/36.0+11.0/
450.0*x13*y21-x13*y31/180.0-19.0/450.0*x32*y11-22.0/225.0*x32*y21+11.0/450.0*
x32*y13+8.0/225.0*x32*y23-2.0/45.0*x22*y31+2.0/45.0*x22*y13+8.0/225.0*x22*y23+
4.0/45.0*x12*y11+11.0/450.0*x12*y31-x12*y13/45.0-22.0/225.0*x12*y23-x12*y33/
50.0+11.0/450.0*x31*y23+x21*y33/50.0-x31*y11/36.0-x31*y21/45.0+x31*y13/180.0
-4.0/45.0*x11*y12+19.0/450.0*x11*y32-2.0/45.0*x12*y32+2.0/45.0*x32*y12+8.0/
225.0*x32*y22-8.0/225.0*x22*y32+22.0/225.0*x21*y32-11.0/450.0*x31*y12+2.0/45.0*
x31*y22-32.0/225.0*x12*y22-32.0/225.0*x22*y21+x13*y12/45.0-2.0/45.0*x13*y22
-11.0/450.0*x13*y32+22.0/225.0*x23*y12-8.0/225.0*x23*y22-8.0/225.0*x23*y32);
}

/* z33 */
static CagdRType SolFunc30(void)
{
    return(-x01*y23/300.0+x01*y11/400.0+1027.0/3600.0*x22*y12+13.0/900.0*x22*
y02-13.0/900.0*x22*y20-x22*y10/144.0-13.0/900.0*x02*y22+x02*y10/3600.0+1027.0/
3600.0*x21*y22-2291.0/14400.0*x21*y12-13.0/3600.0*x21*y20-x21*y10/576.0-x01*y12
/576.0-x10*y01/14400.0+x10*y21/576.0+13.0/900.0*x20*y22-3.0/200.0*x20*y12-x20*
y02/900.0+x01*y20/3600.0+x10*y22/144.0+x01*y10/14400.0-x01*y22/144.0-3.0/200.0*
x21*y02+3.0/100.0*x11*y31-3.0/100.0*x11*y13-9.0/200.0*x11*y23-x21*y01/100.0
-79.0/400.0*x21*y11+x21*y31/80.0+x21*y13/48.0+13.0/300.0*x21*y23-x11*y01/400.0+
x33*y02/2400.0+x33*y12/1200.0+x01*y21/100.0+x01*y31/400.0-x01*y13/1200.0-x01*
y33/1200.0+79.0/400.0*x11*y21-3.0/800.0*x11*y02-13.0/3600.0*x02*y12-x01*y32/
576.0+3.0/200.0*x12*y20+x12*y01/576.0+2291.0/14400.0*x12*y21+13.0/3600.0*x12*
y02+x33*y01/1200.0-x33*y21/1200.0+x02*y20/900.0+x23*y01/300.0+9.0/200.0*x23*y11
-13.0/300.0*x23*y21-x23*y31/200.0+3.0/200.0*x02*y21+x13*y01/1200.0+3.0/100.0*
x13*y11-x13*y21/48.0-x13*y31/100.0-9.0/200.0*x32*y11-349.0/14400.0*x32*y21+x32*
y03/14400.0+x32*y13/200.0+7.0/2880.0*x32*y23-17.0/1200.0*x22*y31+x22*y03/3600.0
+17.0/1200.0*x22*y13+13.0/720.0*x22*y23+x32*y01/576.0+79.0/400.0*x12*y11-x12*
y31/48.0+x12*y03/14400.0-x12*y13/80.0-349.0/14400.0*x12*y23-x12*y33/1200.0+13.0
/3600.0*x20*y21+3.0/800.0*x02*y11+3.0/800.0*x02*y31-x02*y13/2400.0-x02*y23/
600.0-x02*y33/2400.0+x31*y23/200.0-x10*y02/3600.0+x21*y33/1200.0-x31*y01/400.0
-3.0/100.0*x31*y11-x31*y21/80.0+x31*y13/100.0+x01*y30/14400.0-x21*y30/14400.0+
x02*y30/3600.0-13.0/3600.0*x02*y32+13.0/3600.0*x32*y02-x30*y01/14400.0+x30*y21/
14400.0-x10*y03/14400.0-x10*y13/400.0+x10*y23/576.0+x10*y33/1200.0-x20*y03/
3600.0-3.0/800.0*x20*y13+13.0/3600.0*x20*y23+x20*y33/2400.0-x30*y03/14400.0+x30
*y23/14400.0+x13*y10/400.0+3.0/800.0*x13*y20-x23*y10/576.0-13.0/3600.0*x23*y20-
x23*y30/14400.0-x33*y10/1200.0-x33*y20/2400.0-79.0/400.0*x11*y12+9.0/200.0*x11*
y32-x10*y12/100.0+x10*y32/300.0+x30*y22/3600.0+x11*y10/400.0+3.0/800.0*x11*y20-
x31*y10/1200.0-x31*y20/2400.0+x12*y10/100.0-13.0/300.0*x12*y32-x32*y10/300.0-
x32*y20/600.0+13.0/300.0*x32*y12+13.0/720.0*x32*y22-x10*y11/400.0+x10*y31/
1200.0-3.0/800.0*x20*y11+x20*y31/2400.0+x20*y32/600.0-x22*y30/3600.0-13.0/720.0
*x22*y32+x03*y10/14400.0+x03*y20/3600.0+x03*y30/14400.0+349.0/14400.0*x21*y32-
x30*y02/3600.0-3.0/800.0*x31*y02+x31*y12/48.0+17.0/1200.0*x31*y22-x20*y01/
3600.0-x03*y12/14400.0-x03*y22/3600.0-x03*y32/14400.0-1027.0/3600.0*x12*y22+x22
*y01/144.0-1027.0/3600.0*x22*y21+x13*y02/2400.0+x13*y12/80.0-17.0/1200.0*x13*
y22-x13*y32/200.0+x23*y02/600.0+349.0/14400.0*x23*y12-13.0/720.0*x23*y22-7.0/
2880.0*x23*y32);
}

/* z34 */
static CagdRType SolFunc31(void)
{
    return(-x01*y23/300.0+x01*y11/720.0+79.0/450.0*x22*y12+2.0/225.0*x22*y02
-2.0/225.0*x02*y22+52.0/225.0*x21*y22-353.0/1800.0*x21*y12-x01*y12/1800.0-x01*
y22/450.0-7.0/450.0*x21*y02+x11*y31/60.0-x11*y03/1800.0-x11*y13/20.0-7.0/225.0*
x11*y23+x11*y33/150.0-x21*y01/180.0-79.0/720.0*x21*y11+x21*y31/144.0-x21*y03/
450.0-11.0/1200.0*x21*y13+13.0/180.0*x21*y23-x11*y01/720.0+x33*y02/600.0+x33*
y12/150.0+x33*y22/600.0+x01*y21/180.0+x01*y31/720.0-x01*y13/1200.0-x01*y33/
1200.0+79.0/720.0*x11*y21-7.0/1800.0*x11*y02-x02*y12/450.0-x01*y32/1800.0+x12*
y01/1800.0+353.0/1800.0*x12*y21+x12*y02/450.0+x33*y01/1200.0-x33*y11/150.0-x33*
y21/240.0+x23*y01/300.0+7.0/225.0*x23*y11-13.0/180.0*x23*y21-x23*y31/180.0+7.0/
450.0*x02*y21+x13*y01/1200.0+x13*y11/20.0+11.0/1200.0*x13*y21-x13*y31/100.0-7.0
/150.0*x32*y11-43.0/1800.0*x32*y21+x32*y03/1800.0+x32*y13/50.0+17.0/1800.0*x32*
y23-121.0/1800.0*x22*y11-13.0/1800.0*x22*y31+x22*y03/450.0+43.0/600.0*x22*y13+
13.0/225.0*x22*y23-x22*y33/600.0+x32*y01/1800.0+4.0/25.0*x12*y11-x12*y31/150.0+
x12*y03/1800.0-x12*y13/25.0-187.0/1800.0*x12*y23-x12*y33/150.0+7.0/1800.0*x02*
y11+7.0/1800.0*x02*y31-x02*y13/600.0-x02*y23/150.0-x02*y33/600.0+x31*y23/180.0+
x21*y33/240.0-x31*y01/720.0-x31*y11/60.0-x31*y21/144.0-x31*y03/1800.0+x31*y13/
100.0-x02*y32/450.0+x32*y02/450.0-4.0/25.0*x11*y12+121.0/1800.0*x11*y22+7.0/
150.0*x11*y32-2.0/75.0*x12*y32+2.0/75.0*x32*y12+x32*y22/90.0-x22*y32/90.0+43.0/
1800.0*x21*y32-7.0/1800.0*x31*y02+x31*y12/150.0+13.0/1800.0*x31*y22-x03*y12/
1800.0-x03*y22/450.0-x03*y32/1800.0-79.0/450.0*x12*y22+x22*y01/450.0-52.0/225.0
*x22*y21+x13*y02/600.0+x13*y12/25.0-43.0/600.0*x13*y22-x13*y32/50.0+x23*y02/
150.0+187.0/1800.0*x23*y12-13.0/225.0*x23*y22-17.0/1800.0*x23*y32+x03*y11/
1800.0+x03*y21/450.0+x03*y31/1800.0);
}

/* z13 */
static CagdRType SolFunc32(void)
{
    return(x00*y22/450.0-x01*y23/100.0+x01*y11/25.0+x00*y21/1800.0+52.0/225.0*
x22*y12+13.0/180.0*x22*y02-x22*y20/180.0-7.0/450.0*x22*y10-x22*y00/450.0-13.0/
180.0*x02*y22+x02*y10/150.0+79.0/720.0*x21*y22+121.0/1800.0*x21*y12-x21*y20/
720.0-7.0/1800.0*x21*y10-43.0/600.0*x01*y12-x00*y12/450.0-x10*y01/600.0+7.0/
1800.0*x10*y21+x20*y22/180.0-x20*y12/450.0-x20*y02/300.0+x01*y20/1200.0+7.0/
450.0*x10*y22+x01*y10/600.0+11.0/1200.0*x01*y22-x21*y00/1800.0-7.0/225.0*x21*
y02-x11*y03/150.0-2.0/75.0*x11*y13-x11*y23/150.0-x21*y01/20.0-4.0/25.0*x21*y11+
x21*y03/150.0+7.0/150.0*x21*y13+x21*y23/60.0-x11*y01/25.0+x01*y21/20.0-x01*y13/
50.0+4.0/25.0*x11*y21-187.0/1800.0*x11*y02-13.0/225.0*x02*y12+x12*y20/450.0+
43.0/600.0*x12*y01-121.0/1800.0*x12*y21+13.0/225.0*x12*y02+x02*y20/300.0+x23*
y01/100.0+x23*y11/150.0-x23*y21/60.0+7.0/225.0*x02*y21+x12*y00/450.0+x13*y01/
50.0+2.0/75.0*x13*y11-7.0/150.0*x13*y21-353.0/1800.0*x22*y11+x22*y03/240.0+43.0
/1800.0*x22*y13+x22*y23/144.0+79.0/450.0*x12*y11-x12*y03/600.0-x12*y13/90.0
-13.0/1800.0*x12*y23+x20*y21/720.0+187.0/1800.0*x02*y11-17.0/1800.0*x02*y13-x02
*y23/180.0-x10*y02/150.0+x11*y00/1800.0-x00*y11/1800.0-x00*y13/1800.0+x00*y23/
1800.0-x10*y03/600.0-x10*y13/450.0+7.0/1800.0*x10*y23-x20*y03/1200.0-x20*y13/
1800.0+x20*y23/720.0+x13*y00/1800.0+x13*y10/450.0+x13*y20/1800.0-x23*y00/1800.0
-7.0/1800.0*x23*y10-x23*y20/720.0-79.0/450.0*x11*y12+353.0/1800.0*x11*y22-2.0/
225.0*x10*y12+x11*y10/450.0+x11*y20/1800.0+2.0/225.0*x12*y10-x10*y11/450.0-x20*
y11/1800.0+x03*y10/600.0+x03*y20/1200.0-x20*y01/1200.0+x03*y12/600.0-x03*y22/
240.0-52.0/225.0*x12*y22-11.0/1200.0*x22*y01-79.0/720.0*x22*y21+17.0/1800.0*x13
*y02+x13*y12/90.0-43.0/1800.0*x13*y22+x23*y02/180.0+13.0/1800.0*x23*y12-x23*y22
/144.0+x03*y11/150.0-x03*y21/150.0);
}

/* z23 */
static CagdRType SolFunc33(void)
{
    return(-x01*y23/100.0+x01*y11/80.0+1027.0/3600.0*x22*y12+13.0/300.0*x22*y02
-x22*y20/100.0-3.0/200.0*x22*y10-13.0/300.0*x02*y22+x02*y10/600.0+79.0/400.0*
x21*y22-x21*y20/400.0-3.0/800.0*x21*y10-17.0/1200.0*x01*y12-x00*y12/3600.0-x10*
y01/2400.0+3.0/800.0*x10*y21+x20*y22/100.0-x20*y12/144.0-x20*y02/300.0+x01*y20/
1200.0+3.0/200.0*x10*y22+x01*y10/2400.0-x01*y22/48.0-9.0/200.0*x21*y02+x11*y31/
100.0-x11*y03/1200.0-13.0/300.0*x11*y13-x11*y23/48.0-3.0/100.0*x21*y01-79.0/
400.0*x21*y11+x21*y31/400.0+9.0/200.0*x21*y13+3.0/100.0*x21*y23-x11*y01/80.0+
x33*y02/14400.0+x33*y12/3600.0+x33*y22/14400.0+3.0/100.0*x01*y21+x01*y31/400.0-
x01*y13/200.0+79.0/400.0*x11*y21-349.0/14400.0*x11*y02-13.0/720.0*x02*y12+3.0/
800.0*x01*y32+x12*y20/144.0+17.0/1200.0*x12*y01+13.0/720.0*x12*y02+x02*y20/
300.0+x23*y01/100.0+x23*y11/48.0-3.0/100.0*x23*y21-x23*y31/1200.0+9.0/200.0*x02
*y21+x12*y00/3600.0+x13*y01/200.0+13.0/300.0*x13*y11-9.0/200.0*x13*y21-x13*y31/
300.0-3.0/200.0*x32*y11-3.0/800.0*x32*y21+x32*y03/2400.0+x32*y13/600.0+x32*y23/
2400.0-2291.0/14400.0*x22*y11-x22*y31/576.0+x22*y03/1200.0+349.0/14400.0*x22*
y13+x22*y23/80.0-x22*y33/14400.0-3.0/800.0*x32*y01+1027.0/3600.0*x12*y11-x12*
y31/144.0-13.0/720.0*x12*y13-17.0/1200.0*x12*y23-x12*y33/3600.0+x20*y21/400.0+
349.0/14400.0*x02*y11-x02*y31/576.0-7.0/2880.0*x02*y13-x02*y23/200.0-x02*y33/
14400.0+x31*y23/1200.0-x10*y02/600.0-x31*y01/400.0-x31*y11/100.0-x31*y21/400.0+
x31*y03/1200.0+x31*y13/300.0+x11*y00/14400.0-x31*y00/14400.0-13.0/3600.0*x02*
y32-x32*y00/3600.0+13.0/3600.0*x32*y02-x00*y11/14400.0+x00*y31/14400.0-x00*y13/
14400.0+x00*y33/14400.0-x10*y03/2400.0-13.0/3600.0*x10*y13+3.0/800.0*x10*y23+
x10*y33/3600.0-x20*y03/1200.0-x20*y13/576.0+x20*y23/400.0+x20*y33/14400.0+x13*
y00/14400.0+13.0/3600.0*x13*y10+x13*y20/576.0-3.0/800.0*x23*y10-x23*y20/400.0-
x33*y00/14400.0-x33*y10/3600.0-x33*y20/14400.0-1027.0/3600.0*x11*y12+2291.0/
14400.0*x11*y22+3.0/200.0*x11*y32-13.0/900.0*x10*y12+x10*y32/900.0+13.0/3600.0*
x11*y10+x11*y20/576.0-x31*y10/3600.0-x31*y20/14400.0+13.0/900.0*x12*y10-13.0/
900.0*x12*y32-x32*y10/900.0-x32*y20/3600.0+13.0/900.0*x32*y12+13.0/3600.0*x32*
y22-13.0/3600.0*x10*y11+x10*y31/3600.0-x20*y11/576.0+x20*y31/14400.0+x20*y32/
3600.0-13.0/3600.0*x22*y32+x03*y10/2400.0+x03*y20/1200.0+3.0/800.0*x21*y32+x00*
y32/3600.0+x31*y02/576.0+x31*y12/144.0+x31*y22/576.0-x20*y01/1200.0-x03*y22/
1200.0-x03*y32/2400.0-1027.0/3600.0*x12*y22+x22*y01/48.0-79.0/400.0*x22*y21+7.0
/2880.0*x13*y02+13.0/720.0*x13*y12-349.0/14400.0*x13*y22-x13*y32/600.0+x23*y02/
200.0+17.0/1200.0*x23*y12-x23*y22/80.0-x23*y32/2400.0+x03*y11/1200.0-x03*y31/
1200.0);
}

/* z12 */
static CagdRType SolFunc34(void)
{
    return(x00*y22/150.0-x01*y23/300.0+13.0/225.0*x01*y11+x00*y21/240.0+4.0/
25.0*x22*y12+x22*y02/20.0-x22*y20/60.0-7.0/150.0*x22*y10-x22*y00/150.0-x02*y22/
20.0+x02*y10/50.0+79.0/720.0*x21*y22+353.0/1800.0*x21*y12-x21*y20/144.0-43.0/
1800.0*x21*y10-187.0/1800.0*x01*y12-x00*y12/150.0-17.0/1800.0*x10*y01+43.0/
1800.0*x10*y21+x20*y22/60.0-x20*y12/150.0-x20*y02/100.0+x01*y20/180.0+7.0/150.0
*x10*y22+17.0/1800.0*x01*y10-7.0/225.0*x01*y22-x21*y00/240.0+11.0/1200.0*x21*
y02-x11*y03/450.0-2.0/225.0*x11*y13-x11*y23/450.0-13.0/180.0*x21*y01-52.0/225.0
*x21*y11+x21*y03/450.0+7.0/450.0*x21*y13+x21*y23/180.0-13.0/225.0*x11*y01+13.0/
180.0*x01*y21-x01*y13/150.0+52.0/225.0*x11*y21-43.0/600.0*x11*y02-x02*y12/25.0+
x12*y20/150.0+187.0/1800.0*x12*y01-353.0/1800.0*x12*y21+x12*y02/25.0+x02*y20/
100.0+x23*y01/300.0+x23*y11/450.0-x23*y21/180.0-11.0/1200.0*x02*y21+x12*y00/
150.0+x13*y01/150.0+2.0/225.0*x13*y11-7.0/450.0*x13*y21-121.0/1800.0*x22*y11+
x22*y03/1800.0+7.0/1800.0*x22*y13+x22*y23/720.0+79.0/450.0*x12*y11-x12*y03/
1800.0-x12*y13/450.0-x12*y23/1800.0+x20*y21/144.0+43.0/600.0*x02*y11-x02*y13/
600.0-x02*y23/1200.0-x10*y02/50.0+x11*y00/600.0-x00*y11/600.0-x00*y13/600.0-x00
*y23/1200.0-x10*y03/1800.0-x10*y13/450.0-x10*y23/1800.0+x20*y03/1800.0+7.0/
1800.0*x20*y13+x20*y23/720.0+x13*y00/600.0+x13*y10/450.0-7.0/1800.0*x13*y20+x23
*y00/1200.0+x23*y10/1800.0-x23*y20/720.0-79.0/450.0*x11*y12+121.0/1800.0*x11*
y22-2.0/75.0*x10*y12+x11*y10/90.0+13.0/1800.0*x11*y20+2.0/75.0*x12*y10-x10*y11/
90.0-13.0/1800.0*x20*y11+x03*y10/1800.0-x03*y20/1800.0-x20*y01/180.0+x03*y12/
1800.0-x03*y22/1800.0-4.0/25.0*x12*y22+7.0/225.0*x22*y01-79.0/720.0*x22*y21+x13
*y02/600.0+x13*y12/450.0-7.0/1800.0*x13*y22+x23*y02/1200.0+x23*y12/1800.0-x23*
y22/720.0+x03*y11/450.0-x03*y21/450.0);
}

/* z22 */
static CagdRType SolFunc35(void)
{
    return(-x01*y23/300.0+13.0/720.0*x01*y11+x00*y21/1200.0+79.0/400.0*x22*y12+
3.0/100.0*x22*y02-3.0/100.0*x22*y20-9.0/200.0*x22*y10-3.0/100.0*x02*y22+x02*y10
/200.0+79.0/400.0*x21*y22+2291.0/14400.0*x21*y12-x21*y20/80.0-349.0/14400.0*x21
*y10-349.0/14400.0*x01*y12-x00*y12/1200.0-7.0/2880.0*x10*y01+349.0/14400.0*x10*
y21+3.0/100.0*x20*y22-x20*y12/48.0-x20*y02/100.0+x01*y20/200.0+9.0/200.0*x10*
y22+7.0/2880.0*x01*y10-9.0/200.0*x01*y22-x21*y00/1200.0-x21*y02/48.0+13.0/900.0
*x11*y31-x11*y03/3600.0-13.0/900.0*x11*y13-x11*y23/144.0-13.0/300.0*x21*y01
-1027.0/3600.0*x21*y11+13.0/3600.0*x21*y31+3.0/200.0*x21*y13+x21*y23/100.0-13.0
/720.0*x11*y01+13.0/300.0*x01*y21+13.0/3600.0*x01*y31-x01*y13/600.0+1027.0/
3600.0*x11*y21-17.0/1200.0*x11*y02-x02*y12/80.0+x01*y32/576.0+x12*y20/48.0+
349.0/14400.0*x12*y01-2291.0/14400.0*x12*y21+x12*y02/80.0+x02*y20/100.0+x23*y01
/300.0+x23*y11/144.0-x23*y21/100.0-x23*y31/3600.0+x02*y21/48.0+x12*y00/1200.0+
x13*y01/600.0+13.0/900.0*x13*y11-3.0/200.0*x13*y21-x13*y31/900.0-x32*y11/144.0-
x32*y21/576.0+x32*y03/14400.0+x32*y13/3600.0+x32*y23/14400.0-3.0/800.0*x22*y31+
3.0/800.0*x22*y13+x22*y23/400.0-x32*y01/576.0+1027.0/3600.0*x12*y11-3.0/200.0*
x12*y31-x12*y03/14400.0-13.0/3600.0*x12*y13-x12*y23/576.0+x20*y21/80.0+17.0/
1200.0*x02*y11-3.0/800.0*x02*y31-x02*y13/2400.0-x02*y23/1200.0+x31*y23/3600.0-
x10*y02/200.0-13.0/3600.0*x31*y01-13.0/900.0*x31*y11-13.0/3600.0*x31*y21+x31*
y03/3600.0+x31*y13/900.0+x01*y30/14400.0+x21*y30/14400.0-x31*y00/2400.0-x02*y32
/400.0-x32*y00/1200.0+x32*y02/400.0+x00*y31/2400.0-x30*y01/14400.0-x30*y21/
14400.0-x00*y13/2400.0-x00*y23/1200.0-x10*y03/14400.0-13.0/3600.0*x10*y13-x10*
y23/576.0+3.0/800.0*x20*y13+x20*y23/400.0+x30*y03/14400.0+x30*y13/3600.0+x30*
y23/14400.0+x13*y00/2400.0+13.0/3600.0*x13*y10-3.0/800.0*x13*y20-x13*y30/3600.0
+x23*y00/1200.0+x23*y10/576.0-x23*y20/400.0-x23*y30/14400.0-1027.0/3600.0*x11*
y12+x11*y32/144.0-13.0/300.0*x10*y12+x10*y32/300.0+13.0/720.0*x11*y10+17.0/
1200.0*x11*y20+x11*y30/3600.0-x31*y10/600.0-x31*y20/2400.0+13.0/300.0*x12*y10-
x12*y32/100.0-x32*y10/300.0-x32*y20/1200.0+x32*y12/100.0+x32*y22/400.0-13.0/
720.0*x10*y11+x10*y31/600.0-17.0/1200.0*x20*y11+x20*y31/2400.0+x20*y32/1200.0-
x30*y11/3600.0-x22*y32/400.0+x03*y10/14400.0-x03*y30/14400.0+x21*y32/576.0+x00*
y32/1200.0+3.0/800.0*x31*y02+3.0/200.0*x31*y12+3.0/800.0*x31*y22-x20*y01/200.0+
x03*y12/14400.0-x03*y32/14400.0-79.0/400.0*x12*y22+9.0/200.0*x22*y01-79.0/400.0
*x22*y21+x13*y02/2400.0+13.0/3600.0*x13*y12-3.0/800.0*x13*y22-x13*y32/3600.0+
x23*y02/1200.0+x23*y12/576.0-x23*y22/400.0-x23*y32/14400.0+x03*y11/3600.0-x03*
y31/3600.0);
}

/* z42 */
static CagdRType SolFunc36(void)
{
    return(4.0/25.0*x22*y12-2.0/75.0*x22*y20-x22*y10/150.0+79.0/450.0*x21*y22
-121.0/1800.0*x21*y12-x21*y20/90.0-13.0/1800.0*x21*y10+13.0/1800.0*x10*y21+2.0/
75.0*x20*y22-7.0/150.0*x20*y12+x10*y22/150.0+13.0/180.0*x11*y31-x11*y13/180.0
-7.0/450.0*x11*y23-x11*y33/450.0-52.0/225.0*x21*y11+13.0/225.0*x21*y31+x21*y13/
450.0+2.0/225.0*x21*y23+x33*y12/1800.0-x33*y22/1800.0+52.0/225.0*x11*y21+7.0/
150.0*x12*y20+121.0/1800.0*x12*y21+x33*y11/450.0-x33*y21/450.0+7.0/450.0*x23*
y11-2.0/225.0*x23*y21-x23*y31/150.0+x13*y11/180.0-x13*y21/450.0-x13*y31/300.0+
11.0/1200.0*x32*y11-43.0/600.0*x32*y21+x32*y13/1200.0+x32*y23/600.0+353.0/
1800.0*x22*y11-187.0/1800.0*x22*y31+x22*y13/1800.0+x22*y23/450.0+x22*y33/1800.0
+79.0/720.0*x12*y11-7.0/225.0*x12*y31-x12*y13/720.0-7.0/1800.0*x12*y23-x12*y33/
1800.0+x20*y21/90.0+x31*y23/150.0+x21*y33/450.0-13.0/180.0*x31*y11-13.0/225.0*
x31*y21+x31*y13/300.0-x21*y30/600.0+x30*y21/600.0-x10*y13/720.0-7.0/1800.0*x10*
y23-x10*y33/1800.0+x20*y13/1800.0+x20*y23/450.0+x20*y33/1800.0+x30*y13/1200.0+
x30*y23/600.0+x13*y10/720.0-x13*y20/1800.0-x13*y30/1200.0+7.0/1800.0*x23*y10-
x23*y20/450.0-x23*y30/600.0+x33*y10/1800.0-x33*y20/1800.0-79.0/720.0*x11*y12
-353.0/1800.0*x11*y22-11.0/1200.0*x11*y32-x10*y12/60.0+x10*y32/100.0-x30*y12/
150.0+x30*y22/150.0+x11*y10/144.0+43.0/1800.0*x11*y20+x11*y30/240.0-x31*y10/
180.0-17.0/1800.0*x31*y20+x12*y10/60.0+x12*y30/150.0-x12*y32/20.0-x32*y10/100.0
-x32*y20/50.0+x32*y12/20.0+x32*y22/25.0-x10*y11/144.0+x10*y31/180.0-43.0/1800.0
*x20*y11+17.0/1800.0*x20*y31+x20*y32/50.0-x30*y11/240.0-x22*y30/150.0-x22*y32/
25.0+43.0/600.0*x21*y32+7.0/225.0*x31*y12+187.0/1800.0*x31*y22-4.0/25.0*x12*y22
-79.0/450.0*x22*y21+x13*y12/720.0-x13*y22/1800.0-x13*y32/1200.0+7.0/1800.0*x23*
y12-x23*y22/450.0-x23*y32/600.0);
}
