#ifndef _POLYLINE_H_
#define _POLYLINE_H_

#include "rndr_loc.h"

/* In this module we work with homogenous coordinates in screen space. */

typedef struct PolylineOptionsStruct {
    RealType ZNear;
    RealType ZFar;
    RealType MinWidth;
    RealType MaxWidth;

} PolylineOptionsStruct;

typedef struct LineSegmentStruct{
    IPPolygonStruct *Tri;
    PointType4 Vertex[5]; /* 4 for the rectangle + one extra for sharp bends.*/
    VectorType Normal[5]; /* 4 for the rectangle + one extra for sharp bends.*/
    PointType4 LastPoint;
    PointType4 LastDelta;
    IPVertexStruct *TriVertex[3];
    PolylineOptionsStruct PolyOptions;
    RealType k;
    int NumVertex;
    int TrianglesNum;           /* No. of triangles constructing the segment */
    int SharpBend;                    /* TRUE for more than 90 degrees turn. */
}LineSegmentStruct;

void LineSegmentInit(LineSegmentStruct *Seg,
                     PolylineOptionsStruct *PolyOptions);

void LineSegmentSetOptions(LineSegmentStruct *Seg,
                           PolylineOptionsStruct *PolyOptions);

void LineSegmentStart(LineSegmentStruct *Seg);

void LineSegmentSet(LineSegmentStruct *Seg,
                    PointType4 Vertex);

IPPolygonStruct *LineSegmentGetTri(LineSegmentStruct *Seg,
                                   int NumTri);

void LineSegmentEnd(LineSegmentStruct *Seg);

void LineSegmentRelease(LineSegmentStruct *Seg);

#endif
