#ifndef _LIGHTS_H_
#define _LIGHTS_H_

#include "rndr_loc.h"
#include "interpol.h"

/* Data structure describing light source. */
typedef struct LightStruct {
    int Type;                                          /* Light source type. */
    PointType Where;                     /* Light source position or vector. */
    IRndrColorType Color;                           /* Color of the light source. */
} LightStruct;

/* We use array of Light source objects. */
typedef struct LightListStruct {
    int n;                                       /* Number of light sources. */
    LightStruct *Src;                      /* Array of light source objects. */
} LightListStruct;

void LightListInitEmpty(LightListStruct *Lights);

void LightListAdd(LightListStruct *Lights, LightStruct *NewSrc);

void LightListInitDefault(LightListStruct *Lights);

#endif
