#ifndef _INTERPOL_H_
#define _INTERPOL_H_

#include "rndr_loc.h"

/* Scan-line algorithm interpolation values.                                 */
/* Add any for which you want to interpolate.                                */
/* Light intensivity components via shading  models used.                    */

typedef struct IntensivityStruct {
    RealType Diff, Spec;
} IntensivityStruct;

typedef struct InterpolStruct {
    RealType w, z;                           /* Homogenous and Z coordinate. */
    RealType u, v;               /* Bivariative texture mapping coordinates. */
    NormalType n;              /* Normal at the current interpolation point. */
    PointType c;                /* Color at the current interpolation point. */
    IntensivityStruct *i;/* Array of intensivity values for every light src. */
    int IntensSize;
    int HasColor;
} InterpolStruct;

InterpolStruct *InterpolCopy(InterpolStruct *Dst, InterpolStruct *Src);

InterpolStruct *InterpolDelta(InterpolStruct *Dst,
                  InterpolStruct *v1,
                  InterpolStruct *v2,
                  RealType d);

InterpolStruct *InterpolIncr(InterpolStruct *Dst, InterpolStruct *d);

#endif
