/******************************************************************************
* Mvar_loc.h - header file for the MVAR library.			      *
* This header is local to the library - it is NOT external.		      *
*******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                 *
*******************************************************************************
* Written by Gershon Elber, May. 97.					      *
******************************************************************************/

#ifndef MVAR_LOC_H
#define MVAR_LOC_H

#include <math.h>
#include <stdio.h>
#include "irit_sm.h"
#include "iritprsr.h"
#include "cagd_lib.h"

extern GLOBAL_DATA CagdRType 
    MvarBsctSubdivTol, 
    MvarBsctNumerTol,
    MvarBsctUVTol;

typedef struct MvarVoronoiCrvStruct {
    struct MvarVoronoiCrvStruct *Pnext;
    CagdSrfStruct *F3;
    CagdCrvStruct *Crv1;
    CagdCrvStruct *Crv2;
} MvarVoronoiCrvStruct;

/******************************************************************************
* This macro is called when the library has detected an unrecoverable error.  *
* Default action is to call MvarFatalError, but you may want to reroute this  *
* to invoke your handler and recover yourself (by long jump for example).     *
******************************************************************************/
#define MVAR_FATAL_ERROR(Msg)	MvarFatalError(Msg)

#include "mvar_lib.h"		     /* Include the extrenal header as well. */

/******************************************************************************
* Voronoi cell computation						      *
******************************************************************************/
int MvarBsctIsCurveLL(MvarVoronoiCrvStruct *Cv);
MvarVoronoiCrvStruct *MvarBsctApplyLL(MvarVoronoiCrvStruct *Cv);
int MvarBsctApplyCC(MvarVoronoiCrvStruct *Cv1, 
		    MvarVoronoiCrvStruct **CCFreeCrvs);
MvarVoronoiCrvStruct *MvarBsctPurgeAwayLLAndCCConstraints(MvarVoronoiCrvStruct 
							  *InputCrvs);
void MvarBsctTrimCurveBetween(MvarVoronoiCrvStruct *Cv, 
			      MvarPtStruct *Pt1, 
			      MvarPtStruct *Pt2, 
			      MvarVoronoiCrvStruct **TrimmedCurve);
void MvarBsctSplitEnvelope1AtEnvelope2(MvarVoronoiCrvStruct *Envelope1, 
				       MvarVoronoiCrvStruct *Envelope2, 
				       MvarVoronoiCrvStruct **SplitEnvelope1);
void MvarBsctComputeLowerEnvelopeOfOverlap(MvarVoronoiCrvStruct *Cv1, 
					   MvarVoronoiCrvStruct *Cv2, 
					   MvarVoronoiCrvStruct **ResultEnvelope);
void MvarBsctMergeLowerEnvelopes(MvarVoronoiCrvStruct *Envelope1, 
				 MvarVoronoiCrvStruct *Envelope2, 
				 MvarVoronoiCrvStruct **LowerEnvelope);
void MvarBsctComputeLowerEnvelopeAux(MvarVoronoiCrvStruct *InputCurves, 
				     MvarVoronoiCrvStruct **LowerEnvelope);
void MvarBsctComputeLowerEnvelope(MvarVoronoiCrvStruct *inputCurves, 
				  MvarVoronoiCrvStruct **lowerEnvelope);
MvarPtStruct *MvarBsctImplicitCrvExtremeAliter(CagdSrfStruct *Srf,
					       CagdSrfDirType Dir,
					       CagdRType MvarBsctSubdivTol,
					       CagdRType MvarBsctNumerTol);
static MvarPtStruct *MvarBsctGetUVSingularPoints(MvarPtStruct *UExtreme, 
						 MvarPtStruct *VExtreme, 
						 CagdRType MvarBsctSubdivTol, 
						 CagdRType MvarBsctNumerTol);
CagdSrfStruct *MvarBsctTrimSurfaceByUVBbox(CagdSrfStruct *Srf, 
					   CagdBBoxStruct UVBbox);
MvarPtStruct *MvarBsctNewFindZeroSetOfSrfAtParam(CagdSrfStruct *Srf, 
						 CagdRType Param,
						 CagdSrfDirType Dir, 
						 CagdRType MvarBsctSubdivTol,
						 CagdRType MvarBsctNumerTol,
						 CagdBType ShouldCheckEndPoints);
CagdBBoxStruct *MvarBsctMatchOneToThree(MvarPtStruct *First, 
					int FirstLen, 
					MvarPtStruct *Other1, 
					MvarPtStruct *Other2, 
					MvarPtStruct *Other3);
void MvarBsctMateTBLRPoints(CagdSrfStruct *Srf, 
			    CagdSrfStruct **OutLst, 
			    MvarPtStruct *T, 
			    int LenT, 
			    MvarPtStruct *B, 
			    int LenB, 
			    MvarPtStruct *L, 
			    int LenL, 
			    MvarPtStruct *R, 
			    int LenR);
void MvarBsctMateTBLRPoints(CagdSrfStruct *Srf, 
			    CagdSrfStruct **OutLst, 
			    MvarPtStruct *T, 
			    int LenT, 
			    MvarPtStruct *B, 
			    int LenB, 
			    MvarPtStruct *L, 
			    int LenL, 
			    MvarPtStruct *R, 
			    int LenR);
MvarPtStruct *MvarBsctPtsSortAxis(MvarPtStruct *PtList, int Axis);
CagdRType MvarBsctFindMidParam(MvarPtStruct *Lst1, 
			       int LenLst1, 
			       MvarPtStruct *Lst2, 
			       int LenLst2,
			       CagdSrfDirType Dir, 
			       CagdRType* LargestGapOut);
void MvarBsctFindClosestParamsAroundPoint(MvarPtStruct *Pt, 
					  MvarPtStruct *Lst, 
					  CagdRType *UInf, 
					  CagdRType *USup, 
					  CagdRType *VInf, 
					  CagdRType *VSup);
void MvarBsctSplitImplicitCrvToMonotonePieces(CagdSrfStruct *Srf,
					      CagdSrfStruct **OutLst,
					      CagdRType MvarBsctSubdivTol,
					      CagdRType MvarBsctNumerTol);
void MvarBsctComputeDenomOfP(CagdCrvStruct *Crv1Inp,	
			     CagdCrvStruct *Crv2Inp,	
			     CagdSrfStruct **DenomOut);
CagdRType *MvarComputeInterMidPoint(CagdCrvStruct *Crv1,
				    CagdRType t1,
				    CagdCrvStruct *Crv2,
				    CagdRType t2);
void MvarBsctComputeF3(CagdCrvStruct *Crv1Inp,                       
		       CagdCrvStruct *Crv2Inp,			           
		       CagdCrvStruct **Crv1Coerced,
		       CagdCrvStruct **Crv2Coerced,	
		       CagdSrfStruct **F3,
		       CagdSrfStruct **L1,			           
		       CagdSrfStruct **L2,			           
		       CagdSrfStruct **CC1,			           
		       CagdSrfStruct **CC2);
CagdRType *MvarBsctComputeXYFromBisTR(CagdCrvStruct *Crv1,
				      CagdRType t,
				      CagdCrvStruct *Crv2,
				      CagdRType r);
MvarPtStruct *MvarBsctSkel2DEqPts3Crvs(CagdCrvStruct *Crv1,
				       CagdCrvStruct *Crv2,
				       CagdCrvStruct *Crv3);
MvarVoronoiCrvStruct *MvarVoronoiCrvNew(void);
MvarVoronoiCrvStruct *MvarVoronoiCrvCopy(MvarVoronoiCrvStruct *Crv);
void MvarVoronoiCrvFree(MvarVoronoiCrvStruct *Crv);
int MvarBsctIsXSmaller(MvarPtStruct *P1, MvarPtStruct *P2);
void MvarBsctCurveLeft(MvarVoronoiCrvStruct *Cv, MvarPtStruct *Res);
void MvarBsctCurveRight(MvarVoronoiCrvStruct *Cv, MvarPtStruct *Res);
int MvarBsctCv1IsYSmallerAt(MvarVoronoiCrvStruct *Cv1, 
			    MvarVoronoiCrvStruct *Cv2, 
			    MvarPtStruct *MidPoint);
void MvarBsctGetAllIntersectionPoints(MvarVoronoiCrvStruct *Cv1, 
				      MvarVoronoiCrvStruct *Cv2, 
				      MvarPtStruct **Points);
void MvarBsctSplitCurve(MvarVoronoiCrvStruct *Cv, 
			MvarPtStruct *SplitPt, 
			MvarVoronoiCrvStruct **CvLeft,
			MvarVoronoiCrvStruct **CvRight);

#endif /* MVAR_LOC_H */
