/******************************************************************************
* Misc_ftl.c - default FatalError function for the misc library.	      *
*******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                 *
*******************************************************************************
* Written by Gershon Elber, April. 93.					      *
******************************************************************************/

#include <stdio.h>
#include "misc_loc.h"

/*****************************************************************************
* DESCRIPTION:                                                               M
* Trap Misc_lib errors right here. Provides a default error handler for the  M
* misc library. Gets an error description using MiscDescribeError, prints it M
* and exit the program using exit.                                           M
*                                                                            *
* PARAMETERS:                                                                M
*   ErrID:      Error type that was raised.                                  M
*                                                                            *
* RETURN VALUE:                                                              M
*   void                                                                     M
*                                                                            *
* KEYWORDS:                                                                  M
*   MiscFatalError, error handling                                           M
*****************************************************************************/
void MiscFatalError(MiscFatalErrorType ErrID)
{
    char
	*ErrorMsg = MiscDescribeError(ErrID);

    fprintf(stderr, IRIT_EXP_STR("MISC_LIB: %s\n"), ErrorMsg);

    exit(-1);
}
