/******************************************************************************
* Mdl_ftl.c - default FatalError function for the Model library.	      *
*******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                 *
*******************************************************************************
* Written by Gershon Elber, April. 93.					      *
******************************************************************************/

#include <stdio.h>
#include "mdl_loc.h"

/*****************************************************************************
* DESCRIPTION:                                                               M
* Trap Mdl_lib errors right here. Provides a default error handler for the   M
* mdl library. Gets an error description using MdlDescribeError, prints it   M
* and exit the program using exit.                                           M
*                                                                            *
* PARAMETERS:                                                                M
*   ErrID:      Error type that was raised.                                  M
*                                                                            *
* RETURN VALUE:                                                              M
*   void                                                                     M
*                                                                            *
* KEYWORDS:                                                                  M
*   MdlFatalError, error handling                                            M
*****************************************************************************/
void MdlFatalError(MdlFatalErrorType ErrID)
{
    char
	*ErrorMsg = MdlDescribeError(ErrID);

    fprintf(stderr, "MDL_LIB: %s\n", ErrorMsg);

    exit(-1);
}
