/******************************************************************************
* Mdl_err.c - handler for all Model library fatal errors.		      *
*******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                 *
*******************************************************************************
* Written by Gershon Elber, Dec. 96.					      *
******************************************************************************/

#include "mdl_loc.h"

typedef struct MdlErrorStruct {
    MdlFatalErrorType ErrorNum;
    char *ErrorDesc;
} MdlErrorStruct;

static MdlErrorStruct ErrMsgs[] =
{
    { MDL_ERR_PTR_REF,			"Invalid reference pointer" },
    { MDL_ERR_TSEG_NO_SRF,		"Trimming segment with no surfaces" },

    { MDL_ERR_UNDEFINE_ERR,		NULL }
};

/*****************************************************************************
* DESCRIPTION:                                                               M
* Returns a string describing a the given error. Errors can be raised by     M
* any member of this mdl library as well as other users. Raised error will   M
* cause an invokation of MdlFatalError function which decides how to handle  M
* this error. MdlFatalError can for example, invoke this routine with the    M
* error type, print the appropriate message and quit the program.            M
*                                                                            *
* PARAMETERS:                                                                M
*   ErrorNum:   Type of the error that was raised.                           M
*                                                                            *
* RETURN VALUE:                                                              M
*   char *:     A string describing the error type.                          M
*                                                                            *
* KEYWORDS:                                                                  M
*   MdlDescribeError, error handling                                         M
*****************************************************************************/
char *MdlDescribeError(MdlFatalErrorType ErrorNum)
{
    int i = 0;

    for ( ; ErrMsgs[i].ErrorDesc != NULL; i++)
	if (ErrorNum == ErrMsgs[i].ErrorNum)
	    return ErrMsgs[i].ErrorDesc;

    return "Undefined error";
}
