/******************************************************************************
* Mdl_dbg.c - Provide a routine to print model objects to stderr.             *
*******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                 *
*******************************************************************************
* Written by Gershon Elber, Jun. 97.					      *
******************************************************************************/

#include "mdl_loc.h"
#include "iritprsr.h"

/*****************************************************************************
* DESCRIPTION:                                                               M
* Prints model objects to stderr. Should be linked to programs for debugging M
* purposes, so model objects may be inspected from a debugger.		     M
*                                                                            *
* PARAMETERS:                                                                M
*   Obj:       A model object - to be printed to stderr.  		     M
*                                                                            *
* RETURN VALUE:                                                              M
*   void                                                                     M
*                                                                            *
* KEYWORDS:                                                                  M
*   MdlDbg, debugging                                                        M
*****************************************************************************/
void MdlDbg(void *Obj)
{
    char *ErrorMsg;
    MdlModelStruct
	*Mdl = (MdlModelStruct *) Obj;

    MdlWriteModelToFile3(Mdl, stderr, 0, "MdlDbg", &ErrorMsg);

    if (ErrorMsg)
	fprintf(stderr, "MdlDbg Error: %s\n", ErrorMsg);
}
