/*****************************************************************************
*   "Irit" - the 3d (not only polygonal) solid modeller.		     *
*									     *
* Written by:  Gershon Elber				Ver 0.2, Mar. 1990   *
******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                *
******************************************************************************
*   General, local to module, definitions for the Input Parser module.	     *
*   Note this module actually consists of InptPrsr/InptEval/OverLoad modules.*
*****************************************************************************/

#ifndef	INPT_PRSR_LH
#define	INPT_PRSR_LH

/* Every time, we evaluate an aggregare (if/for/sufnction) we jump by level. */
#define IP_EVAL_BASE_LEVEL	1024
#define IP_EVAL_BASE_MASK	1023
#define IP_EVAL_NEXT_LEVEL(Lvl) (((Lvl) & ~IP_EVAL_BASE_MASK) + \
				                            IP_EVAL_BASE_LEVEL)

#define IP_INIT_PARSER_STACK	100	     /* Depth of expression nesting. */

#define IP_EXPR_MAX_STRING_LEN	10000

typedef enum {
    ZERO_EXPR =     0,
    POLY_EXPR =     0x00000001,
    NUMERIC_EXPR =  0x00000002,
    POINT_EXPR	=   0x00000004,
    VECTOR_EXPR	=   0x00000008,
    PLANE_EXPR	=   0x00000010,
    MATRIX_EXPR	=   0x00000020,
    CURVE_EXPR =    0x00000040,
    SURFACE_EXPR =  0x00000080,
    STRING_EXPR	=   0x00000100,
    OLST_EXPR =     0x00000200,
    CTLPT_EXPR =    0x00000400,
    TRIMSRF_EXPR =  0x00000800,
    TRIVAR_EXPR =   0x00001000,
    INSTANCE_EXPR = 0x00002000,
    TRISRF_EXPR =   0x00004000,
    MODEL_EXPR =    0x00008000,
    MULTIVAR_EXPR = 0x00010000,

    POLY_CURVE_EXPR = POLY_EXPR | CURVE_EXPR,
    POLY_LIST_EXPR = POLY_EXPR | OLST_EXPR,
    GEOM_EXPR =     POINT_EXPR | VECTOR_EXPR | POLY_EXPR | CURVE_EXPR |
		    SURFACE_EXPR | CTLPT_EXPR | TRIMSRF_EXPR | TRIVAR_EXPR |
		    INSTANCE_EXPR | TRISRF_EXPR | MODEL_EXPR | MULTIVAR_EXPR,
    OLST_GEOM_EXPR = OLST_EXPR | GEOM_EXPR,
    ANY_EXPR =      POLY_EXPR | NUMERIC_EXPR | POINT_EXPR | VECTOR_EXPR |
    		    PLANE_EXPR | MATRIX_EXPR | CURVE_EXPR | SURFACE_EXPR |
		    STRING_EXPR | OLST_EXPR | CTLPT_EXPR | TRIMSRF_EXPR |
		    TRIVAR_EXPR | MULTIVAR_EXPR | INSTANCE_EXPR |
		    TRISRF_EXPR | MODEL_EXPR,
    FREE_FORM_EXPR = CURVE_EXPR | SURFACE_EXPR | TRIMSRF_EXPR | TRIVAR_EXPR |
		    TRISRF_EXPR | MULTIVAR_EXPR,

    NO_EXPR =       0x10000000,
    ERROR_EXPR =    0x20000000
} IritExprType;

/* See also IPObjectStruct structure for the different object possible: */
#define IS_POLY_NODE(Node)	((Node) -> PObj -> ObjType == IP_OBJ_POLY)
#define IS_NUM_NODE(Node)	((Node) -> PObj -> ObjType == IP_OBJ_NUMERIC)
#define IS_PT_NODE(Node)	((Node) -> PObj -> ObjType == IP_OBJ_POINT)
#define IS_VEC_NODE(Node)	((Node) -> PObj -> ObjType == IP_OBJ_VECTOR)
#define IS_PLANE_NODE(Node)	((Node) -> PObj -> ObjType == IP_OBJ_PLANE)
#define IS_CTLPT_NODE(Node)	((Node) -> PObj -> ObjType == IP_OBJ_CTLPT)
#define IS_MAT_NODE(Node)	((Node) -> PObj -> ObjType == IP_OBJ_MATRIX)
#define IS_STR_NODE(Node)	((Node) -> PObj -> ObjType == IP_OBJ_STRING)
#define IS_OLST_NODE(Node)	((Node) -> PObj -> ObjType == IP_OBJ_LIST_OBJ)
#define IS_CRV_NODE(Node)	((Node) -> PObj -> ObjType == IP_OBJ_CURVE)
#define IS_SRF_NODE(Node)	((Node) -> PObj -> ObjType == IP_OBJ_SURFACE)
#define IS_TRIMSRF_NODE(Node)	((Node) -> PObj -> ObjType == IP_OBJ_TRIMSRF)
#define IS_TRIVAR_NODE(Node)	((Node) -> PObj -> ObjType == IP_OBJ_TRIVAR)
#define IS_INSTNC_NODE(Node)	((Node) -> PObj -> ObjType == IP_OBJ_INSTANCE)
#define IS_TRISRF_NODE(Node)	((Node) -> PObj -> ObjType == IP_OBJ_TRISRF)
#define IS_MODEL_NODE(Node)	((Node) -> PObj -> ObjType == IP_OBJ_MODEL)
#define IS_MULTIVAR_NODE(Node)	((Node) -> PObj -> ObjType == IP_OBJ_MULTIVAR)

/*****************************************************************************
* a block of command seperated by a colon can have assignments followed by   *
* use of variables. We would like to know that when we test for validity.    *
*****************************************************************************/
#define TO_BE_ASSIGNED_TAG	   0x10
#define IS_TO_BE_ASSIGN_OBJ(Obj)   ((Obj) -> Tags & TO_BE_ASSIGNED_TAG)
#define SET_TO_BE_ASSIGN_OBJ(Obj)  ((Obj) -> Tags |= TO_BE_ASSIGNED_TAG)
#define RST_TO_BE_ASSIGN_OBJ(Obj)  ((Obj) -> Tags &= ~TO_BE_ASSIGNED_TAG))

/*****************************************************************************
* Function entry table looks like this (for table see InptPrsr.c module):    *
*****************************************************************************/
#define FUNC_NAME_LEN	31			    /* 10 + NULL terminator. */
#define FUNC_MAX_PARAM	7	       /* Update # Param cases in inptevl1.c */
#define ANY_PARAM_NUM	127

typedef struct FuncTableType {
    char FuncName[FUNC_NAME_LEN];
    int FuncToken;
    char *CFuncName;
    void (*Func)();
    ByteType NumOfParam;
    IritExprType ParamObjType[FUNC_MAX_PARAM];
    IritExprType RetType;
} FuncTableType;

typedef struct NumFuncTableType {
    char FuncName[FUNC_NAME_LEN];
    int FuncToken;
    char *CFuncName;
    double (*Func)();
    ByteType NumOfParam;
    IritExprType ParamObjType[FUNC_MAX_PARAM];
    IritExprType RetType;
} NumFuncTableType;

typedef struct ObjFuncTableType {
    char FuncName[FUNC_NAME_LEN];
    int FuncToken;
    char *CFuncName;
    IPObjectStruct *(*Func)();
    ByteType NumOfParam;
    IritExprType ParamObjType[FUNC_MAX_PARAM];
    IritExprType RetType;
} ObjFuncTableType;

typedef struct GenFuncTableType {
    char FuncName[FUNC_NAME_LEN];
    int FuncToken;
    char *CFuncName;
    void (*Func)();
    ByteType NumOfParam;
    IritExprType ParamObjType[FUNC_MAX_PARAM];
    IritExprType RetType;
} GenFuncTableType;

typedef struct ConstantTableType {
    char FuncName[FUNC_NAME_LEN];
    RealType Value;
} ConstantTableType;

typedef struct UserDefinedFuncDefType {
    struct UserDefinedFuncDefType *Pnext;
    char FuncName[FUNC_NAME_LEN];
    int IsFunction;
    int NumParams;
    IPObjectStruct *Params;
    IPObjectStruct *LocalVars;
    ParseTree *Body;
} UserDefinedFuncDefType;

/* The followings are defined in the InptEval.c module and are globals so   */
/* InptPrsr.c module will be able to access them...			    */
extern GLOBAL_DATA NumFuncTableType NumFuncTable[];
extern GLOBAL_DATA int NumFuncTableSize;
extern GLOBAL_DATA ObjFuncTableType ObjFuncTable[];
extern GLOBAL_DATA int ObjFuncTableSize;
extern GLOBAL_DATA GenFuncTableType GenFuncTable[];
extern GLOBAL_DATA int GenFuncTableSize;
extern GLOBAL_DATA ConstantTableType ConstantTable[];
extern GLOBAL_DATA int ConstantTableSize;
extern GLOBAL_DATA UserDefinedFuncDefType *UserDefinedFuncList;

/*****************************************************************************
* Tokens used in the expression	to tree	conversion and tree definition.	     *
*****************************************************************************/

#define	TOKENERROR  0
#define TOKEN_NONE  1

/* Warning - changing the order of these constants, needs updating the order */
/* of them, in the tables in the begining of InptPrsr.c & OverLoad.c modules.*/

typedef enum {
    USERFUNCDEF = 90,		       /* Function and procedure definition. */
    USERPROCDEF,
    USERINSTDEF
} UserDefinedFuncType;

#define USER_FUNC			0
#define USERFUNC_MAX_PARAM		20
#define MAX_PARAM			MAX(USERFUNC_MAX_PARAM, FUNC_MAX_PARAM)
#define IS_USER_FUNCTION(Token)		((Token) >= USERFUNCDEF && \
					 (Token) <= USERINSTDEF)

typedef enum {				   /* Real value returned functions. */
    ARCCOS = 100,
    ARCSIN,
    ARCTAN2,
    ARCTAN,
    COS,
    EXP,
    ABSOLUTE,
    FLOOR,
    FMOD,
    FPOWER,
    LN,
    LOG,
    SIN,
    SQRT,
    TAN,
    CPOLY,
    AREA,
    VOLUME,
    TIME,
    SIZEOF,
    MESHSIZE,
    THISOBJ,
    IRT_RNDM,
    CLNTEXEC,
    DSTPTLN,
    DSTPTPLN,
    DSTLNLN,
    ZCOLLIDE
} RealValueFuncType;

#define NUM_FUNC	100
#define NUM_FUNC_OFFSET	100
#define NUM_FUNC_END	199
#define IS_NUM_FUNCTION(Token)		((Token) >= NUM_FUNC && \
					 (Token) <= NUM_FUNC_END)

typedef enum {				       /* Object returned Functions. */
    POINT = 200,
    VECTOR,
    PLANE,
    CTLPT,
    ROTX,
    ROTY,
    ROTZ,
    ROTVEC,
    ROTZ2V2,
    ROTZ2V,
    ROTV2V,
    MAP3PT2EQL,
    TRANS,
    SCALE,
    BOX,
    GBOX,
    CONE,
    CONE2,
    CYLIN,
    SPHERE,
    TORUS,
    CIRCPOLY,
    POLY,
    CROSSEC,
    SURFREV,
    SURFREVAXS,
    SURFREV2,
    SURFREVAXS2,
    SURFPREV,
    EXTRUDE,
    LIST,
    LOAD,
    CONVEX,
    SPOWER,
    CPOWER,
    SBEZIER,
    CBEZIER,
    SBSPLINE,
    CBSPLINE,
    SEVAL,
    CEVAL,
    STANGENT,
    CTANGENT,
    PNORMAL,
    PATTRIB,
    SNORMAL,
    TSNORMAL,
    CNORMAL,
    MDIVIDE,
    TDIVIDE,
    SDIVIDE,
    CDIVIDE,
    MREGION,
    TREGION,
    SREGION,
    CREGION,
    MREFINE,
    TREFINE,
    SREFINE,
    CREFINE,
    MRAISE,
    TRAISE,
    SRAISE,
    CRAISE,
    CREDUCE,
    CSURFACE,
    CMESH,
    NTH,
    NREF,
    GPOLYGON,
    GPOLYLINE,
    CIRCLE,
    PCIRCLE,
    CSPIRAL,
    ARC,
    ARC360,
    RULEDSRF,
    RULEDTV,
    BOOLSUM,
    BOOLONE,
    SFROMCRVS,
    SWEEPSRF,
    SWPSCLSRF,
    OFFSET,
    AOFFSET,
    LOFFSET,
    MOFFSET,
    TOFFSET,
    COERCE,
    CEDITPT,
    SEDITPT,
    TEDITPT,
    MERGEPOLY,
    CMORPH,
    PMORPH,
    SMORPH,
    TMORPH,
    BZR2BSP,
    BSP2BZR,
    SMERGE,
    MMERGE,
    CDERIVE,
    SDERIVE,
    TDERIVE,
    MDERIVE,
    TSDERIVE,
    CINTEG,
    SINTEG,
    SNRMLSRF,
    CNRMLCRV,
    SYMBPROD,
    SYMBDPROD,
    SYMBCPROD,
    SYMBIPROD,
    SYMBSUM,
    SYMBDIFF,
    HOMOMAT,
    PROJMAT,
    RFLCTMAT,
    MATPOSDIR,
    MATDECOMP,
    CINFLECT,
    CCRVTR,
    CFNCRVTR,
    SCRVTR,
    SRADCRVTR,
    CIEXTREME,
    PCRVTR,
    PIMPRTNC,
    SGAUSS,
    SMEAN,
    SUMBILIC,
    CREPARAM,
    SREPARAM,
    TREPARAM,
    MREPARAM,
    EVOLUTE,
    CZEROS,
    CEXTREMES,
    PPINTER,
    CCINTER,
    CARRANGMNT,
    SSINTER,
    NIL,
    COORD,
    COMPOSE,
    DECOMPOSE,
    PRISA,
    CRVPTDIST,
    CRVLNDIST,
    SRFPTDIST,
    SRFLNDIST,
    ADAPISO,
    PDOMAIN,
    LINTERP,
    CINTERP,
    SINTERP,
    CMULTIRES,
    GETLINE,
    FFEXTREME,
    TRIMSRF,
    TRMSRFS,
    SRFTRIMSRF,
    CRVTRIMCRV,
    TBEZIER,
    TBSPLINE,
    TSBEZIER,
    TSBSPLINE,
    TSGREGORY,
    TEVAL,
    TSEVAL,
    TEXTGEOM,
    STRIVAR,
    SMESH,
    TINTERP,
    CLNTREAD,
    CLNTCRSR,
    MOMENT,
    TFROMSRFS,
    SFOCAL,
    HERMITE,
    BLHERMITE,
    BLSHERMITE,
    FFMATCH,
    CONTOUR,
    PRINTER,
    SRINTER,
    PLN3PTS,
    PTPTLN,
    PTLNPLN,
    PTSLNLN,
    PTSCRCR,
    TNSCRCR,
    PT3BARY,
    FFSPLIT,
    FFMERGE,
    FFPTTYPE,
    FFGTYPE,
    FFORDER,
    FFMSIZE,
    FFMESH,
    FFKNTVEC,
    FFCTLPTS,
    FFPOLES,
    CNVXHULL,
    MSCIRC,
    CRVPTTAN,
    CRV2TANS,
    CRC2CRVTAN,
    SRF3TANS,
    INSTANCE,
    CANGLEMAP,
    CVIEWMAP,
    CVISIBLE,
    SVISIBLE,
    GETATTR,
    PTHMSPR,
    PDECIMATE,
    FFPTDIST,
    CENVOFF,
    CBISECTOR2D,
    CBISECTOR3D,
    CALPHASECTOR,
    SBISECTOR,
    MBISECTOR,
    CVORONOICELL,
    SPRBISECT,
    BSCTPLNPT,
    BSCTCYLPT,
    BSCTCONPT,
    BSCTSPRPT,
    BSCTTRSPT,
    BSCTPLNLN,
    BSCTCONLN,
    BSCTSPRLN,
    BSCTSPRPL,
    BSCTCYLPL,
    BSCTCONPL,
    BSCTCONCON,
    BSCTCONCN2,
    BSCTCONSPR,
    BSCTCYLSPR,
    BSCTSPRSPR,
    BSCTTRSSPR,
    BSCTCYLCYL,
    BSCTCONCYL,
    SKEL2DINT,
    BBOXOBJ,
    ORTHOTOMC,
    BOUNDARY,
    SILHOUETTE,
    SASPCTGRPH,
    SSILINFL,
    POLARSIL,
    ISOCLINE,
    TCRVTR,
    MRCHCUBE,
    TRIANGL,
    MAXEDGELEN,
    PTS2PLLN,
    COVERPT,
    COVERISO,
    TVLOAD,
    DUALITY,
    ALGSUM,
    SWUNGASUM,
    MPROMOTE,
    MREVERSE,
    MFROMMV,
    MFROMMESH,
    MEVAL,
    MZERO,
    SPARABOLC,
    RRINTER,
    GGINTER,
    SREVERSE,
    CONICSEC,
    ELLIPSE3PT,
    QUADRIC,
    CNC2QUAD,
    IMPLCTRANS,
    IRITSTATE,
    ISGEOM,
    SMOOTHNRML,
    FIXPLNRML,
    FIXPLGEOM,
    BLOSSOM,
    KNOTCLEAN,
    KNOTREMOVE,
    RAYTRAPS,
    CMOEBIUS,
    SMOEBIUS,
    RFLCTLN,
    CAREA,
    SVOLUME,
    SMOMENTS,
    TVZRJACOB,
    CRVKERNEL,
    SRFKERNEL,
    CRVDIAMTR,
    SACCESS,
    SFLECNODAL,
    SRF2TANS,
    NRMLCONE,
    PTREGISTER,
    GETNAME,
    SDDMMAP,
    MVEXPLICIT,
    ANALYFIT,
    PLANECLIP,
    SRFFFORM,
    SCRVTREVAL,
    SASYMPEVAL,
    CARCLEN,
    TEXTWARP,
    SRAYCLIP,
    PPROPFTCH,
    FITPMODEL,
    UVPOLY,
    MPOWER,
    MBEZIER,
    MBSPLINE,
    CBIARCS,
    SPLITLST,
    SETCOVER,
    DIST2FF,
    FFRIGIDSIM,
    FFCMPCRVS,
    ANIMEVAL,
    CUBICCRVS,
    QUADCRVS,
} ObjValueFuncType;

#define OBJ_FUNC1	200
#define OBJ_FUNC2	300
#define OBJ_FUNC3	400
#define OBJ_FUNC4	500
#define OBJ_FUNC_OFFSET	200
#define OBJ_FUNC_END	599
#define IS_OBJ_FUNCTION(Token)		(Token >= OBJ_FUNC1 && \
					 Token <= OBJ_FUNC_END)

typedef enum {		   /* General Functions/No value returned functions. */
    EXIT = 600,
    IRITRESET,
    VIEWOBJ,
    VIEWSET,
    CHDIR,
    INCLUDE,
    SAVE,
    FREEOBJ,
    FREEFUNC,
    IFCOND,
    FORLOOP,
    WHILELOOP,
    PRHELP,
    VARLIST,
    SYSTEM,
    LOGFILE,
    COLOR,
    AWIDTH,
    ADWIDTH,
    SNOC,
    ATTRIB,
    ATTRPROP,
    CPATTR,
    RMATTR,
    FFCOMPAT,
    MSLEEP,
    IRITPRINT,
    IRITPRNTFL,
    IRITERROR,
    CLNTWRITE,
    CLNTCLOSE,
    SETNAME,
    EXEC,
    IQUERY,
    INSERTPOLY,
    IDYNMEM
} GenValueFuncType;

#define GEN_FUNC	600
#define GEN_FUNC_OFFSET	600
#define GEN_FUNC_END	699
#define IS_GEN_FUNCTION(Token)		((Token) >= GEN_FUNC && \
					 (Token) <= GEN_FUNC_END)

#define IS_FUNCTION(Token)              ((Token) >= 90 && \
					 (Token) < GEN_FUNC_END)

#define IS_NO_PARAM_FUNC(Token)		((Token) == EXIT || \
					 (Token) == IRITRESET || \
					 (Token) == VARLIST || \
					 (Token) == NIL)

typedef enum {						       /* Operators. */
    PLUS = 800,
    MINUS,
    MULT,
    DIV,
    POWER,
    UNARMINUS,
    EQUAL,
    COMMA,
    COLON,
    SEMICOLON,
    CMP_EQUAL,
    CMP_NOTEQUAL,
    CMP_LSEQUAL,
    CMP_GTEQUAL,
    CMP_LESS,
    CMP_GREAT,
    BOOL_AND,
    BOOL_OR,
    BOOL_NOT,
    LASTOPER = BOOL_NOT,

    OPENPARA,						     /* Paranthesis. */
    CLOSPARA,

    NUMBER,						    /* Numeric Data. */
    PARAMETER,					 /* Point on new/old object. */
    STRING,		     /* Sequence of characters within double quotes. */

    TOKENSTART,
    TOKENEND
} GenericTokenType;

#define OPERATORS		800
#define OPERATORS_OFFSET	800
#define IS_AN_OPERATOR(Token)		((Token) >= OPERATORS && \
					 (Token) <= LASTOPER)

#define IP_PRSR_MAX_TOKEN	1000              /* Upper bound for tokens. */

typedef enum {
    IRIT_INPUT_SOURCE_KBD,
    IRIT_INPUT_SOURCE_FILE,
    IRIT_INPUT_SOURCE_LINE_QUEUE
} IritInputSourceType;

extern GLOBAL_DATA char IPGlblCharData[];     /* Used for both parse & eval. */
extern GLOBAL_DATA int InptPrsrLastToken;
extern GLOBAL_DATA InptPrsrEvalErrType IPGlblEvalError;/* Global of EvalTree.*/
extern GLOBAL_DATA IritInputSourceType IritInputSource;

/*****************************************************************************
*   The local function (static) prototypes:				     *
*   Note that if DEBUG is defined for the preprocessor, few more function    *
* become available:							     *
*   Also note that some of the routines are defined globals as both the      *
* InptPrsr.c and InptEval.c modules needs them.				     *
*****************************************************************************/

ParseTree *ExprMalloc(void);
void ExprFree(ParseTree *Ptr);
void UpdateCharError(char *StrMsg, int Token, ParseTree *Node);
ParseTree *InptPrsrGenInputParseTree(void);
void InptPrsrFileInclude(char *FileName);
int InptPrsrSetEchoSource(int EchoSource);
IritExprType InptPrsrTypeCheck(ParseTree *Root, int Level);   /* Type check. */
ParseTree *InptPrsrEvalTree(ParseTree *Root, int Level);   /* Evaluate tree. */
void InptPrsrFreeTree(ParseTree *Root);			   /* Free all tree. */
void InptPrsrPrintTree(ParseTree *Root, char *Str, int StrLen);/* Print it...*/
ParseTree *InptPrsrCopyTree(ParseTree *Root);			 /* Copy it. */
IritExprType InptPrsrObjType2Expr(ParseTree *Root, IPObjectStruct *PObj);
ParseTree *InptEvalFetchParameter(ParseTree *Root, int i, int n);
int InptEvalCountNumParameters(ParseTree *Root);

char *InptPrsrTypeToStr(IritExprType Type);
void InptEvalPrintHelp(char *HelpHeader);
ParseTree *InptEvalCompareObject(ParseTree *Root,
				 ParseTree *Left,
			         ParseTree *Right,
				 InptPrsrEvalErrType *IError,
    				 char *CError);
void InptEvalIfCondition(ParseTree *Cond,
			 ParseTree *CondTrue,
			 ParseTree *CondFalse);
void InptEvalForLoop(ParseTree *PStart,
		     ParseTree *PInc,
		     ParseTree *PEnd,
		     ParseTree *PBody);
void InptEvalWhileLoop(ParseTree *PCond, ParseTree *PBody);
IPObjectStruct *InptEvalMVExplicit(RealType *Dim, char *Expr);
void InptPrsrMarkToBeAssigned(ParseTree *Root);
IPObjectStruct *InptEvalGenObjectList(ParseTree *PObjParams);
IPObjectStruct *InptEvalCtlPtFromParams(ParseTree *PObjParams);
void InptEvalDefineFunc(ParseTree *FuncDef);
ParseTree *InptEvalUserFunc(ParseTree *Root, ParseTree *Params[]);
int InptEvalFetchParameters(ParseTree *Root,
			    FuncTableType *FuncTable,
			    int NumParams,
			    int Level,
			    ParseTree *Params[],
			    VoidPtr ParamPtrs[]);
int IritEvalFuncParamMismatch(ParseTree *Root);
void InptEvalPropagateDependencies(IPObjectStruct *PObj, ParseTree *Root);

#endif	/* INPT_PRSR_LH */
