/*****************************************************************************
*   "Irit" - the 3d (not only polygonal) solid modeller.		     *
*									     *
* Written by:  Gershon Elber				Ver 0.2, Mar. 1990   *
******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                *
******************************************************************************
*   Module to evaluate the binary tree generated by the InptPrsr module.     *
*   All the objects are handled the same but the numerical one, which is     *
* moved as a RealType and not as an object (only internally within this	     *
* module) as it is frequently used and consumes much less memory this way.   *
*   Note this module is par of InptPrsr module and was splited only because  *
* of text file sizes problems...					     *
*****************************************************************************/

#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include <string.h>
#include "program.h"
#include "allocate.h"
#include "attribut.h"
#include "ctrl-brk.h"
#include "dosintr.h"
#include "freeform.h"
#include "geom_lib.h"
#include "inptprsg.h"
#include "inptprsl.h"
#include "objects.h"
#include "overload.h"
#include "iritgrap.h"
#include "bsc_geom.h"

#ifdef SUN4
    static double natural_log(double x) { return log10(x) / log10(M_E); }
#else
#   define natural_log  log
#endif /* SUN4 */

#ifndef IRIT_QUIET_STRINGS
static void IritQueryFunctions(void);
static void IritQueryKeywords(void);
#endif /* !IRIT_QUIET_STRINGS */
static void IritQuery(RealType *RQuery);

/* This IPNP Macro expands it parameter twice - as a string and as is.       */
#define IPNP(F)   	#F,	F             /* Irit Parser Name & Pointer. */

/* Although the type of parameters is specified (for InptPrsrTypeCheck rtn)  */
/* All the parameters to the following dispatched functions are passed by    */
/* address.								     */

NumFuncTableType NumFuncTable[] = {
    { "ACOS",	 ARCCOS,   IPNP(acos),		1,	{ NUMERIC_EXPR } },
    { "ASIN",	 ARCSIN,   IPNP(asin),		1,	{ NUMERIC_EXPR } },
    { "ATAN2",	 ARCTAN2,  IPNP(atan2),		2,	{ NUMERIC_EXPR, NUMERIC_EXPR } },
    { "ATAN",	 ARCTAN,   IPNP(atan),		1,	{ NUMERIC_EXPR } },
    { IPNP(COS),	   IPNP(cos),		1,	{ NUMERIC_EXPR } },
    { IPNP(EXP),	   IPNP(exp),		1,	{ NUMERIC_EXPR } },
    { "ABS",     ABSOLUTE, IPNP(fabs),		1,	{ NUMERIC_EXPR } },
    { IPNP(FLOOR),	   IPNP(floor),		1,	{ NUMERIC_EXPR } },
    { IPNP(FMOD),	   IPNP(fmod),		2,	{ NUMERIC_EXPR, NUMERIC_EXPR } },
    { "POWER",	 FPOWER,   IPNP(pow),		2,	{ NUMERIC_EXPR, NUMERIC_EXPR } },
    { IPNP(LN),	      IPNP(natural_log),	1,	{ NUMERIC_EXPR } },
    { IPNP(LOG),      IPNP(log10),		1,	{ NUMERIC_EXPR } },
    { IPNP(SIN),      IPNP(sin),		1,	{ NUMERIC_EXPR } },
    { IPNP(SQRT),     IPNP(sqrt),		1,	{ NUMERIC_EXPR } },
    { IPNP(TAN),      IPNP(tan),		1,	{ NUMERIC_EXPR } },
    { IPNP(CPOLY),    IPNP(PolyCountPolys),	1,	{ POLY_EXPR } },
    { IPNP(AREA),     IPNP(GMPolyObjectArea),	1,	{ POLY_EXPR } },
    { IPNP(VOLUME),   IPNP(GMPolyObjectVolume),	1, 	{ POLY_EXPR } },
    { IPNP(TIME),     IPNP(DosGetTime),		1,	{ NUMERIC_EXPR } },
    { IPNP(SIZEOF),   IPNP(GetObjectSize),	1,	{ POINT_EXPR | PLANE_EXPR | VECTOR_EXPR | CTLPT_EXPR | POLY_LIST_EXPR | POLY_EXPR | CURVE_EXPR | STRING_EXPR } },
    { IPNP(MESHSIZE), IPNP(GetMeshSize),	2,	{ CURVE_EXPR | SURFACE_EXPR | TRIMSRF_EXPR | TRIVAR_EXPR | TRISRF_EXPR | MULTIVAR_EXPR, NUMERIC_EXPR } },
    { IPNP(THISOBJ),  IPNP(ThisObjectIs),	1,	{ STRING_EXPR } },
    { "RANDOM",  IRT_RNDM, IPNP(IritRandom),	2,	{ NUMERIC_EXPR, NUMERIC_EXPR } },
    { IPNP(CLNTEXEC), IPNP(ClientExecute),	1,	{ STRING_EXPR } },
    { IPNP(DSTPTLN),  IPNP(DistPointLine),	3,	{ POINT_EXPR, POINT_EXPR, VECTOR_EXPR } },
    { IPNP(DSTPTPLN), IPNP(DistPointPlane),	2,	{ POINT_EXPR, PLANE_EXPR } },
    { IPNP(DSTLNLN),  IPNP(DistLineLine),	4,	{ POINT_EXPR, VECTOR_EXPR, POINT_EXPR, VECTOR_EXPR } },
    { IPNP(ZCOLLIDE), IPNP(ComputeZCollisions),	4,	{ ANY_EXPR, ANY_EXPR, NUMERIC_EXPR, NUMERIC_EXPR } }
};
int NumFuncTableSize = sizeof(NumFuncTable) / sizeof(NumFuncTableType);

ObjFuncTableType ObjFuncTable[] = {
    { IPNP(POINT),	IPNP(IPGenPTObject),	     3,	{ NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR },		POINT_EXPR },
    { IPNP(VECTOR),	IPNP(IPGenVECObject),	     3,	{ NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR },		VECTOR_EXPR },
    { IPNP(PLANE),	IPNP(IPGenPLANEObject),	     4,	{ NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, PLANE_EXPR },
    { IPNP(CTLPT),	IPNP(InptEvalCtlPtFromParams),ANY_PARAM_NUM, { 0 },						CTLPT_EXPR },
    { IPNP(ROTX),	IPNP(GMGenMatObjectRotX),    1,	{ NUMERIC_EXPR },					MATRIX_EXPR },
    { IPNP(ROTY),	IPNP(GMGenMatObjectRotY),    1,	{ NUMERIC_EXPR },					MATRIX_EXPR },
    { IPNP(ROTZ),	IPNP(GMGenMatObjectRotZ),    1,	{ NUMERIC_EXPR },					MATRIX_EXPR },
    { IPNP(ROTVEC),	IPNP(GMGenMatObjectRotVec),  2,	{ VECTOR_EXPR, NUMERIC_EXPR },				MATRIX_EXPR },
    { IPNP(ROTZ2V2),	IPNP(GMGenMatObjectZ2Dir2),  2,	{ VECTOR_EXPR, VECTOR_EXPR },				MATRIX_EXPR },
    { IPNP(ROTZ2V),	IPNP(GMGenMatObjectZ2Dir),   1,	{ VECTOR_EXPR },					MATRIX_EXPR },
    { IPNP(ROTV2V),	IPNP(GMGenMatObjectV2V),     2,	{ VECTOR_EXPR, VECTOR_EXPR },				MATRIX_EXPR },
    { IPNP(MAP3PT2EQL),	IPNP(GMGenMatrix3Pts2EqltrlTri),3,{ POINT_EXPR, POINT_EXPR, POINT_EXPR },		MATRIX_EXPR },
    { IPNP(TRANS),	IPNP(GMGenMatObjectTrans),   1,	{ VECTOR_EXPR },					MATRIX_EXPR },
    { IPNP(SCALE),	IPNP(GMGenMatObjectScale),   1,	{ VECTOR_EXPR },					MATRIX_EXPR },
    { IPNP(BOX),	IPNP(GenBOXObject),	     4,	{ VECTOR_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, POLY_EXPR },
    { IPNP(GBOX),	IPNP(GenGBOXObject),	     4,	{ VECTOR_EXPR, VECTOR_EXPR, VECTOR_EXPR, VECTOR_EXPR }, POLY_EXPR },
    { IPNP(CONE),	IPNP(GenCONEObject),	     4,	{ VECTOR_EXPR, VECTOR_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, POLY_EXPR | SURFACE_EXPR },
    { "CON2", CONE2,	IPNP(GenCONE2Object),	     5,	{ VECTOR_EXPR, VECTOR_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, POLY_EXPR | SURFACE_EXPR },
    { IPNP(CYLIN),	IPNP(GenCYLINObject),	     4,	{ VECTOR_EXPR, VECTOR_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, POLY_EXPR | SURFACE_EXPR },
    { IPNP(SPHERE),	IPNP(GenSPHEREObject),	     2,	{ VECTOR_EXPR, NUMERIC_EXPR },				POLY_EXPR | SURFACE_EXPR },
    { IPNP(TORUS),	IPNP(GenTORUSObject),	     4,	{ VECTOR_EXPR, VECTOR_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, POLY_EXPR | SURFACE_EXPR },
    { IPNP(CIRCPOLY),	IPNP(GenPOLYDISKObject),     3,	{ VECTOR_EXPR, VECTOR_EXPR, NUMERIC_EXPR },		POLY_EXPR },
    { IPNP(POLY),	IPNP(GenPOLYGONObject),	     2,	{ OLST_EXPR, NUMERIC_EXPR },				POLY_EXPR },
    { IPNP(CROSSEC),	IPNP(GenCROSSECObject),	     1,	{ POLY_CURVE_EXPR },					POLY_EXPR },
    { IPNP(SURFREV),	IPNP(GenSURFREVObject),	     1,	{ POLY_CURVE_EXPR },					POLY_EXPR | SURFACE_EXPR },
    { IPNP(SURFREVAXS),	IPNP(GenSURFREVAxisObject),  2,	{ POLY_CURVE_EXPR, VECTOR_EXPR },			POLY_EXPR | SURFACE_EXPR },
    { IPNP(SURFREV2),	IPNP(GenSURFREV2Object),     3,	{ POLY_CURVE_EXPR, NUMERIC_EXPR, NUMERIC_EXPR },	POLY_EXPR | SURFACE_EXPR },
    { "SURFREVAX2",SURFREVAXS2,IPNP(GenSURFREV2AxisObject), 4, { POLY_CURVE_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, VECTOR_EXPR }, POLY_EXPR | SURFACE_EXPR },
    { IPNP(SURFPREV),	IPNP(GenSURFPREVObject),     1,	{ CURVE_EXPR },						SURFACE_EXPR },
    { IPNP(EXTRUDE),	IPNP(GenEXTRUDEObject),	     3,	{ POLY_CURVE_EXPR | SURFACE_EXPR, VECTOR_EXPR, NUMERIC_EXPR }, POLY_EXPR | SURFACE_EXPR | TRIVAR_EXPR | OLST_EXPR },
    { IPNP(LIST),	IPNP(InptEvalGenObjectList), ANY_PARAM_NUM, { 0 },						OLST_EXPR },
    { IPNP(LOAD),	IPNP(LoadObjectFromFile),    1,	{ STRING_EXPR },					ANY_EXPR },
    { IPNP(CONVEX),	IPNP(GMConvexPolyObjectN),   1,	{ POLY_EXPR  | OLST_EXPR },				POLY_LIST_EXPR },
    { IPNP(SPOWER),	IPNP(GenPowerSurfaceObject), 1,	{ OLST_EXPR },						SURFACE_EXPR },
    { IPNP(CPOWER),	IPNP(GenPowerCurveObject),   1,	{ OLST_EXPR },						CURVE_EXPR },
    { IPNP(SBEZIER),	IPNP(GenBezierSurfaceObject),1 ,{ OLST_EXPR },						SURFACE_EXPR },
    { IPNP(CBEZIER),	IPNP(GenBezierCurveObject),  1,	{ OLST_EXPR },						CURVE_EXPR },
    { IPNP(SBSPLINE),	IPNP(GenBsplineSurfaceObject),4,{ NUMERIC_EXPR, NUMERIC_EXPR, OLST_EXPR, OLST_EXPR },	SURFACE_EXPR },
    { IPNP(CBSPLINE),	IPNP(GenBsplineCurveObject), 3,	{ NUMERIC_EXPR, OLST_EXPR, OLST_EXPR },			CURVE_EXPR },
    { IPNP(SEVAL),	IPNP(EvalSurfaceObject),     3,	{ TRIMSRF_EXPR | SURFACE_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, CTLPT_EXPR },
    { IPNP(CEVAL),	IPNP(EvalCurveObject),	     2,	{ CURVE_EXPR, NUMERIC_EXPR },				CTLPT_EXPR },
    { IPNP(STANGENT),	IPNP(TangentSurfaceObject),  5,	{ TRIMSRF_EXPR | SURFACE_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, VECTOR_EXPR },
    { IPNP(CTANGENT),	IPNP(TangentCurveObject),    3,	{ CURVE_EXPR, NUMERIC_EXPR, NUMERIC_EXPR },		VECTOR_EXPR },
    { IPNP(PNORMAL),	IPNP(SetPolyVrtxNormal),     3,	{ POLY_EXPR, NUMERIC_EXPR, ANY_EXPR },			VECTOR_EXPR },
    { IPNP(PATTRIB),    IPNP(SetGetPolyVrtxAttrib),  4,      { POLY_EXPR, NUMERIC_EXPR, STRING_EXPR, ANY_EXPR },	ANY_EXPR },
    { IPNP(SNORMAL),	IPNP(NormalSurfaceObject),   3,	{ TRIMSRF_EXPR | SURFACE_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, VECTOR_EXPR },
    { IPNP(TSNORMAL),	IPNP(NormalTriSrfObject),    4,	{ TRISRF_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, VECTOR_EXPR },
    { IPNP(CNORMAL),	IPNP(NormalCurveObject),     2,	{ CURVE_EXPR, NUMERIC_EXPR },				VECTOR_EXPR },
    { IPNP(MDIVIDE),	IPNP(DivideMultivarObject),  3,	{ MULTIVAR_EXPR, NUMERIC_EXPR, NUMERIC_EXPR },		OLST_EXPR },
    { IPNP(TDIVIDE),	IPNP(DivideTrivarObject),    3,	{ TRIVAR_EXPR, NUMERIC_EXPR, NUMERIC_EXPR },		OLST_EXPR },
    { IPNP(SDIVIDE),	IPNP(DivideSurfaceObject),   3,	{ TRIMSRF_EXPR | SURFACE_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, OLST_EXPR },
    { IPNP(CDIVIDE),	IPNP(DivideCurveObject),     2,	{ CURVE_EXPR, NUMERIC_EXPR },				OLST_EXPR },
    { IPNP(MREGION),	IPNP(RegionFromMultivarObject),4,{ MULTIVAR_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, MULTIVAR_EXPR },
    { IPNP(TREGION),	IPNP(RegionFromTrivarObject), 4,{ TRIVAR_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, TRIVAR_EXPR },
    { IPNP(SREGION),	IPNP(RegionFromSurfaceObject),4,{ TRIMSRF_EXPR | SURFACE_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, SURFACE_EXPR },
    { IPNP(CREGION),	IPNP(RegionFromCurveObject), 3,	{ CURVE_EXPR, NUMERIC_EXPR, NUMERIC_EXPR },		CURVE_EXPR },
    { IPNP(MREFINE),	IPNP(RefineMultivarObject),  4,	{ MULTIVAR_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, OLST_EXPR }, MULTIVAR_EXPR },
    { IPNP(TREFINE),	IPNP(RefineTrivarObject),    4,	{ TRIVAR_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, OLST_EXPR }, TRIVAR_EXPR },
    { IPNP(SREFINE),	IPNP(RefineSurfaceObject),   4,	{ SURFACE_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, OLST_EXPR }, SURFACE_EXPR },
    { IPNP(CREFINE),	IPNP(RefineCurveObject),     3,	{ CURVE_EXPR, NUMERIC_EXPR, OLST_EXPR },		CURVE_EXPR },
    { IPNP(MRAISE),	IPNP(RaiseMultivarObject),   3,	{ MULTIVAR_EXPR, NUMERIC_EXPR, NUMERIC_EXPR },		MULTIVAR_EXPR },
    { IPNP(TRAISE),	IPNP(RaiseTrivarObject),     3,	{ TRIVAR_EXPR, NUMERIC_EXPR, NUMERIC_EXPR },		TRIVAR_EXPR },
    { IPNP(SRAISE),	IPNP(RaiseSurfaceObject),    3,	{ SURFACE_EXPR, NUMERIC_EXPR, NUMERIC_EXPR },		SURFACE_EXPR },
    { IPNP(CRAISE),	IPNP(RaiseCurveObject),	     2,	{ CURVE_EXPR, NUMERIC_EXPR },				CURVE_EXPR },
    { IPNP(CREDUCE),	IPNP(ReduceCurveObject),     2,	{ CURVE_EXPR, NUMERIC_EXPR },				CURVE_EXPR },
    { IPNP(CSURFACE),	IPNP(CurveFromSurface),	     3,	{ SURFACE_EXPR | TRISRF_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, CURVE_EXPR },
    { IPNP(CMESH),	IPNP(CurveFromSrfMesh),	     3,	{ SURFACE_EXPR, NUMERIC_EXPR, NUMERIC_EXPR },		CURVE_EXPR },
    { IPNP(NTH),	IPNP(GetNthList),	     2,	{ OLST_EXPR, NUMERIC_EXPR },				ANY_EXPR },
    { IPNP(NREF),	IPNP(RefNthList),	     2,	{ OLST_EXPR, NUMERIC_EXPR },				ANY_EXPR },
    { IPNP(GPOLYGON),	IPNP(Geometry2Polygons),     2,	{ OLST_GEOM_EXPR, NUMERIC_EXPR },			POLY_EXPR },
    { IPNP(GPOLYLINE),	IPNP(Geometry2Polylines),    2,	{ OLST_GEOM_EXPR, NUMERIC_EXPR },			POLY_EXPR },
    { IPNP(CIRCLE),	IPNP(GenCircleCurveObject),  2,	{ VECTOR_EXPR, NUMERIC_EXPR },				CURVE_EXPR },
    { IPNP(PCIRCLE),	IPNP(GenPCircleCurveObject), 2,	{ VECTOR_EXPR, NUMERIC_EXPR },				CURVE_EXPR },
    { IPNP(CSPIRAL),	IPNP(GenSpiralCurveObject),  4,	{ NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, CURVE_EXPR },
    { IPNP(ARC),	IPNP(GenArcCurveObject),     3,	{ VECTOR_EXPR, VECTOR_EXPR, VECTOR_EXPR },		CURVE_EXPR },
    { IPNP(ARC360),	IPNP(GenArc2CurveObject),    4,	{ VECTOR_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, CURVE_EXPR },
    { IPNP(RULEDSRF),	IPNP(GenRuledSrfObject),     2,	{ POLY_CURVE_EXPR, POLY_CURVE_EXPR },			SURFACE_EXPR | POLY_EXPR },
    { IPNP(RULEDTV),	IPNP(GenRuledTVObject),	     2,	{ SURFACE_EXPR, SURFACE_EXPR },				TRIVAR_EXPR },
    { IPNP(BOOLSUM),	IPNP(GenBoolSumSrfObject),   4,	{ CURVE_EXPR, CURVE_EXPR, CURVE_EXPR, CURVE_EXPR },	SURFACE_EXPR },
    { IPNP(BOOLONE),	IPNP(GenBoolOneSrfObject),   1,	{ CURVE_EXPR },						SURFACE_EXPR },
    { IPNP(SFROMCRVS),	IPNP(GenSrfFromCrvsObject),  3,	{ OLST_EXPR, NUMERIC_EXPR, NUMERIC_EXPR },		SURFACE_EXPR },
    { IPNP(SWEEPSRF),	IPNP(GenSweepSrfObject),     3,	{ CURVE_EXPR | OLST_EXPR, CURVE_EXPR, CURVE_EXPR | VECTOR_EXPR | NUMERIC_EXPR }, SURFACE_EXPR },
    { IPNP(SWPSCLSRF),	IPNP(GenSweepScaleSrfObject),5,	{ CURVE_EXPR | OLST_EXPR, CURVE_EXPR, CURVE_EXPR | NUMERIC_EXPR, CURVE_EXPR | VECTOR_EXPR | NUMERIC_EXPR, NUMERIC_EXPR }, SURFACE_EXPR },
    { IPNP(OFFSET),	IPNP(GenOffsetObject),	     4,	{ POLY_EXPR | CURVE_EXPR | SURFACE_EXPR | TRIMSRF_EXPR, NUMERIC_EXPR | CURVE_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, POLY_EXPR | CURVE_EXPR | SURFACE_EXPR | TRIMSRF_EXPR },
    { IPNP(AOFFSET),	IPNP(GenAOffsetObject),	     5,	{ CURVE_EXPR, NUMERIC_EXPR | CURVE_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, CURVE_EXPR },
    { IPNP(LOFFSET),	IPNP(GenLeastSqrOffsetObject),5,{ CURVE_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, CURVE_EXPR },
    { IPNP(MOFFSET),	IPNP(GenMatchingOffsetObject),3,{ CURVE_EXPR, NUMERIC_EXPR, NUMERIC_EXPR },		CURVE_EXPR },
    { IPNP(TOFFSET),	IPNP(TrimOffsetObject),	     5,	{ CURVE_EXPR, CURVE_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, OLST_EXPR },
    { IPNP(COERCE),	IPNP(CoerceIritObjectTo),    2,	{ ANY_EXPR, NUMERIC_EXPR },				ANY_EXPR },
    { IPNP(CEDITPT),	IPNP(EditCrvControlPoint),   3,	{ CURVE_EXPR, CTLPT_EXPR, NUMERIC_EXPR },		CURVE_EXPR },
    { IPNP(SEDITPT),	IPNP(EditSrfControlPoint),   4,	{ SURFACE_EXPR, CTLPT_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, SURFACE_EXPR },
    { IPNP(TEDITPT),	IPNP(EditTVControlPoint),    5,	{ TRIVAR_EXPR, CTLPT_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, TRIVAR_EXPR },
    { IPNP(MERGEPOLY),	IPNP(GenObjectFromPolyList), 1,	{ OLST_EXPR },						POLY_EXPR },
    { IPNP(CMORPH),	IPNP(TwoCrvsMorphing),	     4,	{ CURVE_EXPR, CURVE_EXPR, NUMERIC_EXPR, NUMERIC_EXPR },	CURVE_EXPR | OLST_EXPR },
    { IPNP(PMORPH),	IPNP(TwoPolysMorphing),	     3,	{ POLY_EXPR, POLY_EXPR, NUMERIC_EXPR },			POLY_EXPR },
    { IPNP(SMORPH),	IPNP(TwoSrfsMorphing),	     3,	{ SURFACE_EXPR, SURFACE_EXPR, NUMERIC_EXPR },		SURFACE_EXPR },
    { IPNP(TMORPH),	IPNP(TwoTVsMorphing),	     3,	{ TRIVAR_EXPR, TRIVAR_EXPR, NUMERIC_EXPR },		TRIVAR_EXPR },
    { IPNP(BZR2BSP),	IPNP(CnvrtBezierToBspline),  1,	{ SURFACE_EXPR | CURVE_EXPR },				CURVE_EXPR | SURFACE_EXPR },
    { IPNP(BSP2BZR),	IPNP(CnvrtBsplineToBezier),  1,	{ SURFACE_EXPR | CURVE_EXPR },				CURVE_EXPR | SURFACE_EXPR },
    { IPNP(SMERGE),	IPNP(MergeSrfSrf),	     4,	{ SURFACE_EXPR, SURFACE_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, SURFACE_EXPR },
    { IPNP(MMERGE),	IPNP(MergeMVMV),	     4,	{ MULTIVAR_EXPR, MULTIVAR_EXPR, NUMERIC_EXPR, NUMERIC_EXPR },MULTIVAR_EXPR },
    { IPNP(CDERIVE),	IPNP(DeriveCurveObject),     1,	{ CURVE_EXPR },						CURVE_EXPR },
    { IPNP(SDERIVE),	IPNP(DeriveSurfaceObject),   2,	{ SURFACE_EXPR, NUMERIC_EXPR },				SURFACE_EXPR },
    { IPNP(TDERIVE),	IPNP(DeriveTrivarObject),    2,	{ TRIVAR_EXPR, NUMERIC_EXPR },				TRIVAR_EXPR },
    { IPNP(MDERIVE),	IPNP(DeriveMultivarObject),  2,	{ MULTIVAR_EXPR, NUMERIC_EXPR },			MULTIVAR_EXPR },
    { IPNP(TSDERIVE),	IPNP(DeriveTriSrfObject),    2,	{ TRISRF_EXPR, NUMERIC_EXPR },				TRIVAR_EXPR },
    { IPNP(CINTEG),	IPNP(IntegrateCurveObject),  1,	{ CURVE_EXPR },						CURVE_EXPR },
    { IPNP(SINTEG),	IPNP(IntegrateSurfaceObject),2,	{ SURFACE_EXPR, NUMERIC_EXPR },				SURFACE_EXPR },
    { IPNP(SNRMLSRF),	IPNP(SurfaceNormalObject),   1,	{ SURFACE_EXPR },					SURFACE_EXPR },
    { IPNP(CNRMLCRV),	IPNP(CurveNormalObject),     1,	{ CURVE_EXPR },						CURVE_EXPR },
    { IPNP(SYMBPROD),	IPNP(TwoFreeformsProduct),   2,	{ CURVE_EXPR | SURFACE_EXPR | MULTIVAR_EXPR, CURVE_EXPR | SURFACE_EXPR | MULTIVAR_EXPR }, CURVE_EXPR | SURFACE_EXPR | MULTIVAR_EXPR },
    { IPNP(SYMBDPROD),	IPNP(TwoFreeformsDotProduct),2, { VECTOR_EXPR | CURVE_EXPR | SURFACE_EXPR | MULTIVAR_EXPR, VECTOR_EXPR | CURVE_EXPR | SURFACE_EXPR | MULTIVAR_EXPR }, CURVE_EXPR | SURFACE_EXPR | MULTIVAR_EXPR },
    { IPNP(SYMBCPROD),	IPNP(TwoFreeformsCrossProduct),2,{ CURVE_EXPR | SURFACE_EXPR | MULTIVAR_EXPR, CURVE_EXPR | SURFACE_EXPR | MULTIVAR_EXPR }, CURVE_EXPR | SURFACE_EXPR | MULTIVAR_EXPR },
    { IPNP(SYMBIPROD),	IPNP(TwoBasisInnerProduct),  3,	{ ANY_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, 		NUMERIC_EXPR },
    { IPNP(SYMBSUM),	IPNP(TwoFreeformsSum),	     2,	{ CURVE_EXPR | SURFACE_EXPR | MULTIVAR_EXPR, CURVE_EXPR | SURFACE_EXPR | MULTIVAR_EXPR }, CURVE_EXPR | SURFACE_EXPR | MULTIVAR_EXPR },
    { IPNP(SYMBDIFF),	IPNP(TwoFreeformsDiff),	     2,	{ CURVE_EXPR | SURFACE_EXPR | MULTIVAR_EXPR, CURVE_EXPR | SURFACE_EXPR | MULTIVAR_EXPR }, CURVE_EXPR | SURFACE_EXPR | MULTIVAR_EXPR },
    { IPNP(HOMOMAT),	IPNP(GenMatObjectGeneric),   1,	{ OLST_EXPR },						MATRIX_EXPR },
    { IPNP(PROJMAT),	IPNP(GenMatProjectionMat),   3,	{ PLANE_EXPR, VECTOR_EXPR, NUMERIC_EXPR },		MATRIX_EXPR },
    { IPNP(RFLCTMAT),	IPNP(GenMatReflectionMat),   1,	{ PLANE_EXPR },						MATRIX_EXPR },
    { IPNP(MATPOSDIR),	IPNP(GenMatObjectPosDir),    3,	{ POINT_EXPR, VECTOR_EXPR, VECTOR_EXPR },		MATRIX_EXPR },
    { IPNP(MATDECOMP),	IPNP(GetMatTransDecomp),     1,	{ MATRIX_EXPR },					OLST_EXPR },
    { IPNP(CINFLECT),	IPNP(CrvInflectionPts),	     3,	{ CURVE_EXPR, NUMERIC_EXPR, NUMERIC_EXPR },		CURVE_EXPR | OLST_EXPR },
    { IPNP(CCRVTR),	IPNP(CrvCurvaturePts),	     3,	{ CURVE_EXPR, NUMERIC_EXPR, NUMERIC_EXPR },		CURVE_EXPR | OLST_EXPR },
    { IPNP(CFNCRVTR),	IPNP(CrvCurvatureFunction),  4,	{ CURVE_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, CURVE_EXPR },
    { IPNP(SCRVTR),	IPNP(SrfCurvatureBounds),    3,	{ SURFACE_EXPR, NUMERIC_EXPR, NUMERIC_EXPR },		SURFACE_EXPR },
    { IPNP(SRADCRVTR),	IPNP(SrfRadialCurvature),    5,	{ SURFACE_EXPR, VECTOR_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, OLST_EXPR },
    { IPNP(CIEXTREME),	IPNP(ImplicitCrvExtreme),    4,	{ SURFACE_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, OLST_EXPR },
    { IPNP(PCRVTR),	IPNP(PolyCurvatureApprox),   3,	{ POLY_EXPR, NUMERIC_EXPR, NUMERIC_EXPR },		POLY_EXPR },
    { IPNP(PIMPRTNC),	IPNP(PolyImportanceApprox),  2,	{ POLY_EXPR, NUMERIC_EXPR },				POLY_EXPR },
    { IPNP(SGAUSS),	IPNP(SrfGaussCurvature),     2,	{ SURFACE_EXPR, NUMERIC_EXPR },				SURFACE_EXPR },
    { IPNP(SMEAN),	IPNP(SrfMeanCurvature),	     2,	{ SURFACE_EXPR, NUMERIC_EXPR },				SURFACE_EXPR },
    { IPNP(SUMBILIC),	IPNP(SrfUmbilicPts),	     3,	{ SURFACE_EXPR, NUMERIC_EXPR, NUMERIC_EXPR },		OLST_EXPR },
    { IPNP(CREPARAM),	IPNP(CrvReparametrization),  3,	{ CURVE_EXPR, NUMERIC_EXPR, NUMERIC_EXPR },		CURVE_EXPR },
    { IPNP(SREPARAM),	IPNP(SrfReparametrization),  4,	{ SURFACE_EXPR | TRIMSRF_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, SURFACE_EXPR | TRIMSRF_EXPR },
    { IPNP(TREPARAM),	IPNP(TrivReparametrization), 4,	{ TRIVAR_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, TRIVAR_EXPR },
    { IPNP(MREPARAM),	IPNP(MvarReparametrization), 4,	{ MULTIVAR_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, MULTIVAR_EXPR },
    { IPNP(EVOLUTE),	IPNP(FreeformEvolute),	     1,	{ CURVE_EXPR | SURFACE_EXPR },				CURVE_EXPR | SURFACE_EXPR },
    { IPNP(CZEROS),	IPNP(CrvZeros),		     3,	{ CURVE_EXPR, NUMERIC_EXPR, NUMERIC_EXPR },		OLST_EXPR },
    { IPNP(CEXTREMES),	IPNP(CrvExtremes),	     3,	{ CURVE_EXPR, NUMERIC_EXPR, NUMERIC_EXPR },		OLST_EXPR },
    { IPNP(PPINTER),	IPNP(PolyPolyIntersection),  2,	{ POLY_EXPR, POLY_EXPR },				POLY_EXPR },
    { IPNP(CCINTER),	IPNP(CrvCrvInter),	     4,	{ CURVE_EXPR, CURVE_EXPR, NUMERIC_EXPR, NUMERIC_EXPR },	SURFACE_EXPR | OLST_EXPR },
    { IPNP(CARRANGMNT),	IPNP(CrvCrvInterArrangment), 4,	{ OLST_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, ANY_EXPR },	OLST_EXPR },
    { IPNP(SSINTER),	IPNP(SrfSrfInter),	     5,	{ SURFACE_EXPR, SURFACE_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, OLST_EXPR },
    { IPNP(NIL),        IPNP(GetNilList),	     0, { 0 },							OLST_EXPR },
    { IPNP(COORD),      IPNP(GetObjectCoord),	     2, { ANY_EXPR, NUMERIC_EXPR },				ANY_EXPR },
    { IPNP(COMPOSE),    IPNP(CrvComposition),	     2, { CURVE_EXPR | SURFACE_EXPR, CURVE_EXPR },		CURVE_EXPR },
    { IPNP(DECOMPOSE),  IPNP(CrvDecomposition),	     1,	{ CURVE_EXPR },						OLST_EXPR },
    { IPNP(PRISA),      IPNP(SrfsPrisa),	     6,	{ SURFACE_EXPR | TRIMSRF_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, VECTOR_EXPR, NUMERIC_EXPR, }, OLST_EXPR },
    { "CRVPTDST", CRVPTDIST, IPNP(CrvPointDist),     4,	{ CURVE_EXPR, POINT_EXPR, NUMERIC_EXPR, NUMERIC_EXPR },	NUMERIC_EXPR | OLST_EXPR },
    { "CRVLNDST", CRVLNDIST, IPNP(CrvLineDist),	     5,	{ CURVE_EXPR, POINT_EXPR, VECTOR_EXPR, NUMERIC_EXPR, NUMERIC_EXPR },	  NUMERIC_EXPR | OLST_EXPR },
    { "SRFPTDST", SRFPTDIST, IPNP(SrfPointDist),     5,	{ SURFACE_EXPR, POINT_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR },	NUMERIC_EXPR | OLST_EXPR },
    { "SRFLNDST", SRFLNDIST, IPNP(SrfLineDist),	     6,	{ SURFACE_EXPR, POINT_EXPR, VECTOR_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, NUMERIC_EXPR | OLST_EXPR },
    { IPNP(ADAPISO),    IPNP(SrfAdapIsoCurves),	     5,	{ SURFACE_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, OLST_EXPR | CURVE_EXPR },
    { IPNP(PDOMAIN),	IPNP(GetFreefromParamDomain),1,	{ MULTIVAR_EXPR | TRISRF_EXPR | TRIVAR_EXPR | TRIMSRF_EXPR | SURFACE_EXPR | CURVE_EXPR }, OLST_EXPR },
    { IPNP(LINTERP),	IPNP(LineLeastSquarePtData), 1,	{ OLST_EXPR },						OLST_EXPR },
    { IPNP(CINTERP),	IPNP(CrvLeastSquarePtData),  5,	{ CURVE_EXPR | OLST_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR | OLST_EXPR, NUMERIC_EXPR }, CURVE_EXPR },
    { IPNP(SINTERP),	IPNP(SrfLeastSquarePtData),  6,	{ SURFACE_EXPR | OLST_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, SURFACE_EXPR | OLST_EXPR },
    { IPNP(CMULTIRES),	IPNP(CurveMultiResDecomp),   3,	{ CURVE_EXPR, NUMERIC_EXPR, NUMERIC_EXPR },		CURVE_EXPR | OLST_EXPR },
    { IPNP(GETLINE),	IPNP(WndwInputStdinObject),  1,	{ NUMERIC_EXPR },					ANY_EXPR },
    { IPNP(FFEXTREME),	IPNP(ExtremumControlPointVals),2,	{ CURVE_EXPR | SURFACE_EXPR, NUMERIC_EXPR },		CTLPT_EXPR },
    { IPNP(TRIMSRF),    IPNP(GenTrimmedSurface),     3, { SURFACE_EXPR, CURVE_EXPR | OLST_EXPR, NUMERIC_EXPR },	TRIMSRF_EXPR },
    { IPNP(TRMSRFS),    IPNP(GenTrimmedSurfaces2),   2, { SURFACE_EXPR, CURVE_EXPR | POLY_LIST_EXPR },	OLST_EXPR | TRIMSRF_EXPR },
    { "STRIMSRF", SRFTRIMSRF, IPNP(GetSrfFromTrimmedSrf), 1, { TRIMSRF_EXPR },					SURFACE_EXPR },
    { "CTRIMSRF", CRVTRIMCRV, IPNP(GetTrimCrvsFromTrimmedSrf),2,{ TRIMSRF_EXPR, NUMERIC_EXPR },				OLST_EXPR },
    { IPNP(TBEZIER),    IPNP(GenBezierTrivarObject), 1,	{ OLST_EXPR },						TRIVAR_EXPR },
    { IPNP(TBSPLINE),   IPNP(GenBsplineTrivarObject),5,	{ NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, OLST_EXPR, OLST_EXPR },	TRIVAR_EXPR },
    { IPNP(TSBEZIER),   IPNP(GenBezierTriSrfObject), 2,	{ NUMERIC_EXPR, OLST_EXPR },				TRISRF_EXPR },
    { IPNP(TSBSPLINE),  IPNP(GenBsplineTriSrfObject),4,	{ NUMERIC_EXPR, NUMERIC_EXPR, OLST_EXPR, OLST_EXPR },	TRISRF_EXPR },
    { IPNP(TSGREGORY),  IPNP(GenGregoryTriSrfObject),2,	{ NUMERIC_EXPR, OLST_EXPR },				TRISRF_EXPR },
    { IPNP(TEVAL),      IPNP(EvalTrivarObject),	     4,	{ TRIVAR_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, CTLPT_EXPR },
    { IPNP(TSEVAL),     IPNP(EvalTriSrfObject),	     4,	{ TRISRF_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, CTLPT_EXPR },
    { IPNP(TEXTGEOM),   IPNP(GMMakeTextGeometry),    3,	{ STRING_EXPR, VECTOR_EXPR, NUMERIC_EXPR },		ANY_EXPR },
    { IPNP(STRIVAR),	IPNP(SurfaceFromTrivar),     3,	{ TRIVAR_EXPR, NUMERIC_EXPR, NUMERIC_EXPR },		SURFACE_EXPR },
    { IPNP(SMESH),	IPNP(SurfaceFromTrivMesh),   3,	{ TRIVAR_EXPR, NUMERIC_EXPR, NUMERIC_EXPR },		SURFACE_EXPR },
    { IPNP(TINTERP),	IPNP(InterpolateTrivar),     7,	{ TRIVAR_EXPR | OLST_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, TRIVAR_EXPR },
    { IPNP(CLNTREAD),	IPNP(ClientRead),	     2,	{ NUMERIC_EXPR, NUMERIC_EXPR },				ANY_EXPR },
    { IPNP(CLNTCRSR),	IPNP(ClientCursor),	     1,	{ NUMERIC_EXPR },					OLST_EXPR },
    { IPNP(MOMENT),	IPNP(ComputeCrvMoments),     2,	{ CURVE_EXPR, NUMERIC_EXPR },				POINT_EXPR | VECTOR_EXPR },
    { IPNP(TFROMSRFS),	IPNP(GenTVFromSrfsObject),   3,	{ OLST_EXPR, NUMERIC_EXPR, NUMERIC_EXPR },		TRIVAR_EXPR },
    { IPNP(SFOCAL),	IPNP(SrfIsoFocalSrf),	     2,	{ SURFACE_EXPR, NUMERIC_EXPR },				SURFACE_EXPR },
    { IPNP(HERMITE),	IPNP(GenHermiteObject),	     4,	{ CURVE_EXPR | POINT_EXPR | VECTOR_EXPR, CURVE_EXPR | POINT_EXPR | VECTOR_EXPR,
					      CURVE_EXPR | POINT_EXPR | VECTOR_EXPR, CURVE_EXPR | POINT_EXPR | VECTOR_EXPR }, CURVE_EXPR | SURFACE_EXPR },
    { IPNP(BLHERMITE),	IPNP(GenBlendHermiteObject), 6, { CURVE_EXPR, CURVE_EXPR, CURVE_EXPR, CURVE_EXPR, CURVE_EXPR, CURVE_EXPR }, SURFACE_EXPR },
    { IPNP(BLSHERMITE),	IPNP(GenBlendHermiteOnSrfObject),6,{ SURFACE_EXPR, CURVE_EXPR, CURVE_EXPR, NUMERIC_EXPR, NUMERIC_EXPR | CURVE_EXPR, NUMERIC_EXPR | CURVE_EXPR }, SURFACE_EXPR },
    { IPNP(FFMATCH),    IPNP(MatchTwoCurves),	     7, { CURVE_EXPR, CURVE_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR },	CURVE_EXPR },
    { IPNP(CONTOUR),    IPNP(ContourFreeform),	     ANY_PARAM_NUM, { SURFACE_EXPR, PLANE_EXPR, SURFACE_EXPR, OLST_EXPR }, POLY_EXPR },
    { IPNP(PRINTER),    IPNP(PolygonRayIntersect),   3,	{ POLY_EXPR, POINT_EXPR, NUMERIC_EXPR },		NUMERIC_EXPR },
    { IPNP(SRINTER),    IPNP(SurfaceRayIntersect),   3,	{ SURFACE_EXPR, POINT_EXPR, VECTOR_EXPR },		POINT_EXPR },
    { IPNP(PLN3PTS),	IPNP(PlaneFrom3Points),	     3,	{ POINT_EXPR, POINT_EXPR, POINT_EXPR },			PLANE_EXPR },
    { IPNP(PTPTLN),	IPNP(PointFromPointLine),    3,	{ POINT_EXPR, POINT_EXPR, VECTOR_EXPR },		POINT_EXPR },
    { IPNP(PTLNPLN),	IPNP(PointFromLinePlane),    3,	{ POINT_EXPR, VECTOR_EXPR, PLANE_EXPR },		POINT_EXPR },
    { IPNP(PTSLNLN),	IPNP(TwoPointsFromLineLine), 4,	{ POINT_EXPR, VECTOR_EXPR, POINT_EXPR, VECTOR_EXPR },	OLST_EXPR },
    { IPNP(PTSCRCR),	IPNP(TwoPointsFromCircCirc), 6,	{ POINT_EXPR, VECTOR_EXPR, NUMERIC_EXPR, POINT_EXPR, VECTOR_EXPR, NUMERIC_EXPR }, OLST_EXPR },
    { IPNP(TNSCRCR),	IPNP(TwoTangentsFromCircCirc),5,{ POINT_EXPR, NUMERIC_EXPR, POINT_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, OLST_EXPR },
    { IPNP(PT3BARY),	IPNP(BaryCentric3Pts),	     4,	{ POINT_EXPR, POINT_EXPR, POINT_EXPR, POINT_EXPR },	POINT_EXPR },
    { IPNP(FFSPLIT),	IPNP(FreeFormSplitScalar),   1,	{ CURVE_EXPR | SURFACE_EXPR | MULTIVAR_EXPR },		OLST_EXPR },
    { IPNP(FFMERGE),	IPNP(FreeFormMergeScalar),   2,	{ OLST_EXPR, NUMERIC_EXPR },				CURVE_EXPR | SURFACE_EXPR | MULTIVAR_EXPR },
    { IPNP(FFPTTYPE),	IPNP(FreeFormPointType),     1,	{ FREE_FORM_EXPR }, NUMERIC_EXPR },
    { IPNP(FFGTYPE),	IPNP(FreeFormGeomType),      1,	{ FREE_FORM_EXPR }, NUMERIC_EXPR },
    { IPNP(FFORDER),	IPNP(FreeFormOrder),         1,	{ FREE_FORM_EXPR }, OLST_EXPR },
    { IPNP(FFMSIZE),	IPNP(FreeFormMeshSize),      1,	{ FREE_FORM_EXPR }, OLST_EXPR },
    { IPNP(FFMESH),	IPNP(MeshGeometry2Polylines),1,	{ FREE_FORM_EXPR }, POLY_EXPR },
    { IPNP(FFKNTVEC),	IPNP(FreeFormKnotVector),    1,	{ FREE_FORM_EXPR }, OLST_EXPR },
    { IPNP(FFCTLPTS),	IPNP(FreeFormControlPoints), 1,	{ FREE_FORM_EXPR }, OLST_EXPR },
    { IPNP(FFPOLES),	IPNP(FreeFormPoles),	     1,	{ FREE_FORM_EXPR }, NUMERIC_EXPR },
    { IPNP(CNVXHULL),   IPNP(ComputeConvexHull),     2,	{ CURVE_EXPR | SURFACE_EXPR | POLY_LIST_EXPR, NUMERIC_EXPR }, CURVE_EXPR | SURFACE_EXPR | POLY_LIST_EXPR },
    { IPNP(MSCIRC),     IPNP(ComputeMinSpanCirc),    2,	{ POLY_LIST_EXPR, NUMERIC_EXPR | OLST_EXPR },	CURVE_EXPR },
    { IPNP(CRVPTTAN),   IPNP(CrvPointTangents),	     3, { CURVE_EXPR, POINT_EXPR, NUMERIC_EXPR },		OLST_EXPR },
    { IPNP(CRV2TANS),   IPNP(CrvTwoTangents),	     2,	{ CURVE_EXPR, NUMERIC_EXPR },				OLST_EXPR },
    { IPNP(CRC2CRVTAN), IPNP(CircTangentsTwoCrvs),   4,	{ CURVE_EXPR, CURVE_EXPR, NUMERIC_EXPR, NUMERIC_EXPR },	OLST_EXPR },
    { IPNP(SRF3TANS),   IPNP(SrfThreeTangents),	     4, { OLST_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, OLST_EXPR },
    { IPNP(INSTANCE),   IPNP(GenerateInstance),	     2, { STRING_EXPR, MATRIX_EXPR },				INSTANCE_EXPR },
    { IPNP(CANGLEMAP),	IPNP(CrvAngleMap),	     4,	{ CURVE_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, SURFACE_EXPR | OLST_EXPR },
    { IPNP(CVIEWMAP),	IPNP(CrvViewMap),	     5,	{ CURVE_EXPR, CURVE_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, POLY_EXPR | SURFACE_EXPR | OLST_EXPR },
    { IPNP(CVISIBLE),   IPNP(CurveVisibility),	     3, { CURVE_EXPR, VECTOR_EXPR | POINT_EXPR, NUMERIC_EXPR },	OLST_EXPR },
    { IPNP(SVISIBLE),   IPNP(VisibConeDecomposition),3,	{ SURFACE_EXPR, NUMERIC_EXPR, NUMERIC_EXPR },		OLST_EXPR },
    { IPNP(GETATTR),    IPNP(GetObjectAttrib),	     2, { ANY_EXPR, STRING_EXPR },				OLST_EXPR },
    { IPNP(PTHMSPR),    IPNP(PointCoverOfHemiSphere),1,	{ NUMERIC_EXPR },					OLST_EXPR },
    { IPNP(PDECIMATE),  IPNP(GenDecimatedObject),    3, { POLY_EXPR, NUMERIC_EXPR, NUMERIC_EXPR },		POLY_EXPR },
    { IPNP(FFPTDIST),   IPNP(FreeformPointDistrib),  3, { CURVE_EXPR | SURFACE_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, OLST_EXPR },
    { IPNP(CENVOFF),    IPNP(CurveEnvelopeOffset),   3, { CURVE_EXPR, NUMERIC_EXPR, NUMERIC_EXPR },		SURFACE_EXPR },
    { IPNP(CBISECTOR2D),IPNP(CurveBisectorSkel2D),   6, { CURVE_EXPR | OLST_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, CURVE_EXPR },
    { IPNP(CBISECTOR3D),IPNP(CurveBisectorSkel3D),   2, { CURVE_EXPR | OLST_EXPR, NUMERIC_EXPR },    SURFACE_EXPR },
    { IPNP(CALPHASECTOR),IPNP(CurveAlphaSector),     2, { OLST_EXPR, NUMERIC_EXPR },    CURVE_EXPR | SURFACE_EXPR },
    { IPNP(SBISECTOR),  IPNP(SurfaceBisectorSkel),   2, { SURFACE_EXPR, POINT_EXPR },				SURFACE_EXPR },
    { IPNP(MBISECTOR),  IPNP(MultivarBisector),      5, { MULTIVAR_EXPR, MULTIVAR_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, MULTIVAR_EXPR },
    { IPNP(CVORONOICELL),IPNP(ComputeVoronoiCell),   1, { OLST_EXPR },						OLST_EXPR },
    { IPNP(SPRBISECT),  IPNP(SphericalBisector),     2, { OLST_EXPR, NUMERIC_EXPR },				OLST_EXPR | CURVE_EXPR | SURFACE_EXPR },
    { IPNP(BSCTPLNPT),  IPNP(PlanePointBisector),    2, { POINT_EXPR, NUMERIC_EXPR },				OLST_EXPR | SURFACE_EXPR },
    { IPNP(BSCTCYLPT),  IPNP(CylinPointBisector),    5, { POINT_EXPR, VECTOR_EXPR, NUMERIC_EXPR, POINT_EXPR, NUMERIC_EXPR }, OLST_EXPR | SURFACE_EXPR },
    { IPNP(BSCTCONPT),  IPNP(ConePointBisector),     5, { POINT_EXPR, VECTOR_EXPR, NUMERIC_EXPR, POINT_EXPR, NUMERIC_EXPR }, OLST_EXPR | SURFACE_EXPR },
    { IPNP(BSCTSPRPT),  IPNP(SpherePointBisector),   3, { POINT_EXPR, NUMERIC_EXPR, POINT_EXPR },		OLST_EXPR | SURFACE_EXPR },
    { IPNP(BSCTTRSPT),  IPNP(TorusPointBisector),    5, { POINT_EXPR, VECTOR_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, POINT_EXPR }, OLST_EXPR | SURFACE_EXPR },
    { IPNP(BSCTPLNLN),  IPNP(PlaneLineBisector),     2, { VECTOR_EXPR, NUMERIC_EXPR },				OLST_EXPR | SURFACE_EXPR },
    { IPNP(BSCTCONLN),  IPNP(ConeLineBisector),      4, { VECTOR_EXPR, NUMERIC_EXPR, VECTOR_EXPR, NUMERIC_EXPR }, OLST_EXPR | SURFACE_EXPR },
    { IPNP(BSCTSPRLN),  IPNP(SphereLineBisector),    3, { POINT_EXPR, NUMERIC_EXPR, NUMERIC_EXPR },		OLST_EXPR | SURFACE_EXPR },
    { IPNP(BSCTSPRPL),  IPNP(SpherePlaneBisector),   3, { POINT_EXPR, NUMERIC_EXPR, NUMERIC_EXPR },		OLST_EXPR | SURFACE_EXPR },
    { IPNP(BSCTCYLPL),  IPNP(CylinPlaneBisector),    4, { POINT_EXPR, VECTOR_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, OLST_EXPR | SURFACE_EXPR },
    { IPNP(BSCTCONPL),  IPNP(ConePlaneBisector),     4, { POINT_EXPR, VECTOR_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, OLST_EXPR | SURFACE_EXPR },
    { IPNP(BSCTCONCON), IPNP(ConeConeBisector),      5, { VECTOR_EXPR, NUMERIC_EXPR, VECTOR_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, OLST_EXPR | SURFACE_EXPR },
    { IPNP(BSCTCONCN2), IPNP(ConeConeBisector2),     6, { POINT_EXPR, VECTOR_EXPR, NUMERIC_EXPR, POINT_EXPR, VECTOR_EXPR, NUMERIC_EXPR }, SURFACE_EXPR },
    { IPNP(BSCTCONSPR), IPNP(ConeSphereBisector),    6, { POINT_EXPR, VECTOR_EXPR, NUMERIC_EXPR, POINT_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, SURFACE_EXPR | SURFACE_EXPR },
    { IPNP(BSCTCYLSPR), IPNP(CylinSphereBisector),   6, { POINT_EXPR, VECTOR_EXPR, NUMERIC_EXPR, POINT_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, SURFACE_EXPR | SURFACE_EXPR },
    { IPNP(BSCTSPRSPR), IPNP(SphereSphereBisector),  4, { POINT_EXPR, NUMERIC_EXPR, POINT_EXPR, NUMERIC_EXPR },	OLST_EXPR | SURFACE_EXPR },
    { IPNP(BSCTTRSSPR), IPNP(TorusSphereBisector),   6, { POINT_EXPR, VECTOR_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, POINT_EXPR, NUMERIC_EXPR }, SURFACE_EXPR },
    { IPNP(BSCTCYLCYL), IPNP(CylinCylinBisector),    6, { POINT_EXPR, VECTOR_EXPR, NUMERIC_EXPR, POINT_EXPR, VECTOR_EXPR, NUMERIC_EXPR }, SURFACE_EXPR },
    { IPNP(BSCTCONCYL), IPNP(ConeCylinBisector),     6, { POINT_EXPR, VECTOR_EXPR, NUMERIC_EXPR, POINT_EXPR, VECTOR_EXPR, NUMERIC_EXPR }, SURFACE_EXPR },
    { IPNP(SKEL2DINT),  IPNP(Skel2D2PrimsInter),     6, { POINT_EXPR | VECTOR_EXPR | CTLPT_EXPR | CURVE_EXPR,
							  POINT_EXPR | VECTOR_EXPR | CTLPT_EXPR | CURVE_EXPR,
							  POINT_EXPR | VECTOR_EXPR | CTLPT_EXPR | CURVE_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, OLST_EXPR },
    { "BBOX",  BBOXOBJ,	IPNP(ComputeBBOXObject),     1,	{ OLST_GEOM_EXPR },					OLST_EXPR },
    { IPNP(ORTHOTOMC),	IPNP(FreeFormOrthotomic),    3,	{ CURVE_EXPR | SURFACE_EXPR, POINT_EXPR, NUMERIC_EXPR }, CURVE_EXPR | SURFACE_EXPR },
    { IPNP(BOUNDARY),	IPNP(FreeFormBoundary),	     1, { POLY_EXPR | SURFACE_EXPR | TRIMSRF_EXPR | TRIVAR_EXPR }, POLY_EXPR | CURVE_EXPR | SURFACE_EXPR },
    { IPNP(SILHOUETTE),	IPNP(FreeFormSilhouette),    3,	{ POLY_EXPR | SURFACE_EXPR, VECTOR_EXPR, NUMERIC_EXPR }, POLY_EXPR },
    { IPNP(SASPCTGRPH),	IPNP(FreeFormTopoAspectGraph),1,{ SURFACE_EXPR },					POLY_EXPR },
    { IPNP(SSILINFL),	IPNP(FreeFormSilhInflections),4,{ SURFACE_EXPR, VECTOR_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, POLY_EXPR },
    { IPNP(POLARSIL),	IPNP(FreeFormPolarSilhouette),3,{ SURFACE_EXPR, VECTOR_EXPR, NUMERIC_EXPR },		POLY_EXPR },
    { IPNP(ISOCLINE),	IPNP(FreeFormIsocline),	     5, { SURFACE_EXPR, VECTOR_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, POLY_LIST_EXPR },
    { IPNP(TCRVTR),	IPNP(TrivIsoContourCurvature),3, { TRIVAR_EXPR, POINT_EXPR, NUMERIC_EXPR }, ANY_EXPR },
    { IPNP(MRCHCUBE),	IPNP(MarchCubeVolume),	     4, { OLST_EXPR, POINT_EXPR, NUMERIC_EXPR, NUMERIC_EXPR },  POLY_EXPR },
    { IPNP(TRIANGL),	IPNP(ConvertPolysTriangles), 2,	{ POLY_EXPR, NUMERIC_EXPR },				POLY_EXPR },
    { IPNP(MAXEDGELEN), IPNP(LimitTrianglesEdgeLen), 2, { POLY_EXPR, NUMERIC_EXPR },				POLY_EXPR },
    { IPNP(PTS2PLLN),	IPNP(ConvertPointsToPolys),  2,	{ OLST_EXPR, NUMERIC_EXPR },				POLY_EXPR },
    { IPNP(COVERPT),	IPNP(PointCoverPolyObj),     3,	{ POLY_EXPR, NUMERIC_EXPR, VECTOR_EXPR },	POLY_EXPR },
    { IPNP(COVERISO),	IPNP(IsoCoverTVObj),	     7,	{ TRIVAR_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, VECTOR_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, VECTOR_EXPR },	CURVE_EXPR },
    { IPNP(TVLOAD),	IPNP(LoadVolumeIntoTV),	     4, { STRING_EXPR, NUMERIC_EXPR, VECTOR_EXPR, VECTOR_EXPR }, TRIVAR_EXPR },
    { IPNP(DUALITY),    IPNP(FreeFormDuality),	     1, { CURVE_EXPR | SURFACE_EXPR },				CURVE_EXPR | SURFACE_EXPR },
    { IPNP(ALGSUM),	IPNP(TwoCrvsAlgebraicSum),   2,	{ CURVE_EXPR, CURVE_EXPR },				CURVE_EXPR },
    { IPNP(SWUNGASUM),	IPNP(TwoCrvsSwungAlgSum),    2,	{ CURVE_EXPR, CURVE_EXPR },				CURVE_EXPR },
    { IPNP(MPROMOTE),	IPNP(PromoteMultiVar),	     2, { MULTIVAR_EXPR, OLST_EXPR },				MULTIVAR_EXPR },
    { IPNP(MREVERSE),	IPNP(ReverseMultiVar),	     3, { MULTIVAR_EXPR, NUMERIC_EXPR, NUMERIC_EXPR },		MULTIVAR_EXPR },
    { IPNP(MFROMMV),	IPNP(MultiVarFromMultiVar),  3,	{ MULTIVAR_EXPR, NUMERIC_EXPR, NUMERIC_EXPR },		MULTIVAR_EXPR },
    { IPNP(MFROMMESH),	IPNP(MultiVarFromMVMesh),    3,	{ MULTIVAR_EXPR, NUMERIC_EXPR, NUMERIC_EXPR },		MULTIVAR_EXPR },
    { IPNP(MEVAL),      IPNP(EvalMultiVarObject),    2,	{ MULTIVAR_EXPR, OLST_EXPR },				CTLPT_EXPR },
    { IPNP(MZERO),      IPNP(EvalMultiVarZeros),     3,	{ OLST_EXPR, NUMERIC_EXPR, NUMERIC_EXPR },		CTLPT_EXPR },
    { IPNP(SPARABOLC),  IPNP(ParabolicCurvesOnSrf),  2,	{ SURFACE_EXPR,  NUMERIC_EXPR },			OLST_EXPR },
    { IPNP(RRINTER),    IPNP(RuledRuledInter),       6, { CURVE_EXPR, CURVE_EXPR, CURVE_EXPR, CURVE_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, OLST_EXPR },
    { IPNP(GGINTER),    IPNP(RingRingInter),         6, { CURVE_EXPR, CURVE_EXPR, CURVE_EXPR, CURVE_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, OLST_EXPR },
    { IPNP(SREVERSE),	IPNP(SurfaceReverse),	     1,	{ SURFACE_EXPR | TRIMSRF_EXPR },			SURFACE_EXPR | TRIMSRF_EXPR },
    { IPNP(CONICSEC),	IPNP(GenConicSection),	     4, { OLST_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, OLST_EXPR | CURVE_EXPR | SURFACE_EXPR },
    { IPNP(ELLIPSE3PT),	IPNP(GenEllipse3Points),     4, { POINT_EXPR, POINT_EXPR, POINT_EXPR, NUMERIC_EXPR },	OLST_EXPR },
    { IPNP(QUADRIC),	IPNP(GenQuadric),	     1,	{ OLST_EXPR },						SURFACE_EXPR },
    { IPNP(CNC2QUAD),	IPNP(PromoteConicToQuadric), 2,	{ OLST_EXPR, NUMERIC_EXPR },				OLST_EXPR },
    { IPNP(IMPLCTRANS),	IPNP(TransformImplicit),     3,	{ NUMERIC_EXPR, OLST_EXPR, MATRIX_EXPR },		OLST_EXPR },
    { IPNP(IRITSTATE),	IPNP(SetIritState),	     2, { STRING_EXPR, NUMERIC_EXPR | STRING_EXPR },		NUMERIC_EXPR | STRING_EXPR },
    { IPNP(ISGEOM),	IPNP(WasIsGeometry),	     3, { ANY_EXPR, NUMERIC_EXPR, NUMERIC_EXPR },		OLST_EXPR },
    { IPNP(SMOOTHNRML), IPNP(ComputeSmoothPolyNormals),2, { POLY_LIST_EXPR, NUMERIC_EXPR },		POLY_LIST_EXPR },
    { IPNP(FIXPLNRML),  IPNP(FixPolyNormals),	     2, { POLY_LIST_EXPR, NUMERIC_EXPR },		POLY_LIST_EXPR },
    { IPNP(FIXPLGEOM),  IPNP(FixPolyGeometry),	     3, { POLY_LIST_EXPR, NUMERIC_EXPR, NUMERIC_EXPR },	POLY_LIST_EXPR },
    { IPNP(BLOSSOM),    IPNP(BlossomEvaluation),     2, { CURVE_EXPR, OLST_EXPR },				CTLPT_EXPR },
    { IPNP(KNOTCLEAN),  IPNP(CleanRefinedKnots),     2, { CURVE_EXPR, NUMERIC_EXPR },				CURVE_EXPR },
    { IPNP(KNOTREMOVE), IPNP(RemoveKnots),	     4, { CURVE_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, CURVE_EXPR },
    { IPNP(RAYTRAPS),   IPNP(MultivarRayTrap),	     3, { OLST_EXPR, NUMERIC_EXPR, NUMERIC_EXPR },		OLST_EXPR },
    { IPNP(CMOEBIUS),   IPNP(MoebiusCurveTrans),     2, { CURVE_EXPR, NUMERIC_EXPR },				CURVE_EXPR },
    { IPNP(SMOEBIUS),   IPNP(MoebiusSurfaceTrans),   3, { SURFACE_EXPR, NUMERIC_EXPR, NUMERIC_EXPR },		SURFACE_EXPR },
    { IPNP(RFLCTLN),    IPNP(ReflectionLines),	     4, { SURFACE_EXPR, VECTOR_EXPR, ANY_EXPR, NUMERIC_EXPR },	OLST_EXPR },
    { IPNP(CAREA),      IPNP(CrvAreaIntergal),	     1, { CURVE_EXPR },						CURVE_EXPR },
    { IPNP(SVOLUME),    IPNP(SrfVolumeIntergal),     3, { SURFACE_EXPR, NUMERIC_EXPR, NUMERIC_EXPR },		SURFACE_EXPR | NUMERIC_EXPR },
    { IPNP(SMOMENTS),   IPNP(SrfMomentIntergal),     5, { SURFACE_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, SURFACE_EXPR | NUMERIC_EXPR },
    { IPNP(TVZRJACOB),	IPNP(TrivZeroJacobian),	     4, { TRIVAR_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR | OLST_EXPR }, POLY_EXPR },
    { IPNP(CRVKERNEL),	IPNP(CrvKernel),	     5,	{ CURVE_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR | OLST_EXPR, NUMERIC_EXPR },POLY_EXPR | TRIVAR_EXPR },
    { IPNP(SRFKERNEL),	IPNP(SrfKernel),	     3,	{ SURFACE_EXPR, NUMERIC_EXPR, NUMERIC_EXPR },		POLY_EXPR },
    { IPNP(CRVDIAMTR),	IPNP(CrvDiameter),	     4,	{ CURVE_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR },POINT_EXPR | OLST_EXPR },
    { IPNP(SACCESS),	IPNP(SurfaceAccessibility),  6,	{ SURFACE_EXPR, ANY_EXPR, SURFACE_EXPR, ANY_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, POLY_EXPR },
    { IPNP(SFLECNODAL), IPNP(SurfaceFlecnodals),     5, { SURFACE_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, POLY_EXPR },
    { IPNP(SRF2TANS),   IPNP(SurfaceBiTangents),     5, { SURFACE_EXPR | OLST_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, POLY_EXPR },
    { IPNP(NRMLCONE),	IPNP(EvalSrfNormalsCone),    1,	{ SURFACE_EXPR },					OLST_EXPR },
    { IPNP(PTREGISTER),	IPNP(RegisterPointSet),      4,	{ OLST_EXPR, OLST_EXPR | SURFACE_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, MATRIX_EXPR },
    { IPNP(GETNAME),	IPNP(GetSubObjectName),      2,	{ OLST_EXPR, NUMERIC_EXPR },				STRING_EXPR },
    { IPNP(SDDMMAP),	IPNP(EvalDDMForSrf),	     5,	{ POLY_EXPR | SURFACE_EXPR, ANY_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, ANY_EXPR },
    { IPNP(MVEXPLICIT), IPNP(InptEvalMVExplicit),    2,	{ NUMERIC_EXPR, STRING_EXPR },				MULTIVAR_EXPR },
    { IPNP(ANALYFIT), 	IPNP(AnalyticSrfFit),	     4,	{ OLST_EXPR, OLST_EXPR, NUMERIC_EXPR, NUMERIC_EXPR },	OLST_EXPR },
    { IPNP(PLANECLIP), 	IPNP(PolyPlaneClipping),     2,	{ POLY_EXPR, PLANE_EXPR },				OLST_EXPR },
    { IPNP(SRFFFORM), 	IPNP(SrfFundamentalForms),   2,	{ SURFACE_EXPR, NUMERIC_EXPR },				OLST_EXPR },
    { IPNP(SCRVTREVAL), IPNP(EvalSurfaceCurvature),  4, { SURFACE_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, OLST_EXPR },
    { IPNP(SASYMPEVAL), IPNP(EvalSurfaceAsympDir),   4, { SURFACE_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, OLST_EXPR },
    { IPNP(CARCLEN),	IPNP(CrvArcLenApprox),       3, { CURVE_EXPR, NUMERIC_EXPR, NUMERIC_EXPR },		CURVE_EXPR },
    { IPNP(TEXTWARP),   IPNP(TextWarpThroughSrf),    6, { SURFACE_EXPR, STRING_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, OLST_EXPR },
    { IPNP(SRAYCLIP),   IPNP(BezierRayClipping),     3,	{ POINT_EXPR, VECTOR_EXPR, SURFACE_EXPR },		OLST_EXPR },
    { IPNP(PPROPFTCH),	IPNP(PolyPropFetch),	     3,	{ POLY_EXPR, NUMERIC_EXPR, OLST_EXPR },			POLY_EXPR },
    { IPNP(FITPMODEL),  IPNP(FitPrim2PolyModel),     4, { POLY_EXPR, NUMERIC_EXPR, NUMERIC_EXPR, NUMERIC_EXPR }, OLST_EXPR },
    { IPNP(UVPOLY),     IPNP(SetUVsToPolys),         2, { POLY_EXPR, OLST_EXPR }, 				POLY_EXPR },
    { IPNP(MPOWER),     IPNP(GenPowerMVObject),      2, { OLST_EXPR, OLST_EXPR }, 				MULTIVAR_EXPR },
    { IPNP(MBEZIER),    IPNP(GenBezierMVObject),     2, { OLST_EXPR, OLST_EXPR }, 				MULTIVAR_EXPR },
    { IPNP(MBSPLINE),   IPNP(GenBsplineMVObject),    4, { OLST_EXPR, OLST_EXPR, OLST_EXPR, OLST_EXPR }, 	MULTIVAR_EXPR },
    { IPNP(CBIARCS),    IPNP(CrvBiArcApprox),        3, { CURVE_EXPR, NUMERIC_EXPR, NUMERIC_EXPR },	 	OLST_EXPR },
    { IPNP(SPLITLST),	IPNP(SplitLnkList2ObjList),  1, { ANY_EXPR },                                           OLST_EXPR },
    { IPNP(SETCOVER),   IPNP(MinSetCover),	     2, { OLST_EXPR, NUMERIC_EXPR },				OLST_EXPR },
    { IPNP(DIST2FF),	IPNP(DistanceTwoFreeforms),  3, { CURVE_EXPR | SURFACE_EXPR, CURVE_EXPR | SURFACE_EXPR, NUMERIC_EXPR }, SURFACE_EXPR | MULTIVAR_EXPR },
    { IPNP(FFRIGIDSIM),	IPNP(FreeformCompareUptoRigidScale2D), 3, { CURVE_EXPR | SURFACE_EXPR, CURVE_EXPR | SURFACE_EXPR, NUMERIC_EXPR }, NUMERIC_EXPR | OLST_EXPR },
    { IPNP(FFCMPCRVS),  IPNP(CurvesCompare),	     3, { CURVE_EXPR, CURVE_EXPR, NUMERIC_EXPR },		OLST_EXPR },
    { IPNP(ANIMEVAL),	IPNP(EvalAnimationTime),     3,	{ NUMERIC_EXPR, ANY_EXPR, NUMERIC_EXPR },		ANY_EXPR },
    { IPNP(CUBICCRVS),	IPNP(ApproxCrvAsCubics),     3,	{ CURVE_EXPR, NUMERIC_EXPR, NUMERIC_EXPR },		OLST_EXPR },
    { IPNP(QUADCRVS),	IPNP(ApproxCrvAsQuadratics), 3,	{ CURVE_EXPR, NUMERIC_EXPR, NUMERIC_EXPR },		OLST_EXPR },
};
int ObjFuncTableSize = sizeof(ObjFuncTable) / sizeof(ObjFuncTableType);

GenFuncTableType GenFuncTable[] = {
    { IPNP(EXIT),	IPNP(IritExit0),		0,	{ 0 } },
    { "RESET",  IRITRESET,IPNP(IritReset),		0,	{ 0 } },
    { IPNP(VIEWOBJ),	IPNP(WndwViewObject),		1,	{ ANY_EXPR } },
    { IPNP(VIEWSET),	IPNP(WndwSetCrntDisplay),	1,	{ NUMERIC_EXPR } },
    { IPNP(CHDIR),	IPNP(DosChangeDir),		1,	{ STRING_EXPR } },
    { IPNP(INCLUDE),	IPNP(InptPrsrFileInclude),	1,	{ STRING_EXPR } },
    { IPNP(SAVE),	IPNP(SaveObjectInFile),	        2,	{ STRING_EXPR, ANY_EXPR } },
    { "FREE",	FREEOBJ,   IPNP(FreeIritObject),	1,	{ ANY_EXPR } },
    { "FNFREE",	FREEFUNC,  IPNP(InptEvalFreeFunc),      1,	{ STRING_EXPR } },
    { "IF",	IFCOND,    IPNP(InptEvalIfCondition),	ANY_PARAM_NUM, { 0 } },
    { "FOR",	FORLOOP,   IPNP(InptEvalForLoop),	4,	{ NUMERIC_EXPR,	NUMERIC_EXPR, NUMERIC_EXPR, ANY_EXPR } },
    { "WHILE",  WHILELOOP, IPNP(InptEvalWhileLoop),     2,      { NUMERIC_EXPR, ANY_EXPR } },
    { "HELP",	PRHELP,	   IPNP(InptEvalPrintHelp),     1,	{ STRING_EXPR } },
    { IPNP(VARLIST), 	IPNP(PrintIritObjectList),	0,	{ 0 } },
    { IPNP(SYSTEM),	IPNP(DosSystem),		1,	{ STRING_EXPR } },
    { IPNP(LOGFILE), 	IPNP(WndwLogPrint),		1,	{ STRING_EXPR | NUMERIC_EXPR } },
    { IPNP(COLOR),	IPNP(SetObjectAttrColor), 	2,	{ OLST_GEOM_EXPR, NUMERIC_EXPR } },
    { IPNP(AWIDTH),	IPNP(SetObjectAttrWidth), 	2,	{ OLST_GEOM_EXPR, NUMERIC_EXPR } },
    { IPNP(ADWIDTH),	IPNP(SetObjectAttrDWidth), 	2,	{ OLST_GEOM_EXPR, NUMERIC_EXPR } },
    { IPNP(SNOC),	IPNP(SnocList),		        2,	{ ANY_EXPR, OLST_EXPR } },
    { IPNP(ATTRIB),	IPNP(SetObjectAttrib),	        3,	{ ANY_EXPR, STRING_EXPR, ANY_EXPR } },
    { IPNP(ATTRPROP),	IPNP(SetObjectAttribProp),	3,	{ ANY_EXPR, STRING_EXPR, ANY_EXPR } },
    { IPNP(CPATTR),	IPNP(CopyObjectAllAttribs),	2,	{ ANY_EXPR, ANY_EXPR } },
    { IPNP(RMATTR),	IPNP(RemoveObjectAttrib),	2,	{ ANY_EXPR, STRING_EXPR } },
    { IPNP(FFCOMPAT),	IPNP(MakeFreeFormCompatible),	2,	{ CURVE_EXPR | SURFACE_EXPR | TRIVAR_EXPR, CURVE_EXPR | SURFACE_EXPR | TRIVAR_EXPR } },
    { IPNP(MSLEEP),	IPNP(MilisecondSleep),	        1,	{ NUMERIC_EXPR } },
    { "PRINTF", IRITPRINT,    IPNP(IritObjectPrintf),	2,	{ STRING_EXPR, OLST_EXPR } },
    { "PRINTFILE",IRITPRNTFL, IPNP(IritObjectPrintfSetFile),1,	{ STRING_EXPR } },
    { "ERROR",  IRITERROR,    "IritNonFatalError", (void (*)()) IritNonFatalError,	1, { STRING_EXPR } },
    { IPNP(CLNTWRITE),	IPNP(ClientWrite),		2,	{ NUMERIC_EXPR, ANY_EXPR } },
    { IPNP(CLNTCLOSE),	IPNP(ClientClose),		2,	{ NUMERIC_EXPR, NUMERIC_EXPR } },
    { IPNP(SETNAME),	IPNP(SetSubObjectName),	        3,	{ OLST_EXPR, NUMERIC_EXPR, STRING_EXPR } },
    { IPNP(EXEC),	IPNP(ExecOneLine),		1,	{ STRING_EXPR } },
    { IPNP(IQUERY),	IPNP(IritQuery),		1,	{ NUMERIC_EXPR } },
    { IPNP(INSERTPOLY),	"InsertPolyToPoly", (void (*)()) InsertPolyToPoly,	2, { POLY_EXPR, POLY_EXPR } }

#ifdef DEBUG_IRIT_MALLOC
    , { "IDYNMEM",IDYNMEM,	IPNP(IritCheckMarkDynMemory),	1,	{ NUMERIC_EXPR } }
#endif /* DEBUG_IRIT_MALLOC */
};
int GenFuncTableSize = sizeof(GenFuncTable) / sizeof(GenFuncTableType);

ConstantTableType ConstantTable[] = {
    { "PI",	M_PI },

    { "ON",	1.0 },
    { "TRUE",	1.0 },
    { "OFF",	0.0 },
    { "FALSE",	0.0 },

    { "COL",    (double) CAGD_CONST_U_DIR },
    { "ROW",    (double) CAGD_CONST_V_DIR },
    { "DEPTH",  (double) TRIV_CONST_W_DIR },

    { "CLIENTS_ALL", (double) IP_CLNT_BROADCAST_ALL_HANDLES },

    { "KV_OPEN", (double) KV_UNIFORM_OPEN },
    { "KV_DISC_OPEN", (double) KV_UNIFORM_DISCONT_OPEN },
    { "KV_FLOAT", (double) KV_UNIFORM_FLOAT },
    { "KV_PERIODIC", (double) KV_UNIFORM_PERIODIC },

    { "PARAM_NIELFOL", (double) CAGD_NIELSON_FOLEY_PARAM },
    { "PARAM_CHORD", (double) CAGD_CHORD_LEN_PARAM },
    { "PARAM_CENTRIP", (double) CAGD_CENTRIPETAL_PARAM },
    { "PARAM_UNIFORM", (double) CAGD_UNIFORM_PARAM },

    { "E1", (double) CAGD_PT_E1_TYPE },
    { "E2", (double) CAGD_PT_E2_TYPE },
    { "E3", (double) CAGD_PT_E3_TYPE },
    { "E4", (double) CAGD_PT_E4_TYPE },
    { "E5", (double) CAGD_PT_E5_TYPE },
    { "E6", (double) CAGD_PT_E6_TYPE },
    { "E7", (double) CAGD_PT_E7_TYPE },
    { "E8", (double) CAGD_PT_E8_TYPE },
    { "E9", (double) CAGD_PT_E9_TYPE },

    { "P1", (double) CAGD_PT_P1_TYPE },
    { "P2", (double) CAGD_PT_P2_TYPE },
    { "P3", (double) CAGD_PT_P3_TYPE },
    { "P4", (double) CAGD_PT_P4_TYPE },
    { "P5", (double) CAGD_PT_P5_TYPE },
    { "P6", (double) CAGD_PT_P6_TYPE },
    { "P7", (double) CAGD_PT_P7_TYPE },
    { "P8", (double) CAGD_PT_P8_TYPE },
    { "P9", (double) CAGD_PT_P9_TYPE },

    { "UNDEF_TYPE",   (double) IP_OBJ_UNDEF },
    { "POLY_TYPE",    (double) IP_OBJ_POLY },
    { "NUMERIC_TYPE", (double) IP_OBJ_NUMERIC },
    { "POINT_TYPE",   (double) IP_OBJ_POINT },
    { "VECTOR_TYPE",  (double) IP_OBJ_VECTOR },
    { "PLANE_TYPE",   (double) IP_OBJ_PLANE },
    { "MATRIX_TYPE",  (double) IP_OBJ_MATRIX },
    { "CURVE_TYPE",   (double) IP_OBJ_CURVE },
    { "SURFACE_TYPE", (double) IP_OBJ_SURFACE },
    { "STRING_TYPE",  (double) IP_OBJ_STRING },
    { "CTLPT_TYPE",   (double) IP_OBJ_CTLPT },
    { "LIST_TYPE",    (double) IP_OBJ_LIST_OBJ },
    { "TRIVAR_TYPE",  (double) IP_OBJ_TRIVAR },
    { "TRISRF_TYPE",  (double) IP_OBJ_TRISRF },
    { "TRIMSRF_TYPE", (double) IP_OBJ_TRIMSRF },
    { "MODEL_TYPE",   (double) IP_OBJ_MODEL },
    { "MULTIVAR_TYPE",(double) IP_OBJ_MULTIVAR },

    { "BEZIER_TYPE", (double) FF_BEZIER_TYPE },
    { "BSPLINE_TYPE",(double) FF_BSPLINE_TYPE },
    { "POWER_TYPE",  (double) FF_POWER_TYPE },
    { "GREGORY_TYPE",(double) FF_GREGORY_TYPE },

    { "GEOM_CONST",      (double) CAGD_GEOM_CONST },
    { "GEOM_LINEAR",     (double) CAGD_GEOM_LINEAR },
    { "GEOM_CIRCULAR",   (double) CAGD_GEOM_CIRCULAR },
    { "GEOM_PLANAR",     (double) CAGD_GEOM_PLANAR },
    { "GEOM_SPHERICAL",  (double) CAGD_GEOM_SPHERICAL },
    { "GEOM_SRF_OF_REV", (double) CAGD_GEOM_SRF_OF_REV },
    { "GEOM_EXTRUSION",  (double) CAGD_GEOM_EXTRUSION },
    { "GEOM_RULED_SRF",  (double) CAGD_GEOM_RULED_SRF },
    { "GEOM_DEVELOP_SRF",(double) CAGD_GEOM_DEVELOP_SRF },
    { "GEOM_SWEEP",      (double) CAGD_GEOM_SWEEP_SRF },

    { "BLACK",  (double) IG_IRIT_BLACK },
    { "BLUE",	(double) IG_IRIT_BLUE },
    { "GREEN",	(double) IG_IRIT_GREEN },
    { "CYAN",	(double) IG_IRIT_CYAN },
    { "RED",	(double) IG_IRIT_RED },
    { "MAGENTA",(double) IG_IRIT_MAGENTA },
    { "YELLOW", (double) IG_IRIT_YELLOW },
    { "WHITE",  (double) IG_IRIT_WHITE },

    { "MSDOS",  (double) MACHINE_MSDOS },
    { "SGI",    (double) MACHINE_SGI },
    { "HP",     (double) MACHINE_HP },
    { "SUN",    (double) MACHINE_SUN },
    { "APOLLO", (double) MACHINE_APOLLO },
    { "UNIX",   (double) MACHINE_UNIX },
    { "IBMOS2", (double) MACHINE_IBMOS2 },
    { "IBMNT",  (double) MACHINE_IBMNT },
    { "AMIGA",  (double) MACHINE_AMIGA },
};
int ConstantTableSize = sizeof(ConstantTable) / sizeof(ConstantTableType);

UserDefinedFuncDefType
    *UserDefinedFuncList = NULL;

#ifndef IRIT_QUIET_STRINGS

/*****************************************************************************
* DESCRIPTION:                                                               *
*   Prints to stdout the definition of all available functions in IRIT.      *
*                                                                            *
* PARAMETERS:                                                                *
*   None                                                                     *
*                                                                            *
* RETURN VALUE:                                                              *
*   void                                                                     *
*****************************************************************************/
static void IritQueryFunctions(void)
{
    int i, l;
    UserDefinedFuncDefType *UserFunc;

    for (i = 0; i < NumFuncTableSize; i++) {
	NumFuncTableType
	    *NumEntry = &NumFuncTable[i];
	
	printf("%sDEFFUNC 00002 %-10s %3d [", GUI_PROMPT,
	       NumEntry -> FuncName, NumEntry -> NumOfParam);
	if (NumEntry -> NumOfParam != ANY_PARAM_NUM) {
	    for (l = 0; l < NumEntry -> NumOfParam; l++)
		printf("%s%05x",
		       l == 0 ? "" : " ", NumEntry -> ParamObjType[l]);
	}
	printf("]\n");
    }

    for (i = 0; i < ObjFuncTableSize; i++) {
	ObjFuncTableType
	    *ObjEntry = &ObjFuncTable[i];
	
	printf("%sDEFFUNC %05x %-10s %3d [", GUI_PROMPT, ObjEntry -> RetType,
	       ObjEntry -> FuncName, ObjEntry -> NumOfParam);
	if (ObjEntry -> NumOfParam != ANY_PARAM_NUM) {
	    for (l = 0; l < ObjEntry -> NumOfParam; l++)
		printf("%s%05x",
		       l == 0 ? "" : " ", ObjEntry -> ParamObjType[l]);
	}
	printf("]\n");
    }

    for (i = 0; i < GenFuncTableSize; i++) {
	GenFuncTableType
	    *GenEntry = &GenFuncTable[i];
	
	printf("%sDEFFUNC 00000 %-10s %3d [", GUI_PROMPT,
	       GenEntry -> FuncName, GenEntry -> NumOfParam);
	if (GenEntry -> NumOfParam != ANY_PARAM_NUM) {
	    for (l = 0; l < GenEntry -> NumOfParam; l++)
		printf("%s%05x",
		       l == 0 ? "" : " ", GenEntry -> ParamObjType[l]);
	}
	printf("]\n");
    }

    for (UserFunc = UserDefinedFuncList;
	 UserFunc != NULL;
	 UserFunc = UserFunc -> Pnext) {
	int n = IPObjListLen(UserFunc -> Params);

	printf("%sDEFUFUNC %05x %-10s %3d [", GUI_PROMPT,
	       UserFunc -> IsFunction ? ANY_EXPR : 0,
	       UserFunc -> FuncName, n);
	for (l = 0; l < n; l++)
	    printf("%s%05x", l == 0 ? "" : " ", ANY_EXPR);
	printf("]\n");
    }

    for (i = 0; i < ConstantTableSize; i++) {
	ConstantTableType
	    *GenEntry = &ConstantTable[i];
	
	printf("%sDEFCONST %-10s %-17.15f\n", GUI_PROMPT,
	       GenEntry -> FuncName, GenEntry -> Value);
    }
}

/*****************************************************************************
* DESCRIPTION:                                                               *
*   Prints to stdout the definition of all available functions in IRIT.      *
*                                                                            *
* PARAMETERS:                                                                *
*   None                                                                     *
*                                                                            *
* RETURN VALUE:                                                              *
*   void                                                                     *
*****************************************************************************/
static void IritQueryKeywords(void)
{
    int i;

    for (i = 0; i < NumFuncTableSize; i++)
	printf("%s\n", NumFuncTable[i].FuncName);

    for (i = 0; i < ObjFuncTableSize; i++)
	printf("%s\n", ObjFuncTable[i].FuncName);

    for (i = 0; i < GenFuncTableSize; i++)
	printf("%s\n", GenFuncTable[i].FuncName);

    for (i = 0; i < ConstantTableSize; i++)
	printf("%s\n", ConstantTable[i].FuncName);
}

#endif /* !IRIT_QUIET_STRINGS */

/*****************************************************************************
* DESCRIPTION:                                                               *
*   Prints to stdout queries on the IRIT state.                              *
*                                                                            *
* PARAMETERS:                                                                *
*   RealType *:  Type of query.                                              *
*                                                                            *
* RETURN VALUE:                                                              *
*   void                                                                     *
*****************************************************************************/
static void IritQuery(RealType *RQuery)
{
#ifndef IRIT_QUIET_STRINGS
    int Query = REAL_PTR_TO_INT(RQuery);

    switch (Query) {
	case 1:
	    IritQueryFunctions();
            break;
	case 2:
	    IritQueryKeywords();
            break;
    }
#endif /* !IRIT_QUIET_STRINGS */
}
