/******************************************************************************
* User_lib.h - Header file for the User Interaction library.		      *
* This header is also the interface header to the world.		      *
*******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                 *
*******************************************************************************
* Written by Gershon Elber, Mar. 90.					      *
******************************************************************************/

#ifndef USER_LIB_H
#define USER_LIB_H

#include "cagd_lib.h"
#include "iritprsr.h"

typedef enum {
    USER_ERR_WRONG_SRF,
    USER_ERR_MISSING_ATTRIB,
    USER_ERR_WRONG_ANGLE,
    USER_ERR_INVALID_PLANE,
    USER_ERR_RATIONAL_NO_SUPPORT,
    USER_ERR_NON_CRV_OBJ_IN_FONT,
    USER_ERR_NO_ADJ_INFO,
    USER_ERR_NO_NRML_INFO,
    USER_ERR_NO_CRVTR_INFO,
    USER_ERR_EXPCT_REG_TRIANG,
    USER_ERR_EXPCT_POLY_OBJ,
    USER_ERR_EXPCT_SRF_OBJ,
    USER_ERR_EXPCT_VRTX_NRMLS,
    USER_ERR_EXPCT_VRTX_UVS,
    USER_ERR_UNDEFINE_ERR
} UserFatalErrorType;

typedef enum {					/* Type of surface marching. */
  USER_SRF_MARCH_ISO_PARAM,
    USER_SRF_MARCH_ISOCLINES,
    USER_SRF_MARCH_ORTHOCLINES,
    USER_SRF_MARCH_PRIN_CRVTR
} UserSrfMarchType;

typedef int (*UserRegisterTestConverganceFuncType)(RealType CrntDist, int i);
typedef int (*UserCntrIsValidCntrPtFuncType)(CagdSrfStruct *Srf,
					     CagdRType U,
					     CagdRType V);

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

/* Surface-Ray intersection. */

VoidPtr IntrSrfRayPreprocessSrf(CagdSrfStruct *Srf, int FineNess);
void IntrSrfRayFreePreprocess(VoidPtr Handle);
CagdBType IntrSrfRayTestRay(VoidPtr Handle,
			    CagdPType RayOrigin,
			    CagdVType RayDir,
			    CagdUVType InterUV);

/* Surface-plane contouring. */

IPPolygonStruct *UserCntrSrfWithPlane(CagdSrfStruct *Srf,
                                      PlaneType Plane,
                                      RealType FineNess);
IPPolygonStruct *UserCntrEvalToE3(CagdSrfStruct *Srf,
				  IPPolygonStruct *Cntrs,
				  UserCntrIsValidCntrPtFuncType ValidCntrPtFunc);

/* Linear Bsplines vs polylines convertion. */

CagdCrvStruct *UserPolyline2LinBsplineCrv(IPPolygonStruct *Poly,
					  CagdBType FilterDups);
CagdCrvStruct *UserPolylines2LinBsplineCrvs(IPPolygonStruct *Polys,
					    CagdBType FilterDups);

/* Surface cone decomposition. */

IPObjectStruct *UserSrfVisibConeDecomp(CagdSrfStruct *Srf,
				       CagdRType Resolution,
				       CagdRType ConeSize);
TrimSrfStruct *UserVisibilityClassify(IPObjectStruct *SclrSrf,
					  TrimSrfStruct *TrimmedSrfs);
IPObjectStruct *UserViewingConeSrfDomains(CagdSrfStruct *Srf,
					      CagdSrfStruct *NSrf,
					      IPPolygonStruct *ConeDirs,
					      CagdRType Resolution,
					      CagdRType ConeSize,
					      CagdRType Euclidean);
IPPolygonStruct *UserSrfTopoAspectGraph(CagdSrfStruct *PSrf,
					CagdRType Tolerance);

/* Surface marching. */

IPPolygonStruct *UserMarchOnSurface(UserSrfMarchType MarchType,
				    CagdUVType UVOrig,
				    CagdVType DirOrig,
				    CagdSrfStruct *Srf,
				    CagdSrfStruct *NSrf,
				    CagdSrfStruct *DuSrf,
				    CagdSrfStruct *DvSrf,
				    CagdRType Length,
				    CagdRType FineNess,
				    CagdBType ClosedInU,
				    CagdBType ClosedInV);
IPPolygonStruct *UserMarchOnPolygons(IPObjectStruct *PObj,
				     UserSrfMarchType MarchType,
				     IPPolygonStruct *PlHead,
				     IPVertexStruct *VHead,
				     CagdRType Length);

/* Curve/Surface visibility and accessibility. */

IPObjectStruct *UserCrvViewMap(CagdCrvStruct *Crv,
			       CagdCrvStruct *ViewCrv,
			       CagdRType SubTol,
			       CagdRType NumTol,
			       CagdBType TrimInvisible);
IPObjectStruct *UserCrvAngleMap(CagdCrvStruct *Crv,
				CagdRType Tolerance,
				CagdRType Angle);
IPObjectStruct *UserCrvOMDiagExtreme(CagdCrvStruct *Crv,
				     IPObjectStruct *OM,
				     int DiagExtRes);

CagdCrvStruct *UserCrvVisibleRegions(CagdCrvStruct *Crv,
				     CagdRType *View,
				     CagdRType Tolerance);

TrimSrfStruct *UserMoldReliefAngle2Srf(CagdSrfStruct *Srf,
				       CagdVType VDir,
				       CagdRType Theta,
				       int MoreThanTheta,
				       CagdRType Tolerance);
CagdSrfStruct *UserMoldRuledRelief2Srf(CagdSrfStruct *Srf,
				       CagdVType VDir,
				       CagdRType Theta,
				       CagdRType Tolerance);

/* Minimal distance to polylines/gons. */

RealType UserMinDistLineBBox(PointType LinePos,
			     VectorType LineDir,
			     BBoxType BBox);
RealType UserMinDistLinePolygonList(PointType LinePos,
				    VectorType LineDir,
				    IPPolygonStruct *Pls,
				    IPPolygonStruct **MinPl,
				    PointType MinPt,
				    RealType *HitDepth,
				    RealType *IndexFrac);
RealType UserMinDistLinePolylineList(PointType LinePos,
				     VectorType LineDir,
				     IPPolygonStruct *Pls,
				     int PolyClosed,
				     IPPolygonStruct **MinPl,
				     PointType MinPt,
				     RealType *IndexFrac);
RealType UserMinDistPointPolylineList(PointType Pt,
				      IPPolygonStruct *Pls,
				      IPPolygonStruct **MinPl,
				      IPVertexStruct **MinV,
				      int *Index);

/* Surface surface intersection. */

int UserSrfSrfInter(CagdSrfStruct *Srf1,
		    CagdSrfStruct *Srf2,
		    int Euclidean,
		    CagdRType Eps,
		    int AlignSrfs,
		    CagdCrvStruct **Crvs1,
		    CagdCrvStruct **Crvs2);

/* Jacobian of trivariates and zero set. */

IPObjectStruct *UserTVZeroJacobian(TrivTVStruct *Tv,
				   CagdBType Euclidean,
				   int SkipRate,
				   CagdRType Fineness[3]);
IPObjectStruct *UserTrivarZeros(TrivTVStruct *Tv,
				TrivTVStruct *TvEuclidean,
				int SkipRate,
				CagdRType Fineness[3]);

/* Z direction collision. */
RealType UserTwoObjMaxZRelMotion(IPObjectStruct *PObj1,
				 IPObjectStruct *PObj2,
				 RealType FineNess,
				 int NumIters);

/* Geometry registration. */

int UserRegisterTestConvergance(RealType Dist, int i);
RealType UserRegisterTwoPointSets(int n1,
				  PointType *PtsSet1,
				  int n2,
				  PointType *PtsSet2,
				  RealType AlphaConverge,
				  RealType Tolerance,
				  UserRegisterTestConverganceFuncType
				      RegisterTestConvergance,
				  MatrixType RegMat);
RealType UserRegisterPointSetSrf(int n,
				 PointType *PtsSet,
				 CagdSrfStruct *Srf,
				 RealType AlphaConverge,
				 RealType Tolerance,
				 UserRegisterTestConverganceFuncType
				     RegisterTestConvergance,
				 MatrixType RegMat);

/* Bump mapping. */

IPObjectStruct *UserDDMPolysOverSrf(CagdSrfStruct *Srf,
				    IPObjectStruct *Texture,
				    RealType UDup,
				    RealType VDup,
				    int LclUV);
IPObjectStruct *UserDDMPolysOverPolys(IPObjectStruct *PlSrf,
				      IPObjectStruct *Texture,
				      RealType UDup,
				      RealType VDup,
				      int LclUV);


/* Freeform kernels. */

IPObjectStruct *UserSrfKernel(CagdSrfStruct *Srf,
			      CagdRType Tolerance,
			      int SkipRate);

/* Freeform umbilical. */

MvarPtStruct *UserSrfUmbilicalPts(CagdSrfStruct *Srf,
				  CagdRType SubTol,
				  CagdRType NumTol);

/* Warping of text using composition with surfaces. */

IPObjectStruct *UserWarpTextOnSurface(CagdSrfStruct *Srf,
				      char *Txt,
				      RealType HSpace,
				      RealType VBase,
				      RealType VTop,
				      RealType Ligatures);

/* Error handling. */

char *UserDescribeError(UserFatalErrorType ErrorNum);
void UserFatalError(UserFatalErrorType ErrID);

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif /* USER_LIB_H */
