/*****************************************************************************
*   "Irit" - the 3d polygonal solid modeller.				     *
******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                *
******************************************************************************
* Extra functions from external, public domain, sources.		     *
*****************************************************************************/

#ifndef	EXTRA_FN_H
#define	EXTRA_FN_H

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

/* SVD decomposition. */
int SvdMatrix4x4(MatrixType M,
		 RealType U[3][3],
		 VectorType S,
		 RealType V[3][3]);
void SvdMatrixNxN(RealType *M, RealType *U, RealType *S, RealType *V, int n);
RealType SvdLeastSqr(RealType *A, RealType *x, RealType *b, int NData, int Nx);

/* Matrix diagonalization. */
void JacobiMatrixDiag4x4(RealType M[4][4],
			 RealType U[4][4],
			 RealType D[4][4],
			 RealType V[4][4]);
void JacobiMatrixDiagNxN(RealType *M[],
			 RealType *U[],
			 RealType *D[],
			 RealType *V[],
			 int n);

/* Bezier interpolation. */
void BzrCrvInterp(RealType *Result, RealType *Input, int Size);

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif /* EXTRA_FN_H */
