/******************************************************************************
* Geom_ftl.c - default FatalError function for the geom library.	      *
*******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                 *
*******************************************************************************
* Written by Gershon Elber, April. 98.					      *
******************************************************************************/

#include <stdio.h>
#include "geom_loc.h"

/*****************************************************************************
* DESCRIPTION:                                                               M
* Trap Geom_lib errors right here. Provides a default error handler for the  M
* geom library. Gets an error description using GeomDescribeError, prints it M
* and exit the program using exit.                                           M
*                                                                            *
* PARAMETERS:                                                                M
*   ErrID:      Error type that was raised.                                  M
*                                                                            *
* RETURN VALUE:                                                              M
*   void                                                                     M
*                                                                            *
* KEYWORDS:                                                                  M
*   GeomFatalError, error handling                                           M
*****************************************************************************/
void GeomFatalError(GeomFatalErrorType ErrID)
{
    char
	*ErrorMsg = GeomDescribeError(ErrID);

    fprintf(stderr, IRIT_EXP_STR("GEOM_LIB: %s\n"), ErrorMsg);

    exit(-1);
}
