#
# Makefile for the IRIT solid modeler documentation (unix).
#

include ../makeflag.sas

all:	irit.tex irit.doc irit.hlp user_man.html

HELP_OBJS = irithlp.o
PRGM_OBJS = progman.o

PROG_LIBS_TEX = prog_man/bool_lib.tex prog_man/cagd_lib.tex \
	prog_man/geom_lib.tex prog_man/misc_lib.tex \
	prog_man/prsr_lib.tex prog_man/symb_lib.tex \
	prog_man/triv_lib.tex prog_man/trim_lib.tex \
	prog_man/user_lib.tex prog_man/xtra_lib.tex

PROG_LIBS_HTML = prog_man/bool_lib.html prog_man/cagd_lib.html \
	prog_man/geom_lib.html prog_man/misc_lib.html \
	prog_man/prsr_lib.html prog_man/symb_lib.html \
	prog_man/triv_lib.html prog_man/trim_lib.html \
	prog_man/user_lib.html prog_man/xtra_lib.html

irithlp: $(HELP_OBJS)
	slink from lib:c.o $(HELP_OBJS) to irithlp sc $(SYMS) noicons \
lib $(LIBS) $(MORELIBS) $(MATHLIB) lib:scnb.lib

install: irit.hlp
	mv irit.hlp $(BIN_DIR)

irit.tex: irithlp irit.src user_man
	./irithlp -l -o irit.tex irit.src

irit.hlp: irithlp irit.src
	./irithlp -h -o irit.hlp irit.src

irit.doc: irithlp irit.src
	./irithlp -t -o irit.doc irit.src

user_man.html: irithlp irit.src
	./irithlp -w -o user_man.html irit.src

user_man.ps: irit.tex user_man/doc_figs.irt
	-(cd user_man && make -f makefile.ami)
	latex irit.tex
	latex irit.tex
	dvips -o user_man.ps irit.dvi

progman: $(PRGM_OBJS)
	slink from lib:c.o $(PRGM_OBJS) to progman sc $(SYMS)\
lib $(LIBS) $(MORELIBS) $(MATHLIB) lib:scnb.lib

prog_man.ps:	$(PROG_LIBS_TEX)
	-(cd cexample && sh conv_c_to_tex)
	latex prog_man.tex
	makeindex prog_man.idx
	latex prog_man.tex
	dvips -o prog_man.ps -f prog_man.dvi

prog_man/bool_lib.tex:	progman
	progman -l -o prog_man/bool_lib.tex $(SRC_DIR)/bool_lib/*.c

prog_man/cagd_lib.tex:	progman
	progman -l -o prog_man/cagd_lib.tex $(SRC_DIR)/cagd_lib/*.c

prog_man/geom_lib.tex:	progman
	progman -l -o prog_man/geom_lib.tex $(SRC_DIR)/geom_lib/*.c

prog_man/misc_lib.tex:	progman
	progman -l -o prog_man/misc_lib.tex $(SRC_DIR)/misc_lib/*.c

prog_man/prsr_lib.tex:	progman
	progman -l -o prog_man/prsr_lib.tex $(SRC_DIR)/prsr_lib/*.c

prog_man/symb_lib.tex:	progman
	progman -l -o prog_man/symb_lib.tex $(SRC_DIR)/symb_lib/*.c

prog_man/triv_lib.tex:	progman
	progman -l -o prog_man/triv_lib.tex $(SRC_DIR)/triv_lib/*.c

prog_man/trim_lib.tex:	progman
	progman -l -o prog_man/trim_lib.tex $(SRC_DIR)/trim_lib/*.c

prog_man/xtra_lib.tex:	progman
	progman -l -o prog_man/xtra_lib.tex $(SRC_DIR)/xtra_lib/*.c

prog_man/user_lib.tex:	progman
	progman -l -o prog_man/user_lib.tex $(SRC_DIR)/user_lib/*.c


prog_man.html:	$(PROG_LIBS_HTML)

prog_man/bool_lib.html:	progman
	progman -w -o bool_lib.html $(SRC_DIR)/bool_lib/*.c
	mv bool_lib.html* prog_man

prog_man/cagd_lib.html:	progman
	progman -w -o cagd_lib.html $(SRC_DIR)/cagd_lib/*.c
	mv cagd_lib.html* prog_man

prog_man/geom_lib.html:	progman
	progman -w -o geom_lib.html $(SRC_DIR)/geom_lib/*.c
	mv geom_lib.html* prog_man

prog_man/misc_lib.html:	progman
	progman -w -o misc_lib.html $(SRC_DIR)/misc_lib/*.c
	mv misc_lib.html* prog_man

prog_man/prsr_lib.html:	progman
	progman -w -o prsr_lib.html $(SRC_DIR)/prsr_lib/*.c
	mv prsr_lib.html* prog_man

prog_man/symb_lib.html:	progman
	progman -w -o symb_lib.html $(SRC_DIR)/symb_lib/*.c
	mv symb_lib.html* prog_man

prog_man/triv_lib.html:	progman
	progman -w -o triv_lib.html $(SRC_DIR)/triv_lib/*.c
	mv triv_lib.html* prog_man

prog_man/trim_lib.html:	progman
	progman -w -o trim_lib.html $(SRC_DIR)/trim_lib/*.c
	mv trim_lib.html* prog_man

prog_man/xtra_lib.html:	progman
	progman -w -o xtra_lib.html $(SRC_DIR)/xtra_lib/*.c
	mv xtra_lib.html* prog_man

prog_man/user_lib.html:	progman
	progman -w -o user_lib.html $(SRC_DIR)/user_lib/*.c
	mv user_lib.html* prog_man


man3:	progman
	progman -M $(SRC_DIR)/*_lib/*.c

man6:	irithlp irit.src
	irithlp -M irit.src

man:	man3 man6

# Do NOT DELETE THIS LINE -- make depend depends on it.

irithlp.o: ../include/irit_sm.h
progman.o: ../include/irit_sm.h ../include/imalloc.h
# DO NOT DELETE

irithlp.o: ../include/irit_sm.h
progman.o: ../include/irit_sm.h ../include/misc_lib.h
