/*****************************************************************************
* Adaptive Iso Shader program to render freeform models.		     *
******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                *
******************************************************************************
* Written by:  Gershon Elber			     Ver 0.1, October 1994.  *
*****************************************************************************/

#ifndef ADAP_ISO_SHADER_H
#define ADAP_ISO_SHADER_H

extern GLOBAL_DATA SymbCrvApproxMethodType
    GlblCrvApproxMethod;
extern GLOBAL_DATA int
    GlblTalkative,
    GlblSamplesPerCurve,
    GlblPolyOptimalMethod;
extern GLOBAL_DATA RealType
    GlblPolyFineNess;

/* Global function in aisoshad.c/pts_shad.c. */
void ShaderExit(int ExitCode);

/* Global function in zbufcrvs.c. */
void ScanConvertPolySrfs(IPObjectStruct *PObjs,
			 int ZBufferSize,
			 RealType Depth,
			 int ImageOperator);
void DumpZBufferAsSrf(char *FileName);
IPObjectStruct *TestCurveVisibility(CagdCrvStruct *Crvs, RealType WidthScale);
int TestPointVisibility(RealType X, RealType Y, RealType Z);
RealType GetPointDepth(int x, int y);

#endif /* ADAP_ISO_SHADER_H */
