/********************************************************************

   Module Name:     RowsetSource.java
   Creation Date:   8/26/97
   Description:     Simple Applet which can return RowsetAccess items for
                    "emp" and "dept" tables.

*********************************************************************/

/*
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 */

/**
 * This applet illustrates the use of the InfoBus RowsetAccess interface.
 * It maintains a very simple "in memory" database of a few tables,
 * and can return a RowsetAccess item for each of these tables.
 * Insert/Update/Delete operations are supported, but only affect the in 
 * memory images of the tables.
 */



import java.applet.*;
import java.awt.*;
import java.beans.*;
import java.io.*;
import java.net.*;
import java.sql.Types;
import java.util.*;

import javax.infobus.*;

public  class RowsetSource 
           extends Applet 
           implements InfoBusMember, InfoBusDataProducer
{
    private static final String whoami="RowsetSource";

    private SimpleTable emp=null;
    private SimpleTable dept=null;
    private String tableName=null;
    private SimpleTable table=null;

    private Hashtable database=null;

   // --- Applet Management methods --------------------------------------------------------

   /**
    * join the infobus at app initialization time
    */
   public  void init()
   { 
      // We use an InfoBusMemberSupport to hold and maintain our InfoBus property.
      // The "this" arg passed to its constructor will be returned as the source of
      // any events its creates on our behalf.
      m_InfoBusHolder = new InfoBusMemberSupport( this );
      // Tell the InfoBusMemberSupport to join the default InfoBus for this Applet
      try
      {
        m_InfoBusHolder.joinInfoBus( this );
      }
      catch ( InfoBusMembershipException e )
      {
          System.out.println(whoami + ".init warning: "+
              "joinInfoBus failed because InfoBus already set: " + e.toString());
      }
      catch ( PropertyVetoException pve )
      {
          System.out.println(whoami + ".init warning: "+
              "joinInfoBus failed because voter vetoed setInfoBus: "+ pve.toString());
      }
                
      // We register for changes to our InfoBus property
      m_InfoBusHolder.addInfoBusPropertyListener( this );
 
      // If we dont have an InfoBus now, joinInfoBus must have failed.
      if (getInfoBus() == null)
      {
         System.out.println("joinInfoBus failed");
         return;
      }

      try 
      {
         database = new Hashtable();

         emp = new SimpleTable("emp", this, /*NEEDSWORK*/null, empColumnName, empColumnDatatypeNumber, empData);
         database.put("emp", emp);

         dept = new SimpleTable("dept", this, /*NEEDSWORK*/null, deptColumnName, deptColumnDatatypeNumber, deptData);
         database.put("dept", dept);

         // Sleep a little while to let other Applets that may request one of our simple tables
         // to get fully started, so they can hear and process our initial announcment:
         Thread.sleep(2000); 
       
         for  (Enumeration  e  =  database.keys()  ;  e.hasMoreElements()  ;)  
         {
             String hashName = (String) e.nextElement();
             System.out.println("Announcing SimpleTable "+hashName);
             getInfoBus().fireItemAvailable(hashName, null, this);
         }
      }
      catch(Exception e)
      {
          System.out.println(whoami+"Exception:"+e.toString());
          e.printStackTrace();
      }
  }
    

   /**
    * Add ourself to InfoBus as DataProducer se we can listen for requests for our data items
    */
   public 
       void start()
   {
      // If we dont have an InfoBus now, join must have failed.
        InfoBus ib = m_InfoBusHolder.getInfoBus();
        if (null != ib) 
        {
            ib.addDataProducer(this);
        }
   }

   /**
    * Called when we leave the page or need to otherwise shut down.
    * We want to stop listening to events here.
    */
   public  void stop()
   {
      // we dont need to hear events when were not running
      getInfoBus().removeDataProducer(this);

   }


   /**
    * called to release allocated resources.
    */
   public  void destroy()
   {
      stop();

      // tell our InfoBusMemberSupport to remove itself from the InfoBus
      try
      {
      m_InfoBusHolder.leaveInfoBus();
      }
      catch ( Exception e )
      {
          // InfoBusMembershipException thrown if InfoBus already null
          // PropertyVetoException thrown if voter refuses to let InfoBus = null
      }
   }



   // --- interface InfoBusMember method implementations ----------------------------------

   private InfoBusMemberSupport m_InfoBusHolder = null;

   /**
    * accessor to return our "InfoBus" property value
    */
    public  InfoBus getInfoBus()
    {
        return m_InfoBusHolder.getInfoBus();
    }

    /**
    * accessor to set an "InfoBus" property value. Before setting the new value, it polls
    * any VetoableChangeListeners to see if theyll let us do it.
    */
    public  void setInfoBus (InfoBus b) throws PropertyVetoException
    {
        m_InfoBusHolder.setInfoBus ( b );
    }

   /**
    * add a Veto listener for our InfoBus property
    */
    public  void addInfoBusVetoableListener(VetoableChangeListener l)
    {
        m_InfoBusHolder.addInfoBusVetoableListener ( l );
    }

   /**
    * remove a Veto listener for our InfoBus property
    */
    public  void removeInfoBusVetoableListener(VetoableChangeListener l)
    {
        m_InfoBusHolder.removeInfoBusVetoableListener ( l );
    }
    
   /**
    * add a Property listener for our InfoBus property
    */
    public  void addInfoBusPropertyListener(PropertyChangeListener l)
    {
        m_InfoBusHolder.addInfoBusPropertyListener ( l );
    }

   /**
    * remove a Property listener for our InfoBus property
    */
    public  void removeInfoBusPropertyListener(PropertyChangeListener l)
    {
        m_InfoBusHolder.removeInfoBusPropertyListener ( l );
    }




   // --- interface InfoBusDataProducer method implementations ----------------------------

   /**
    * When an InfoBus data consumer requests one of the tables we can supply,
    * we return the appropriate SimpleTable item.
    */
   public  void dataItemRequested (InfoBusItemRequestedEvent e)
   {
      // We only respond to requests for the tables in our "in memory" database
      Object o = database.get(e.getDataItemName());
      if (o != null)
      {
          e.setDataItem(o); 
          return;
      }
      return;
   }


    /**
    * React to announcements of property changes -- the only one we
    * track is our own InfoBus property, which is being maintained for
    * us in a separate object
    */
    public  void propertyChange ( PropertyChangeEvent pce )
    {
        String s = pce.getPropertyName();
        if ( ! s.equals("InfoBus") )
        {
            return;
        }

        Object oldVal = pce.getOldValue();
        Object newVal = pce.getNewValue();

        if ( oldVal == newVal )
        {
            return;
        }

        //note that either old or new value may validly be NULL

        if ( oldVal != null && oldVal instanceof InfoBus )
        {
            ((InfoBus) oldVal).removeDataProducer ( this );
        }

        if ( newVal != null && newVal instanceof InfoBus )
        {
            ((InfoBus) newVal).addDataProducer ( this );
        }
    }


    
   private String[] empColumnName={
                       "name", 
                       "id", 
                       "salary", 
                       "deptid"};
   private int[]    empColumnDatatypeNumber={
                        java.sql.Types.VARCHAR, 
                        java.sql.Types.INTEGER, 
                        java.sql.Types.DOUBLE, 
                        java.sql.Types.INTEGER};
   private Object[][] empData = {
                        {"Brown", new Integer(1), new Double(25000.0), new Integer(10)},
                        {"Jones", new Integer(2), new Double(57500.0), new Integer(30)},
                        {"Smith", new Integer(3), new Double(32000.0), new Integer(20)},
                        {"Wilson",new Integer(4), new Double(68000.0), new Integer(20)} 
   };
       
   private String[] deptColumnName={
                        "name", 
                        "id", 
                        "mgrid"};
   private int[]    deptColumnDatatypeNumber={
                        java.sql.Types.VARCHAR, 
                        java.sql.Types.INTEGER, 
                        java.sql.Types.INTEGER};
   private Object[][] deptData = {
                        {"Administration", new Integer(10), new Integer(1)},
                        {"Engineering",    new Integer(20), new Integer(3)},
                        {"Sales",          new Integer(30), new Integer(2)}
   };

}
   

