package iaik.pkcs.pkcs11.wrapper;

/**
 * class CK_ECDH2_DERIVE_PARAMS provides the parameters to the
 * CKM_ECMQV_DERIVE mechanism.<p>
 * <B>PKCS#11 structure:</B>
 * <PRE>
 * typedef struct CK_ECDH2_DERIVE_PARAMS {
 *   CK_EC_KDF_TYPE kdf;
 *   CK_ULONG ulSharedDataLen;
 *   CK_BYTE_PTR pSharedData;
 *   CK_ULONG ulPublicDataLen;
 *   CK_BYTE_PTR pPublicData;
 *   CK_ULONG ulPrivateDataLen;
 *   CK_OBJECT_HANDLE hPrivateData;
 *   CK_ULONG ulPublicDataLen2;
 *   CK_BYTE_PTR pPublicData2;
 * } CK_ECDH2_DERIVE_PARAMS;
 * </PRE>
 *
 * @author Karl Scheibelhofer <Karl.Scheibelhofer@iaik.at>
 */
public class CK_ECDH2_DERIVE_PARAMS {

	/**
	 * <B>PKCS#11:</B>
	 * <PRE>
	 *   CK_EC_KDF_TYPE kdf;
	 * </PRE>
	 */
	public long kdf;

	/**
	 * <B>PKCS#11:</B>
	 * <PRE>
	 *   CK_ULONG ulSharedDataLen;
	 *   CK_BYTE_PTR pSharedData;
	 * </PRE>
	 */
	public byte[] pSharedData;

	/**
	 * <B>PKCS#11:</B>
	 * <PRE>
	 *   CK_ULONG ulPublicDataLen;
	 *   CK_BYTE_PTR pPublicData;
	 * </PRE>
	 */
	public byte[] pPublicData;

	/**
	 * <B>PKCS#11:</B>
	 * <PRE>
	 *   CK_ULONG ulPrivateDataLen;
	 * </PRE>
	 */
	public long ulPrivateDataLen;

	/**
	 * <B>PKCS#11:</B>
	 * <PRE>
	 *   CK_OBJECT_HANDLE hPrivateData;
	 * </PRE>
	 */
	public long hPrivateData;

	/**
	 * <B>PKCS#11:</B>
	 * <PRE>
	 *   CK_ULONG ulPublicDataLen2;
	 *   CK_BYTE_PTR pPublicData2;
	 * </PRE>
	 */
	public byte[] pPublicData2;

	/**
	 * Returns the string representation of CK_PKCS5_PBKD2_PARAMS.
	 *
	 * @return the string representation of CK_PKCS5_PBKD2_PARAMS
	 */
	public String toString() {
		StringBuffer buffer = new StringBuffer();

		buffer.append(Constants.INDENT);
		buffer.append("kdf: 0x");
		buffer.append(Functions.toFullHexString(kdf));
		buffer.append(Constants.NEWLINE);

		buffer.append(Constants.INDENT);
		buffer.append("pSharedDataLen: ");
		buffer.append(pSharedData.length);
		buffer.append(Constants.NEWLINE);

		buffer.append(Constants.INDENT);
		buffer.append("pSharedData: ");
		buffer.append(Functions.toHexString(pSharedData));
		buffer.append(Constants.NEWLINE);

		buffer.append(Constants.INDENT);
		buffer.append("pPublicDataLen: ");
		buffer.append(pPublicData.length);
		buffer.append(Constants.NEWLINE);

		buffer.append(Constants.INDENT);
		buffer.append("pPublicData: ");
		buffer.append(Functions.toHexString(pPublicData));
		buffer.append(Constants.NEWLINE);

		buffer.append(Constants.INDENT);
		buffer.append("ulPrivateDataLen: ");
		buffer.append(ulPrivateDataLen);
		buffer.append(Constants.NEWLINE);

		buffer.append(Constants.INDENT);
		buffer.append("hPrivateData: ");
		buffer.append(hPrivateData);
		buffer.append(Constants.NEWLINE);

		buffer.append(Constants.INDENT);
		buffer.append("pPublicDataLen2: ");
		buffer.append(pPublicData2.length);
		buffer.append(Constants.NEWLINE);

		buffer.append(Constants.INDENT);
		buffer.append("pPublicData2: ");
		buffer.append(Functions.toHexString(pPublicData2));
		//buffer.append(Constants.NEWLINE);

		return buffer.toString();
	}

}
