/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.AttributeArray;
import iaik.pkcs.pkcs11.objects.BooleanAttribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.DHPrivateKey;
import iaik.pkcs.pkcs11.objects.DSAPrivateKey;
import iaik.pkcs.pkcs11.objects.ECDSAPrivateKey;
import iaik.pkcs.pkcs11.objects.KEAPrivateKey;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.KeyTypeAttribute;
import iaik.pkcs.pkcs11.objects.LongAttribute;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.objects.RSAPrivateKey;
import iaik.pkcs.pkcs11.wrapper.Constants;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;

public class PrivateKey
extends Key {
    protected ByteArrayAttribute subject_;
    protected BooleanAttribute sensitive_;
    protected BooleanAttribute secondaryAuth_;
    protected LongAttribute authPinFlags_;
    protected BooleanAttribute decrypt_;
    protected BooleanAttribute sign_;
    protected BooleanAttribute signRecover_;
    protected BooleanAttribute unwrap_;
    protected BooleanAttribute extractable_;
    protected BooleanAttribute alwaysSensitive_;
    protected BooleanAttribute neverExtractable_;
    protected BooleanAttribute wrapWithTrusted_;
    protected AttributeArray unwrapTemplate_;
    protected BooleanAttribute alwaysAuthenticate_;

    public PrivateKey() {
        this.objectClass_.setLongValue(Object.ObjectClass.PRIVATE_KEY);
    }

    protected PrivateKey(Session session, long l) throws TokenException {
        super(session, l);
        this.objectClass_.setLongValue(Object.ObjectClass.PRIVATE_KEY);
    }

    protected void allocateAttributes() {
        super.allocateAttributes();
        this.subject_ = new ByteArrayAttribute(Attribute.SUBJECT);
        this.sensitive_ = new BooleanAttribute(Attribute.SENSITIVE);
        this.secondaryAuth_ = new BooleanAttribute(Attribute.SECONDARY_AUTH);
        this.authPinFlags_ = new LongAttribute(Attribute.AUTH_PIN_FLAGS);
        this.decrypt_ = new BooleanAttribute(Attribute.DECRYPT);
        this.sign_ = new BooleanAttribute(Attribute.SIGN);
        this.signRecover_ = new BooleanAttribute(Attribute.SIGN_RECOVER);
        this.unwrap_ = new BooleanAttribute(Attribute.UNWRAP);
        this.extractable_ = new BooleanAttribute(Attribute.EXTRACTABLE);
        this.alwaysSensitive_ = new BooleanAttribute(Attribute.ALWAYS_SENSITIVE);
        this.neverExtractable_ = new BooleanAttribute(Attribute.NEVER_EXTRACTABLE);
        this.wrapWithTrusted_ = new BooleanAttribute(Attribute.WRAP_WITH_TRUSTED);
        this.unwrapTemplate_ = new AttributeArray(Attribute.UNWRAP_TEMPLATE);
        this.alwaysAuthenticate_ = new BooleanAttribute(Attribute.ALWAYS_AUTHENTICATE);
        PrivateKey.putAttributesInTable(this);
    }

    public java.lang.Object clone() {
        PrivateKey privateKey = (PrivateKey)super.clone();
        privateKey.subject_ = (ByteArrayAttribute)this.subject_.clone();
        privateKey.sensitive_ = (BooleanAttribute)this.sensitive_.clone();
        privateKey.secondaryAuth_ = (BooleanAttribute)this.secondaryAuth_.clone();
        privateKey.authPinFlags_ = (LongAttribute)this.authPinFlags_.clone();
        privateKey.decrypt_ = (BooleanAttribute)this.decrypt_.clone();
        privateKey.sign_ = (BooleanAttribute)this.sign_.clone();
        privateKey.signRecover_ = (BooleanAttribute)this.signRecover_.clone();
        privateKey.unwrap_ = (BooleanAttribute)this.unwrap_.clone();
        privateKey.extractable_ = (BooleanAttribute)this.extractable_.clone();
        privateKey.alwaysSensitive_ = (BooleanAttribute)this.alwaysSensitive_.clone();
        privateKey.neverExtractable_ = (BooleanAttribute)this.neverExtractable_.clone();
        privateKey.wrapWithTrusted_ = (BooleanAttribute)this.wrapWithTrusted_.clone();
        privateKey.unwrapTemplate_ = (AttributeArray)this.unwrapTemplate_.clone();
        privateKey.alwaysAuthenticate_ = (BooleanAttribute)this.alwaysAuthenticate_.clone();
        PrivateKey.putAttributesInTable(privateKey);
        return privateKey;
    }

    public boolean equals(java.lang.Object object) {
        boolean bl = false;
        if (object instanceof PrivateKey) {
            PrivateKey privateKey = (PrivateKey)object;
            bl = this == privateKey || super.equals(privateKey) && this.subject_.equals(privateKey.subject_) && this.sensitive_.equals(privateKey.sensitive_) && this.secondaryAuth_.equals(privateKey.secondaryAuth_) && this.authPinFlags_.equals(privateKey.authPinFlags_) && this.decrypt_.equals(privateKey.decrypt_) && this.sign_.equals(privateKey.sign_) && this.signRecover_.equals(privateKey.signRecover_) && this.unwrap_.equals(privateKey.unwrap_) && this.extractable_.equals(privateKey.extractable_) && this.alwaysSensitive_.equals(privateKey.alwaysSensitive_) && this.neverExtractable_.equals(privateKey.neverExtractable_) && this.wrapWithTrusted_.equals(privateKey.wrapWithTrusted_) && this.unwrapTemplate_.equals(privateKey.unwrapTemplate_) && this.alwaysAuthenticate_.equals(privateKey.alwaysAuthenticate_);
        }
        return bl;
    }

    public BooleanAttribute getAlwaysAuthenticate() {
        return this.alwaysAuthenticate_;
    }

    public BooleanAttribute getAlwaysSensitive() {
        return this.alwaysSensitive_;
    }

    public LongAttribute getAuthPinFlags() {
        return this.authPinFlags_;
    }

    public BooleanAttribute getDecrypt() {
        return this.decrypt_;
    }

    public BooleanAttribute getExtractable() {
        return this.extractable_;
    }

    public static Object getInstance(Session session, long l) throws TokenException {
        if (session == null) {
            throw new NullPointerException("Argument \"session\" must not be null.");
        }
        KeyTypeAttribute keyTypeAttribute = new KeyTypeAttribute();
        Object.getAttributeValue(session, l, keyTypeAttribute);
        Long l2 = keyTypeAttribute.getLongValue();
        Object object = keyTypeAttribute.isPresent() && l2 != null ? (l2.equals(Key.KeyType.RSA) ? RSAPrivateKey.getInstance(session, l) : (l2.equals(Key.KeyType.DSA) ? DSAPrivateKey.getInstance(session, l) : (l2.equals(Key.KeyType.ECDSA) ? ECDSAPrivateKey.getInstance(session, l) : (l2.equals(Key.KeyType.DH) ? DHPrivateKey.getInstance(session, l) : (l2.equals(Key.KeyType.KEA) ? KEAPrivateKey.getInstance(session, l) : ((l2 & Key.KeyType.VENDOR_DEFINED) != 0L ? PrivateKey.getUnknownPrivateKey(session, l) : PrivateKey.getUnknownPrivateKey(session, l))))))) : PrivateKey.getUnknownPrivateKey(session, l);
        return object;
    }

    public BooleanAttribute getNeverExtractable() {
        return this.neverExtractable_;
    }

    public BooleanAttribute getSecondaryAuth() {
        return this.secondaryAuth_;
    }

    public BooleanAttribute getSensitive() {
        return this.sensitive_;
    }

    public BooleanAttribute getSign() {
        return this.sign_;
    }

    public BooleanAttribute getSignRecover() {
        return this.signRecover_;
    }

    public ByteArrayAttribute getSubject() {
        return this.subject_;
    }

    protected static Object getUnknownPrivateKey(Session session, long l) throws TokenException {
        Object object;
        if (session == null) {
            throw new NullPointerException("Argument \"session\" must not be null.");
        }
        if (Key.vendorKeyBuilder_ != null) {
            try {
                object = Key.vendorKeyBuilder_.build(session, l);
            }
            catch (PKCS11Exception pKCS11Exception) {
                object = new PrivateKey(session, l);
            }
        } else {
            object = new PrivateKey(session, l);
        }
        return object;
    }

    public BooleanAttribute getUnwrap() {
        return this.unwrap_;
    }

    public AttributeArray getUnwrapTemplate() {
        return this.unwrapTemplate_;
    }

    public BooleanAttribute getWrapWithTrusted() {
        return this.wrapWithTrusted_;
    }

    protected static void putAttributesInTable(PrivateKey privateKey) {
        if (privateKey == null) {
            throw new NullPointerException("Argument \"object\" must not be null.");
        }
        privateKey.attributeTable_.put(Attribute.SUBJECT, privateKey.subject_);
        privateKey.attributeTable_.put(Attribute.SENSITIVE, privateKey.sensitive_);
        privateKey.attributeTable_.put(Attribute.SECONDARY_AUTH, privateKey.secondaryAuth_);
        privateKey.attributeTable_.put(Attribute.AUTH_PIN_FLAGS, privateKey.authPinFlags_);
        privateKey.attributeTable_.put(Attribute.DECRYPT, privateKey.decrypt_);
        privateKey.attributeTable_.put(Attribute.SIGN, privateKey.sign_);
        privateKey.attributeTable_.put(Attribute.SIGN_RECOVER, privateKey.signRecover_);
        privateKey.attributeTable_.put(Attribute.UNWRAP, privateKey.unwrap_);
        privateKey.attributeTable_.put(Attribute.EXTRACTABLE, privateKey.extractable_);
        privateKey.attributeTable_.put(Attribute.ALWAYS_SENSITIVE, privateKey.alwaysSensitive_);
        privateKey.attributeTable_.put(Attribute.NEVER_EXTRACTABLE, privateKey.neverExtractable_);
        privateKey.attributeTable_.put(Attribute.WRAP_WITH_TRUSTED, privateKey.wrapWithTrusted_);
        privateKey.attributeTable_.put(Attribute.UNWRAP_TEMPLATE, privateKey.unwrapTemplate_);
        privateKey.attributeTable_.put(Attribute.ALWAYS_AUTHENTICATE, privateKey.alwaysAuthenticate_);
    }

    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        Object.getAttributeValues(session, this.objectHandle_, new Attribute[]{this.subject_, this.sensitive_, this.secondaryAuth_, this.authPinFlags_, this.decrypt_, this.sign_, this.signRecover_, this.unwrap_, this.extractable_, this.alwaysSensitive_, this.neverExtractable_, this.wrapWithTrusted_, this.alwaysAuthenticate_});
        Object.getAttributeValue(session, this.objectHandle_, this.unwrapTemplate_);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(super.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Subject (DER, hex): ");
        stringBuffer.append(this.subject_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Sensitive: ");
        stringBuffer.append(this.sensitive_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Secondary Authentication: ");
        stringBuffer.append(this.secondaryAuth_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Secondary Authentication PIN Flags: ");
        if (this.authPinFlags_.isPresent() && !this.authPinFlags_.isSensitive() && this.authPinFlags_.getLongValue() != null) {
            long l = this.authPinFlags_.getLongValue();
            stringBuffer.append(Constants.NEWLINE);
            stringBuffer.append("  ");
            stringBuffer.append("  ");
            stringBuffer.append("User PIN-Count low: ");
            stringBuffer.append((l & 0x10000L) != 0L);
            stringBuffer.append(Constants.NEWLINE);
            stringBuffer.append("  ");
            stringBuffer.append("  ");
            stringBuffer.append("User PIN final Try: ");
            stringBuffer.append((l & 0x20000L) != 0L);
            stringBuffer.append(Constants.NEWLINE);
            stringBuffer.append("  ");
            stringBuffer.append("  ");
            stringBuffer.append("User PIN locked: ");
            stringBuffer.append((l & 0x40000L) != 0L);
            stringBuffer.append(Constants.NEWLINE);
            stringBuffer.append("  ");
            stringBuffer.append("  ");
            stringBuffer.append("User PIN to be changed: ");
            stringBuffer.append((l & 0x80000L) != 0L);
        } else {
            stringBuffer.append(this.authPinFlags_.toString());
        }
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Decrypt: ");
        stringBuffer.append(this.decrypt_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Sign: ");
        stringBuffer.append(this.sign_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Sign Recover: ");
        stringBuffer.append(this.signRecover_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Unwrap: ");
        stringBuffer.append(this.unwrap_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Extractable: ");
        stringBuffer.append(this.extractable_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Always Sensitive: ");
        stringBuffer.append(this.alwaysSensitive_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Never Extractable: ");
        stringBuffer.append(this.neverExtractable_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Wrap With Trusted: ");
        stringBuffer.append(this.wrapWithTrusted_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Unwrap Template: ");
        stringBuffer.append(this.unwrapTemplate_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Always Authenticate: ");
        stringBuffer.append(this.alwaysAuthenticate_.toString());
        return stringBuffer.toString();
    }
}

