/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.wrapper.Constants;

public class DES2SecretKey
extends SecretKey {
    protected ByteArrayAttribute value_;

    public DES2SecretKey() {
        this.keyType_.setLongValue(Key.KeyType.DES2);
    }

    protected DES2SecretKey(Session session, long l) throws TokenException {
        super(session, l);
        this.keyType_.setLongValue(Key.KeyType.DES2);
    }

    protected void allocateAttributes() {
        super.allocateAttributes();
        this.value_ = new ByteArrayAttribute(Attribute.VALUE);
        DES2SecretKey.putAttributesInTable(this);
    }

    public java.lang.Object clone() {
        DES2SecretKey dES2SecretKey = (DES2SecretKey)super.clone();
        dES2SecretKey.value_ = (ByteArrayAttribute)this.value_.clone();
        DES2SecretKey.putAttributesInTable(dES2SecretKey);
        return dES2SecretKey;
    }

    public boolean equals(java.lang.Object object) {
        boolean bl = false;
        if (object instanceof DES2SecretKey) {
            DES2SecretKey dES2SecretKey = (DES2SecretKey)object;
            bl = this == dES2SecretKey || super.equals(dES2SecretKey) && this.value_.equals(dES2SecretKey.value_);
        }
        return bl;
    }

    public static Object getInstance(Session session, long l) throws TokenException {
        return new DES2SecretKey(session, l);
    }

    public ByteArrayAttribute getValue() {
        return this.value_;
    }

    protected static void putAttributesInTable(DES2SecretKey dES2SecretKey) {
        if (dES2SecretKey == null) {
            throw new NullPointerException("Argument \"object\" must not be null.");
        }
        dES2SecretKey.attributeTable_.put(Attribute.VALUE, dES2SecretKey.value_);
    }

    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        Object.getAttributeValue(session, this.objectHandle_, this.value_);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(super.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Value (hex): ");
        stringBuffer.append(this.value_.toString());
        return stringBuffer.toString();
    }
}

