/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.BooleanAttribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.CertificateTypeAttribute;
import iaik.pkcs.pkcs11.objects.DateAttribute;
import iaik.pkcs.pkcs11.objects.LongAttribute;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.objects.Storage;
import iaik.pkcs.pkcs11.objects.X509AttributeCertificate;
import iaik.pkcs.pkcs11.objects.X509PublicKeyCertificate;
import iaik.pkcs.pkcs11.wrapper.Constants;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;

public class Certificate
extends Storage {
    protected static VendorDefinedCertificateBuilder vendorCertificateBuilder_;
    protected CertificateTypeAttribute certificateType_;
    protected BooleanAttribute trusted_;
    protected LongAttribute certificateCategory_;
    protected ByteArrayAttribute checkValue_;
    protected DateAttribute startDate_;
    protected DateAttribute endDate_;

    public Certificate() {
        this.objectClass_.setLongValue(Object.ObjectClass.CERTIFICATE);
    }

    protected Certificate(Session session, long l) throws TokenException {
        super(session, l);
        this.objectClass_.setLongValue(Object.ObjectClass.CERTIFICATE);
    }

    protected void allocateAttributes() {
        super.allocateAttributes();
        this.certificateType_ = new CertificateTypeAttribute();
        this.trusted_ = new BooleanAttribute(Attribute.TRUSTED);
        this.certificateCategory_ = new LongAttribute(Attribute.CERTIFICATE_CATEGORY);
        this.checkValue_ = new ByteArrayAttribute(Attribute.CHECK_VALUE);
        this.startDate_ = new DateAttribute(Attribute.START_DATE);
        this.endDate_ = new DateAttribute(Attribute.END_DATE);
        Certificate.putAttributesInTable(this);
    }

    public java.lang.Object clone() {
        Certificate certificate = (Certificate)super.clone();
        certificate.certificateType_ = (CertificateTypeAttribute)this.certificateType_.clone();
        certificate.trusted_ = (BooleanAttribute)this.trusted_.clone();
        certificate.certificateCategory_ = (LongAttribute)this.certificateCategory_.clone();
        certificate.checkValue_ = (ByteArrayAttribute)this.checkValue_.clone();
        certificate.startDate_ = (DateAttribute)this.startDate_.clone();
        certificate.endDate_ = (DateAttribute)this.endDate_.clone();
        Certificate.putAttributesInTable(certificate);
        return certificate;
    }

    public boolean equals(java.lang.Object object) {
        boolean bl = false;
        if (object instanceof Certificate) {
            Certificate certificate = (Certificate)object;
            bl = this == certificate || super.equals(certificate) && this.certificateType_.equals(certificate.certificateType_) && this.trusted_.equals(certificate.trusted_) && this.certificateCategory_.equals(certificate.certificateCategory_) && this.checkValue_.equals(certificate.checkValue_) && this.startDate_.equals(certificate.startDate_) && this.endDate_.equals(certificate.endDate_);
        }
        return bl;
    }

    public LongAttribute getCertificateCategory() {
        return this.certificateCategory_;
    }

    public LongAttribute getCertificateType() {
        return this.certificateType_;
    }

    public static String getCertificateTypeName(Long l) {
        if (l == null) {
            throw new NullPointerException("Argument \"certificateType\" must not be null.");
        }
        String string = l.equals(CertificateType.X_509_PUBLIC_KEY) ? "X.509 Public Key" : (l.equals(CertificateType.X_509_ATTRIBUTE) ? "X.509 Attribute" : ((l & CertificateType.VENDOR_DEFINED) != 0L ? "Vendor Defined" : "<unknown>"));
        return string;
    }

    public ByteArrayAttribute getCheckValue() {
        return this.checkValue_;
    }

    public DateAttribute getEndDate() {
        return this.endDate_;
    }

    public static Object getInstance(Session session, long l) throws TokenException {
        if (session == null) {
            throw new NullPointerException("Argument \"session\" must not be null.");
        }
        CertificateTypeAttribute certificateTypeAttribute = new CertificateTypeAttribute();
        Object.getAttributeValue(session, l, certificateTypeAttribute);
        Long l2 = certificateTypeAttribute.getLongValue();
        Object object = certificateTypeAttribute.isPresent() && l2 != null ? (l2.equals(CertificateType.X_509_PUBLIC_KEY) ? X509PublicKeyCertificate.getInstance(session, l) : (l2.equals(CertificateType.X_509_ATTRIBUTE) ? X509AttributeCertificate.getInstance(session, l) : ((l2 & CertificateType.VENDOR_DEFINED) != 0L ? Certificate.getUnknownCertificate(session, l) : Certificate.getUnknownCertificate(session, l)))) : Certificate.getUnknownCertificate(session, l);
        return object;
    }

    public DateAttribute getStartDate() {
        return this.startDate_;
    }

    public BooleanAttribute getTrusted() {
        return this.trusted_;
    }

    protected static Object getUnknownCertificate(Session session, long l) throws TokenException {
        Object object;
        if (session == null) {
            throw new NullPointerException("Argument \"session\" must not be null.");
        }
        if (vendorCertificateBuilder_ != null) {
            try {
                object = vendorCertificateBuilder_.build(session, l);
            }
            catch (PKCS11Exception pKCS11Exception) {
                object = new Certificate(session, l);
            }
        } else {
            object = new Certificate(session, l);
        }
        return object;
    }

    public static VendorDefinedCertificateBuilder getVendorDefinedCertificateBuilder() {
        return vendorCertificateBuilder_;
    }

    public int hashCode() {
        return this.certificateType_.hashCode();
    }

    protected static void putAttributesInTable(Certificate certificate) {
        if (certificate == null) {
            throw new NullPointerException("Argument \"object\" must not be null.");
        }
        certificate.attributeTable_.put(Attribute.CERTIFICATE_TYPE, certificate.certificateType_);
        certificate.attributeTable_.put(Attribute.TRUSTED, certificate.trusted_);
        certificate.attributeTable_.put(Attribute.CERTIFICATE_CATEGORY, certificate.certificateCategory_);
        certificate.attributeTable_.put(Attribute.CHECK_VALUE, certificate.checkValue_);
        certificate.attributeTable_.put(Attribute.START_DATE, certificate.startDate_);
        certificate.attributeTable_.put(Attribute.END_DATE, certificate.endDate_);
    }

    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        Object.getAttributeValues(session, this.objectHandle_, new Attribute[]{this.trusted_, this.certificateCategory_, this.checkValue_, this.startDate_, this.endDate_});
    }

    public static void setVendorDefinedCertificateBuilder(VendorDefinedCertificateBuilder vendorDefinedCertificateBuilder) {
        vendorCertificateBuilder_ = vendorDefinedCertificateBuilder;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append(super.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Certificate Type: ");
        if (this.certificateType_ != null) {
            stringBuffer.append(this.certificateType_.toString());
        } else {
            stringBuffer.append("<unavailable>");
        }
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Trusted: ");
        stringBuffer.append(this.trusted_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Certificate Category: ");
        stringBuffer.append(this.certificateCategory_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Check Value: ");
        stringBuffer.append(this.checkValue_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Start Date: ");
        stringBuffer.append(this.startDate_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("End Date: ");
        stringBuffer.append(this.endDate_.toString());
        return stringBuffer.toString();
    }

    public static interface CertificateType {
        public static final Long X_509_PUBLIC_KEY = new Long(0L);
        public static final Long X_509_ATTRIBUTE = new Long(1L);
        public static final Long VENDOR_DEFINED = new Long(0x80000000L);
    }

    public static interface VendorDefinedCertificateBuilder {
        public Object build(Session var1, long var2) throws PKCS11Exception;
    }
}

