/*
 * Decompiled with CFR 0.152.
 */
package demo.pkcs.pkcs11;

import iaik.security.provider.IAIK;
import iaik.utils.Util;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.crypto.Cipher;

public class VerifySignature {
    protected X509Certificate certificate_;
    protected Signature verifyEngine_;

    public VerifySignature(X509Certificate x509Certificate, String string) throws GeneralSecurityException {
        this.certificate_ = x509Certificate;
        this.verifyEngine_ = Signature.getInstance(string);
        this.verifyEngine_.initVerify(x509Certificate.getPublicKey());
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 4) {
            VerifySignature.printUsage();
            System.exit(1);
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
            byte[] byArray = Util.readStream((InputStream)new FileInputStream(stringArray[1]));
            FileInputStream fileInputStream2 = new FileInputStream(stringArray[2]);
            Security.addProvider((Provider)new IAIK());
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(fileInputStream2);
            VerifySignature verifySignature = new VerifySignature(x509Certificate, stringArray[3]);
            if (verifySignature.verify(fileInputStream, byArray)) {
                System.out.println("Verified signature successfully.");
            } else {
                System.out.println("Signature is INVALID.");
                Cipher cipher = Cipher.getInstance("RSA/ECB/NoPadding");
                cipher.init(2, x509Certificate.getPublicKey());
                byte[] byArray2 = cipher.doFinal(byArray);
                System.out.println("Decrypted signature value is (hex):");
                System.out.println(new BigInteger(1, byArray2).toString(16));
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void printUsage() {
        System.out.println("Usage: VerifySignature <data file> <signature file> <X.509 certificate file> <algorithm>");
        System.out.println(" e.g.: VerifySignature data.dat signature.bin signerCertificate.der SHA1withRSA");
    }

    public boolean verify(InputStream inputStream, byte[] byArray) throws IOException, GeneralSecurityException {
        int n;
        byte[] byArray2 = new byte[1024];
        while ((n = inputStream.read(byArray2, 0, byArray2.length)) >= 0) {
            this.verifyEngine_.update(byArray2, 0, n);
        }
        return this.verifyEngine_.verify(byArray);
    }
}

