/*
 * Decompiled with CFR 0.152.
 */
package demo.pkcs.pkcs11;

import demo.pkcs.pkcs11.AlgorithmIDAdapter;
import demo.pkcs.pkcs11.KeyAndCertificate;
import demo.pkcs.pkcs11.PKCS11SignatureEngine;
import demo.pkcs.pkcs11.TokenPrivateKey;
import demo.pkcs.pkcs11.Util;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Name;
import iaik.pkcs.pkcs10.CertificateRequest;
import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.MechanismInfo;
import iaik.pkcs.pkcs11.Module;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.RSAPrivateKey;
import iaik.pkcs.pkcs11.objects.X509PublicKeyCertificate;
import iaik.security.rsa.RSAPublicKey;
import iaik.utils.PemOutputStream;
import iaik.utils.RFC2253NameParser;
import iaik.x509.X509Certificate;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.List;

public class SignCertificateRequest {
    static PrintWriter output_;
    static BufferedReader input_;

    static {
        try {
            output_ = new PrintWriter(System.out, true);
            input_ = new BufferedReader(new InputStreamReader(System.in));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            output_ = new PrintWriter(System.out, true);
            input_ = new BufferedReader(new InputStreamReader(System.in));
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 4) {
            SignCertificateRequest.printUsage();
            System.exit(1);
        }
        try {
            try {
                MechanismInfo mechanismInfo;
                List<Mechanism> list;
                Module module = Module.getInstance((String)stringArray[0]);
                module.initialize(null);
                Token token = Util.selectToken(module, output_, input_);
                if (token == null) {
                    output_.println("We have no token to proceed. Finished.");
                    output_.flush();
                    System.exit(0);
                }
                if (!(list = Arrays.asList(token.getMechanismList())).contains(Mechanism.RSA_PKCS)) {
                    output_.print("This token does not support raw RSA signing!");
                    output_.flush();
                    System.exit(0);
                } else {
                    mechanismInfo = token.getMechanismInfo(Mechanism.RSA_PKCS);
                    if (!mechanismInfo.isSign()) {
                        output_.print("This token does not support RSA signing according to PKCS!");
                        output_.flush();
                        System.exit(0);
                    }
                }
                mechanismInfo = Util.openAuthorizedSession(token, false, output_, input_);
                RSAPrivateKey rSAPrivateKey = new RSAPrivateKey();
                rSAPrivateKey.getSign().setBooleanValue(Boolean.TRUE);
                KeyAndCertificate keyAndCertificate = Util.selectKeyAndCertificate((Session)mechanismInfo, (Key)rSAPrivateKey, output_, input_);
                if (keyAndCertificate == null) {
                    output_.println("We have no signature key to proceed. Finished.");
                    output_.flush();
                    System.exit(0);
                }
                iaik.pkcs.pkcs11.objects.PrivateKey privateKey = (iaik.pkcs.pkcs11.objects.PrivateKey)keyAndCertificate.getKey();
                X509PublicKeyCertificate x509PublicKeyCertificate = keyAndCertificate.getCertificate();
                X509Certificate x509Certificate = x509PublicKeyCertificate != null ? new X509Certificate(x509PublicKeyCertificate.getValue().getByteArrayValue()) : null;
                output_.println("################################################################################");
                output_.println("generating and signing PKCS#10 certificate request");
                FileInputStream fileInputStream = new FileInputStream(stringArray[1]);
                RSAPublicKey rSAPublicKey = new RSAPublicKey((InputStream)fileInputStream);
                RFC2253NameParser rFC2253NameParser = new RFC2253NameParser(stringArray[2]);
                Name name = rFC2253NameParser.parse();
                CertificateRequest certificateRequest = new CertificateRequest((PublicKey)rSAPublicKey, name);
                PKCS11SignatureEngine pKCS11SignatureEngine = new PKCS11SignatureEngine("SHA1withRSA", (Session)mechanismInfo, Mechanism.RSA_PKCS, AlgorithmID.sha1);
                AlgorithmIDAdapter algorithmIDAdapter = new AlgorithmIDAdapter(AlgorithmID.sha1WithRSAEncryption);
                algorithmIDAdapter.setSignatureInstance(pKCS11SignatureEngine);
                TokenPrivateKey tokenPrivateKey = new TokenPrivateKey(privateKey);
                output_.print("signing certificate request... ");
                certificateRequest.sign((AlgorithmID)algorithmIDAdapter, (PrivateKey)tokenPrivateKey);
                output_.println("finished");
                output_.print("writing certificate request to file \"");
                output_.print(stringArray[3]);
                output_.print("\"... ");
                String string = "-----BEGIN NEW CERTIFICATE REQUEST-----";
                String string2 = "-----END NEW CERTIFICATE REQUEST-----";
                PemOutputStream pemOutputStream = new PemOutputStream((OutputStream)new FileOutputStream(stringArray[3]), string, string2);
                certificateRequest.writeTo((OutputStream)pemOutputStream);
                pemOutputStream.flush();
                pemOutputStream.close();
                output_.println("finished");
                output_.println("################################################################################");
                mechanismInfo.closeSession();
                module.finalize(null);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            Object var2_22 = null;
            output_.close();
        }
        catch (Throwable throwable) {
            Object var2_23 = null;
            output_.close();
            throw throwable;
        }
    }

    public static void printUsage() {
        output_.println("Usage: SignCertificateRequest <PKCS#11 module> <DER-encoded X.509 public RSA key file> <RFC2253 subject name> <PEM-encoded PKCS#10 certificate request output file>");
        output_.println(" e.g.: SignCertificateRequest pk2priv.dll publicKey.xpk \"CN=Karl Scheibelhofer,O=IAIK,C=AT,EMAIL=karl.scheibelhofer@iaik.at\" certificateRequest.p10");
        output_.println("The given DLL must be in the search path of the system.");
    }
}

