/*
 * Decompiled with CFR 0.152.
 */
package demo.pkcs.pkcs11;

import demo.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.Module;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.TokenInfo;
import iaik.pkcs.pkcs11.objects.Data;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;

public class ReadDataObject {
    static PrintWriter output_;
    static BufferedReader input_;

    static {
        try {
            output_ = new PrintWriter(System.out, true);
            input_ = new BufferedReader(new InputStreamReader(System.in));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            output_ = new PrintWriter(System.out, true);
            input_ = new BufferedReader(new InputStreamReader(System.in));
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 3) {
            ReadDataObject.printUsage();
            System.exit(1);
        }
        try {
            Data data;
            Module module = Module.getInstance((String)stringArray[0]);
            module.initialize(null);
            Token token = Util.selectToken(module, output_, input_);
            if (token == null) {
                output_.println("We have no token to proceed. Finished.");
                output_.flush();
                System.exit(0);
            }
            TokenInfo tokenInfo = token.getTokenInfo();
            output_.println("################################################################################");
            output_.println("Information of Token:");
            output_.println(tokenInfo);
            output_.println("################################################################################");
            Session session = Util.openAuthorizedSession(token, true, output_, input_);
            output_.println("################################################################################");
            output_.println("searching for data object on the card using this search template... ");
            output_.flush();
            Data data2 = new Data();
            data2.getLabel().setCharArrayValue(stringArray[1].toCharArray());
            output_.println(data2);
            session.findObjectsInit((iaik.pkcs.pkcs11.objects.Object)data2);
            iaik.pkcs.pkcs11.objects.Object[] objectArray = session.findObjects(1);
            if (objectArray.length > 0) {
                data = (Data)objectArray[0];
                output_.println("________________________________________________________________________________");
                output_.print("found this data object with handle: ");
                output_.println(data.getObjectHandle());
                output_.println(data);
                output_.println("________________________________________________________________________________");
            } else {
                data = null;
            }
            session.findObjectsFinal();
            output_.println("################################################################################");
            output_.println("################################################################################");
            output_.println("Writing content data (value attribute) to: " + stringArray[2]);
            FileOutputStream fileOutputStream = new FileOutputStream(stringArray[2]);
            byte[] byArray = data.getValue().getByteArrayValue();
            if (byArray != null) {
                ((OutputStream)fileOutputStream).write(byArray);
            }
            fileOutputStream.flush();
            ((OutputStream)fileOutputStream).close();
            output_.println("################################################################################");
            session.closeSession();
            module.finalize(null);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected static void printUsage() {
        output_.println("ReadDataObject <PKCS#11 module name> <data object label> <output file>");
        output_.println("e.g.: ReadDataObject gclib.dll \"Student Data\" data.dat");
    }
}

