/*
 * Decompiled with CFR 0.152.
 */
package demo.pkcs.pkcs11;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.Module;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.Slot;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.DES3SecretKey;
import iaik.pkcs.pkcs11.objects.Key;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.util.Arrays;

public class MAC {
    static PrintWriter output_;

    static {
        try {
            output_ = new PrintWriter(System.out, true);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            output_ = new PrintWriter(System.out, true);
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 3) {
            MAC.printUsage();
            System.exit(1);
        }
        try {
            int n;
            Module module = Module.getInstance((String)stringArray[0]);
            module.initialize(null);
            Slot[] slotArray = module.getSlotList(true);
            if (slotArray.length == 0) {
                output_.println("No slot with present token found!");
                System.exit(0);
            }
            Slot slot = slotArray[0];
            Token token = slot.getToken();
            Session session = token.openSession(true, false, null, null);
            output_.println("################################################################################");
            output_.println("generate secret MAC key");
            Mechanism mechanism = Mechanism.DES3_KEY_GEN;
            DES3SecretKey dES3SecretKey = new DES3SecretKey();
            dES3SecretKey.getSign().setBooleanValue(Boolean.TRUE);
            dES3SecretKey.getVerify().setBooleanValue(Boolean.TRUE);
            DES3SecretKey dES3SecretKey2 = (DES3SecretKey)session.generateKey(mechanism, (iaik.pkcs.pkcs11.objects.Object)dES3SecretKey);
            output_.println("################################################################################");
            output_.println("################################################################################");
            output_.println("MACing data from file: " + stringArray[2]);
            FileInputStream fileInputStream = new FileInputStream(stringArray[2]);
            Mechanism mechanism2 = Mechanism.SHA_1_HMAC;
            session.signInit(mechanism2, (Key)dES3SecretKey2);
            byte[] byArray = new byte[1024];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n = ((InputStream)fileInputStream).read(byArray)) >= 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            Arrays.fill(byArray, (byte)0);
            byteArrayOutputStream.flush();
            byteArrayOutputStream.close();
            ((InputStream)fileInputStream).close();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            byte[] byArray3 = session.sign(byArray2);
            output_.println("The MAC value is: " + new BigInteger(1, byArray3).toString(16));
            output_.println("################################################################################");
            output_.println("################################################################################");
            output_.print("verification of the MAC... ");
            fileInputStream = new FileInputStream(stringArray[2]);
            session.verifyInit(mechanism2, (Key)dES3SecretKey2);
            byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n = ((InputStream)fileInputStream).read(byArray)) >= 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            Arrays.fill(byArray, (byte)0);
            byteArrayOutputStream.flush();
            byteArrayOutputStream.close();
            ((InputStream)fileInputStream).close();
            byArray2 = byteArrayOutputStream.toByteArray();
            try {
                session.verify(byArray2, byArray3);
                output_.println("successful");
            }
            catch (TokenException tokenException) {
                output_.println("FAILED: " + tokenException.getMessage());
            }
            output_.println("################################################################################");
            session.closeSession();
            module.finalize(null);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void printUsage() {
        output_.println("Usage: MAC <PKCS#11 module> <user-PIN> <file to be MACed>");
        output_.println(" e.g.: MAC pk2priv.dll password data.dat");
        output_.println("The given DLL must be in the search path of the system.");
    }
}

