/*
 * Decompiled with CFR 0.152.
 */
package demo.pkcs.pkcs11;

import demo.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.Module;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.TokenInfo;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;

public class InitToken {
    static PrintWriter output_;
    static BufferedReader input_;

    static {
        try {
            output_ = new PrintWriter(System.out, true);
            input_ = new BufferedReader(new InputStreamReader(System.in));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            output_ = new PrintWriter(System.out, true);
            input_ = new BufferedReader(new InputStreamReader(System.in));
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            InitToken.printUsage();
            System.exit(1);
        }
        try {
            Module module = Module.getInstance((String)stringArray[0]);
            module.initialize(null);
            Token token = Util.selectToken(module, output_, input_);
            if (token == null) {
                output_.println("We have no token to proceed. Finished.");
                output_.flush();
                System.exit(0);
            }
            TokenInfo tokenInfo = token.getTokenInfo();
            output_.println("################################################################################");
            output_.println("Information of Token to be initialized:");
            output_.println(tokenInfo);
            output_.println("################################################################################");
            output_.print("initializing... ");
            String string = null;
            if (tokenInfo.isProtectedAuthenticationPath()) {
                output_.print("Please enter the SO-PIN at the PIN-pad of your reader.");
                token.initToken(null, stringArray[1]);
            } else {
                output_.print("Enter the SO-PIN and press [return key]: ");
                output_.flush();
                string = input_.readLine();
                token.initToken(string.toCharArray(), stringArray[1]);
            }
            output_.println("FINISHED");
            if (tokenInfo.isLoginRequired()) {
                output_.print("initializing user-PIN... ");
                Session session = token.openSession(true, true, null, null);
                if (tokenInfo.isProtectedAuthenticationPath()) {
                    output_.print("Please enter the SO-PIN at the PIN-pad of your reader.");
                    output_.flush();
                    session.login(false, null);
                    output_.print("Please enter the user-PIN at the PIN-pad of your reader.");
                    output_.flush();
                    session.initPIN(null);
                } else {
                    if (string != null) {
                        session.login(false, string.toCharArray());
                    } else {
                        output_.print("Enter the SO-PIN and press [return key]: ");
                        output_.flush();
                        string = input_.readLine();
                        session.login(false, string.toCharArray());
                    }
                    output_.print("Enter the user-PIN and press [return key]: ");
                    output_.flush();
                    String string2 = input_.readLine();
                    session.initPIN(string2.toCharArray());
                }
                session.closeSession();
                output_.println("FINISHED");
            }
            output_.println("################################################################################");
            tokenInfo = token.getTokenInfo();
            output_.println("################################################################################");
            output_.println("Information of initialized Token:");
            output_.println(tokenInfo);
            output_.println("################################################################################");
            module.finalize(null);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void printUsage() {
        output_.println("Usage: InitToken <PKCS#11 module> \"Card Label\"");
        output_.println(" e.g.: InitToken pk2priv.dll \"My Test Card\"");
        output_.println("ATTENTION: Any data on the card will get lost upon initialization!");
        output_.println("The given DLL must be in the search path of the system.");
    }
}

