/*
 * Decompiled with CFR 0.152.
 */
package demo.pkcs.pkcs11;

import iaik.pkcs.pkcs11.Info;
import iaik.pkcs.pkcs11.InitializeArgs;
import iaik.pkcs.pkcs11.Module;
import iaik.pkcs.pkcs11.MutexHandler;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;

public class InitArgs
implements InitializeArgs {
    static PrintWriter output_;
    protected byte[] reservedParameter_;

    static {
        try {
            output_ = new PrintWriter(System.out, true);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            output_ = new PrintWriter(System.out, true);
        }
    }

    public InitArgs(byte[] byArray) {
        this.reservedParameter_ = byArray;
    }

    public MutexHandler getMutexHandler() {
        output_.println("getMutexHandler() called");
        return null;
    }

    public Object getReserved() {
        output_.println("getReserved() called");
        return this.reservedParameter_;
    }

    public boolean isLibraryCantCreateOsThreads() {
        output_.println("isLibraryCantCreateOsThreads() called");
        return false;
    }

    public boolean isOsLockingOk() {
        output_.println("isOsLockingOk() called");
        return true;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 1 || stringArray.length == 2) {
            try {
                output_.println("################################################################################");
                output_.println("load and initialize module \"" + stringArray[0] + "\" using InitializeArgs");
                output_.flush();
                Module module = Module.getInstance((String)stringArray[0]);
                byte[] byArray = stringArray.length >= 2 ? InitArgs.readStream(new FileInputStream(stringArray[1])) : null;
                InitArgs initArgs = new InitArgs(byArray);
                module.initialize((InitializeArgs)initArgs);
                Info info = module.getInfo();
                output_.println(info);
                output_.println("################################################################################");
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        } else {
            InitArgs.printUsage();
        }
        System.gc();
    }

    protected static void printUsage() {
        output_.println("InitArgs <PKCS#11 module name> [<file providing reserved parameter>]");
        output_.println("e.g.: InitArgs slbck.dll");
    }

    protected static byte[] readStream(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(256);
        byte[] byArray = new byte[256];
        while ((n = inputStream.read(byArray)) >= 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

