/*
 * Decompiled with CFR 0.152.
 */
package demo.pkcs.pkcs11;

import iaik.pkcs.pkcs11.DefaultInitializeArgs;
import iaik.pkcs.pkcs11.InitializeArgs;
import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.Module;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.Slot;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.TokenInfo;
import iaik.pkcs.pkcs11.objects.X509AttributeCertificate;
import iaik.pkcs.pkcs11.objects.X509PublicKeyCertificate;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;

public class GetInfoWithWrapperPath {
    static PrintWriter output_;
    static BufferedReader input_;

    static {
        try {
            output_ = new PrintWriter(System.out, true);
            input_ = new BufferedReader(new InputStreamReader(System.in));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            output_ = new PrintWriter(System.out, true);
            input_ = new BufferedReader(new InputStreamReader(System.in));
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 2 || stringArray.length == 3) {
            try {
                Object object;
                Mechanism[] mechanismArray;
                Slot[] slotArray;
                Object[] objectArray;
                DefaultInitializeArgs defaultInitializeArgs;
                output_.println("################################################################################");
                output_.println("load and initialize module: " + stringArray[0]);
                output_.flush();
                Module module = Module.getInstance((String)stringArray[0], (String)stringArray[1]);
                if (stringArray.length == 2) {
                    module.initialize(null);
                } else {
                    defaultInitializeArgs = new DefaultInitializeArgs();
                    objectArray = stringArray[2].getBytes();
                    byte[] byArray = new byte[objectArray.length + 5];
                    System.arraycopy(objectArray, 0, byArray, 0, objectArray.length);
                    defaultInitializeArgs.setReserved((Object)byArray);
                    module.initialize((InitializeArgs)defaultInitializeArgs);
                }
                defaultInitializeArgs = module.getInfo();
                output_.println(defaultInitializeArgs);
                output_.println("################################################################################");
                output_.println("################################################################################");
                output_.println("getting list of all slots");
                objectArray = module.getSlotList(false);
                int n = 0;
                while (n < objectArray.length) {
                    output_.println("________________________________________________________________________________");
                    slotArray = objectArray[n].getSlotInfo();
                    output_.print("Slot with ID: ");
                    output_.println(objectArray[n].getSlotID());
                    output_.println("--------------------------------------------------------------------------------");
                    output_.println(slotArray);
                    output_.println("________________________________________________________________________________");
                    ++n;
                }
                output_.println("################################################################################");
                output_.println("################################################################################");
                output_.println("getting list of all tokens");
                slotArray = module.getSlotList(true);
                Token[] tokenArray = new Token[slotArray.length];
                int n2 = 0;
                while (n2 < slotArray.length) {
                    output_.println("________________________________________________________________________________");
                    tokenArray[n2] = slotArray[n2].getToken();
                    TokenInfo tokenInfo = tokenArray[n2].getTokenInfo();
                    output_.print("Token in slot with ID: ");
                    output_.println(tokenArray[n2].getSlot().getSlotID());
                    output_.println("--------------------------------------------------------------------------------");
                    output_.println(tokenInfo);
                    output_.println("supported Mechanisms:");
                    mechanismArray = tokenArray[n2].getMechanismList();
                    int n3 = 0;
                    while (n3 < mechanismArray.length) {
                        output_.println("--------------------------------------------------------------------------------");
                        output_.println("Mechanism Name: " + mechanismArray[n3].getName());
                        object = tokenArray[n2].getMechanismInfo(mechanismArray[n3]);
                        output_.println(object);
                        output_.println("--------------------------------------------------------------------------------");
                        ++n3;
                    }
                    output_.println("________________________________________________________________________________");
                    ++n2;
                }
                output_.println("################################################################################");
                output_.println("################################################################################");
                output_.println("listing objects on tokens");
                int n4 = 0;
                while (n4 < tokenArray.length) {
                    output_.println("________________________________________________________________________________");
                    output_.println("listing objects for token: ");
                    mechanismArray = tokenArray[n4].getTokenInfo();
                    output_.println(mechanismArray);
                    Session session = tokenArray[n4].openSession(true, false, null, null);
                    if (mechanismArray.isLoginRequired()) {
                        if (mechanismArray.isProtectedAuthenticationPath()) {
                            session.login(true, null);
                        } else {
                            output_.print("Enter user-PIN or press [return] to list just public objects: ");
                            output_.flush();
                            object = input_.readLine();
                            output_.println();
                            output_.print("listing all" + (((String)object).length() > 0 ? "" : " public") + " objects on token");
                            if (((String)object).length() > 0) {
                                session.login(true, ((String)object).toCharArray());
                            }
                        }
                    }
                    object = session.getSessionInfo();
                    output_.println(" using session:");
                    output_.println(object);
                    session.findObjectsInit(null);
                    iaik.pkcs.pkcs11.objects.Object[] objectArray2 = session.findObjects(1);
                    CertificateFactory certificateFactory = null;
                    while (objectArray2.length > 0) {
                        Certificate certificate;
                        byte[] byArray;
                        iaik.pkcs.pkcs11.objects.Object object2 = objectArray2[0];
                        output_.println("--------------------------------------------------------------------------------");
                        output_.println("Object with handle: " + objectArray2[0].getObjectHandle());
                        output_.println(object2);
                        if (object2 instanceof X509PublicKeyCertificate) {
                            try {
                                byArray = ((X509PublicKeyCertificate)object2).getValue().getByteArrayValue();
                                if (certificateFactory == null) {
                                    certificateFactory = CertificateFactory.getInstance("X.509");
                                }
                                certificate = certificateFactory.generateCertificate(new ByteArrayInputStream(byArray));
                                output_.println("................................................................................");
                                output_.println("The decoded X509PublicKeyCertificate is:");
                                output_.println(certificate.toString());
                                output_.println("................................................................................");
                            }
                            catch (Exception exception) {
                                output_.println("Could not decode this X509PublicKeyCertificate. Exception is: " + exception.toString());
                            }
                        } else if (object2 instanceof X509AttributeCertificate) {
                            try {
                                byArray = ((X509AttributeCertificate)object2).getValue().getByteArrayValue();
                                if (certificateFactory == null) {
                                    certificateFactory = CertificateFactory.getInstance("X.509");
                                }
                                certificate = certificateFactory.generateCertificate(new ByteArrayInputStream(byArray));
                                output_.println("................................................................................");
                                output_.println("The decoded X509AttributeCertificate is:");
                                output_.println(certificate.toString());
                                output_.println("................................................................................");
                            }
                            catch (Exception exception) {
                                output_.println("Could not decode this X509AttributeCertificate. Exception is: " + exception.toString());
                            }
                        }
                        output_.println("--------------------------------------------------------------------------------");
                        objectArray2 = session.findObjects(1);
                    }
                    session.findObjectsFinal();
                    session.closeSession();
                    output_.println("________________________________________________________________________________");
                    ++n4;
                }
                output_.println("################################################################################");
                module.finalize(null);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        } else {
            GetInfoWithWrapperPath.printUsage();
        }
        System.gc();
        System.exit(0);
    }

    protected static void printUsage() {
        output_.println("GetInfo <PKCS#11 module name> <full path to pkcs11wrapper.dll> [<initialization parameters>]");
        output_.println("e.g.: GetInfo aetpkss1.dll C:\\provider\\lib\\win32\\pkcs11wrapper.dll");
    }
}

