/*
 * Decompiled with CFR 0.152.
 */
package demo.pkcs.pkcs11;

import demo.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.Module;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.Slot;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.TokenInfo;
import iaik.pkcs.pkcs11.objects.KeyPair;
import iaik.pkcs.pkcs11.objects.RSAPrivateKey;
import iaik.pkcs.pkcs11.objects.RSAPublicKey;
import iaik.pkcs.pkcs11.wrapper.Functions;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;

public class GenerateKeyPair2048 {
    static BufferedReader input_;
    static PrintWriter output_;
    static /* synthetic */ Class class$java$security$spec$X509EncodedKeySpec;

    static {
        try {
            output_ = new PrintWriter(System.out, true);
            input_ = new BufferedReader(new InputStreamReader(System.in));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            output_ = new PrintWriter(System.out, true);
            input_ = new BufferedReader(new InputStreamReader(System.in));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            GenerateKeyPair2048.printUsage();
            System.exit(1);
        }
        try {
            Module module = Module.getInstance((String)stringArray[0]);
            module.initialize(null);
            Slot[] slotArray = module.getSlotList(true);
            if (slotArray.length == 0) {
                output_.println("No slot with present token found!");
                System.exit(0);
            }
            Slot slot = slotArray[0];
            Token token = slot.getToken();
            TokenInfo tokenInfo = token.getTokenInfo();
            output_.println("################################################################################");
            output_.println("Information of Token:");
            output_.println(tokenInfo);
            output_.println("################################################################################");
            Session session = Util.openAuthorizedSession(token, true, output_, input_);
            output_.println("################################################################################");
            output_.print("Generating new 2048 bit RSA key-pair... ");
            output_.flush();
            HashSet<Mechanism> hashSet = new HashSet<Mechanism>(Arrays.asList(token.getMechanismList()));
            Object object = hashSet.contains(Mechanism.RSA_PKCS) ? token.getMechanismInfo(Mechanism.RSA_PKCS) : (hashSet.contains(Mechanism.RSA_X_509) ? token.getMechanismInfo(Mechanism.RSA_X_509) : (hashSet.contains(Mechanism.RSA_9796) ? token.getMechanismInfo(Mechanism.RSA_9796) : (hashSet.contains(Mechanism.RSA_PKCS_OAEP) ? token.getMechanismInfo(Mechanism.RSA_PKCS_OAEP) : null)));
            Mechanism mechanism = Mechanism.RSA_PKCS_KEY_PAIR_GEN;
            RSAPublicKey rSAPublicKey = new RSAPublicKey();
            RSAPrivateKey rSAPrivateKey = new RSAPrivateKey();
            rSAPublicKey.getModulusBits().setLongValue(new Long(2048L));
            byte[] byArray = new byte[3];
            byArray[0] = 1;
            byArray[2] = 1;
            byte[] byArray2 = byArray;
            rSAPublicKey.getPublicExponent().setByteArrayValue(byArray2);
            rSAPublicKey.getToken().setBooleanValue(Boolean.TRUE);
            byte[] byArray3 = new byte[20];
            new Random().nextBytes(byArray3);
            rSAPublicKey.getId().setByteArrayValue(byArray3);
            rSAPrivateKey.getSensitive().setBooleanValue(Boolean.TRUE);
            rSAPrivateKey.getToken().setBooleanValue(Boolean.TRUE);
            rSAPrivateKey.getPrivate().setBooleanValue(Boolean.TRUE);
            rSAPrivateKey.getId().setByteArrayValue(byArray3);
            if (object != null) {
                rSAPublicKey.getVerify().setBooleanValue(new Boolean(object.isVerify()));
                rSAPublicKey.getVerifyRecover().setBooleanValue(new Boolean(object.isVerifyRecover()));
                rSAPublicKey.getEncrypt().setBooleanValue(new Boolean(object.isEncrypt()));
                rSAPublicKey.getDerive().setBooleanValue(new Boolean(object.isDerive()));
                rSAPublicKey.getWrap().setBooleanValue(new Boolean(object.isWrap()));
                rSAPrivateKey.getSign().setBooleanValue(new Boolean(object.isSign()));
                rSAPrivateKey.getSignRecover().setBooleanValue(new Boolean(object.isSignRecover()));
                rSAPrivateKey.getDecrypt().setBooleanValue(new Boolean(object.isDecrypt()));
                rSAPrivateKey.getDerive().setBooleanValue(new Boolean(object.isDerive()));
                rSAPrivateKey.getUnwrap().setBooleanValue(new Boolean(object.isUnwrap()));
            } else {
                rSAPrivateKey.getSign().setBooleanValue(Boolean.TRUE);
                rSAPrivateKey.getDecrypt().setBooleanValue(Boolean.TRUE);
                rSAPublicKey.getVerify().setBooleanValue(Boolean.TRUE);
                rSAPublicKey.getEncrypt().setBooleanValue(Boolean.TRUE);
            }
            rSAPublicKey.getKeyType().setPresent(false);
            rSAPublicKey.getObjectClass().setPresent(false);
            rSAPrivateKey.getKeyType().setPresent(false);
            rSAPrivateKey.getObjectClass().setPresent(false);
            KeyPair keyPair = session.generateKeyPair(mechanism, (iaik.pkcs.pkcs11.objects.Object)rSAPublicKey, (iaik.pkcs.pkcs11.objects.Object)rSAPrivateKey);
            RSAPublicKey rSAPublicKey2 = (RSAPublicKey)keyPair.getPublicKey();
            RSAPrivateKey rSAPrivateKey2 = (RSAPrivateKey)keyPair.getPrivateKey();
            output_.println("Success");
            output_.println("The public key is");
            output_.println("_______________________________________________________________________________");
            output_.println(rSAPublicKey2);
            output_.println("_______________________________________________________________________________");
            output_.println("The private key is");
            output_.println("_______________________________________________________________________________");
            output_.println(rSAPrivateKey2);
            output_.println("_______________________________________________________________________________");
            output_.println("################################################################################");
            output_.println("Writing the public key of the generated key-pair to file: " + stringArray[1]);
            RSAPublicKey rSAPublicKey3 = rSAPublicKey2;
            BigInteger bigInteger = new BigInteger(1, rSAPublicKey3.getModulus().getByteArrayValue());
            BigInteger bigInteger2 = new BigInteger(1, rSAPublicKey3.getPublicExponent().getByteArrayValue());
            RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(bigInteger, bigInteger2);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            java.security.interfaces.RSAPublicKey rSAPublicKey4 = (java.security.interfaces.RSAPublicKey)keyFactory.generatePublic(rSAPublicKeySpec);
            X509EncodedKeySpec x509EncodedKeySpec = (X509EncodedKeySpec)keyFactory.getKeySpec(rSAPublicKey4, class$java$security$spec$X509EncodedKeySpec != null ? class$java$security$spec$X509EncodedKeySpec : (class$java$security$spec$X509EncodedKeySpec = GenerateKeyPair2048.class$("java.security.spec.X509EncodedKeySpec")));
            FileOutputStream fileOutputStream = new FileOutputStream(stringArray[1]);
            fileOutputStream.write(x509EncodedKeySpec.getEncoded());
            fileOutputStream.flush();
            fileOutputStream.close();
            output_.println("################################################################################");
            output_.println("################################################################################");
            output_.println("Trying to search for the public key of the generated key-pair by ID: " + Functions.toHexString((byte[])byArray3));
            RSAPublicKey rSAPublicKey5 = new RSAPublicKey();
            rSAPublicKey5.getId().setByteArrayValue(byArray3);
            session.findObjectsInit((iaik.pkcs.pkcs11.objects.Object)rSAPublicKey5);
            iaik.pkcs.pkcs11.objects.Object[] objectArray = session.findObjects(1);
            session.findObjectsFinal();
            if (objectArray.length != 1) {
                output_.println("Error: Cannot find the public key under the given ID!");
            } else {
                output_.println("Found public key!");
                output_.println("_______________________________________________________________________________");
                output_.println(objectArray[0]);
                output_.println("_______________________________________________________________________________");
            }
            output_.println("################################################################################");
            session.closeSession();
            module.finalize(null);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void printUsage() {
        output_.println("Usage: GenerateKeyPair2048 <PKCS#11 module> <X.509 encoded public key file>");
        output_.println(" e.g.: GenerateKeyPair2048 pk2priv.dll publicKey.xpk");
        output_.println("The given DLL must be in the search path of the system.");
    }
}

