/*
 * Decompiled with CFR 0.152.
 */
package demo.pkcs.pkcs11;

import demo.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.Module;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.TokenInfo;
import iaik.pkcs.pkcs11.objects.Data;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;

public class DownloadData {
    static BufferedReader input_;
    static PrintWriter output_;

    static {
        try {
            output_ = new PrintWriter(System.out, true);
            input_ = new BufferedReader(new InputStreamReader(System.in));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            output_ = new PrintWriter(System.out, true);
            input_ = new BufferedReader(new InputStreamReader(System.in));
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 3) {
            DownloadData.printUsage();
            System.exit(1);
        }
        try {
            int n;
            Module module = Module.getInstance((String)stringArray[0]);
            module.initialize(null);
            Token token = Util.selectToken(module, output_, input_);
            if (token == null) {
                output_.println("We have no token to proceed. Finished.");
                output_.flush();
                System.exit(0);
            }
            TokenInfo tokenInfo = token.getTokenInfo();
            output_.println("################################################################################");
            output_.println("Information of Token:");
            output_.println(tokenInfo);
            output_.println("################################################################################");
            output_.println("################################################################################");
            output_.println("Reading data from: " + stringArray[1]);
            FileInputStream fileInputStream = new FileInputStream(stringArray[1]);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(256);
            byte[] byArray = new byte[4096];
            while ((n = ((InputStream)fileInputStream).read(byArray)) >= 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            ((InputStream)fileInputStream).close();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            output_.println("################################################################################");
            Session session = Util.openAuthorizedSession(token, true, output_, input_);
            output_.println("################################################################################");
            output_.println("creating data object on the card... ");
            output_.flush();
            Data data = new Data();
            data.getLabel().setCharArrayValue(stringArray[2].toCharArray());
            data.getValue().setByteArrayValue(byArray2);
            data.getToken().setBooleanValue(Boolean.TRUE);
            output_.println(data);
            session.createObject((iaik.pkcs.pkcs11.objects.Object)data);
            output_.println("################################################################################");
            session.closeSession();
            module.finalize(null);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void printUsage() {
        output_.println("Usage: DownloadData <PKCS#11 module> <data file> <data object label>");
        output_.println(" e.g.: DownloadData gclib.dll data.dat \"Student Data\"");
        output_.println("The given DLL must be in the search path of the system.");
    }
}

