/*
 * Decompiled with CFR 0.152.
 */
package demo.pkcs.pkcs11;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.Module;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.Slot;
import iaik.pkcs.pkcs11.Token;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Arrays;

public class ConcurrentHash {
    public static void main(String[] stringArray) {
        if (stringArray.length == 3) {
            try {
                int n;
                System.out.println("################################################################################");
                System.out.println("load and initialize module: " + stringArray[0]);
                Module module = Module.getInstance((String)stringArray[0]);
                module.initialize(null);
                System.out.println("load and initialize module: " + stringArray[1]);
                Module module2 = Module.getInstance((String)stringArray[1]);
                module2.initialize(null);
                System.out.println("################################################################################");
                System.out.println("################################################################################");
                System.out.println("getting tokens");
                Slot[] slotArray = module.getSlotList(true);
                if (slotArray.length < 1) {
                    System.err.println("No token present for module: " + module.getInfo());
                    System.exit(1);
                }
                Token token = slotArray[0].getToken();
                System.out.println("________________________________________________________________________________");
                System.out.println("token #1:");
                System.out.println(token.getTokenInfo());
                System.out.println("________________________________________________________________________________");
                Slot[] slotArray2 = module2.getSlotList(true);
                if (slotArray2.length < 1) {
                    System.err.println("No token present for module: " + module2.getInfo());
                    System.exit(1);
                }
                Token token2 = slotArray2[0].getToken();
                System.out.println("________________________________________________________________________________");
                System.out.println("token #2:");
                System.out.println(token2.getTokenInfo());
                System.out.println("________________________________________________________________________________");
                System.out.println("################################################################################");
                System.out.println("################################################################################");
                System.out.println("opening sessions");
                Session session = token.openSession(true, false, null, null);
                Session session2 = token2.openSession(true, false, null, null);
                System.out.println("opening data file: " + stringArray[2]);
                FileInputStream fileInputStream = new FileInputStream(stringArray[2]);
                Mechanism mechanism = Mechanism.SHA_1;
                System.out.println("initializing sessions for hashing");
                session.digestInit(mechanism);
                session2.digestInit(mechanism);
                byte[] byArray = new byte[1024];
                while ((n = ((InputStream)fileInputStream).read(byArray)) >= 0) {
                    byte[] byArray2 = new byte[n];
                    System.arraycopy(byArray, 0, byArray2, 0, n);
                    session.digestUpdate(byArray2);
                    session2.digestUpdate(byArray2);
                    Arrays.fill(byArray2, (byte)0);
                }
                Arrays.fill(byArray, (byte)0);
                byte[] byArray3 = session.digestFinal();
                byte[] byArray4 = session2.digestFinal();
                System.out.println("The SHA-1 hash value #1 is: " + new BigInteger(1, byArray3).toString(16));
                System.out.println("The SHA-1 hash value #2 is: " + new BigInteger(1, byArray4).toString(16));
                if (Arrays.equals(byArray3, byArray4)) {
                    System.out.println("The hash values are equal.");
                } else {
                    System.out.println("The hash values are different. Test failed");
                }
                System.out.println("closing sessions");
                session.closeSession();
                session2.closeSession();
                System.out.println("################################################################################");
                System.out.println("################################################################################");
                System.out.println("verifying hash with software digest");
                MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
                fileInputStream = new FileInputStream(stringArray[2]);
                while ((n = ((InputStream)fileInputStream).read(byArray)) >= 0) {
                    messageDigest.update(byArray, 0, n);
                }
                ((InputStream)fileInputStream).close();
                byte[] byArray5 = messageDigest.digest();
                Arrays.fill(byArray, (byte)0);
                System.out.println("The software digest value is: " + new BigInteger(1, byArray5).toString(16));
                if (Arrays.equals(byArray3, byArray5) && Arrays.equals(byArray4, byArray5)) {
                    System.out.println("All SHA-1 hash values are equal. Test passed successfully.");
                } else {
                    System.out.println("Verification of hash value FAILED!");
                }
                System.out.println("################################################################################");
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        } else {
            ConcurrentHash.printUsage();
        }
        System.gc();
    }

    protected static void printUsage() {
        System.out.println("ConcurrentHash <PKCS#11 module name #1> <PKCS#11 module name #2> <data>");
        System.out.println("e.g.: ConcurrentHash pk2priv.dll softtoken.dll data.dat");
        System.out.println("Both modules must support hashing without the user being logged in.");
    }
}

