/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.isqlviewer.util.Base64FormatException;
import org.isqlviewer.util.StringUtilities;

public class Base64Decoder {
    private static final int BUFFER_SIZE = 1024;
    InputStream in = null;
    OutputStream out = null;
    boolean stringp = false;

    private final int get1(byte[] buf, int off) {
        return (buf[off] & 0x3F) << 2 | (buf[off + 1] & 0x30) >>> 4;
    }

    private final int get2(byte[] buf, int off) {
        return (buf[off + 1] & 0xF) << 4 | (buf[off + 2] & 0x3C) >>> 2;
    }

    private final int get3(byte[] buf, int off) {
        return (buf[off + 2] & 3) << 6 | buf[off + 3] & 0x3F;
    }

    private final int check(int ch) {
        if (ch >= 65 && ch <= 90) {
            return ch - 65;
        }
        if (ch >= 97 && ch <= 122) {
            return ch - 97 + 26;
        }
        if (ch >= 48 && ch <= 57) {
            return ch - 48 + 52;
        }
        switch (ch) {
            case 61: {
                return 65;
            }
            case 43: {
                return 62;
            }
            case 47: {
                return 63;
            }
        }
        return -1;
    }

    public void process() throws IOException, Base64FormatException {
        byte[] buffer = new byte[1024];
        byte[] chunk = new byte[4];
        int got = -1;
        int ready = 0;
        block0: while ((got = this.in.read(buffer)) > 0) {
            int skiped = 0;
            while (skiped < got) {
                while (ready < 4) {
                    int ch;
                    if (skiped >= got) continue block0;
                    if ((ch = this.check(buffer[skiped++])) < 0) continue;
                    chunk[ready++] = (byte)ch;
                }
                if (chunk[2] == 65) {
                    this.out.write(this.get1(chunk, 0));
                    return;
                }
                if (chunk[3] == 65) {
                    this.out.write(this.get1(chunk, 0));
                    this.out.write(this.get2(chunk, 0));
                    return;
                }
                this.out.write(this.get1(chunk, 0));
                this.out.write(this.get2(chunk, 0));
                this.out.write(this.get3(chunk, 0));
                ready = 0;
            }
        }
        if (ready != 0) {
            throw new Base64FormatException("Invalid length.");
        }
        this.out.flush();
    }

    public String processString() throws Base64FormatException {
        String s;
        if (!this.stringp) {
            throw new RuntimeException("[processString] invalid call (not a String)");
        }
        try {
            this.process();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            String code = ((ByteArrayOutputStream)this.out).toString("ISO-8859-1");
            s = StringUtilities.decode(code);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("[processString] Unable to convert properly char to bytes");
        }
        return s;
    }

    public Base64Decoder(String input) {
        byte[] bytes;
        try {
            bytes = input.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(this.getClass().getName() + "[Constructor] Unable to convert" + "properly char to bytes");
        }
        this.stringp = true;
        this.in = new ByteArrayInputStream(bytes);
        this.out = new ByteArrayOutputStream();
    }

    public Base64Decoder(InputStream in, OutputStream out) {
        this.in = in;
        this.out = out;
        this.stringp = false;
    }
}

