/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.ui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import org.isqlviewer.swing.WizardPanel;
import org.isqlviewer.util.BasicUtilities;

public abstract class WizardContainer
extends JDialog {
    protected final String STEP_FINAL = "final.step";
    protected static final GridBagConstraints UI_CONSTRAINT = new GridBagConstraints(0, 0, 0, 0, 0.0, 0.0, 0, 0, new Insets(1, 1, 1, 1), 0, 0);
    private JButton btnNext = new JButton();
    private JButton btnPrev = new JButton();
    private JButton btnExit = new JButton();
    private JButton btnHome = new JButton();
    private JLabel lblBanner = new JLabel("");
    private JLabel lblComment = new JLabel("");
    private JLabel lblIcon = new JLabel(BasicUtilities.loadIconResource("Database24"));
    private StepPanel contentPane = new StepPanel();
    private JPanel pnlBanner = new JPanel(new GridBagLayout());
    private JPanel pnlToolbr = new JPanel(new GridBagLayout());
    private boolean isWizardStarted = false;
    private ArrayList steps = new ArrayList();

    public WizardContainer(Frame owner) {
        super(owner, true);
        this.initUI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addUserComponent(String name, Component c) {
        ArrayList arrayList = this.steps;
        synchronized (arrayList) {
            this.steps.add(name);
            this.contentPane.add(c, name);
            if (this.isWizardStarted) {
                this.contentPane.showCard(this.getCurrentStep());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertStepAfter(String step, String name, Component c) {
        ArrayList arrayList = this.steps;
        synchronized (arrayList) {
            int index = this.steps.indexOf(step);
            try {
                this.steps.add(++index, name);
                this.contentPane.add(c, name);
            }
            catch (Throwable t) {
                // empty catch block
            }
            this.contentPane.add(c, name);
            if (this.isWizardStarted) {
                this.contentPane.showCard(this.getCurrentStep());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeUserComponent(String name) {
        String current = this.getCurrentStep();
        if (current.equals(name)) {
            return;
        }
        ArrayList arrayList = this.steps;
        synchronized (arrayList) {
            Component c = this.contentPane.getCard(name);
            if (c != null) {
                this.steps.remove(name);
                this.contentPane.remove(c);
                if (this.isWizardStarted) {
                    this.contentPane.showCard(this.getCurrentStep());
                }
            }
        }
    }

    protected void setBanner(String text) {
        this.lblBanner.setText(text);
    }

    protected void setComment(String text) {
        this.lblComment.setText(text);
    }

    protected void setIcon(Icon ico) {
        this.lblIcon.setIcon(ico);
    }

    protected void startWizard() {
        if (this.steps.size() >= 1) {
            this.showStep((String)this.steps.get(0));
            this.isWizardStarted = true;
        }
    }

    protected void showStep(String step) {
        if (step == null) {
            return;
        }
        String current = this.getCurrentStep();
        this.contentPane.showCard(step);
        this.processStepChange(step, step.equals("final.step"), current);
    }

    protected void setNextStepEnabled(boolean f) {
        this.btnNext.setEnabled(f);
    }

    protected void setPreviousStepEnabled(boolean f) {
        this.btnPrev.setEnabled(f);
    }

    protected void setHomeAllowable(boolean f) {
        this.btnHome.setVisible(f);
        this.btnHome.setEnabled(f);
    }

    protected abstract void processStepChange(String var1, boolean var2, String var3);

    protected boolean isStepValid(String stepName) {
        return stepName != null;
    }

    protected String getCurrentStep() {
        return this.contentPane.getCurrentCard();
    }

    protected void processWindowEvent(WindowEvent e) {
        switch (e.getID()) {
            case 200: {
                this.contentPane.showFirstCard();
            }
        }
        super.processWindowEvent(e);
    }

    private void initUI() {
        this.setDefaultCloseOperation(2);
        JPanel cp = (JPanel)this.getContentPane();
        cp.setLayout(new GridBagLayout());
        this.configureToolbar();
        this.configureBanner();
        WizardContainer.constrain(0, 0, 1, 1, 0.0, 0.0, 10, 0);
        cp.add(Box.createHorizontalStrut(5), UI_CONSTRAINT);
        WizardContainer.constrain(1, 0, 1, 1, 1.0, 0.0, 10, 2);
        cp.add((Component)this.pnlBanner, UI_CONSTRAINT);
        WizardContainer.constrain(2, 0, 1, 1, 0.0, 0.0, 10, 0);
        cp.add(Box.createHorizontalStrut(5), UI_CONSTRAINT);
        WizardContainer.constrain(0, 1, 3, 1, 1.0, 1.0, 10, 1);
        cp.add((Component)this.contentPane, UI_CONSTRAINT);
        WizardContainer.constrain(0, 2, 1, 1, 0.0, 0.0, 10, 0);
        cp.add(Box.createHorizontalStrut(5), UI_CONSTRAINT);
        WizardContainer.constrain(1, 2, 1, 1, 1.0, 0.0, 10, 2);
        cp.add((Component)this.pnlToolbr, UI_CONSTRAINT);
        WizardContainer.constrain(2, 2, 1, 1, 0.0, 0.0, 10, 0);
        cp.add(Box.createHorizontalStrut(5), UI_CONSTRAINT);
    }

    private void configureToolbar() {
        this.btnHome.addActionListener(this.contentPane);
        this.btnPrev.addActionListener(this.contentPane);
        this.btnNext.addActionListener(this.contentPane);
        this.btnExit.addActionListener(this.contentPane);
        this.btnHome.setText(BasicUtilities.getString("Wizard_Home_Text"));
        this.btnPrev.setText(BasicUtilities.getString("Wizard_Prev_Text"));
        this.btnNext.setText(BasicUtilities.getString("Wizard_Next_Text"));
        this.btnExit.setText(BasicUtilities.getString("Wizard_Cancel_Text"));
        this.btnHome.setToolTipText(BasicUtilities.getString("Wizard_Home_Tip"));
        this.btnPrev.setToolTipText(BasicUtilities.getString("Wizard_Prev_Tip"));
        this.btnNext.setToolTipText(BasicUtilities.getString("Wizard_Next_Tip"));
        this.btnExit.setToolTipText(BasicUtilities.getString("Wizard_Cancel_Tip"));
        WizardContainer.constrain(0, 0, 1, 1, 1.0, 0.0, 10, 0);
        this.pnlToolbr.add(Box.createHorizontalGlue(), UI_CONSTRAINT);
        WizardContainer.constrain(1, 0, 1, 1, 0.0, 0.0, 13, 0);
        this.pnlToolbr.add((Component)this.btnHome, UI_CONSTRAINT);
        WizardContainer.constrain(2, 0, 1, 1, 0.0, 0.0, 13, 0);
        this.pnlToolbr.add((Component)this.btnPrev, UI_CONSTRAINT);
        WizardContainer.constrain(3, 0, 1, 1, 0.0, 0.0, 13, 0);
        this.pnlToolbr.add((Component)this.btnNext, UI_CONSTRAINT);
        WizardContainer.constrain(4, 0, 1, 1, 0.0, 0.0, 13, 0);
        this.pnlToolbr.add((Component)this.btnExit, UI_CONSTRAINT);
    }

    private void configureBanner() {
        this.pnlBanner.setBorder(BorderFactory.createLineBorder(UIManager.getColor("TextArea.foreground"), 1));
        this.pnlBanner.setBackground(UIManager.getColor("TextArea.background"));
        this.pnlBanner.setForeground(UIManager.getColor("TextArea.foreground"));
        this.lblBanner.setFont(this.lblBanner.getFont().deriveFont(1, 16.0f));
        this.lblBanner.setForeground(this.pnlBanner.getForeground());
        this.lblBanner.setBackground(this.pnlBanner.getBackground());
        this.lblComment.setFont(this.lblComment.getFont().deriveFont(2, 12.0f));
        this.lblComment.setForeground(this.pnlBanner.getForeground());
        this.lblComment.setBackground(this.pnlBanner.getBackground());
        WizardContainer.constrain(0, 0, 1, 2, 0.0, 0.0, 10, 0);
        this.pnlBanner.add(Box.createHorizontalStrut(12), UI_CONSTRAINT);
        WizardContainer.constrain(0, 0, 2, 1, 1.0, 0.0, 17, 2);
        this.pnlBanner.add((Component)this.lblBanner, UI_CONSTRAINT);
        WizardContainer.constrain(1, 1, 1, 1, 1.0, 0.0, 17, 2);
        this.pnlBanner.add((Component)this.lblComment, UI_CONSTRAINT);
        WizardContainer.constrain(2, 0, 1, 2, 0.0, 0.0, 10, 0);
        this.pnlBanner.add((Component)this.lblIcon, UI_CONSTRAINT);
        WizardContainer.constrain(3, 0, 1, 2, 0.0, 0.0, 10, 0);
        this.pnlBanner.add(Box.createHorizontalStrut(12), UI_CONSTRAINT);
    }

    protected static void constrain(int x, int y, int w, int h, double wx, double wy, int a, int f) {
        WizardContainer.UI_CONSTRAINT.gridx = x;
        WizardContainer.UI_CONSTRAINT.gridy = y;
        WizardContainer.UI_CONSTRAINT.gridwidth = w;
        WizardContainer.UI_CONSTRAINT.gridheight = h;
        WizardContainer.UI_CONSTRAINT.weightx = wx;
        WizardContainer.UI_CONSTRAINT.weighty = wy;
        WizardContainer.UI_CONSTRAINT.anchor = a;
        WizardContainer.UI_CONSTRAINT.fill = f;
    }

    private class StepPanel
    extends WizardPanel
    implements ActionListener {
        private StepPanel() {
        }

        public void showCard(Component card) {
            int idx;
            int index;
            if (card.getParent() != this) {
                this.add(card);
            }
            if ((index = this.getVisibleChildIndex()) != -1) {
                this.getComponent(index).setVisible(false);
            }
            if ((idx = WizardContainer.this.steps.indexOf(card.getName())) == 0) {
                WizardContainer.this.btnPrev.setEnabled(false);
                if (WizardContainer.this.btnHome.isVisible()) {
                    WizardContainer.this.btnHome.setEnabled(false);
                }
            } else {
                WizardContainer.this.btnPrev.setEnabled(true);
                if (WizardContainer.this.btnHome.isVisible()) {
                    WizardContainer.this.btnHome.setEnabled(true);
                }
            }
            if (idx == WizardContainer.this.steps.size() - 1) {
                WizardContainer.this.btnNext.setText(BasicUtilities.getString("Wizard_Finish_Text"));
            } else {
                WizardContainer.this.btnNext.setText(BasicUtilities.getString("Wizard_Next_Text"));
            }
            card.setVisible(true);
            this.fireStateChanged(new ChangeEvent(this));
            this.revalidate();
            this.repaint();
        }

        public void showCard(String name) {
            int nChildren = this.getComponentCount();
            for (int i = 0; i < nChildren; ++i) {
                Component child = this.getComponent(i);
                if (!child.getName().equals(name)) continue;
                this.showCard(child);
                break;
            }
        }

        public void showNextCard() {
            if (this.getComponentCount() <= 0) {
                return;
            }
            try {
                String card = this.getCurrentCard();
                int index = WizardContainer.this.steps.indexOf(card);
                if (index >= WizardContainer.this.steps.size() - 1) {
                    this.showLastCard();
                } else {
                    card = (String)WizardContainer.this.steps.get(++index);
                    this.showCard(card);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public void showPreviousCard() {
            if (this.getComponentCount() <= 0) {
                return;
            }
            try {
                String card = this.getCurrentCard();
                int index = WizardContainer.this.steps.indexOf(card);
                if (index >= 1) {
                    card = (String)WizardContainer.this.steps.get(--index);
                    this.showCard(card);
                } else {
                    this.showFirstCard();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public void showFirstCard() {
            if (this.getComponentCount() <= 0) {
                return;
            }
            try {
                String card = (String)WizardContainer.this.steps.get(0);
                this.showCard(card);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public void showLastCard() {
            if (this.getComponentCount() <= 0) {
                return;
            }
            try {
                String card = (String)WizardContainer.this.steps.get(WizardContainer.this.steps.size() - 1);
                this.showCard(card);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            String current = this.getCurrentCard();
            if (src == WizardContainer.this.btnHome) {
                this.showFirstCard();
                WizardContainer.this.processStepChange(this.getCurrentCard(), false, current);
                return;
            }
            if (src == WizardContainer.this.btnPrev) {
                this.showPreviousCard();
                WizardContainer.this.processStepChange(this.getCurrentCard(), false, current);
                return;
            }
            if (src == WizardContainer.this.btnNext && WizardContainer.this.isStepValid(this.getCurrentCard())) {
                if (WizardContainer.this.steps.indexOf(this.getCurrentCard()) == WizardContainer.this.steps.size() - 1) {
                    WizardContainer.this.processStepChange("final.step", true, current);
                    WizardContainer.this.dispatchEvent(new WindowEvent(WizardContainer.this, 201));
                    return;
                }
                this.showNextCard();
                WizardContainer.this.processStepChange(this.getCurrentCard(), false, current);
                return;
            }
            if (src == WizardContainer.this.btnExit) {
                WizardContainer.this.dispatchEvent(new WindowEvent(WizardContainer.this, 201));
                return;
            }
        }
    }
}

