/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.ui;

import com.ibm.bsf.BSFManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.PrintStream;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import org.isqlviewer.core.IPCListener;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.core.model.ScriptTreeModel;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.sql.ResultSetViewer;
import org.isqlviewer.swing.ActionToolBar;
import org.isqlviewer.swing.ITabbedPane;
import org.isqlviewer.swing.JConsole;
import org.isqlviewer.swing.SimpleTextEditor;
import org.isqlviewer.swing.WizardPanel;
import org.isqlviewer.ui.SQLWorkBench;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.UserPreferences;

public class ScriptManager
extends JFrame {
    public static final String BEAN_ID_DATABASE_CONNECTION = "isql_db";
    public static final String BEAN_ID_iSQL_CONFIG = "isql_config";
    public static final String BEAN_ID_iSQL_UTILITES = "isql_util";
    public static final String BEAN_ID_RESULT_RENDERER = "isql_renderer";
    public static final String BEAN_ID_CONSOLE_OUT = "out";
    public static final String BEAN_ID_CONSOLE_ERR = "err";
    private static final ThreadGroup SCRIPT_GROUP = new ThreadGroup("isql-scripts");
    private static ScriptManager instance = null;
    private BSFManager scriptManager = new BSFManager();
    private SystemConfig sysConfig = SystemConfig.getInstance();
    private boolean beVerbose = this.sysConfig.getPreferences().getBoolean("scripting.debug-enabled");
    private ScriptTreeModel mdlScripts = new ScriptTreeModel(new ScriptFileFilter());
    private JTree treScripts = new JTree(this.mdlScripts);
    private JSplitPane sppTreeEditorView = new JSplitPane(1);
    private JSplitPane sppRoot = new JSplitPane(0);
    private ActionHandler actionHandler = new ActionHandler();
    private JToolBar editorToolbar = ActionToolBar.createNullInstance();
    private ITabbedPane fileContainer = new ITabbedPane(1, 5);
    private JConsole console = new JConsole(BasicUtilities.getString("Script_Console_Ready"));
    private JButton btnExecute = new JButton(BasicUtilities.loadToolbarIconResource("Play"));
    private JButton btnSave = new JButton(BasicUtilities.loadToolbarIconResource("Save"));
    private JButton btnSaveAs = new JButton(BasicUtilities.loadToolbarIconResource("SaveAs"));
    private JButton btnOpen = new JButton(BasicUtilities.loadToolbarIconResource("Open"));
    private JButton btnNew = new JButton(BasicUtilities.loadToolbarIconResource("New"));
    private JButton btnOK = new JButton(BasicUtilities.getString("Ok"));
    private PrintStream dbg = new PrintStream(this.console.createFilteredStream(JConsole.CATEGORY_SCRIPT_DEBUG), true);
    private PrintStream out = new PrintStream(this.console.createFilteredStream("system"), true);
    private PrintStream err = new PrintStream(this.console.createFilteredStream("err"), true);
    static /* synthetic */ Class class$org$isqlviewer$util$BasicUtilities;

    public static int showDialog(JFrame owner, DatabaseConnection connection, SQLWorkBench wb) {
        if (instance == null) {
            try {
                instance = new ScriptManager(connection, wb);
                instance.pack();
                instance.setSize(640, 480);
                instance.setLocationRelativeTo(owner);
                instance.show();
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t, "", true);
                instance = null;
                return -1;
            }
        } else {
            instance.toFront();
        }
        return 0;
    }

    protected void processWindowEvent(WindowEvent event) {
        int id = event.getID();
        switch (id) {
            case 202: {
                instance = null;
                break;
            }
            case 201: {
                this.sysConfig.getIPCService().unSubscribeAll(this.actionHandler);
                break;
            }
            case 200: {
                this.sppRoot.setDividerLocation(0.8);
                this.sppTreeEditorView.setDividerLocation(this.treScripts.getPreferredSize().width + this.sppTreeEditorView.getDividerSize());
            }
        }
        super.processWindowEvent(event);
    }

    ScriptManager(DatabaseConnection dbc, SQLWorkBench wb) {
        this.setDefaultCloseOperation(2);
        this.setTitle(BasicUtilities.getString("Script_Manager_Title"));
        this.scriptManager.setDebugStream(this.dbg);
        this.console.configure(this.sysConfig.getPreferences());
        this.sysConfig.getIPCService().subscribe(this.actionHandler, "isql-service-change");
        this.scriptManager.setClassLoader(this.sysConfig.getRuntimeClassLoader());
        if (this.beVerbose) {
            this.out.println(BasicUtilities.getString("Script_Bean_Register", BEAN_ID_iSQL_CONFIG));
        }
        this.scriptManager.registerBean(BEAN_ID_iSQL_CONFIG, (Object)this.sysConfig);
        if (this.beVerbose) {
            this.out.println(BasicUtilities.getString("Script_Bean_Register", BEAN_ID_CONSOLE_OUT));
        }
        this.scriptManager.registerBean(BEAN_ID_CONSOLE_OUT, (Object)this.out);
        if (this.beVerbose) {
            this.out.println(BasicUtilities.getString("Script_Bean_Register", BEAN_ID_CONSOLE_ERR));
        }
        this.scriptManager.registerBean(BEAN_ID_CONSOLE_ERR, (Object)this.err);
        if (this.beVerbose) {
            this.out.println(BasicUtilities.getString("Script_Bean_Register", BEAN_ID_RESULT_RENDERER));
        }
        ResultSetViewer defaultRenderer = wb.createResultSetDelegate();
        this.scriptManager.registerBean(BEAN_ID_RESULT_RENDERER, (Object)defaultRenderer);
        if (this.beVerbose) {
            this.out.println(BasicUtilities.getString("Script_Bean_Register", BEAN_ID_iSQL_UTILITES));
        }
        this.scriptManager.registerBean(BEAN_ID_iSQL_UTILITES, (Object)(class$org$isqlviewer$util$BasicUtilities == null ? (class$org$isqlviewer$util$BasicUtilities = ScriptManager.class$("org.isqlviewer.util.BasicUtilities")) : class$org$isqlviewer$util$BasicUtilities));
        if (dbc != null) {
            if (this.beVerbose) {
                this.out.println(BasicUtilities.getString("Script_Bean_Register", BEAN_ID_DATABASE_CONNECTION));
            }
            this.scriptManager.registerBean(BEAN_ID_DATABASE_CONNECTION, (Object)dbc);
        } else if (this.beVerbose) {
            this.err.println(BasicUtilities.getString("Script_DB_Warning", BEAN_ID_DATABASE_CONNECTION));
        }
        try {
            this.initUI();
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    private void initUI() {
        JToolBar bar = new JToolBar(0);
        this.btnOK.setPreferredSize(new Dimension(2 * this.btnOK.getPreferredSize().width, this.btnOK.getPreferredSize().height));
        BasicUtilities.lockComponentToPerferredSize(this.btnOK);
        this.btnOK.setToolTipText(BasicUtilities.getString("Close_This_Dialog"));
        this.btnExecute.setToolTipText(BasicUtilities.getString("Script_Exec_Tip"));
        this.btnSave.setToolTipText(BasicUtilities.getString("Script_Save_Tip"));
        this.btnSaveAs.setToolTipText(BasicUtilities.getString("Script_SaveAs_Tip"));
        this.btnNew.setToolTipText(BasicUtilities.getString("Script_New_Tip"));
        this.btnOK.addActionListener(this.actionHandler);
        this.btnNew.addActionListener(this.actionHandler);
        this.btnExecute.addActionListener(this.actionHandler);
        this.btnSave.addActionListener(this.actionHandler);
        this.btnSaveAs.addActionListener(this.actionHandler);
        this.btnOpen.addActionListener(this.actionHandler);
        this.btnNew.setName("New");
        this.btnExecute.setName("Play");
        this.btnSave.setName("Save");
        this.btnSaveAs.setName("SaveAS");
        this.btnOpen.setName("Open");
        this.btnExecute.setMnemonic('X');
        this.btnSave.setMnemonic('S');
        this.btnSaveAs.setMnemonic('A');
        this.btnNew.setMnemonic('N');
        this.editorToolbar.setOrientation(0);
        this.editorToolbar.setFloatable(false);
        this.editorToolbar.add(this.btnOpen);
        this.editorToolbar.add(this.btnNew);
        this.editorToolbar.add(this.btnSave);
        this.editorToolbar.add(this.btnSaveAs);
        this.editorToolbar.addSeparator();
        this.editorToolbar.add(this.btnExecute);
        bar.setFloatable(false);
        bar.add(Box.createHorizontalGlue());
        bar.add(this.btnOK);
        bar.add(Box.createHorizontalStrut(12));
        WizardPanel panel = new WizardPanel();
        panel.add((Component)this.sppRoot, "root");
        panel.showCard(this.sppRoot);
        this.sppRoot.setTopComponent(this.sppTreeEditorView);
        this.treScripts.setCellRenderer(new ScriptRenderer());
        this.treScripts.addMouseListener(this.actionHandler);
        this.treScripts.setEditable(true);
        this.treScripts.setRootVisible(false);
        this.sppTreeEditorView.setLeftComponent(new JScrollPane(this.treScripts));
        this.sppTreeEditorView.setRightComponent(this.fileContainer);
        this.sppRoot.setBottomComponent(new JScrollPane(this.console));
        this.getContentPane().add((Component)this.editorToolbar, "North");
        this.getContentPane().add((Component)panel, "Center");
        this.getContentPane().add((Component)bar, "South");
    }

    private Component createEditor(File f) {
        return new SimpleTextEditor(f, this.getLangforFile(f));
    }

    private Icon getIconforFile(File f) {
        Icon ico = BasicUtilities.loadIconResource("Script16");
        try {
            BSFManager.getLangFromFilename((String)f.getName());
        }
        catch (Exception bsfe) {
            ico = BasicUtilities.loadIconResource("BadScript16");
        }
        return ico;
    }

    private String getLangforFile(File f) {
        String lang = null;
        try {
            lang = BSFManager.getLangFromFilename((String)f.getName());
        }
        catch (Exception e) {
            lang = "null";
        }
        return lang;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ScriptRunner
    implements Runnable {
        private File script = null;

        public ScriptRunner(File f) {
            this.script = f;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            long epoch = System.currentTimeMillis();
            try {
                try {
                    FileInputStream fis = new FileInputStream(this.script);
                    ByteArrayOutputStream bos = new ByteArrayOutputStream((int)this.script.length());
                    BasicUtilities.copyStream(fis, bos);
                    fis.close();
                    String data = new String(bos.toByteArray());
                    String lang = BSFManager.getLangFromFilename((String)this.script.getName());
                    String[] p = new String[]{this.script.getName(), lang};
                    ScriptManager.this.out.println(BasicUtilities.getString("Script_Exec_Start", p));
                    ScriptManager.this.scriptManager.exec(lang, this.script.getName(), 0, 0, (Object)data);
                }
                catch (Throwable t) {
                    BasicUtilities.HandleException(t, BasicUtilities.getString("Srcipt_Exec_Error", this.script.getName()), true, ScriptManager.this.err);
                    Object var9_9 = null;
                    String[] p = new String[]{this.script.getName(), Long.toString(System.currentTimeMillis() - epoch)};
                    ScriptManager.this.out.println(BasicUtilities.getString("Script_Exec_Finished", p));
                    return;
                }
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                String[] p = new String[]{this.script.getName(), Long.toString(System.currentTimeMillis() - epoch)};
                ScriptManager.this.out.println(BasicUtilities.getString("Script_Exec_Finished", p));
                throw throwable;
            }
            String[] p = new String[]{this.script.getName(), Long.toString(System.currentTimeMillis() - epoch)};
            ScriptManager.this.out.println(BasicUtilities.getString("Script_Exec_Finished", p));
        }
    }

    private class ScriptFileFilter
    implements FileFilter {
        private ScriptFileFilter() {
        }

        public boolean accept(File pathname) {
            if (pathname.isFile()) {
                UserPreferences prefs = ScriptManager.this.sysConfig.getPreferences();
                if (prefs.getBoolean("scripting.filefilter-enabled")) {
                    try {
                        BSFManager.getLangFromFilename((String)pathname.getName());
                        return true;
                    }
                    catch (Throwable t) {
                        return false;
                    }
                }
                return true;
            }
            return true;
        }
    }

    private class ActionHandler
    extends MouseAdapter
    implements ActionListener,
    IPCListener {
        private ActionHandler() {
        }

        public void receiveMessage(Object src, String topic, Object msg) {
            if (topic != null && topic.equals("isql-service-change")) {
                DatabaseConnection dbc = (DatabaseConnection)msg;
                if (dbc != null) {
                    if (ScriptManager.this.beVerbose) {
                        ScriptManager.this.out.println(BasicUtilities.getString("Script_Bean_Register", ScriptManager.BEAN_ID_DATABASE_CONNECTION));
                    }
                    ScriptManager.this.scriptManager.registerBean(ScriptManager.BEAN_ID_DATABASE_CONNECTION, (Object)dbc);
                } else {
                    if (ScriptManager.this.beVerbose) {
                        ScriptManager.this.err.println(BasicUtilities.getString("Script_DB_Warning", ScriptManager.BEAN_ID_DATABASE_CONNECTION));
                    }
                    try {
                        ScriptManager.this.scriptManager.unregisterBean(ScriptManager.BEAN_ID_DATABASE_CONNECTION);
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
            }
        }

        public void actionPerformed(ActionEvent evt) {
            Object src = evt.getSource();
            if (src == ScriptManager.this.btnOK) {
                ScriptManager.this.dispatchEvent(new WindowEvent(ScriptManager.this, 201));
            } else if (src == ScriptManager.this.btnSave) {
                this.saveSelected();
            } else if (src == ScriptManager.this.btnSaveAs) {
                this.saveSelectedAs();
            } else if (src == ScriptManager.this.btnExecute) {
                this.execSelected();
            } else if (src == ScriptManager.this.btnNew) {
                this.createNew();
            } else if (src == ScriptManager.this.btnOpen) {
                File f = BasicUtilities.getSystemFile(ScriptManager.this, 0);
                if (f == null) {
                    return;
                }
                this.openFile(f);
            }
        }

        public void removeSelected() {
        }

        public void createNew() {
        }

        public File getSelectedScript() {
            TreePath tp;
            Object o;
            File script = null;
            if (!ScriptManager.this.fileContainer.isEmpty()) {
                SimpleTextEditor editor = (SimpleTextEditor)ScriptManager.this.fileContainer.getSelectedComponent();
                if (editor.isModified()) {
                    this.saveSelected();
                }
                script = new File(ScriptManager.this.fileContainer.getSelectedToolTip());
            } else if (ScriptManager.this.treScripts.getSelectionPath() != null && (o = (tp = ScriptManager.this.treScripts.getSelectionPath()).getLastPathComponent()) instanceof File) {
                script = (File)o;
                script = script.isFile() ? script : null;
            }
            return script;
        }

        public void mouseClicked(MouseEvent evt) {
            Object o;
            if (evt.getClickCount() == 2 && (o = ScriptManager.this.treScripts.getSelectionPath().getLastPathComponent()) instanceof File) {
                File f = (File)o;
                this.openFile(f);
            }
        }

        public void openFile(File f) {
            if (f.isFile()) {
                try {
                    Icon ico = ScriptManager.this.getIconforFile(f);
                    int i = -1;
                    for (int j = 0; j < ScriptManager.this.fileContainer.getTabCount(); ++j) {
                        if (!ScriptManager.this.fileContainer.getToolTipTextAt(j).equals(f.getAbsolutePath())) continue;
                        i = j;
                        break;
                    }
                    if (i != -1) {
                        ScriptManager.this.fileContainer.setSelectedIndex(i);
                    } else {
                        String name = f.getName();
                        int idx = name.lastIndexOf(46);
                        if (idx >= 0) {
                            name = name.substring(0, idx);
                        }
                        Component editor = ScriptManager.this.createEditor(f);
                        ScriptManager.this.fileContainer.addTab(name, ico, editor, f.getAbsolutePath());
                        ScriptManager.this.fileContainer.setSelectedIndex(ScriptManager.this.fileContainer.getTabCount() - 1);
                        editor.requestFocus();
                    }
                }
                catch (Throwable t) {
                    BasicUtilities.HandleException(t, BasicUtilities.getString("Script_Read_Error", f.getName()), false);
                }
            }
        }

        public void execSelected() {
            File f = this.getSelectedScript();
            if (f != null) {
                ScriptRunner runner = new ScriptRunner(f);
                Thread t = new Thread(SCRIPT_GROUP, runner, f.getName());
                t.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void saveSelected() {
            try {
                try {
                    File f = new File(ScriptManager.this.fileContainer.getSelectedToolTip());
                    FileWriter fw = new FileWriter(f);
                    SimpleTextEditor editor = (SimpleTextEditor)ScriptManager.this.fileContainer.getSelectedComponent();
                    fw.write(editor.getText());
                    fw.flush();
                    fw.close();
                }
                catch (Throwable t) {
                    BasicUtilities.HandleException(t, BasicUtilities.getString("Could_Not_Save_File", ScriptManager.this.fileContainer.getSelectedToolTip()), true, ScriptManager.this.err);
                    Object var5_6 = null;
                    ScriptManager.this.out.println(BasicUtilities.getString("Script_Save", ScriptManager.this.fileContainer.getSelectedToolTip()));
                }
                Object var5_5 = null;
                ScriptManager.this.out.println(BasicUtilities.getString("Script_Save", ScriptManager.this.fileContainer.getSelectedToolTip()));
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                ScriptManager.this.out.println(BasicUtilities.getString("Script_Save", ScriptManager.this.fileContainer.getSelectedToolTip()));
                throw throwable;
            }
        }

        public void saveSelectedAs() {
        }
    }

    private static class ScriptRenderer
    extends DefaultTreeCellRenderer {
        public ScriptRenderer() {
            this.setLeafIcon(BasicUtilities.loadIconResource("Script16"));
            this.setOpenIcon(BasicUtilities.loadIconResource("LeafOpen16"));
            this.setClosedIcon(BasicUtilities.loadIconResource("LeafClose16"));
        }

        public Component getTreeCellRendererComponent(JTree t, Object v, boolean s, boolean e, boolean l, int r, boolean f) {
            super.getTreeCellRendererComponent(t, v, s, e, l, r, f);
            if (v instanceof File) {
                File file = (File)v;
                this.setText(file.getName());
                this.setToolTipText(file.getAbsolutePath());
                if (file.isFile()) {
                    try {
                        BSFManager.getLangFromFilename((String)file.getName());
                    }
                    catch (Exception bsfe) {
                        this.setIcon(BasicUtilities.loadIconResource("BadScript16"));
                    }
                }
            }
            return this;
        }
    }
}

