/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.isqlviewer.core.SQLBookmark;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.core.model.CheckListTableModel;
import org.isqlviewer.event.ProgressEvent;
import org.isqlviewer.sql.DatabaseConnection;
import org.isqlviewer.sql.JDBCUtilities;
import org.isqlviewer.sql.ResultSetViewer;
import org.isqlviewer.swing.IconListCellRenderer;
import org.isqlviewer.swing.OrderEditor;
import org.isqlviewer.swing.ProgressPanel;
import org.isqlviewer.swing.WhereEditor;
import org.isqlviewer.ui.SQLEditor;
import org.isqlviewer.ui.SQLWorkBench;
import org.isqlviewer.ui.TableSelector;
import org.isqlviewer.ui.WizardContainer;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.ColumnMetaData;

public class QueryWizard
extends WizardContainer {
    private SystemConfig sysConfig = SystemConfig.getInstance();
    private TreeMap columnSelection = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private TreeMap tableSelection = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private ArrayList relationships = new ArrayList();
    private ArrayList lstEditor = new ArrayList();
    private ArrayList lstOrderings = new ArrayList();
    private int[] preparedTypes = null;
    private Object[] preparedData = null;
    private DatabaseConnection cnx = null;
    private ColumnSelectionPanel columnSelector = null;
    private TableSelectionPanel tableSelector = null;
    private WhereSelectionPanel whereSelector = null;
    private ProgressPanel metaLoadProgress = null;
    private SQLWorkBench workbench = null;
    private OrderByConfig orderbyConfig = null;
    private QueryPreview queryPreview = null;
    private Thread metaLoadThread = null;
    private final String PROP_CATALOG = "catalog";
    private final String PROP_SCHEMA = "schema";
    private final String PROP_ALIAS = "alias";
    private final String PROP_COLUMN = "column";
    private final String PROP_TYPE = "type";
    private Calendar calendar = Calendar.getInstance();
    final String TABLE_SELECT = "TABLE_SELECT";
    final String COLUMN_SELECT = "COLUMN_SELECT";
    final String WHERE_SELECT = "WHERE_SELECT";
    final String META_LOAD = "META_LOAD";
    final String FK_SELECT = "FK_SELECT";
    final String ORDER_BY_SELECT = "ORDER_BY_SELECT";
    final String PREVIEW = "PREVIEW";

    public QueryWizard(Frame owner, DatabaseConnection dbc, SQLWorkBench wb) {
        super(owner);
        this.setTitle(BasicUtilities.getString("QueryWizard_Title"));
        this.cnx = dbc;
        this.workbench = wb;
        this.setHomeAllowable(false);
        this.configureTableSelector();
        this.pack();
        this.setSize(640, 480);
    }

    public static int showDialog(Frame parent, DatabaseConnection dbc, SQLWorkBench wb) {
        QueryWizard dlg = new QueryWizard(parent, dbc, wb);
        dlg.setLocationRelativeTo(parent);
        dlg.show();
        return 1;
    }

    protected boolean isStepValid(String stepName) {
        if (stepName.equals("FK_SELECT") && this.hasAllRelationshipsDisabled()) {
            String msg = BasicUtilities.getString("QBuild_Relations_Warning");
            int res = JOptionPane.showConfirmDialog(this, msg, "", 0, 2);
            return res == 0;
        }
        return super.isStepValid(stepName);
    }

    protected void processStepChange(String stepName, boolean isFinal, String lastStep) {
        block26: {
            if (isFinal) {
                try {
                    String sql = this.queryPreview.getSQL();
                    this.queryPreview.createBookmark();
                    if (this.preparedData != null && this.preparedTypes != null) {
                        this.sysConfig.getHistoryManager().addHistoryItem(sql, this.cnx);
                        ResultSetViewer handler = this.workbench.createResultSetDelegate();
                        this.cnx.executePreparedRequest(sql, this.preparedData, this.preparedTypes, handler);
                        break block26;
                    }
                    this.workbench.performQuery(sql, true);
                }
                catch (Throwable t) {
                    String msg = "QueryWizard.processStepChange(String,boolean)";
                    BasicUtilities.HandleException(t, msg, this.cnx.getDebugOn());
                }
            } else if (stepName.equals("COLUMN_SELECT")) {
                this.setIcon(BasicUtilities.loadIconResource("Table24"));
                this.setBanner(BasicUtilities.getString("QBuild_Column_Select_Banner"));
                this.setComment(BasicUtilities.getString("QBuild_Column_Select_Comment"));
                this.columnSelector.refreshList();
            } else if (stepName.equals("PREVIEW")) {
                this.setIcon(BasicUtilities.loadIconResource("Query24"));
                this.setBanner(BasicUtilities.getString("QBuild_Preview_Banner"));
                this.setComment(BasicUtilities.getString("QBuild_Preview_Comment"));
                this.queryPreview.update();
            } else if (stepName.equals("WHERE_SELECT")) {
                this.setIcon(BasicUtilities.loadIconResource("Query24"));
                this.setBanner(BasicUtilities.getString("QBuild_Where_Select_Banner"));
                this.setComment(BasicUtilities.getString("QBuild_Where_Select_Comment"));
                this.whereSelector.refreshMap();
            } else if (stepName.equals("ORDER_BY_SELECT")) {
                this.setIcon(BasicUtilities.loadIconResource("Query24"));
                this.setBanner(BasicUtilities.getString("QBuild_OrderBy_Select_Banner"));
                this.setComment(BasicUtilities.getString("QBuild_OrderBy_Select_Comment"));
                this.orderbyConfig.refreshMap();
            } else if (stepName.equals("FK_SELECT")) {
                if (this.getTrueTableSelectionCount() < 2) {
                    if (lastStep.equals("COLUMN_SELECT")) {
                        this.showStep("WHERE_SELECT");
                    } else if (lastStep.equals("WHERE_SELECT")) {
                        this.showStep("COLUMN_SELECT");
                    }
                } else {
                    this.setIcon(BasicUtilities.loadIconResource("Query24"));
                    this.setBanner(BasicUtilities.getString("QBuild_FK_Banner"));
                    this.setComment(BasicUtilities.getString("QBuild_FK_Comment"));
                }
            } else if (stepName.equals("TABLE_SELECT")) {
                this.setIcon(BasicUtilities.loadIconResource("Table24"));
                this.setBanner(BasicUtilities.getString("QBuild_Table_Select_Banner"));
                this.setComment(BasicUtilities.getString("QBuild_Table_Select_Comment"));
                this.setNextStepEnabled(!this.tableSelection.isEmpty());
            } else if (stepName.equals("META_LOAD")) {
                if (lastStep.equals("TABLE_SELECT")) {
                    if (this.metaLoadThread != null && this.metaLoadThread.isAlive()) {
                        this.metaLoadThread.interrupt();
                    }
                    this.metaLoadThread = new Thread(new MetaLoader());
                    this.metaLoadThread.start();
                    this.setNextStepEnabled(false);
                    this.setPreviousStepEnabled(false);
                    this.setIcon(BasicUtilities.loadIconResource("Table24"));
                    this.setBanner(BasicUtilities.getString("QBuild_Metaload_Banner"));
                    this.setComment(BasicUtilities.getString("QBuild_Metaload_Comment"));
                } else {
                    this.showStep("TABLE_SELECT");
                }
            }
        }
    }

    protected boolean isTableSelected(String cat, String scm, String tab, String type) {
        String fqn = null;
        fqn = cat != null && cat.trim().length() >= 1 ? cat.concat(".") : new String("");
        if (scm != null && scm.trim().length() >= 1) {
            fqn = fqn.concat(scm).concat(".");
        }
        if (this.tableSelection.containsKey(fqn = fqn.concat(type))) {
            SelectionItem selection = (SelectionItem)this.tableSelection.get(fqn);
            Collection c = selection.getSubSelection();
            return c.contains(tab);
        }
        return false;
    }

    protected boolean hasAllRelationshipsDisabled() {
        Iterator itr = this.relationships.iterator();
        while (itr.hasNext()) {
            SelectionItem item = (SelectionItem)itr.next();
            if (!item.isEnabled()) continue;
            return false;
        }
        return true;
    }

    protected int getTableSelectionCount() {
        int count = 0;
        Iterator itr = this.tableSelection.values().iterator();
        while (itr.hasNext()) {
            SelectionItem i = (SelectionItem)itr.next();
            if (i.isEmpty()) continue;
            count += i.getSubSelection().size();
        }
        return count;
    }

    protected int getTrueTableSelectionCount() {
        int count = 0;
        Iterator itr = this.columnSelection.values().iterator();
        while (itr.hasNext()) {
            SelectionItem i = (SelectionItem)itr.next();
            if (i.isEmpty()) continue;
            ++count;
        }
        return count;
    }

    protected int getColumnSelectionCount() {
        int count = 0;
        Iterator itr = this.columnSelection.values().iterator();
        while (itr.hasNext()) {
            SelectionItem i = (SelectionItem)itr.next();
            if (i.isEmpty()) continue;
            count += i.getSubSelection().size();
        }
        return count;
    }

    protected String generateSelectClause() {
        StringBuffer buff = new StringBuffer("SELECT\n");
        int tablecount = this.getTrueTableSelectionCount();
        boolean lotsOfTables = tablecount >= 27;
        Iterator tables = this.columnSelection.keySet().iterator();
        int count = 0;
        char alias = 'a';
        while (tables.hasNext()) {
            String table = (String)tables.next();
            SelectionItem selection = (SelectionItem)this.columnSelection.get(table);
            Collection subSelection = selection.getSubSelection();
            if (subSelection == null || subSelection.isEmpty()) {
                selection.setEnabled(false);
                continue;
            }
            selection.setEnabled(true);
            Iterator columns = subSelection.iterator();
            if (tablecount >= 2) {
                char c = alias;
                alias = (char)(alias + 1);
                selection.setProperty("alias", c + (lotsOfTables ? Integer.toString(count++) : ""));
            } else {
                selection.setProperty("alias", "");
            }
            StringBuffer subBuff = new StringBuffer("");
            while (columns.hasNext()) {
                String column = (String)columns.next();
                SelectClause clause = new SelectClause(column);
                String sql = clause.getSQL(selection.getProperty("alias"));
                if (subBuff.length() + (sql.length() + 2) > 80) {
                    buff.append(subBuff.toString());
                    buff.append("\n");
                    subBuff.setLength(0);
                }
                subBuff.append(" ");
                subBuff.append(sql);
                if (!columns.hasNext() && !tables.hasNext()) continue;
                subBuff.append(",");
            }
            if (subBuff.length() >= 1) {
                buff.append(subBuff.toString());
                subBuff.setLength(0);
            }
            if (tables.hasNext()) {
                buff.append("\n");
            }
            ++count;
        }
        String txt = buff.toString().trim();
        if (txt.endsWith(",")) {
            buff.deleteCharAt(txt.lastIndexOf(44));
        }
        return buff.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String generateFromClause(boolean fullyQualify) {
        StringBuffer buff = new StringBuffer("");
        buff.append("FROM\n");
        Iterator tables = this.columnSelection.keySet().iterator();
        while (tables.hasNext()) {
            String table = (String)tables.next();
            SelectionItem selection = (SelectionItem)this.columnSelection.get(table);
            if (!selection.isEnabled()) continue;
            String schema = selection.getProperty("schema");
            String catalog = selection.getProperty("catalog");
            ResultSet set = null;
            try {
                String[] types = new String[]{selection.getProperty("type").trim()};
                set = this.cnx.getDatabaseInformation().getTables(catalog, schema, table, types);
                if (set.next()) {
                    catalog = set.getString("TABLE_CAT");
                    schema = set.getString("TABLE_SCHEM");
                }
            }
            catch (Throwable t) {
                if (this.cnx.getVerboseOn()) {
                    BasicUtilities.HandleException(t, "generateFromClause(" + fullyQualify + ")", this.cnx.getDebugOn());
                }
                schema = selection.getProperty("schema");
                catalog = selection.getProperty("catalog");
            }
            finally {
                try {
                    set.close();
                }
                catch (Throwable t) {}
            }
            FromClause clause = new FromClause(this.cnx, schema, catalog, table);
            clause.setAlias(selection.getProperty("alias"));
            buff.append("  ");
            buff.append(clause.getSQL(fullyQualify));
            if (tables.hasNext()) {
                buff.append(",");
            }
            buff.append("\n");
        }
        String txt = buff.toString().trim();
        if (txt.endsWith(",")) {
            buff.deleteCharAt(txt.lastIndexOf(44));
        }
        return buff.toString().trim();
    }

    protected String generateWhereClause() throws ParseException {
        StringBuffer buff = new StringBuffer("");
        Iterator relations = this.relationships.iterator();
        StringBuffer subBuff = new StringBuffer("   (");
        boolean hasExistingConditions = false;
        while (relations.hasNext()) {
            SelectionItem fk = (SelectionItem)relations.next();
            if (!fk.isEnabled()) continue;
            SelectionItem pk = (SelectionItem)fk.subSelections.get(0);
            SelectionItem pkColumn = (SelectionItem)this.columnSelection.get(pk.getSelectionName());
            SelectionItem fkColumn = (SelectionItem)this.columnSelection.get(fk.getSelectionName());
            if (!pkColumn.isEnabled() || !fkColumn.isEnabled()) continue;
            String pkAlias = pkColumn.getProperty("alias");
            String fkAlias = fkColumn.getProperty("alias");
            subBuff.append(fkAlias);
            subBuff.append(".");
            subBuff.append(pk.getProperty("column"));
            subBuff.append(" = ");
            subBuff.append(pkAlias);
            subBuff.append(".");
            subBuff.append(pk.getProperty("column"));
            hasExistingConditions = true;
            if (!relations.hasNext()) continue;
            subBuff.append(" AND ");
        }
        subBuff.append(")");
        if (subBuff.toString().trim().length() >= 3) {
            buff.append(subBuff.toString());
            buff.append("\n");
        }
        subBuff.setLength(0);
        if (this.whereSelector.isSelectionEnabled()) {
            subBuff.append(this.generateUserWhereClause());
            if (subBuff.toString().trim().length() >= 1) {
                if (hasExistingConditions) {
                    buff.append(" AND\n   (");
                }
                buff.append(subBuff.toString());
                if (hasExistingConditions) {
                    buff.append("   )\n");
                }
            }
        }
        if (buff.toString().trim().length() >= 1) {
            buff.insert(0, "WHERE\n");
        }
        return buff.toString().trim();
    }

    protected String generateUserWhereClause() throws ParseException {
        StringBuffer buff = new StringBuffer("");
        Iterator editors = this.lstEditor.iterator();
        StringBuffer subBuff = new StringBuffer("");
        ArrayList<Integer> prepTypes = new ArrayList<Integer>();
        ArrayList<Object> prepData = new ArrayList<Object>();
        while (editors.hasNext()) {
            WhereEditor editor = (WhereEditor)editors.next();
            ColumnMetaData cmd = editor.getSelectedColumn();
            if (cmd == null) continue;
            SelectionItem item = (SelectionItem)this.columnSelection.get(cmd.getTable());
            String alias = item.getProperty("alias");
            int style = editor.getSelectedStyle();
            Object[] params = null;
            try {
                params = editor.getUserOptions();
            }
            catch (Throwable t) {
                continue;
            }
            String clause = null;
            clause = alias != null && alias.trim().length() >= 1 ? alias.concat(".").concat(cmd.getName()) : cmd.getName();
            switch (style) {
                case 5: {
                    clause = clause.concat(" NOT");
                }
                case 4: {
                    clause = clause.concat(" LIKE '%");
                    clause = clause.concat((String)params[0]);
                    clause = clause.concat("%' ");
                    break;
                }
                case 10: {
                    clause = clause.concat(" LIKE '%");
                    clause = clause.concat((String)params[0]);
                    clause = clause.concat("' ");
                    break;
                }
                case 11: {
                    clause = clause.concat(" LIKE '");
                    clause = clause.concat((String)params[0]);
                    clause = clause.concat("%' ");
                    break;
                }
                case 0: {
                    clause = clause.concat(" = ?");
                    prepTypes.add(new Integer(cmd.getType()));
                    prepData.add(JDBCUtilities.convertValue(params[0], cmd.getType(), null));
                    break;
                }
                case 1: {
                    clause = clause.concat(" <> ?");
                    prepTypes.add(new Integer(cmd.getType()));
                    prepData.add(JDBCUtilities.convertValue(params[0], cmd.getType(), null));
                    break;
                }
                case 7: {
                    clause = clause.concat(" NOT");
                }
                case 6: {
                    clause = clause.concat(" BETWEEN ? AND ?");
                    prepTypes.add(new Integer(cmd.getType()));
                    prepData.add(JDBCUtilities.convertValue(params[0], cmd.getType(), null));
                    prepTypes.add(new Integer(cmd.getType()));
                    prepData.add(JDBCUtilities.convertValue(params[1], cmd.getType(), null));
                    break;
                }
                case 9: {
                    clause = clause.concat(" NOT");
                }
                case 8: {
                    clause = clause.concat(" BETWEEN ? AND ?");
                    Date now = new Date();
                    this.calendar.setTime(now);
                    int diff = ((Number)params[0]).intValue();
                    String idx = (String)params[1];
                    switch (Integer.parseInt(idx)) {
                        case 0: {
                            this.calendar.roll(11, -1 * diff);
                            break;
                        }
                        case 1: {
                            this.calendar.roll(6, -1 * diff);
                            break;
                        }
                        case 2: {
                            this.calendar.roll(3, -1 * diff);
                            break;
                        }
                        case 3: {
                            this.calendar.roll(2, -1 * diff);
                            break;
                        }
                        case 4: {
                            this.calendar.roll(1, -1 * diff);
                            break;
                        }
                    }
                    prepTypes.add(new Integer(cmd.getType()));
                    prepData.add(JDBCUtilities.convertValue(this.calendar.getTime(), cmd.getType(), null));
                    prepTypes.add(new Integer(cmd.getType()));
                    prepData.add(JDBCUtilities.convertValue(now, cmd.getType(), null));
                    break;
                }
                case 2: {
                    clause = clause.concat(" > ?");
                    prepTypes.add(new Integer(cmd.getType()));
                    prepData.add(JDBCUtilities.convertValue(params[0], cmd.getType(), null));
                    break;
                }
                case 3: {
                    clause = clause.concat(" < ?");
                    prepTypes.add(new Integer(cmd.getType()));
                    prepData.add(JDBCUtilities.convertValue(params[0], cmd.getType(), null));
                    break;
                }
            }
            if (editors.hasNext()) {
                clause = this.whereSelector.allRequired() ? clause.concat("\n  AND\n   ") : clause.concat("\n  OR\n   ");
            }
            if (subBuff.length() + (clause.length() + 2) > 80) {
                buff.append(subBuff.toString());
                subBuff.setLength(0);
            }
            buff.append(clause);
        }
        if (!prepData.isEmpty()) {
            this.preparedData = new Object[prepData.size()];
            this.preparedTypes = new int[prepTypes.size()];
            Iterator data = prepData.iterator();
            Iterator type = prepTypes.iterator();
            int x = 0;
            while (data.hasNext() && type.hasNext()) {
                Integer val = (Integer)type.next();
                Object obj = data.next();
                this.preparedData[x] = obj;
                this.preparedTypes[x] = val;
                ++x;
            }
        } else {
            this.preparedData = null;
            this.preparedTypes = null;
        }
        return buff.toString().trim();
    }

    protected String generateOrderByClause() {
        StringBuffer buff = new StringBuffer("");
        Iterator editors = this.lstOrderings.iterator();
        StringBuffer subBuff = new StringBuffer("");
        while (editors.hasNext()) {
            OrderEditor editor = (OrderEditor)editors.next();
            ColumnMetaData cmd = editor.getSelectedColumn();
            if (cmd == null) continue;
            SelectionItem item = (SelectionItem)this.columnSelection.get(cmd.getTable());
            String alias = item.getProperty("alias");
            int direction = editor.getSelectedStyle();
            String clause = null;
            clause = alias != null && alias.trim().length() >= 1 ? alias.concat(".").concat(cmd.getName()) : cmd.getName();
            switch (direction) {
                case 1: {
                    clause = clause.concat(" DESC");
                    break;
                }
                default: {
                    clause = clause.concat(" ASC");
                }
            }
            if (subBuff.length() + (clause.length() + 2) > 80) {
                buff.append(subBuff.toString());
                buff.append("\n ");
                subBuff.setLength(0);
            }
            subBuff.append(" ");
            subBuff.append(clause);
            if (!editors.hasNext()) continue;
            subBuff.append(",");
        }
        if (subBuff.toString().trim().length() >= 1) {
            buff.append(subBuff);
        }
        if (buff.toString().trim().length() >= 1) {
            buff.insert(0, "ORDER BY\n ");
        }
        return buff.toString().trim();
    }

    protected String generateSQL() throws ParseException {
        StringBuffer sql = new StringBuffer("");
        sql.append(this.generateSelectClause());
        sql.append("\n");
        sql.append(this.generateFromClause(true));
        sql.append("\n");
        sql.append(this.generateWhereClause());
        if (this.orderbyConfig.isSelectionEnabled()) {
            sql.append("\n");
            sql.append(this.generateOrderByClause());
        }
        return sql.toString().trim();
    }

    protected void configureTableSelector() {
        this.columnSelector = new ColumnSelectionPanel();
        this.tableSelector = new TableSelectionPanel();
        this.whereSelector = new WhereSelectionPanel();
        this.metaLoadProgress = new ProgressPanel();
        this.orderbyConfig = new OrderByConfig();
        this.queryPreview = new QueryPreview();
        this.addUserComponent("TABLE_SELECT", this.tableSelector);
        this.addUserComponent("META_LOAD", this.metaLoadProgress);
        this.addUserComponent("COLUMN_SELECT", this.columnSelector);
        this.addUserComponent("WHERE_SELECT", this.whereSelector);
        this.addUserComponent("ORDER_BY_SELECT", this.orderbyConfig);
        this.addUserComponent("PREVIEW", this.queryPreview);
        this.startWizard();
    }

    static /* synthetic */ ProgressPanel access$1000(QueryWizard x0) {
        return x0.metaLoadProgress;
    }

    private class SelectClause {
        private String name = null;
        private String alias = null;

        public SelectClause(String n) {
            this.name = n;
        }

        public String getSQL(String tablealias) {
            String clause = null;
            clause = tablealias != null && tablealias.length() >= 1 ? tablealias.concat(".").concat(this.name) : this.name;
            if (this.alias != null && this.alias.length() >= 1) {
                clause = clause.concat(" AS ").concat(this.alias);
            }
            return clause;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }
    }

    private class MetaLoader
    implements Runnable {
        private MetaLoader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            out = QueryWizard.access$1000(QueryWizard.this).getOutStream();
            dmd = QueryWizard.access$200(QueryWizard.this).getDatabaseInformation();
            set = null;
            types = QueryWizard.access$300(QueryWizard.this).keySet().iterator();
            map = new TreeMap<String, ColumnMetaData>(String.CASE_INSENSITIVE_ORDER);
            chkFKeys = QueryWizard.this.getTableSelectionCount() >= 2;
            pe = new ProgressEvent(this, 0, QueryWizard.access$300(QueryWizard.this).size());
            progress = 0;
            var9_9 = QueryWizard.access$500(QueryWizard.this);
            synchronized (var9_9) {
                QueryWizard.access$500(QueryWizard.this).clear();
            }
            c = QueryWizard.this.getTableSelectionCount();
            while (types.hasNext()) {
                type = (String)types.next();
                item = (SelectionItem)QueryWizard.access$300(QueryWizard.this).get(type);
                tables = item.getSubSelection().iterator();
                while (tables.hasNext()) {
                    block35: {
                        block33: {
                            table = (String)tables.next();
                            cat = item.getProperty("catalog");
                            scm = item.getProperty("schema");
                            p = new String[]{cat, scm, table};
                            try {
                                try {
                                    out.println(BasicUtilities.getString("QBuild_MetaLoad_Info", p));
                                    set = dmd.getColumns(cat, scm, table, "%");
                                    while (set.next()) {
                                        cmd = new ColumnMetaData();
                                        cmd.setTable(table);
                                        cmd.setCatalog(set.getString("TABLE_CAT"));
                                        cmd.setSchema(set.getString("TABLE_SCHEM"));
                                        cmd.setName(set.getString("COLUMN_NAME"));
                                        cmd.setPrecision(set.getInt("COLUMN_SIZE"));
                                        cmd.setType(set.getInt("DATA_TYPE"));
                                        cmd.setNullable("yes".equalsIgnoreCase(set.getString("IS_NULLABLE")));
                                        if (c == 1) {
                                            map.put(cmd.getName(), cmd);
                                        } else {
                                            map.put(table.concat(".").concat(cmd.getName()), cmd);
                                        }
                                        pe.setNote(cmd.getName());
                                        QueryWizard.access$1000(QueryWizard.this).progressUpdated(pe);
                                    }
                                    var20_25 = null;
                                    if (set == null) break block33;
                                }
                                catch (Throwable t) {
                                    if (QueryWizard.access$200(QueryWizard.this).getVerboseOn()) {
                                        err = QueryWizard.access$1000(QueryWizard.this).getErrStream();
                                        BasicUtilities.HandleException(t, null, QueryWizard.access$200(QueryWizard.this).getDebugOn(), err);
                                    }
                                    var20_25 = null;
                                    if (set != null) {
                                        try {
                                            set.close();
                                        }
                                        catch (Throwable t) {}
                                    }
                                    break block33;
                                }
                            }
                            catch (Throwable var19_24) {
                                var20_25 = null;
                                if (set == null) throw var19_24;
                                ** try [egrp 3[TRYBLOCK] [6 : 526->535)] { 
lbl64:
                                // 1 sources

                                set.close();
                                throw var19_24;
lbl66:
                                // 1 sources

                                catch (Throwable t) {
                                    // empty catch block
                                }
                                throw var19_24;
                            }
                            try {}
                            catch (Throwable t) {}
                            set.close();
                        }
                        if (chkFKeys) {
                            count = 0;
                            try {
                                try {
                                    ttype = item.getSelectionName();
                                    set = dmd.getImportedKeys(cat, scm, table);
                                    out.println(BasicUtilities.getString("QBuild_MetaLoad_FK_Info", p));
                                    while (set.next()) {
                                        catalog = set.getString("PKTABLE_CAT");
                                        schema = set.getString("PKTABLE_SCHEM");
                                        fKey = set.getString("PKCOLUMN_NAME");
                                        fqn = set.getString("PKTABLE_NAME");
                                        if (!QueryWizard.this.isTableSelected(catalog, schema, fqn, ttype)) continue;
                                        i = new SelectionItem(fqn);
                                        i.setProperty("catalog", catalog);
                                        i.setProperty("schema", schema);
                                        i.setProperty("column", fKey);
                                        k = new SelectionItem(table);
                                        k.setProperty("catalog", cat);
                                        k.setProperty("schema", scm);
                                        k.addSubSelection(i);
                                        var25_30 = QueryWizard.access$500(QueryWizard.this);
                                        synchronized (var25_30) {
                                            QueryWizard.access$500(QueryWizard.this).add(k);
                                        }
                                        ++count;
                                        pe.setNote(fqn);
                                        QueryWizard.access$1000(QueryWizard.this).progressUpdated(pe);
                                    }
                                    var28_31 = null;
                                    out.println(BasicUtilities.getString("QBuild_MetaLoad_FK_Result", Integer.toString(count)));
                                    if (set == null) break block35;
                                }
                                catch (Throwable t) {
                                    if (QueryWizard.access$200(QueryWizard.this).getVerboseOn()) {
                                        err = QueryWizard.access$1000(QueryWizard.this).getErrStream();
                                        BasicUtilities.HandleException(t, null, QueryWizard.access$200(QueryWizard.this).getDebugOn(), err);
                                    }
                                    var28_31 = null;
                                    out.println(BasicUtilities.getString("QBuild_MetaLoad_FK_Result", Integer.toString(count)));
                                    if (set != null) {
                                        try {
                                            set.close();
                                        }
                                        catch (Throwable t) {}
                                    }
                                    break block35;
                                }
                            }
                            catch (Throwable var27_33) {
                                var28_31 = null;
                                out.println(BasicUtilities.getString("QBuild_MetaLoad_FK_Result", Integer.toString(count)));
                                if (set == null) throw var27_33;
                                ** try [egrp 7[TRYBLOCK] [13 : 875->884)] { 
lbl127:
                                // 1 sources

                                set.close();
                                throw var27_33;
lbl129:
                                // 1 sources

                                catch (Throwable t) {
                                    // empty catch block
                                }
                                throw var27_33;
                            }
                            try {}
                            catch (Throwable t) {}
                            set.close();
                        }
                    }
                    pe.setProgress(++progress);
                    QueryWizard.access$1000(QueryWizard.this).progressUpdated(pe);
                }
            }
            if (QueryWizard.access$500(QueryWizard.this).size() > 0) {
                QueryWizard.this.insertStepAfter("COLUMN_SELECT", "FK_SELECT", new FKAutoJoin());
            } else {
                QueryWizard.this.removeUserComponent("FK_SELECT");
            }
            QueryWizard.access$1000(QueryWizard.this).setCompleted();
            QueryWizard.this.setNextStepEnabled(true);
            QueryWizard.this.setPreviousStepEnabled(true);
            QueryWizard.access$600(QueryWizard.this).setSelection(map);
        }
    }

    static class FromClause {
        private String scm = null;
        private String cat = null;
        private String tab = null;
        private String alias = null;
        private DatabaseConnection connection = null;

        public FromClause(DatabaseConnection dbc, String s, String c, String t) {
            this.connection = dbc;
            this.scm = s;
            this.cat = c;
            this.tab = t;
        }

        public String getSQL(boolean fullQualify) {
            String seperator = ".";
            boolean catalogFirst = true;
            try {
                catalogFirst = this.connection.getDatabaseInformation().isCatalogAtStart();
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                seperator = this.connection.getDatabaseInformation().getCatalogSeparator();
            }
            catch (Throwable t) {
                // empty catch block
            }
            String fqn = new String("");
            if (catalogFirst) {
                if (fullQualify) {
                    if (this.cat != null && this.cat.trim().length() >= 1) {
                        fqn = this.cat.concat(seperator);
                    }
                    if (this.scm != null && this.scm.trim().length() >= 1) {
                        fqn = fqn.concat(this.scm).concat(".");
                    }
                }
                fqn = fqn.concat(this.tab);
                if (this.alias != null && this.alias.trim().length() >= 1) {
                    fqn = fqn.concat(" ");
                    fqn = fqn.concat(this.alias);
                }
            } else {
                if (fullQualify && this.scm != null && this.scm.trim().length() >= 1) {
                    fqn = fqn.concat(this.scm).concat(".");
                }
                fqn = fqn.concat(this.tab);
                if (fullQualify && this.cat != null && this.cat.trim().length() >= 1) {
                    fqn = fqn.concat(seperator.concat(this.cat));
                }
                if (this.alias != null && this.alias.trim().length() >= 1) {
                    fqn = fqn.concat(" ");
                    fqn = fqn.concat(this.alias);
                }
            }
            return fqn;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }
    }

    private class SelectionItem {
        private String selection = null;
        private ArrayList subSelections = null;
        private TreeMap properties = null;
        private boolean enabled = true;

        public SelectionItem(String name) {
            this.selection = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setProperty(String key, String value) {
            if (this.properties == null && value != null) {
                this.properties = new TreeMap(String.CASE_INSENSITIVE_ORDER);
            }
            if (this.properties == null) {
                return;
            }
            TreeMap treeMap = this.properties;
            synchronized (treeMap) {
                if (value == null) {
                    if (this.properties.containsKey(key)) {
                        this.properties.remove(key);
                    }
                } else {
                    this.properties.put(key, value);
                }
            }
            if (this.properties.isEmpty()) {
                this.properties = null;
            }
        }

        public String getProperty(String key) {
            if (this.properties == null) {
                return null;
            }
            return (String)this.properties.get(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSubSelection(Object subSelection) {
            if (this.subSelections == null) {
                this.subSelections = new ArrayList(1);
            }
            ArrayList arrayList = this.subSelections;
            synchronized (arrayList) {
                this.subSelections.add(subSelection);
            }
        }

        public String getSelectionName() {
            return this.selection;
        }

        public boolean contains(Object item) {
            if (this.subSelections == null) {
                return false;
            }
            return this.subSelections.contains(item);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeSubSelection(String subSelection) {
            if (this.subSelections == null) {
                return;
            }
            ArrayList arrayList = this.subSelections;
            synchronized (arrayList) {
                this.subSelections.remove(subSelection);
            }
        }

        public boolean isEmpty() {
            if (this.subSelections == null) {
                return true;
            }
            return this.subSelections.isEmpty();
        }

        public Collection getSubSelection() {
            if (this.subSelections != null) {
                return (Collection)this.subSelections.clone();
            }
            return null;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    private class TableSelectionPanel
    extends JPanel
    implements ListSelectionListener,
    ChangeListener,
    TableModelListener {
        private DefaultListModel mdlTypeSelection = new DefaultListModel();
        private CheckListTableModel mdlTableSelection = new CheckListTableModel();
        private JTable tabTableSelection = new JTable(this.mdlTableSelection);
        private JList lstTypeSelection = new JList(this.mdlTypeSelection);
        private TableSelector tabSelector = new TableSelector(QueryWizard.access$200(QueryWizard.this).getDatabaseInformation(), false);
        private JSplitPane jsp = new JSplitPane(1);
        private int maxTables = 0;

        public TableSelectionPanel() {
            try {
                this.initUI();
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t, "QueryWizard.TableSelectionPanel::initUI()");
            }
            try {
                this.maxTables = QueryWizard.this.cnx.getDatabaseInformation().getMaxTablesInSelect();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.maxTables == 0) {
                this.maxTables = Integer.MAX_VALUE;
            }
        }

        private void initUI() {
            this.tabSelector.addChangeListener(this);
            this.jsp.setLeftComponent(new JScrollPane(this.lstTypeSelection));
            this.jsp.setRightComponent(new JScrollPane(this.tabTableSelection));
            this.setLayout(new BorderLayout());
            this.add((Component)this.tabSelector, "North");
            this.add((Component)this.jsp, "Center");
            IconListCellRenderer typeRenderer = new IconListCellRenderer(BasicUtilities.loadIconResource("Query16"));
            this.tabTableSelection.getTableHeader().setReorderingAllowed(false);
            this.mdlTableSelection.setSelectableTitle(BasicUtilities.getString("Select_Tables"));
            this.mdlTableSelection.addTableModelListener(this);
            this.lstTypeSelection.setCellRenderer(typeRenderer);
            this.lstTypeSelection.addListSelectionListener(this);
            this.tabSelector.setSelectedCatalog(QueryWizard.this.cnx.getCatalog());
            this.tabSelector.setSelectedSchema(QueryWizard.this.cnx.getSchema());
            this.refreshList(QueryWizard.this.cnx.getCatalog(), QueryWizard.this.cnx.getSchema());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refreshList(String catalog, String schema) {
            String[] ttypes = QueryWizard.this.cnx.getTableTypes();
            ResultSet set = null;
            this.mdlTypeSelection.clear();
            this.mdlTableSelection.clear();
            DatabaseMetaData dmd = QueryWizard.this.cnx.getDatabaseInformation();
            for (int i = 0; i < ttypes.length; ++i) {
                try {
                    set = dmd.getTables(catalog, schema, null, new String[]{ttypes[i]});
                    if (!set.next()) continue;
                    this.mdlTypeSelection.addElement(ttypes[i]);
                    continue;
                }
                catch (Throwable t) {
                    if (QueryWizard.this.cnx.getVerboseOn()) {
                        BasicUtilities.HandleException(t, null, QueryWizard.this.cnx.getDebugOn());
                    }
                    return;
                }
                finally {
                    try {
                        set.close();
                    }
                    catch (Throwable t) {}
                    set = null;
                }
            }
            int w = this.lstTypeSelection.getPreferredScrollableViewportSize().width;
            int d = this.jsp.getDividerSize() * 2 + 2;
            if (this.jsp.getDividerLocation() < w + d) {
                this.jsp.setDividerLocation(w + d);
            }
            try {
                if (this.mdlTypeSelection.size() >= 1) {
                    this.lstTypeSelection.setSelectedIndex(0);
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
            QueryWizard.this.setNextStepEnabled(!QueryWizard.this.tableSelection.isEmpty());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            String ttype = (String)this.lstTypeSelection.getSelectedValue();
            if (ttype == null) {
                return;
            }
            String catalog = this.tabSelector.getSelectedCatalog();
            String schema = this.tabSelector.getSelectedSchema();
            ResultSet set = null;
            Object[] tables = null;
            try {
                DatabaseMetaData dmd = QueryWizard.this.cnx.getDatabaseInformation();
                set = dmd.getTables(catalog, schema, null, new String[]{ttype.trim()});
                tables = JDBCUtilities.getSingleColumn(set, "TABLE_NAME", null);
            }
            catch (Throwable t) {
                if (QueryWizard.this.cnx.getVerboseOn()) {
                    BasicUtilities.HandleException(t, "TableSelectionPanel::valueChanged()", QueryWizard.this.cnx.getDebugOn());
                }
                return;
            }
            finally {
                try {
                    set.close();
                }
                catch (Throwable t) {}
                set = null;
            }
            this.mdlTableSelection.setSelectableData(Arrays.asList(tables));
            String fqn = null;
            fqn = catalog != null && catalog.trim().length() >= 1 ? catalog.concat(".") : new String("");
            if (schema != null && schema.trim().length() >= 1) {
                fqn = fqn.concat(schema).concat(".");
            }
            fqn = fqn.concat(ttype);
            SelectionItem item = (SelectionItem)QueryWizard.this.tableSelection.get(fqn);
            if (item != null && !item.isEmpty()) {
                this.mdlTableSelection.setItemsAsSelected(item.getSubSelection());
            }
        }

        public void stateChanged(ChangeEvent ce) {
            this.refreshList(this.tabSelector.getSelectedCatalog(), this.tabSelector.getSelectedSchema());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void tableChanged(TableModelEvent e) {
            int row = e.getFirstRow();
            int col = e.getColumn();
            if (row < 0 || row >= this.mdlTableSelection.getRowCount()) {
                return;
            }
            if (col < 0 || col >= this.mdlTableSelection.getColumnCount()) {
                return;
            }
            if (e.getType() == 0) {
                Object item;
                Boolean chk = (Boolean)this.mdlTableSelection.getValueAt(e.getFirstRow(), e.getColumn());
                String tab = (String)this.mdlTableSelection.getValueAt(e.getFirstRow(), 0);
                String ttype = (String)this.lstTypeSelection.getSelectedValue();
                String catalog = this.tabSelector.getSelectedCatalog();
                String schema = this.tabSelector.getSelectedSchema();
                String fqn = null;
                fqn = catalog != null && catalog.trim().length() >= 1 ? catalog.concat(".") : new String("");
                if (schema != null && schema.trim().length() >= 1) {
                    fqn = fqn.concat(schema).concat(".");
                }
                fqn = fqn.concat(ttype);
                if (!QueryWizard.this.tableSelection.containsKey(fqn)) {
                    TreeMap treeMap = QueryWizard.this.tableSelection;
                    synchronized (treeMap) {
                        item = new SelectionItem(ttype);
                        ((SelectionItem)item).setProperty("catalog", this.tabSelector.getSelectedCatalog());
                        ((SelectionItem)item).setProperty("schema", this.tabSelector.getSelectedSchema());
                        QueryWizard.this.tableSelection.put(fqn, item);
                    }
                }
                SelectionItem item2 = (SelectionItem)QueryWizard.this.tableSelection.get(fqn);
                if (chk.booleanValue()) {
                    item2.addSubSelection(tab);
                } else {
                    item2.removeSubSelection(tab);
                    if (item2.isEmpty()) {
                        item = QueryWizard.this.tableSelection;
                        synchronized (item) {
                            QueryWizard.this.tableSelection.remove(fqn);
                        }
                    }
                }
                int count = QueryWizard.this.getTableSelectionCount();
                QueryWizard.this.setNextStepEnabled(count >= 1 && count <= this.maxTables);
            }
        }
    }

    private class WhereSelectionPanel
    extends JPanel
    implements ActionListener {
        private JPanel pnlEditor = new JPanel(new GridBagLayout());
        private JCheckBox chkEnable = new JCheckBox();
        private JComboBox jcbBool = new JComboBox<String>(new String[]{BasicUtilities.getString("QBuild_All"), BasicUtilities.getString("QBuild_Any")});
        private TreeMap metaMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);

        public WhereSelectionPanel() {
            super(new GridBagLayout());
            try {
                this.initUI();
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t, "QueryWizard.TableSelectionPanel::initUI()");
            }
        }

        public boolean allRequired() {
            return this.jcbBool.getSelectedIndex() == 0;
        }

        public boolean isSelectionEnabled() {
            return this.chkEnable.isSelected();
        }

        public void refreshMap() {
            int c = QueryWizard.this.getTrueTableSelectionCount();
            TreeMap<String, ColumnMetaData> newMap = new TreeMap<String, ColumnMetaData>(String.CASE_INSENSITIVE_ORDER);
            Iterator itr = this.metaMap.values().iterator();
            while (itr.hasNext()) {
                ColumnMetaData cmd = (ColumnMetaData)itr.next();
                String table = cmd.getTable();
                if (c == 1) {
                    SelectionItem item = (SelectionItem)QueryWizard.this.columnSelection.get(table);
                    if (item.isEmpty()) continue;
                    newMap.put(cmd.getName(), cmd);
                } else {
                    newMap.put(table.concat(".").concat(cmd.getName()), cmd);
                }
                itr.remove();
            }
            this.setSelection(newMap);
        }

        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (src instanceof WhereEditor) {
                WhereEditor editor = (WhereEditor)src;
                switch (e.getID()) {
                    case 0: {
                        this.addWhereEditor(QueryWizard.this.lstEditor.indexOf(editor));
                        break;
                    }
                    case 1: {
                        this.removeWhereEditor(editor);
                    }
                }
                return;
            }
            if (src == this.chkEnable) {
                int x = QueryWizard.this.lstEditor.size();
                Iterator itr = QueryWizard.this.lstEditor.iterator();
                this.jcbBool.setEnabled(this.chkEnable.isSelected());
                while (itr.hasNext()) {
                    WhereEditor editor = (WhereEditor)itr.next();
                    editor.setEnabled(this.chkEnable.isSelected());
                    if (!this.chkEnable.isSelected()) continue;
                    editor.setDeleteEnabled(x >= 2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setSelection(Map data) {
            TreeMap treeMap = this.metaMap;
            synchronized (treeMap) {
                this.metaMap.clear();
                this.metaMap.putAll(data);
            }
            Iterator itr = QueryWizard.this.lstEditor.iterator();
            while (itr.hasNext()) {
                WhereEditor editor = (WhereEditor)itr.next();
                editor.updateMetamap(data);
            }
        }

        private void initUI() {
            String txt = BasicUtilities.getString("QBuild_Match_Conditions", "@");
            int idx = txt.indexOf(64);
            this.chkEnable.setText(txt.substring(0, idx));
            this.chkEnable.setToolTipText(BasicUtilities.getString("QBuild_Match_Conditions_Tip"));
            this.pnlEditor.setBorder(BorderFactory.createBevelBorder(1));
            WizardContainer.constrain(1, 0, 3, 1, 0.0, 0.0, 17, 0);
            this.add(Box.createVerticalStrut(6), WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(0, 0, 1, 4, 0.0, 0.0, 17, 0);
            this.add(Box.createHorizontalStrut(12), WizardContainer.UI_CONSTRAINT);
            JScrollPane jsp = new JScrollPane(this.pnlEditor);
            WizardContainer.constrain(1, 1, 1, 1, 0.0, 0.0, 17, 1);
            this.add((Component)this.chkEnable, WizardContainer.UI_CONSTRAINT);
            JLabel lbl = new JLabel(txt.substring(idx + 1));
            WizardContainer.constrain(2, 1, 1, 1, 0.0, 0.0, 17, 0);
            this.add((Component)this.jcbBool, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(3, 1, 1, 1, 0.0, 0.0, 17, 1);
            this.add((Component)lbl, WizardContainer.UI_CONSTRAINT);
            this.jcbBool.setVisible(false);
            WizardContainer.constrain(1, 2, 3, 1, 1.0, 1.0, 17, 1);
            this.add((Component)jsp, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(1, 3, 3, 1, 0.0, 0.0, 17, 0);
            this.add(Box.createVerticalStrut(6), WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(3, 0, 1, 4, 0.0, 0.0, 17, 0);
            this.add(Box.createHorizontalStrut(12), WizardContainer.UI_CONSTRAINT);
            this.addWhereEditor(0);
            this.chkEnable.doClick();
            this.chkEnable.addActionListener(this);
        }

        private void addWhereEditor(int index) {
            WhereEditor editor = new WhereEditor(this.metaMap);
            editor.addActionListener(this);
            int x = QueryWizard.this.lstEditor.size();
            if (++index > x || x < 0) {
                QueryWizard.this.lstEditor.add(editor);
            } else {
                QueryWizard.this.lstEditor.add(index, editor);
            }
            this.pnlEditor.removeAll();
            x = QueryWizard.this.lstEditor.size();
            Iterator itr = QueryWizard.this.lstEditor.iterator();
            WizardContainer.constrain(0, 0, 1, 1, 1.0, 0.0, 17, 2);
            while (itr.hasNext()) {
                WhereEditor e = (WhereEditor)itr.next();
                e.setDeleteEnabled(x >= 2);
                this.jcbBool.setVisible(x >= 2);
                this.pnlEditor.add((Component)e, WizardContainer.UI_CONSTRAINT);
                ++WizardContainer.UI_CONSTRAINT.gridy;
            }
            WizardContainer.UI_CONSTRAINT.fill = 3;
            WizardContainer.UI_CONSTRAINT.weighty = 1.0;
            this.pnlEditor.add(Box.createVerticalGlue(), WizardContainer.UI_CONSTRAINT);
            this.pnlEditor.invalidate();
            this.validateTree();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeWhereEditor(WhereEditor editor) {
            ArrayList arrayList = QueryWizard.this.lstEditor;
            synchronized (arrayList) {
                QueryWizard.this.lstEditor.remove(editor);
                QueryWizard.this.lstEditor.trimToSize();
            }
            this.pnlEditor.remove(editor);
            if (QueryWizard.this.lstEditor.size() == 1) {
                WhereEditor e = (WhereEditor)QueryWizard.this.lstEditor.get(0);
                e.setDeleteEnabled(false);
            }
            this.jcbBool.setVisible(QueryWizard.this.lstEditor.size() >= 2);
            this.pnlEditor.invalidate();
            this.validateTree();
        }
    }

    private class OrderByConfig
    extends JPanel
    implements ActionListener {
        private JPanel pnlEditor = new JPanel(new GridBagLayout());
        private JCheckBox chkEnable = new JCheckBox();
        private TreeMap metaMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        private int maxOrderings = 0;

        public OrderByConfig() {
            super(new GridBagLayout());
            try {
                this.initUI();
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t, "QueryWizard.TableSelectionPanel::initUI()");
            }
            try {
                this.maxOrderings = QueryWizard.this.cnx.getDatabaseInformation().getMaxColumnsInOrderBy();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.maxOrderings == 0) {
                this.maxOrderings = Integer.MAX_VALUE;
            }
        }

        public boolean isSelectionEnabled() {
            return this.chkEnable.isSelected();
        }

        public void refreshMap() {
            Iterator tables = QueryWizard.this.columnSelection.keySet().iterator();
            int count = QueryWizard.this.getTrueTableSelectionCount();
            int tcount = QueryWizard.this.getTableSelectionCount();
            TreeMap<String, ColumnMetaData> dataMap = new TreeMap<String, ColumnMetaData>(String.CASE_INSENSITIVE_ORDER);
            boolean supportsUnrelated = false;
            try {
                supportsUnrelated = QueryWizard.this.cnx.getDatabaseInformation().supportsOrderByUnrelated();
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (supportsUnrelated) {
                this.setSelection(QueryWizard.this.whereSelector.metaMap);
            } else {
                while (tables.hasNext()) {
                    String table = (String)tables.next();
                    SelectionItem selection = (SelectionItem)QueryWizard.this.columnSelection.get(table);
                    Collection subSelection = selection.getSubSelection();
                    if (subSelection == null || subSelection.isEmpty()) {
                        selection.setEnabled(false);
                        continue;
                    }
                    Iterator columns = subSelection.iterator();
                    while (columns.hasNext()) {
                        String column = (String)columns.next();
                        String key = null;
                        key = tcount >= 2 ? table.concat(".").concat(column) : column;
                        ColumnMetaData cmd = (ColumnMetaData)QueryWizard.this.whereSelector.metaMap.get(key);
                        key = count >= 2 ? table.concat(".").concat(column) : column;
                        dataMap.put(key, cmd);
                    }
                }
                this.setSelection(dataMap);
            }
        }

        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (src instanceof OrderEditor) {
                OrderEditor editor = (OrderEditor)src;
                switch (e.getID()) {
                    case 0: {
                        this.addOrderEditor(QueryWizard.this.lstEditor.indexOf(editor));
                        break;
                    }
                    case 1: {
                        this.removeOrderEditor(editor);
                    }
                }
                return;
            }
            if (src == this.chkEnable) {
                int x = QueryWizard.this.lstEditor.size();
                Iterator itr = QueryWizard.this.lstOrderings.iterator();
                while (itr.hasNext()) {
                    OrderEditor editor = (OrderEditor)itr.next();
                    editor.setEnabled(this.chkEnable.isSelected());
                    if (!this.chkEnable.isSelected()) continue;
                    editor.setDeleteEnabled(x >= 2);
                    editor.setAddEnabled(x < Math.min(this.metaMap.size(), this.maxOrderings));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setSelection(Map data) {
            TreeMap treeMap = this.metaMap;
            synchronized (treeMap) {
                this.metaMap.clear();
                this.metaMap.putAll(data);
            }
            int x = QueryWizard.this.lstOrderings.size();
            Iterator itr = QueryWizard.this.lstOrderings.iterator();
            while (itr.hasNext()) {
                OrderEditor editor = (OrderEditor)itr.next();
                editor.updateMetamap(data);
                editor.setDeleteEnabled(x >= 2);
                editor.setAddEnabled(x < Math.min(this.metaMap.size(), this.maxOrderings));
            }
        }

        private void initUI() {
            this.chkEnable.setText(BasicUtilities.getString("QBuild_OrderBy_Enable"));
            this.chkEnable.setToolTipText(BasicUtilities.getString("QBuild_OrderBy_Enable_Tip"));
            this.pnlEditor.setBorder(BorderFactory.createBevelBorder(1));
            WizardContainer.constrain(1, 0, 2, 1, 0.0, 0.0, 17, 0);
            this.add(Box.createVerticalStrut(6), WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(0, 0, 1, 4, 0.0, 0.0, 17, 0);
            this.add(Box.createHorizontalStrut(12), WizardContainer.UI_CONSTRAINT);
            JScrollPane jsp = new JScrollPane(this.pnlEditor);
            WizardContainer.constrain(1, 1, 1, 1, 0.0, 0.0, 17, 1);
            this.add((Component)this.chkEnable, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(1, 2, 2, 1, 1.0, 1.0, 17, 1);
            this.add((Component)jsp, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(1, 3, 2, 1, 0.0, 0.0, 17, 0);
            this.add(Box.createVerticalStrut(6), WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(3, 0, 1, 4, 0.0, 0.0, 17, 0);
            this.add(Box.createHorizontalStrut(12), WizardContainer.UI_CONSTRAINT);
            this.addOrderEditor(0);
            this.chkEnable.addActionListener(this);
            this.chkEnable.doClick();
        }

        private void addOrderEditor(int index) {
            OrderEditor editor = new OrderEditor(this.metaMap);
            editor.addActionListener(this);
            int x = QueryWizard.this.lstOrderings.size();
            if (++index > x || x < 0) {
                QueryWizard.this.lstOrderings.add(editor);
            } else {
                QueryWizard.this.lstOrderings.add(index, editor);
            }
            this.pnlEditor.removeAll();
            x = QueryWizard.this.lstOrderings.size();
            Iterator itr = QueryWizard.this.lstOrderings.iterator();
            WizardContainer.constrain(0, 0, 1, 1, 1.0, 0.0, 17, 2);
            while (itr.hasNext()) {
                OrderEditor e = (OrderEditor)itr.next();
                e.setDeleteEnabled(x >= 2);
                e.setAddEnabled(x < Math.min(this.metaMap.size(), this.maxOrderings));
                this.pnlEditor.add((Component)e, WizardContainer.UI_CONSTRAINT);
                ++WizardContainer.UI_CONSTRAINT.gridy;
            }
            WizardContainer.UI_CONSTRAINT.fill = 3;
            WizardContainer.UI_CONSTRAINT.weighty = 1.0;
            this.pnlEditor.add(Box.createVerticalGlue(), WizardContainer.UI_CONSTRAINT);
            this.pnlEditor.invalidate();
            this.validateTree();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeOrderEditor(OrderEditor editor) {
            ArrayList arrayList = QueryWizard.this.lstOrderings;
            synchronized (arrayList) {
                QueryWizard.this.lstOrderings.remove(editor);
                QueryWizard.this.lstOrderings.trimToSize();
            }
            this.pnlEditor.remove(editor);
            int x = QueryWizard.this.lstOrderings.size();
            if (QueryWizard.this.lstEditor.size() == 1) {
                OrderEditor e = (OrderEditor)QueryWizard.this.lstOrderings.get(0);
                e.setDeleteEnabled(false);
                e.setAddEnabled(x < Math.min(this.metaMap.size(), this.maxOrderings));
            }
            this.pnlEditor.invalidate();
            this.validateTree();
        }
    }

    private class FKAutoJoin
    extends JPanel
    implements ActionListener,
    TableModelListener {
        private JCheckBox chkEnable = new JCheckBox("", true);
        private CheckListTableModel mdlKeys = new CheckListTableModel();
        private JTable tabKeys = new JTable(this.mdlKeys);

        public FKAutoJoin() {
            super(new GridBagLayout());
            try {
                this.initUI();
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t, "QueryWizard.FKAutoJoin::initUI()");
            }
            Iterator itr = QueryWizard.this.relationships.iterator();
            ArrayList<String> items = new ArrayList<String>();
            while (itr.hasNext()) {
                SelectionItem item = (SelectionItem)itr.next();
                SelectionItem subItem = (SelectionItem)item.subSelections.get(0);
                String[] p = new String[]{item.getSelectionName(), subItem.getSelectionName(), subItem.getProperty("column")};
                String selection = BasicUtilities.getString("QBuild_Relationship_Template", p);
                items.add(selection);
            }
            this.mdlKeys.setSelectableData(items);
            this.mdlKeys.setAllSelected(true);
        }

        public void actionPerformed(ActionEvent ae) {
            this.tabKeys.setEnabled(!this.chkEnable.isSelected());
            if (this.chkEnable.isSelected()) {
                this.mdlKeys.setAllSelected(true);
            }
        }

        public void tableChanged(TableModelEvent e) {
            int row = e.getFirstRow();
            int col = e.getColumn();
            if (row < 0 || row >= this.mdlKeys.getRowCount()) {
                return;
            }
            if (col < 0 || col >= this.mdlKeys.getColumnCount()) {
                return;
            }
            if (e.getType() == 0) {
                Boolean chk = (Boolean)this.mdlKeys.getValueAt(e.getFirstRow(), e.getColumn());
                SelectionItem item = (SelectionItem)QueryWizard.this.relationships.get(e.getFirstRow());
                item.setEnabled(chk);
            }
        }

        private void initUI() {
            this.mdlKeys.setSelectableTitle(BasicUtilities.getString("QBuild_Relationships"));
            this.mdlKeys.addTableModelListener(this);
            this.chkEnable.setText(BasicUtilities.getString("QBuild_Relations_Enable_All"));
            this.chkEnable.setToolTipText(BasicUtilities.getString("QBuild_Relations_Enable_All_Tip"));
            this.chkEnable.addActionListener(this);
            this.tabKeys.setEnabled(false);
            WizardContainer.constrain(1, 0, 1, 1, 0.0, 0.0, 17, 0);
            this.add(Box.createVerticalStrut(6), WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(0, 0, 1, 4, 0.0, 0.0, 17, 0);
            this.add(Box.createHorizontalStrut(12), WizardContainer.UI_CONSTRAINT);
            JScrollPane jspKeys = new JScrollPane(this.tabKeys);
            WizardContainer.constrain(1, 1, 1, 1, 0.0, 0.0, 17, 0);
            this.add((Component)this.chkEnable, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(1, 2, 1, 1, 1.0, 1.0, 17, 1);
            this.add((Component)jspKeys, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(1, 3, 1, 1, 0.0, 0.0, 17, 0);
            this.add(Box.createVerticalStrut(6), WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(2, 0, 1, 4, 0.0, 0.0, 17, 0);
            this.add(Box.createHorizontalStrut(12), WizardContainer.UI_CONSTRAINT);
            BasicUtilities.optimizeTableView(this.tabKeys);
        }
    }

    private class ColumnSelectionPanel
    extends JPanel
    implements ListSelectionListener,
    TableModelListener {
        private DefaultListModel mdlTableSelection = new DefaultListModel();
        private CheckListTableModel mdlColumnSelection = new CheckListTableModel();
        private JTable tabColumnSelection = new JTable(this.mdlColumnSelection);
        private JList lstTableSelection = new JList(this.mdlTableSelection);
        private JSplitPane jsp = new JSplitPane(1);
        private int maxColumns = 0;

        public ColumnSelectionPanel() {
            try {
                this.initUI();
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                this.maxColumns = QueryWizard.this.cnx.getDatabaseInformation().getMaxColumnsInSelect();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.maxColumns == 0) {
                this.maxColumns = Integer.MAX_VALUE;
            }
        }

        private void initUI() {
            this.jsp.setLeftComponent(new JScrollPane(this.lstTableSelection));
            this.jsp.setRightComponent(new JScrollPane(this.tabColumnSelection));
            this.setLayout(new BorderLayout());
            this.add((Component)this.jsp, "Center");
            IconListCellRenderer typeRenderer = new IconListCellRenderer(BasicUtilities.loadIconResource("Table16"));
            this.mdlColumnSelection.setSelectableTitle(BasicUtilities.getString("Select_Columns"));
            this.tabColumnSelection.getTableHeader().setReorderingAllowed(false);
            this.lstTableSelection.setCellRenderer(typeRenderer);
            this.lstTableSelection.addListSelectionListener(this);
            this.mdlColumnSelection.addTableModelListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void refreshList() {
            Iterator itr = QueryWizard.this.tableSelection.values().iterator();
            this.mdlTableSelection.clear();
            while (itr.hasNext()) {
                SelectionItem item = (SelectionItem)itr.next();
                if (item.isEmpty()) continue;
                Iterator sitr = item.getSubSelection().iterator();
                while (sitr.hasNext()) {
                    String table = (String)sitr.next();
                    if (!QueryWizard.this.columnSelection.containsKey(table)) {
                        TreeMap treeMap = QueryWizard.this.columnSelection;
                        synchronized (treeMap) {
                            SelectionItem i = new SelectionItem(table);
                            i.setProperty("catalog", item.getProperty("catalog"));
                            i.setProperty("schema", item.getProperty("schema"));
                            i.setProperty("type", item.getSelectionName());
                            QueryWizard.this.columnSelection.put(table, i);
                        }
                    }
                    this.mdlTableSelection.addElement(table);
                }
            }
            if (this.mdlTableSelection.size() >= 1) {
                this.lstTableSelection.setSelectedIndex(0);
            }
            QueryWizard.this.setNextStepEnabled(QueryWizard.this.getTrueTableSelectionCount() >= 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            String table = (String)this.lstTableSelection.getSelectedValue();
            if (table == null) {
                return;
            }
            ResultSet set = null;
            try {
                DatabaseMetaData dmd = QueryWizard.this.cnx.getDatabaseInformation();
                SelectionItem item = (SelectionItem)QueryWizard.this.columnSelection.get(table);
                String catalog = item.getProperty("catalog");
                String schema = item.getProperty("schema");
                set = dmd.getColumns(catalog, schema, table, null);
                Object[] columns = JDBCUtilities.getSingleColumn(set, "COLUMN_NAME", null);
                this.mdlColumnSelection.setSelectableData(Arrays.asList(columns));
                if (item != null && !item.isEmpty()) {
                    this.mdlColumnSelection.setItemsAsSelected(item.getSubSelection());
                }
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t, "ColumnSelectionPanel::valueChanged()");
            }
            finally {
                try {
                    set.close();
                }
                catch (Throwable t) {}
            }
        }

        public void tableChanged(TableModelEvent e) {
            int count;
            int row = e.getFirstRow();
            int col = e.getColumn();
            if (row < 0 || row >= this.mdlColumnSelection.getRowCount()) {
                return;
            }
            if (col < 0 || col >= this.mdlColumnSelection.getColumnCount()) {
                return;
            }
            if (e.getType() == 0) {
                Boolean chk = (Boolean)this.mdlColumnSelection.getValueAt(e.getFirstRow(), e.getColumn());
                String column = (String)this.mdlColumnSelection.getValueAt(e.getFirstRow(), 0);
                String tab = (String)this.lstTableSelection.getSelectedValue();
                SelectionItem item = (SelectionItem)QueryWizard.this.columnSelection.get(tab);
                if (chk.booleanValue()) {
                    item.addSubSelection(column);
                } else {
                    item.removeSubSelection(column);
                }
            }
            QueryWizard.this.setNextStepEnabled((count = QueryWizard.this.getColumnSelectionCount()) >= 1 && count <= this.maxColumns);
        }
    }

    private class QueryPreview
    extends JPanel
    implements ActionListener,
    DocumentListener {
        private JCheckBox chkCreateBm = new JCheckBox();
        private JCheckBox chkAllowEdit = new JCheckBox();
        private JTextField txtBookmark = new JTextField(12);
        private SQLEditor txtEditor = new SQLEditor(null);

        public QueryPreview() {
            try {
                this.initUI();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public String getSQL() {
            return this.txtEditor.getText();
        }

        public void actionPerformed(ActionEvent ae) {
            Object src = ae.getSource();
            if (src == this.chkCreateBm) {
                this.txtBookmark.setEnabled(this.chkCreateBm.isSelected());
                if (this.chkCreateBm.isSelected()) {
                    QueryWizard.this.setNextStepEnabled(this.txtBookmark.getText().trim().length() >= 1);
                } else {
                    QueryWizard.this.setNextStepEnabled(true);
                }
            } else {
                String title;
                String msg = BasicUtilities.getString("QBuild_PreEdit_Warning");
                int res = JOptionPane.showConfirmDialog(this, msg, title = BasicUtilities.getString("Warning"), 0);
                if (res == 0) {
                    this.txtEditor.setEditable(true);
                    QueryWizard.this.setPreviousStepEnabled(false);
                    this.chkAllowEdit.setEnabled(false);
                } else {
                    this.chkAllowEdit.setEnabled(true);
                    this.chkAllowEdit.setSelected(false);
                }
            }
        }

        public void createBookmark() {
            if (this.chkCreateBm.isSelected() && this.txtBookmark.getText().trim().length() >= 1) {
                SQLBookmark bm = new SQLBookmark(this.txtBookmark.getText().trim());
                bm.setSQL(this.txtEditor.getText());
                bm.setPath("/");
                SystemConfig.getInstance().getBookmarks().addBookmark(bm);
            }
        }

        public void update() {
            try {
                this.txtEditor.setText(QueryWizard.this.generateSQL());
                this.txtEditor.setCaretPosition(0);
                this.txtEditor.validate();
            }
            catch (Throwable t) {
                BasicUtilities.HandleException(t, "QueryWizard::generateSQL()");
            }
        }

        private void initUI() {
            this.setLayout(new GridBagLayout());
            this.txtEditor.setEditable(false);
            this.chkCreateBm.setText(BasicUtilities.getString("QBuild_CreateBookmark"));
            this.chkCreateBm.setToolTipText(BasicUtilities.getString("QBuild_CreateBookmark_Tip"));
            this.chkCreateBm.addActionListener(this);
            this.chkCreateBm.setSelected(false);
            this.chkAllowEdit.setText(BasicUtilities.getString("QBuild_PreEdit_Query"));
            this.chkAllowEdit.setToolTipText(BasicUtilities.getString("QBuild_PreEdit_Query_Tip"));
            this.chkAllowEdit.addActionListener(this);
            this.txtBookmark.getDocument().addDocumentListener(this);
            this.txtBookmark.setEnabled(this.chkCreateBm.isSelected());
            WizardContainer.constrain(1, 0, 1, 1, 0.0, 0.0, 17, 0);
            this.add(Box.createVerticalStrut(6), WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(0, 0, 1, 6, 0.0, 0.0, 17, 0);
            this.add(Box.createHorizontalStrut(12), WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(1, 1, 1, 2, 0.0, 0.0, 17, 0);
            this.add(Box.createHorizontalStrut(6), WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(1, 1, 2, 1, 0.0, 0.0, 17, 0);
            this.add((Component)this.chkCreateBm, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(2, 2, 1, 1, 0.0, 0.0, 17, 0);
            this.add((Component)this.txtBookmark, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(1, 3, 2, 1, 0.0, 0.0, 17, 0);
            this.add(Box.createVerticalStrut(6), WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(1, 4, 2, 1, 0.0, 0.0, 17, 0);
            this.add((Component)this.chkAllowEdit, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(1, 5, 2, 1, 1.0, 1.0, 17, 1);
            this.add((Component)this.txtEditor, WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(1, 6, 1, 1, 0.0, 0.0, 17, 0);
            this.add(Box.createVerticalStrut(6), WizardContainer.UI_CONSTRAINT);
            WizardContainer.constrain(3, 0, 1, 6, 0.0, 0.0, 17, 0);
            this.add(Box.createHorizontalStrut(12), WizardContainer.UI_CONSTRAINT);
        }

        public void changedUpdate(DocumentEvent e) {
            if (this.chkCreateBm.isSelected()) {
                QueryWizard.this.setNextStepEnabled(this.txtBookmark.getText().trim().length() >= 1);
            } else {
                QueryWizard.this.setNextStepEnabled(true);
            }
        }

        public void insertUpdate(DocumentEvent e) {
            if (this.chkCreateBm.isSelected()) {
                QueryWizard.this.setNextStepEnabled(this.txtBookmark.getText().trim().length() >= 1);
            } else {
                QueryWizard.this.setNextStepEnabled(true);
            }
        }

        public void removeUpdate(DocumentEvent e) {
            if (this.chkCreateBm.isSelected()) {
                QueryWizard.this.setNextStepEnabled(this.txtBookmark.getText().trim().length() >= 1);
            } else {
                QueryWizard.this.setNextStepEnabled(true);
            }
        }
    }
}

