/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.ui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.isqlviewer.util.BasicUtilities;

public class LoginOptionPane
extends JDialog
implements ActionListener {
    private final Insets insDefault = new Insets(2, 2, 2, 2);
    private JTextField mUserName = new JTextField("", 16);
    private JPasswordField mUserPass = new JPasswordField("", 16);
    private JButton mOKButton = new JButton(BasicUtilities.getString("Ok"));
    private JButton mCancelButton = new JButton(BasicUtilities.getString("Cancel"));
    private String[] tokens = null;

    public LoginOptionPane(Frame Owner) {
        super(Owner, BasicUtilities.getString("AuthPrompt_Title"), true);
        try {
            this.initUI();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.pack();
        this.mUserName.grabFocus();
        this.setResizable(false);
    }

    public static String[] showDialog(Frame f) {
        LoginOptionPane dlg = new LoginOptionPane(f);
        dlg.setLocationRelativeTo(f);
        dlg.show();
        return dlg.getAuthTokens();
    }

    public String[] getAuthTokens() {
        return this.tokens;
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src.equals(this.mUserPass) || src.equals(this.mOKButton)) {
            this.tokens = new String[2];
            this.tokens[0] = this.mUserName.getText();
            this.tokens[1] = new String(this.mUserPass.getPassword());
            this.dispose();
        } else if (src.equals(this.mCancelButton)) {
            this.tokens = null;
            this.dispose();
        } else if (src.equals(this.mUserName)) {
            this.mUserPass.requestFocus();
        }
    }

    private void initUI() throws Exception {
        JPanel cp = (JPanel)this.getContentPane();
        cp.setLayout(new GridBagLayout());
        this.mOKButton.addActionListener(this);
        this.mUserName.addActionListener(this);
        this.mUserPass.addActionListener(this);
        this.mCancelButton.addActionListener(this);
        this.mUserName.requestFocus();
        Component c = null;
        c = Box.createHorizontalStrut(8);
        cp.add(c, this.createGridBag(0, 0, 1, 5, 0.0, 0.0, 17, 0));
        c = Box.createHorizontalStrut(8);
        cp.add(c, this.createGridBag(1, 0, 2, 1, 0.0, 0.0, 17, 0));
        c = new JLabel(BasicUtilities.loadIconResource("Database24"));
        cp.add(c, this.createGridBag(1, 1, 1, 2, 0.0, 0.0, 10, 0));
        c = new JLabel(BasicUtilities.getString("SERV_User_Label"));
        cp.add(c, this.createGridBag(2, 1, 1, 1, 0.0, 0.0, 17, 0));
        c = new JLabel(BasicUtilities.getString("SERV_Pass_Label"));
        cp.add(c, this.createGridBag(2, 2, 1, 1, 0.0, 0.0, 17, 0));
        c = this.mUserName;
        cp.add(c, this.createGridBag(3, 1, 1, 1, 1.0, 0.0, 17, 2));
        c = this.mUserPass;
        cp.add(c, this.createGridBag(3, 2, 1, 1, 1.0, 0.0, 17, 2));
        c = this.mOKButton;
        cp.add(c, this.createGridBag(2, 3, 1, 1, 0.0, 0.0, 13, 0));
        c = this.mCancelButton;
        cp.add(c, this.createGridBag(3, 3, 1, 1, 0.0, 0.0, 17, 0));
        c = Box.createHorizontalStrut(8);
        cp.add(c, this.createGridBag(4, 0, 1, 5, 0.0, 0.0, 17, 0));
        c = Box.createHorizontalStrut(8);
        cp.add(c, this.createGridBag(1, 4, 2, 1, 0.0, 0.0, 17, 0));
    }

    private GridBagConstraints createGridBag(int x, int y, int width, int hieght, double xwieght, double ywieght, int anchor, int fill) {
        return new GridBagConstraints(x, y, width, hieght, xwieght, ywieght, anchor, fill, this.insDefault, 1, 1);
    }
}

