/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing.print;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.swing.ActionToolBar;
import org.isqlviewer.swing.WizardPanel;
import org.isqlviewer.swing.print.DefaultPaperComponent;
import org.isqlviewer.swing.print.JImagePaper;
import org.isqlviewer.swing.print.JTablePaper;
import org.isqlviewer.ui.PreferencesEditor;
import org.isqlviewer.util.BasicUtilities;

public final class PrinterPreview
extends JDialog
implements ActionListener {
    private static SystemConfig config = SystemConfig.getInstance();
    private static final Hashtable PAPER_MAP = new Hashtable();
    private JButton actionZoomIn = new JButton(BasicUtilities.loadToolbarIconResource("ZoomIn"));
    private JButton actionZoomOut = new JButton(BasicUtilities.loadToolbarIconResource("ZoomOut"));
    private JButton actionPrint = new JButton(BasicUtilities.loadToolbarIconResource("Print"));
    private JButton actionPageSetup = new JButton(BasicUtilities.loadToolbarIconResource("PageSetup"));
    private JButton actionHome = new JButton(BasicUtilities.loadToolbarIconResource("Home"));
    private JButton actionEditPrefs = new JButton(BasicUtilities.loadToolbarIconResource("Preferences"));
    private JButton actionPageUp = new JButton(BasicUtilities.loadIconResource("Up16"));
    private JButton actionPageDown = new JButton(BasicUtilities.loadIconResource("Down16"));
    private JButton actionRefresh = new JButton(BasicUtilities.loadToolbarIconResource("Refresh"));
    private JLabel StatusBar = new JLabel();
    private JScrollPane pageContainer = null;
    private UserKeyHandler inputHandler = new UserKeyHandler();
    private NumberFormat nf = NumberFormat.getPercentInstance();
    private DefaultPaperComponent ppane = new JTablePaper();
    private double currentScale = 1.0;
    private double zoomFactor = 0.1;
    static /* synthetic */ Class class$javax$swing$JTable;
    static /* synthetic */ Class class$javax$swing$table$TableModel;
    static /* synthetic */ Class class$javax$swing$JLabel;
    static /* synthetic */ Class class$javax$swing$ImageIcon;
    static /* synthetic */ Class class$java$lang$Object;

    private static DefaultPaperComponent getPaperforObject(Object o) {
        Class<?> paper = o.getClass();
        if (!PAPER_MAP.containsKey(paper)) {
            Iterator itr = PAPER_MAP.keySet().iterator();
            while (itr.hasNext()) {
                Class clazz = (Class)itr.next();
                if (clazz.equals(class$java$lang$Object == null ? PrinterPreview.class$("java.lang.Object") : class$java$lang$Object) || !clazz.isInstance(o)) continue;
                return (DefaultPaperComponent)PAPER_MAP.get(clazz);
            }
            return (DefaultPaperComponent)PAPER_MAP.get(class$java$lang$Object == null ? (class$java$lang$Object = PrinterPreview.class$("java.lang.Object")) : class$java$lang$Object);
        }
        return (DefaultPaperComponent)PAPER_MAP.get(paper);
    }

    public PrinterPreview(Object data, Dialog owner) {
        super(owner, BasicUtilities.getString("Print_Preview_Title"), true);
        this.enableEvents(8L);
        this.nf.setMaximumFractionDigits(2);
        try {
            this.ppane = PrinterPreview.getPaperforObject(data);
            this.ppane.addPropertyChangeListener(new PaperPropertyListener());
            this.ppane.configure(config.getPreferences());
            this.ppane.setContent(data);
            this.ppane.setZoomLevel(1.0);
            this.initUI();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.validateTree();
    }

    public PrinterPreview(Object data, Frame owner) {
        super(owner, BasicUtilities.getString("Print_Preview_Title"), true);
        this.enableEvents(8L);
        this.nf.setMaximumFractionDigits(2);
        try {
            this.ppane = PrinterPreview.getPaperforObject(data);
            this.ppane.addPropertyChangeListener(new PaperPropertyListener());
            this.ppane.configure(config.getPreferences());
            this.ppane.setContent(data);
            this.ppane.setZoomLevel(1.0);
            this.initUI();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.validateTree();
    }

    public static final int print(Object Data, String title) {
        DefaultPaperComponent paper = PrinterPreview.getPaperforObject(Data);
        SystemConfig cfg = SystemConfig.getInstance();
        paper.setTitleString(title);
        paper.setContent(Data);
        paper.configure(cfg.getPreferences());
        paper.print();
        return 1;
    }

    public static final int showPrintPreviewDialog(Frame owner, Object Data, String Title) {
        PrinterPreview dialog = new PrinterPreview(Data, owner);
        dialog.ppane.setTitleString(Title);
        dialog.setDefaultCloseOperation(2);
        dialog.pack();
        dialog.setSize(new Dimension(640, 480));
        dialog.setLocationRelativeTo(owner);
        dialog.show();
        return 1;
    }

    public static final int showPrintPreviewDialog(Dialog owner, Object Data, String Title) {
        PrinterPreview dialog = new PrinterPreview(Data, owner);
        dialog.ppane.setTitleString(Title);
        dialog.setDefaultCloseOperation(2);
        dialog.pack();
        dialog.setSize(new Dimension(640, 480));
        dialog.setLocationRelativeTo(owner);
        dialog.show();
        return 1;
    }

    public void actionPerformed(ActionEvent evt) {
        switch (Integer.parseInt(evt.getActionCommand())) {
            case 0: {
                this.currentScale += this.zoomFactor;
                if (this.currentScale >= 3.0) {
                    this.currentScale = 3.0;
                }
                this.ppane.setZoomLevel(this.currentScale);
                break;
            }
            case 1: {
                this.currentScale -= this.zoomFactor;
                if (this.currentScale <= 0.5) {
                    this.currentScale = 0.5;
                }
                this.ppane.setZoomLevel(this.currentScale);
                break;
            }
            case 2: {
                this.ppane.setZoomLevel(1.0);
                this.ppane.print();
                break;
            }
            case 3: {
                this.ppane.setPageNumber(this.ppane.getPage() - 1);
                break;
            }
            case 4: {
                this.ppane.setPageNumber(this.ppane.getPage() + 1);
                break;
            }
            case 5: {
                PrinterJob pj = PrinterJob.getPrinterJob();
                this.ppane.setPageFormat(pj.pageDialog(this.ppane.getPageFormat()));
                break;
            }
            case 6: {
                this.ppane.setPageNumber(0);
                break;
            }
            case 7: {
                PreferencesEditor.showDialog(this, 0);
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.ppane.configure(config.getPreferences());
                this.setCursor(Cursor.getDefaultCursor());
                break;
            }
            case 8: {
                this.pageContainer.getViewport().remove(this.ppane);
                this.ppane.configure(config.getPreferences());
                this.pageContainer.setViewportView(this.ppane);
                this.pageContainer.getViewport().invalidate();
            }
        }
        this.StatusBar.setText(this.getStatusText());
    }

    private void initUI() throws Exception {
        ActionToolBar tb = ActionToolBar.createNullInstance();
        this.addKeyListener(this.inputHandler);
        tb.setOrientation(0);
        tb.setFloatable(false);
        ((Container)tb).add(this.actionPrint);
        ((Container)tb).add(this.actionPageSetup);
        ((Container)tb).add(this.actionEditPrefs);
        ((Container)tb).add(Box.createHorizontalStrut(32));
        ((Container)tb).add(this.actionHome);
        ((Container)tb).add(this.actionRefresh);
        ((Container)tb).add(Box.createHorizontalStrut(32));
        ((Container)tb).add(this.actionZoomIn);
        ((Container)tb).add(this.actionZoomOut);
        this.actionPrint.addActionListener(this);
        this.actionPageSetup.addActionListener(this);
        this.actionEditPrefs.addActionListener(this);
        this.actionZoomIn.addActionListener(this);
        this.actionZoomIn.setToolTipText(BasicUtilities.getString("Zoom_In_By", this.nf.format(this.zoomFactor)));
        this.actionZoomOut.addActionListener(this);
        this.actionZoomOut.setToolTipText(BasicUtilities.getString("Zoom_Out_By", this.nf.format(this.zoomFactor)));
        this.actionPageUp.addActionListener(this);
        this.actionPageUp.setToolTipText(BasicUtilities.getString("View_Prev"));
        this.actionPageDown.addActionListener(this);
        this.actionPageDown.setToolTipText(BasicUtilities.getString("View_Next"));
        this.actionRefresh.addActionListener(this);
        this.actionRefresh.setToolTipText(BasicUtilities.getString("Print_Refresh_Tip"));
        this.actionHome.addActionListener(this);
        this.actionHome.setActionCommand("6");
        this.actionPrint.setActionCommand("2");
        this.actionPageUp.setActionCommand("3");
        this.actionZoomIn.setActionCommand("0");
        this.actionZoomOut.setActionCommand("1");
        this.actionPageDown.setActionCommand("4");
        this.actionPageSetup.setActionCommand("5");
        this.actionEditPrefs.setActionCommand("7");
        this.actionRefresh.setActionCommand("8");
        this.pageContainer = new JScrollPane(this.ppane, 22, 32);
        this.pageContainer.setColumnHeaderView(Box.createVerticalStrut(16));
        this.pageContainer.setCorner("UPPER_RIGHT_CORNER", this.actionPageUp);
        this.pageContainer.setCorner("LOWER_RIGHT_CORNER", this.actionPageDown);
        this.actionPageDown.setBorderPainted(!BasicUtilities.isMac());
        this.actionPageUp.setBorderPainted(!BasicUtilities.isMac());
        WizardPanel panel = new WizardPanel();
        JPanel pnl = new JPanel(new BorderLayout());
        pnl.add((Component)tb, "North");
        pnl.add((Component)this.pageContainer, "Center");
        pnl.add((Component)this.StatusBar, "South");
        panel.add(pnl);
        panel.showCard(pnl);
        this.setContentPane(panel);
        this.StatusBar.setText(this.getStatusText());
        this.validateTree();
    }

    private String getStatusText() {
        return BasicUtilities.getString("Print_Preview_Status", new String[]{"" + (this.ppane.getPage() + 1), "" + this.ppane.getPageCount(), this.nf.format(this.ppane.getZoomLevel())});
    }

    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        switch (e.getID()) {
            case 205: {
                this.validateTree();
                break;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        PAPER_MAP.put(class$javax$swing$JTable == null ? (class$javax$swing$JTable = PrinterPreview.class$("javax.swing.JTable")) : class$javax$swing$JTable, new JTablePaper());
        PAPER_MAP.put(class$javax$swing$table$TableModel == null ? (class$javax$swing$table$TableModel = PrinterPreview.class$("javax.swing.table.TableModel")) : class$javax$swing$table$TableModel, PAPER_MAP.get(class$javax$swing$JTable == null ? (class$javax$swing$JTable = PrinterPreview.class$("javax.swing.JTable")) : class$javax$swing$JTable));
        PAPER_MAP.put(class$javax$swing$JLabel == null ? (class$javax$swing$JLabel = PrinterPreview.class$("javax.swing.JLabel")) : class$javax$swing$JLabel, new JImagePaper());
        PAPER_MAP.put(class$javax$swing$ImageIcon == null ? (class$javax$swing$ImageIcon = PrinterPreview.class$("javax.swing.ImageIcon")) : class$javax$swing$ImageIcon, PAPER_MAP.get(class$javax$swing$JLabel == null ? (class$javax$swing$JLabel = PrinterPreview.class$("javax.swing.JLabel")) : class$javax$swing$JLabel));
    }

    private class UserKeyHandler
    extends KeyAdapter {
        private UserKeyHandler() {
        }

        public void keyPressed(KeyEvent ke) {
            KeyStroke ks = KeyStroke.getKeyStrokeForEvent(ke);
            if ((ks.getModifiers() & BasicUtilities.CMD_MASK) == BasicUtilities.CMD_MASK) {
                switch (ks.getKeyCode()) {
                    case 36: {
                        PrinterPreview.this.actionPerformed(new ActionEvent(this, 0, "6"));
                        break;
                    }
                    case 61: 
                    case 107: 
                    case 521: {
                        PrinterPreview.this.actionPerformed(new ActionEvent(this, 0, "0"));
                        break;
                    }
                    case 45: 
                    case 109: 
                    case 523: {
                        PrinterPreview.this.actionPerformed(new ActionEvent(this, 0, "1"));
                        break;
                    }
                    case 34: {
                        PrinterPreview.this.actionPerformed(new ActionEvent(this, 0, "4"));
                        break;
                    }
                    case 33: {
                        PrinterPreview.this.actionPerformed(new ActionEvent(this, 0, "3"));
                    }
                }
            }
        }
    }

    private class PaperPropertyListener
    implements PropertyChangeListener {
        private JLabel lbl = new JLabel(BasicUtilities.getString("Print_Format_Wait_Mesg"), BasicUtilities.loadIconResource("PrintPreview24"), 0);

        public void propertyChange(PropertyChangeEvent pce) {
            if (pce.getPropertyName().equalsIgnoreCase("init")) {
                boolean f = (Boolean)pce.getNewValue();
                if (f) {
                    PrinterPreview.this.pageContainer.getViewport().add((Component)this.lbl, 0);
                } else {
                    PrinterPreview.this.pageContainer.getViewport().add((Component)PrinterPreview.this.ppane, 0);
                    PrinterPreview.this.StatusBar.setText(PrinterPreview.this.getStatusText());
                }
            }
        }
    }
}

