/*
 * Decompiled with CFR 0.152.
 */
package org.isqlviewer.swing;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.isqlviewer.core.SystemConfig;
import org.isqlviewer.sql.JDBCUtilities;
import org.isqlviewer.util.BasicUtilities;
import org.isqlviewer.util.ColumnMetaData;

public class WhereEditor
extends JComponent {
    public static final int ACTION_ADD = 0;
    public static final int ACTION_DELETE = 1;
    public static final int STYLE_EQUAL = 0;
    public static final int STYLE_NOT_EQUAL = 1;
    public static final int STYLE_GREATER_THAN = 2;
    public static final int STYLE_LESS_THAN = 3;
    public static final int STYLE_CONTAINS = 4;
    public static final int STYLE_DOES_NOT_CONTAIN = 5;
    public static final int STYLE_IN_RANGE = 6;
    public static final int STYLE_NOT_IN_RANGE = 7;
    public static final int STYLE_IN_LAST = 8;
    public static final int STYLE_NOT_IN_LAST = 9;
    public static final int STYLE_ENDS_WITH = 10;
    public static final int STYLE_STARTS_WITH = 11;
    private DefaultComboBoxModel mdlColumn = new DefaultComboBoxModel<Object>(new Object[0]);
    private DefaultComboBoxModel mdlStyle = new DefaultComboBoxModel<Object>(new Object[0]);
    private DefaultComboBoxModel mdlDays = new DefaultComboBoxModel<Object>(new Object[]{BasicUtilities.getString("QBuild_Natural_Hours"), BasicUtilities.getString("QBuild_Natural_Days"), BasicUtilities.getString("QBuild_Natural_Weeks"), BasicUtilities.getString("QBuild_Natural_Months"), BasicUtilities.getString("QBuild_Natural_Years")});
    private JComboBox jcbColumn = new JComboBox(this.mdlColumn);
    private JComboBox jcbStyle = new JComboBox(this.mdlStyle);
    private JComboBox jcbDays = new JComboBox(this.mdlDays);
    private SystemConfig sysConfig = SystemConfig.getInstance();
    private SimpleDateFormat sdf = new SimpleDateFormat("");
    private JTextComponent txtValue = new JTextField(8);
    private JTextComponent txtSecondary = new JTextField(8);
    private JButton btnAdd = new JButton(BasicUtilities.getString("QBuild_Natural_Plus"));
    private JButton btnDel = new JButton(BasicUtilities.getString("QBuild_Natural_Minus"));
    private JPanel pnlEditor = new JPanel();
    private JLabel lblTo = new JLabel(BasicUtilities.getString("QBuild_Natural_To"));
    private TreeMap meta = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private ArrayList listenerList = null;
    private ActionHandler actionHandler = new ActionHandler();

    public WhereEditor(Map metaMap) {
        this.setLayout(new GridBagLayout());
        this.btnAdd.setMargin(new Insets(0, 0, 0, 0));
        this.btnDel.setMargin(new Insets(0, 0, 0, 0));
        this.btnDel.setPreferredSize(this.btnDel.getMinimumSize());
        this.btnAdd.setPreferredSize(this.btnAdd.getMinimumSize());
        this.pnlEditor.setLayout(new GridBagLayout());
        this.pnlEditor.add(this.txtValue);
        this.add((Component)this.jcbColumn, WhereEditor.constrain(0, 0.0, 17, 0));
        this.add((Component)this.jcbStyle, WhereEditor.constrain(1, 0.0, 17, 0));
        this.add((Component)this.pnlEditor, WhereEditor.constrain(2, 1.0, 17, 2));
        this.add((Component)this.btnDel, WhereEditor.constrain(3, 0.0, 17, 0));
        this.add((Component)this.btnAdd, WhereEditor.constrain(4, 0.0, 17, 0));
        this.jcbColumn.addActionListener(this.actionHandler);
        this.jcbStyle.addActionListener(this.actionHandler);
        this.btnDel.addActionListener(this.actionHandler);
        this.btnAdd.addActionListener(this.actionHandler);
        this.updateMetamap(metaMap);
        this.validateTree();
    }

    public int getSelectedStyle() {
        String style = (String)this.jcbStyle.getSelectedItem();
        String t1 = null;
        String t2 = null;
        t1 = BasicUtilities.getString("QBuild_Natural_Equal");
        if (t1.equalsIgnoreCase(style)) {
            return 0;
        }
        t1 = BasicUtilities.getString("QBuild_Natural_Not_Equal");
        if (t1.equalsIgnoreCase(style)) {
            return 1;
        }
        t1 = BasicUtilities.getString("QBuild_Natural_In_Range");
        if (t1.equalsIgnoreCase(style)) {
            return 6;
        }
        t1 = BasicUtilities.getString("QBuild_Natural_Not_In_Range");
        if (t1.equalsIgnoreCase(style)) {
            return 7;
        }
        t1 = BasicUtilities.getString("QBuild_Natural_In_Last");
        if (t1.equalsIgnoreCase(style)) {
            return 8;
        }
        t1 = BasicUtilities.getString("QBuild_Natural_Not_In_Last");
        if (t1.equalsIgnoreCase(style)) {
            return 9;
        }
        t1 = BasicUtilities.getString("QBuild_Natural_Starts_With");
        if (t1.equalsIgnoreCase(style)) {
            return 11;
        }
        t1 = BasicUtilities.getString("QBuild_Natural_Ends_With");
        if (t1.equalsIgnoreCase(style)) {
            return 10;
        }
        t1 = BasicUtilities.getString("QBuild_Natural_Does_Not_Contain");
        if (t1.equalsIgnoreCase(style)) {
            return 5;
        }
        t1 = BasicUtilities.getString("QBuild_Natural_Contains");
        if (t1.equalsIgnoreCase(style)) {
            return 4;
        }
        t1 = BasicUtilities.getString("QBuild_Natural_After");
        t2 = BasicUtilities.getString("QBuild_Natural_Greater_Than");
        if (t1.equalsIgnoreCase(style) || t2.equalsIgnoreCase(style)) {
            return 2;
        }
        t1 = BasicUtilities.getString("QBuild_Natural_Before");
        t2 = BasicUtilities.getString("QBuild_Natural_Less_Than");
        if (t1.equalsIgnoreCase(style) || t2.equalsIgnoreCase(style)) {
            return 3;
        }
        return -1;
    }

    public ColumnMetaData getSelectedColumn() {
        Object key = this.jcbColumn.getSelectedItem();
        return (ColumnMetaData)this.meta.get(key);
    }

    public Object[] getUserOptions() throws ParseException {
        int style = this.getSelectedStyle();
        int type = this.getSelectedColumn().getType();
        String pattern = this.sysConfig.getFormatForSQLType(type);
        pattern = pattern == null ? "" : pattern;
        this.sdf.applyPattern(pattern);
        Object opt1 = this.txtValue.getText();
        Object opt2 = this.txtSecondary.getText();
        block4 : switch (type) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                opt1 = JDBCUtilities.convertValue(opt1, type, null);
                try {
                    opt2 = JDBCUtilities.convertValue(opt2, type, null);
                    break;
                }
                catch (ParseException t) {
                    switch (style) {
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: {
                            break block4;
                        }
                    }
                    throw t;
                }
            }
            case 91: {
                switch (style) {
                    case 8: 
                    case 9: {
                        opt1 = JDBCUtilities.convertValue(opt1, 4, null);
                        break block4;
                    }
                }
                opt1 = JDBCUtilities.convertValue(opt1, type, this.sdf);
                try {
                    opt2 = JDBCUtilities.convertValue(opt2, type, this.sdf);
                }
                catch (ParseException t) {
                    switch (style) {
                        case 6: 
                        case 7: {
                            throw t;
                        }
                    }
                }
                break;
            }
            case 92: {
                switch (style) {
                    case 8: 
                    case 9: {
                        opt1 = JDBCUtilities.convertValue(opt1, 4, null);
                        break block4;
                    }
                }
                opt1 = JDBCUtilities.convertValue(opt1, type, this.sdf);
                try {
                    opt2 = JDBCUtilities.convertValue(opt2, type, this.sdf);
                }
                catch (ParseException t) {
                    switch (style) {
                        case 6: 
                        case 7: {
                            throw t;
                        }
                    }
                }
                break;
            }
            case 93: {
                switch (style) {
                    case 8: 
                    case 9: {
                        opt1 = JDBCUtilities.convertValue(opt1, 4, null);
                        break block4;
                    }
                }
                opt1 = JDBCUtilities.convertValue(opt1, type, this.sdf);
                try {
                    opt1 = JDBCUtilities.convertValue(opt2, type, this.sdf);
                }
                catch (ParseException t) {
                    switch (style) {
                        case 6: 
                        case 7: {
                            throw t;
                        }
                    }
                }
                break;
            }
        }
        switch (style) {
            case 6: 
            case 7: {
                return new Object[]{opt1, opt2};
            }
            case 8: 
            case 9: {
                return new Object[]{opt1, Integer.toString(this.jcbDays.getSelectedIndex())};
            }
        }
        return new Object[]{opt1};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMetamap(Map data) {
        TreeMap treeMap = this.meta;
        synchronized (treeMap) {
            this.meta.clear();
            if (data != null) {
                this.meta.putAll(data);
            }
        }
        this.loadMap();
    }

    public void setAddEnabled(boolean f) {
        this.btnAdd.setEnabled(f);
    }

    public void setDeleteEnabled(boolean f) {
        this.btnDel.setEnabled(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActionListener(ActionListener l) {
        if (this.listenerList != null && this.listenerList.contains(l)) {
            ArrayList arrayList = this.listenerList;
            synchronized (arrayList) {
                this.listenerList.remove(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActionListener(ActionListener l) {
        if (this.listenerList == null) {
            this.listenerList = new ArrayList(1);
        }
        if (!this.listenerList.contains(l)) {
            ArrayList arrayList = this.listenerList;
            synchronized (arrayList) {
                this.listenerList.add(l);
            }
        }
    }

    private void loadMap() {
        Iterator itr = this.meta.keySet().iterator();
        this.mdlColumn.removeAllElements();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            this.mdlColumn.addElement(key);
        }
    }

    private void loadSytle(ColumnMetaData cmd) {
        this.mdlStyle.removeAllElements();
        if (cmd == null) {
            return;
        }
        Object[] styles = null;
        int sqlType = cmd.getType();
        String pattern = this.sysConfig.getFormatForSQLType(sqlType);
        pattern = pattern == null ? "" : pattern;
        this.sdf.applyPattern(pattern);
        switch (cmd.getType()) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                styles = WhereEditor.getNumberStyles();
                this.txtValue.setText("0");
                this.txtSecondary.setText("1");
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                styles = WhereEditor.getStringStyles();
                break;
            }
            case 91: {
                styles = WhereEditor.getDateStyles();
                this.txtValue.setText(this.sdf.format(new Date()));
                this.txtSecondary.setText(this.sdf.format(new Date()));
                break;
            }
            case 92: {
                styles = WhereEditor.getDateStyles();
                this.txtValue.setText(this.sdf.format(new Date()));
                this.txtSecondary.setText(this.sdf.format(new Date()));
                break;
            }
            case 93: {
                styles = WhereEditor.getDateStyles();
                this.txtValue.setText(this.sdf.format(new Date()));
                this.txtSecondary.setText(this.sdf.format(new Date()));
                break;
            }
            default: {
                styles = WhereEditor.getUnknownStyles();
                this.txtValue.setText("");
                this.txtSecondary.setText("");
            }
        }
        if (styles != null) {
            for (int i = 0; i < styles.length; ++i) {
                this.mdlStyle.addElement(styles[i]);
            }
            this.mdlStyle.setSelectedItem(styles[0]);
        }
    }

    private void updateEditor() {
        String selection = (String)this.mdlStyle.getSelectedItem();
        String column = (String)this.mdlColumn.getSelectedItem();
        ColumnMetaData cmd = (ColumnMetaData)this.meta.get(column);
        if (cmd == null) {
            return;
        }
        String t1 = null;
        String t2 = null;
        this.pnlEditor.removeAll();
        if (JDBCUtilities.isDateType(cmd.getType())) {
            t1 = BasicUtilities.getString("QBuild_Natural_In_Last");
            t2 = BasicUtilities.getString("QBuild_Natural_Not_In_Last");
            if (t1.equalsIgnoreCase(selection) || t2.equalsIgnoreCase(selection)) {
                this.pnlEditor.add((Component)this.txtValue, WhereEditor.constrain(0, 0.5, 17, 2));
                this.pnlEditor.add((Component)this.jcbDays, WhereEditor.constrain(1, 0.5, 17, 0));
                this.txtValue.setText("1");
                this.pnlEditor.invalidate();
                this.validateTree();
                return;
            }
        }
        t1 = BasicUtilities.getString("QBuild_Natural_In_Range");
        t2 = BasicUtilities.getString("QBuild_Natural_Not_In_Range");
        if (t1.equalsIgnoreCase(selection) || t2.equalsIgnoreCase(selection)) {
            this.pnlEditor.add((Component)this.txtValue, WhereEditor.constrain(0, 0.5, 17, 2));
            this.pnlEditor.add((Component)this.lblTo, WhereEditor.constrain(1, 0.0, 17, 0));
            this.pnlEditor.add((Component)this.txtSecondary, WhereEditor.constrain(2, 0.5, 17, 2));
        } else {
            this.pnlEditor.add((Component)this.txtValue, WhereEditor.constrain(0, 1.0, 17, 2));
        }
        this.pnlEditor.invalidate();
        this.validateTree();
    }

    private static Object constrain(int x, double wieght, int anchor, int fill) {
        Insets insets = new Insets(1, 1, 1, 1);
        return new GridBagConstraints(x, 0, 1, 1, wieght, 0.0, anchor, fill, insets, 1, 1);
    }

    private static Object[] getNumberStyles() {
        Object[] styles = new String[]{BasicUtilities.getString("QBuild_Natural_Equal"), BasicUtilities.getString("QBuild_Natural_Not_Equal"), BasicUtilities.getString("QBuild_Natural_Greater_Than"), BasicUtilities.getString("QBuild_Natural_Less_Than"), BasicUtilities.getString("QBuild_Natural_In_Range"), BasicUtilities.getString("QBuild_Natural_Not_In_Range")};
        return styles;
    }

    private static Object[] getUnknownStyles() {
        Object[] styles = new String[]{BasicUtilities.getString("QBuild_Natural_Equal"), BasicUtilities.getString("QBuild_Natural_Not_Equal")};
        return styles;
    }

    private static Object[] getDateStyles() {
        Object[] styles = new String[]{BasicUtilities.getString("QBuild_Natural_Equal"), BasicUtilities.getString("QBuild_Natural_Not_Equal"), BasicUtilities.getString("QBuild_Natural_Before"), BasicUtilities.getString("QBuild_Natural_After"), BasicUtilities.getString("QBuild_Natural_In_Last"), BasicUtilities.getString("QBuild_Natural_Not_In_Last"), BasicUtilities.getString("QBuild_Natural_In_Range"), BasicUtilities.getString("QBuild_Natural_Not_In_Range")};
        return styles;
    }

    private static Object[] getStringStyles() {
        Object[] styles = new String[]{BasicUtilities.getString("QBuild_Natural_Equal"), BasicUtilities.getString("QBuild_Natural_Not_Equal"), BasicUtilities.getString("QBuild_Natural_Starts_With"), BasicUtilities.getString("QBuild_Natural_Ends_With"), BasicUtilities.getString("QBuild_Natural_Contains"), BasicUtilities.getString("QBuild_Natural_Does_Not_Contain")};
        return styles;
    }

    protected void forwardEvent(ActionEvent e) {
        if (this.listenerList != null) {
            Iterator itr = this.listenerList.iterator();
            Object src = e.getSource();
            int id = src == this.btnAdd ? 0 : 1;
            ActionEvent evt = new ActionEvent(this, id, e.getActionCommand(), e.getModifiers());
            while (itr.hasNext()) {
                ActionListener l = (ActionListener)itr.next();
                try {
                    l.actionPerformed(evt);
                }
                catch (Throwable t) {}
            }
        }
    }

    public void setEnabled(boolean enabled) {
        this.jcbColumn.setEnabled(enabled);
        this.jcbDays.setEnabled(enabled);
        this.jcbStyle.setEnabled(enabled);
        this.txtSecondary.setEnabled(enabled);
        this.txtValue.setEnabled(enabled);
        this.btnAdd.setEnabled(enabled);
        this.btnDel.setEnabled(enabled);
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        public void actionPerformed(ActionEvent ae) {
            Object src = ae.getSource();
            if (src == WhereEditor.this.jcbColumn) {
                try {
                    String column = (String)WhereEditor.this.mdlColumn.getSelectedItem();
                    ColumnMetaData cmd = (ColumnMetaData)WhereEditor.this.meta.get(column);
                    WhereEditor.this.loadSytle(cmd);
                    WhereEditor.this.updateEditor();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return;
            }
            if (src == WhereEditor.this.jcbStyle) {
                WhereEditor.this.updateEditor();
                return;
            }
            if (src == WhereEditor.this.btnAdd || src == WhereEditor.this.btnDel) {
                WhereEditor.this.forwardEvent(ae);
            }
        }
    }
}

